#include "head.h"
#include <stdio.h>
#include <string.h>

char *writing_flag, *already_read;
extern int *fat;
struct FDC_REQ *freq_fat0, *freq_fat1;
extern struct biosinfo *basic;

void change_name(char *to, const char *from);
void fdc_write(int clustno);
void wait(int time);

void file_readfat(unsigned char *rawfat)
{
  int i,j=0;
  fat=(int *)alloc4((struct manager *)(MANAGER_ADDR),4*2880);
  memset((int *) fat, 0, 2880 * 4);
  writing_flag = (char *) alloc4((struct manager *)(MANAGER_ADDR),2880);
  memset(writing_flag, 0, 2880);
  freq_fat0 = start_fdc_req('w');
  freq_fat1 = start_fdc_req('w');
  for(i=0;i<2880;i+=2){
    fat[i + 0]=(rawfat[j + 0]      | rawfat[j + 1] << 8) & 0xfff;
    fat[i + 1]=(rawfat[j + 1] >> 4 | rawfat[j + 2] << 4) & 0xfff;
    j+=3;
  }
  already_read = (char *) alloc4((struct manager *)(MANAGER_ADDR), 2880);
  memset(already_read, 0xff, basic->cyls * 36);
  memset(already_read + basic->cyls * 36, 0, 2880);
  return;
}

void file_loadfile(int clustno,int size,char *buf,char *img)
{
  int i;
  for(;;){
    if(size<=512){
      for(i=0;i<size;i++) {
      	buf[i]=img[clustno*512+i];
      }
      break;
    }
    for(i=0;i<512;i++){
      buf[i]=img[clustno*512+i];
    }
    size-=512;
    buf+=512;
    clustno=fat[clustno];	/* ɃoO */
  }
  return;
}
char *file_loadfile2(int clustno, int *psize)
{
  int size = *psize, size2;
  char *buf, *buf2;
  buf = (char *) alloc4((struct manager *)(MANAGER_ADDR), size);
  file_loadfile(clustno, size, buf, (char *) (ADR_DISKIMG + 0x003e00));
  if (size >= 17) {
    size2 = tek_getsize(buf);
    if (size2 > 0) {	/* tekkĂ */
      buf2 = (char *) alloc4((struct manager *)(MANAGER_ADDR), size2);
      tek_decomp(buf, buf2, size2);
      free4((struct manager *)(MANAGER_ADDR), (int) buf, size);
      buf = buf2;
      *psize = size2;
    }
  }
  return buf;
}

struct FILEINFO *file_search(char *name,struct FILEINFO *finfo,int max)
{
  int i, j;
  char s[12];
	
  change_name(s, name);
	
  for (i = 0; i < max; ) {
    if (finfo->name[0] == 0x00) {
      break;
    }
    if ((finfo[i].type & 0x18) == 0) { // fBNg(0x08)₻̑̏(0x10)ł͂Ȃ
      for (j = 0; j < 11; j++) {
	if (finfo[i].name[j] != s[j]) {
	  goto next;
	}
      }
      return finfo + i; /* t@C */
    }
  next:
    i++;
  }
  return 0; /* Ȃ */
}
int file_setfat(int clustno, int num)
{
  int clustlow, clustupp;
  unsigned char comp[3];
	
  if (clustno == FAT_SEARCH) {
    // ǂKɒTĂ
    for (clustno = 0; clustno < 2849; clustno++) {
      if (fat[clustno] == 0x0000) {
	// Ă
	io_cli();
	if (fat[clustno] == 0x0000) {
	  fat[clustno] = num;
	  io_sti();
	  goto found;
	}
	io_sti();
      }
    }
  } else {
    io_cli();
    fat[clustno] = num;
    io_sti();
    goto found;
  }
  // Ȃ
  return 0x0fff;
	
 found:
  // FATkăfBXNC[Wɕۑ
  // (0, 1)->0 (2, 3)->2 (4, 5)->4...Ɠ̔{ɂ邱ƂŁAFATXVł悤ɂ
  clustlow = clustno & ~0x01;
  clustupp = clustlow + 1;

  comp[0] = (unsigned char) (fat[clustlow] & 0x0ff);
  comp[1] = (unsigned char) ((fat[clustupp] & 0x00f) << 4 | (fat[clustlow] & 0xf00) >> 8);
  comp[2] = (unsigned char) ((fat[clustupp] & 0xff0) >> 4);

  // ڂFAT
  memcpy((char *) (ADR_DISKIMG + 0x0200 + clustlow / 2 * 3), comp, 3);
  add_fdc_req_addr(freq_fat0, (char *) (0x0200 + clustlow / 2 * 3), 3);
  // ڂFAT
  memcpy((char *) (ADR_DISKIMG + 0x1400 + clustlow / 2 * 3), comp, 3);
  add_fdc_req_addr(freq_fat1, (char *) (0x01400 + clustlow / 2 * 3), 3);
	
  return clustno;
}

void change_name(char *to, const char *from)
{
  int i, j;
	
  for (j = 0; j < 11; j++) {
    to[j] = ' ';
  }
  for (i = 0, j = 0; j < 11 && from[i] != 0; i++) {
    if (from[i] == '.') {
      j = 8;
    } else {
      to[j] = from[i];
      if ('a' <= to[j] && to[j] <= 'z') {
	/* ͑啶ɒ */
	to[j] -= 0x20;
      } 
      j++;
    }
  }
	
  return;
}

struct FILEINFO *file_create(char *_name, struct FILEINFO *finfo, int max,char type)
{
  struct clock c;
  struct DATE *date;
  struct TIME *time;
  struct FDC_REQ *freq = start_fdc_req('w');
  int i, len = strlen(_name);
  char name[13];
	
  for (i = 0; i < len; i++) {
    switch (_name[i]) {
    case 0:
      if (i > 0) {
	break;
      } else {
	// t@C
	return 0;
      }
      break;
			
    case '\\':
    case '/':
    case ':':
    case ',':
    case ';':
    case '*':
    case '?':
    case '\"':
    case '>':
    case '<':
    case '|':
      // gĂ͂ȂL
      return 0;
    }
  }
	
  change_name(name, _name);
  clockGet(&c);

  if (file_search(_name, (struct FILEINFO *) (ADR_DISKIMG + 0x2600), 244) != 0) {
    // t@C͂łɑ݂
    return 0;
  }
	
  for (i = 0; i < max; i++) {
    if (finfo[i].name[0] == 0x00 || finfo[i].name[0] == 0xE5) {
      goto next;
    }
  }
  // 󂫂܂ł
  return 0;
	
 next:
  io_cli();
  strncpy(finfo[i].name, name, 12);
  finfo[i].type = type;
  finfo[i].size = 0;
  finfo[i].clustno = file_setfat(FAT_SEARCH, 0xfff);
  /* ŐV̓tƎԂɕύX */
  /* date = (struct DATE *) &(finfo[i].date); */
  /* date->day = c.day; */
  /* date->month = c.month; */
  /* date->year = c.year; */
  /* time = (struct TIME *) &(finfo[i].time); */
  /* time->hour = c.hour; */
  /* time->min = c.min; */
  /* time->sec = c.sec; */
  add_fdc_req_addr(freq, (char *) ((int) &(finfo[i]) - ADR_DISKIMG), 0x20);
  io_sti();
  
  end_fdc_req(freq);
	
  return &(finfo[i]);
}

void file_delete(struct FILEINFO *finfo)
{
  struct FDC_REQ *freq = start_fdc_req('w');
	
  if (finfo != 0) {
    file_clear(finfo);
    finfo->name[0] = 0xe5;
    add_fdc_req_addr(freq, (char *) ((int) finfo - ADR_DISKIMG), 0x20);
    file_setfat(finfo->clustno, 0);
  }
  end_fdc_req(freq);
	
  return;
}

char *get_imgaddr(struct FILEHANDLE *fh, int cur, int err, int *clustno_)
{
  int i, cnt = cur / 512;
  int clustno = fh->finfo->clustno;
	
  for (i = 0; i < cnt; i++)
    {
      if (fat[clustno] >= 0xff8) {
	if (err == 0) {
	  // G[Ƃď
	  return 0;
	} else {
	  // V
	  file_setfat(clustno, file_setfat(FAT_SEARCH, 0xfff));
	}
      }
      clustno = fat[clustno];
    }
	
  if (clustno_ != 0) *clustno_ = clustno;
  return (char *) (ADR_DISKIMG + clustno * 512 + 0x3e00);
}

struct FILEHANDLE *file_open(struct FILEHANDLE *fh, char *name, char mode)
{
  struct FILEINFO *finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x2600), 224);
  struct FDC_REQ *freq;
	
  fh->finfo = finfo;
	
  if (mode == 'r') {
    // ǂݍ݃[h
    if (finfo == 0) {
      // t@C݂ȂȂG[
      return 0;
    }
    fh->write_cur = -1;
    fh->freq = 0;
		
  } else {
    // ݃[hǉ݃[h
    if (finfo == 0) {
      // t@CȂȂ
      if ((finfo = fh->finfo = file_create(name, (struct FILEINFO *) (ADR_DISKIMG + 0x2600), 224,0x20)) == 0) {
	// t@CȂ
	return 0;
      }
			
    } else if (mode == 'w') {
      file_clear(finfo);
      freq = start_fdc_req('w');
      add_fdc_req_addr(freq, (char *) ((int) finfo - ADR_DISKIMG), 0x20);
      end_fdc_req(freq);
    }
		
    if (mode == 'w') {
      // ݃[h
      fh->write_cur = 0;
			
    } else if (mode == 'a') {
      // ǉ݃[h
      fh->write_cur = finfo->size;
    }
    fh->freq = start_fdc_req('w');
  }
	
  fh->pos = 0;
  fh->size = finfo->size;
  fh->tek = 0;
  fh->flag = 1;
	
  freq = start_fdc_req('r');
  add_fdc_req(freq, 0x3e00 / 512 + finfo->clustno);
  end_fdc_req(freq);
  while (already_read[0x3e00 / 512 + finfo->clustno] == 0) wait(100);
	
  if (fh->size >= 17) { // tek?
    if (tek_getsize(get_imgaddr(fh, 0, 0, 0)) > 0) { // ςtek
      fh->buf = file_loadfile2(finfo->clustno, &(fh->size));
      fh->tek = 1;
    }
  }
	
  return fh;
}
struct FILEHANDLE *file_open_cluster(struct FILEHANDLE *fh,int cluster,char mode)
{
  struct FILEINFO *finfo=(struct FILEINFO *)(ADR_DISKIMG + 0x2600+cluster*512);
  struct FDC_REQ *freq;
  int i;
  fh->finfo = finfo;
	
  if (mode == 'r') {
    // ǂݍ݃[h
    if (finfo == 0) {
      // t@C݂ȂȂG[
      return 0;
    }
    fh->write_cur = -1;
    fh->freq = 0;
  }else if (mode == 'w') {
    file_clear(finfo);
    freq = start_fdc_req('w');
    add_fdc_req_addr(freq, (char *) ((int) finfo - ADR_DISKIMG), 0x20);
    end_fdc_req(freq);
    fh->write_cur = 0;
  } else if (mode == 'a') {
    // ǉ݃[h
    fh->write_cur = finfo->size;
  }
  fh->freq = start_fdc_req('w');
	
  fh->pos = 0;
  fh->size = finfo->size;
  fh->tek = 0;
  fh->flag = 1;
	
  freq = start_fdc_req('r');
  add_fdc_req(freq, 0x3e00 / 512 + finfo->clustno);
  end_fdc_req(freq);
  while (already_read[0x3e00 / 512 + finfo->clustno] == 0) wait(100);
	
  if (fh->size >= 17) { // tek?
    if (tek_getsize(get_imgaddr(fh, 0, 0, 0)) > 0) { // ςtek
      fh->buf = file_loadfile2(finfo->clustno, &(fh->size));
      fh->tek = 1;
    }
  }
	
  return fh;
}

int file_read(struct FILEHANDLE *fh, char *to, int len)
{
  struct FDC_REQ *freq;
  int i, r = 0, clustno, l = len, p = fh->pos;
  char *read_buf;
	
  if (fh->tek == 1) {
    // tek[h
    for (i = 0; i < len; i++) {
      if (fh->pos == fh->size) {
	break;
      }
      to[i] = fh->buf[fh->pos];
      fh->pos++;
    }
		
    return i;
  } else {
    freq = start_fdc_req('r');
    do {
      get_imgaddr(fh, p, 0, &clustno);
      add_fdc_req(freq, 0x3e00 / 512 + clustno);
      p += 512;
      l -= 512;
    } while (l > 0);
    end_fdc_req(freq);
		
    do {
      read_buf = get_imgaddr(fh, fh->pos, 0, &clustno);
      while (already_read[0x3e00 / 512 + clustno] == 0) wait(10);
      if (read_buf == 0 || (fh->pos + len) > fh->size) {
	return 0;
      }
      i = fh->pos % 512;
      for (; i < 512 && len > 0; fh->pos++, i++, len--, to++, r++) {
	*to = read_buf[i];
      }
    } while (len > 0);
		
    return r;
  }
}

void file_write(struct FILEHANDLE *fh, char *data, int len, struct FDC_REQ *freq)
{
  int cur = fh->write_cur % 512, clustno;
  char *write_buf;
  char *d = data;
	
  if (writing_flag[fh->finfo->clustno] != 0) {
    return; 
  } else {
    io_cli();
    writing_flag[fh->finfo->clustno] = 1;
    io_sti();
  }
  if (fh == 0 || fh->write_cur == -1) return;
  write_buf = get_imgaddr(fh, fh->write_cur, 1, &clustno);
	
  for (; cur < 512 && len > 0; fh->write_cur++, cur++, len--, d++) {
    write_buf[cur] = *d;
  }
	
  add_fdc_req(freq, 0x3e00 / 512 + clustno);
	
  io_cli();
  writing_flag[fh->finfo->clustno] = 0;
  io_sti();
  if (len <= 0) {
    // ރf[^Ȃ
    if (fh->write_cur > fh->finfo->size) {
      fh->finfo->size = fh->write_cur;
      fh->size = fh->write_cur;
    }
    return;
  } else {
    file_write(fh, d, len, freq);
  }
	
  return;
}

void file_clear(struct FILEINFO *finfo)
{
  int i = finfo->clustno, next, first;
  next = 0;
  first = i;
	
  for (; ; i = next) {
    next = fat[i];
    file_setfat(i, 0);
    if (next >= 0xff8) {
      break;
    }
  }
	
  file_setfat(first, 0xfff);
  finfo->size = 0;
	
  return;
}

void file_close(struct FILEHANDLE *fh)
{
  if (fh->flag == 0) {
    return;
  }
	
  if (fh->tek == 1) {
    // tekkĂ
    free4((struct manager *)(MANAGER_ADDR), (int) fh->buf, fh->size);
  }
	
  io_cli();
  if (writing_flag[fh->finfo->clustno] == 1) {
    writing_flag[fh->finfo->clustno] = 0;
  }
  io_sti();
	
  if (fh->freq != 0) end_fdc_req(fh->freq);
  fh->flag = 0;
	
  return;
}
void rename_file(struct FILEINFO *finfo,char *name)
{
  struct FDC_REQ *freq = start_fdc_req('w');
  int i, j;
  unsigned char s[12];
  if (finfo != 0) {

    for (i = 0; i < 11; i++) {
      s[i] = ' ';
    }
    i = 0;
    for (j = 0; name[j] != 0; j++) {
      if (i >= 11) {
	return;
      }
      if (name[j] == '.' && j <= 8) {
	i = 8;
      } else {
	s[i] = name[j];
	if ('a' <= s[i] && s[i] <= 'z') {
	  s[i] -= 0x20;
	}
	i++;
      }
    }
    for (i = 0; i < 11; i++) {
      finfo->name[i] = s[i];
    }
    /* gq͕ςȂH */
    add_fdc_req_addr(freq, (char *) ((int) finfo - ADR_DISKIMG), 0x20);
  }
  end_fdc_req(freq);
	
  return;
}
int alloc_cluster(void)
{
  int clustno;
  for (clustno = 0; clustno < 2849; clustno++) {
    if (fat[clustno] == 0x0000) {
      // Ă
      return clustno;
    }
  }
  return -1;			/* Ȃ */
}
/* int mkdir(const char *path) */
/* { */
/*   struct FAT_dirent dirent; */
/*   int ret; */
/*   int clus_num; */
/*   struct FILEHANDLE file_dot,file_dotdot; */
/*   char *dir,file[FILENAME_LEN+1]; */
/*   unsigned char ptr[DIRENT_SIZE]; */
/*   ret=path_to_dirent(path,&(file_dot.dirent)); */
/*   /\* ret̓NX^ionameȂ̂ŒӁB֐Kv *\/ */
/*   if(file_open_cluster(&file_dot,ret,'w')==0){ */
/*     return -1;			/\* can't make file *\/ */
/*   } */
/*   file_close(&file_dot); */
/*   clus_num=alloc_cluster(); */
/*   ret=create_dirent(path,&dirent,ATTR_DIRECTORY,clus_num); */
/*   if(ret<0){ */
/*     return -1; */
/*   } */
/*   /\* .Gg쐬 *\/ */
/*   file_open_cluster(&file_dot,ret,'w'); */
/*   dirent=file_dot.dirent;	/\* struct filedirentvf邩mFBstruct FILEɂ邩? *\/ */
/*   memcpy (dirent.name, DIR_DOT, FILENAME_LEN + 1); */
/*   encode_dirent(ptr,&dirent); */
/*   file_write(&file_dot,ptr,DIRENT_SIZE,file_dot.freq); /\* freq̏ꏊwB *\/ */
/*   file_close(&file_dot); */
/*   /\* ..Gg쐬 *\/ */
/*   dir=divide_path_right(path,file); */
/*   ret=path_to_dirent(path,&(file_dotdot.dirent)); */
/*   file_open_cluster(&file_dotdot,ret,'w'); */
/*   FAT12_readdir (&file_dotdot, &dirent, 0); */
/*   file_close(&file_dotdot); */
/*   memcpy (dirent.name, DIR_DOTDOT, FILENAME_LEN + 1); */
/*   encode_dirent (ptr, &dirent); */
/*   file_write(&file_dot,ptr,DIRENT_SIZE,file_dot.freq); /\* freq̏ꏊw *\/ */
  
/*   dirent.name [0] = DIRENT_END_DIR; */
/*   encode_dirent (ptr, &dirent); */
/*   file_write(&file_dot,ptr,DIRENT_SIZE,file_dot.freq); */

/*   file_close(&file_dot); */
/*   return 0; */
/*   /\* Ƃ肠mkdirɊւĂ͘_IȊԈႢ͂Ȃ͂ *\/ */
/* } */
