#include <stdio.h>
#include <string.h>
#include "head.h"
#include "OREhead.h"
#include "linux_vfat.h"
extern struct TASK *task_close;
extern struct TASKCTL *task_control;
extern struct wcontrol *window_control;
void COMOREcmd_see(struct ORE *value);
void ORE_newline(struct ORE *value)
{
  int i,j;

  if(value->cur_y<(value->window->ysize-value->shift*2-WINDOW_TITLESIZE-font_ysize)){
    value->cur_y+=font_ysize;
  }else{
    for(j=WINDOW_TITLESIZE;j<CONSOLE_YWIDTH-WINDOW_TITLESIZE-value->shift;j++){
      for(i=value->shift;i<CONSOLE_XWIDTH-value->shift;i++){
	value->window->buffer[j*value->window->xsize+i]=value->window->buffer[(j+font_ysize)*value->window->xsize+i];
      }
    }
    refresh_window(value->window,value->shift,WINDOW_TITLESIZE,CONSOLE_XWIDTH-value->shift,CONSOLE_YWIDTH-WINDOW_TITLESIZE-value->shift);
    box(value->window,value->shift,CONSOLE_XWIDTH-WINDOW_TITLESIZE-value->shift,CONSOLE_YWIDTH-value->shift,CONSOLE_XWIDTH-WINDOW_TITLESIZE,KURO);
  }
  value->cur_x=0;
  return;
}
void execute(struct ORE *value)
{
  struct window *window;
  int i;
  open_console();
  for(i=0;value->filelist[value->position][value->nowfile[value->position]][i]!=0x00;i++){
    fifo_in(&window->task->fifo,value->filelist[value->position][value->nowfile[value->position]][i]+256);
  }
  fifo_in(&window->task->fifo,10+256);
  return;
}
void ORE_exit(struct ORE *value)
{
  struct TASK *task=task_now();
  switch_window(value->window,-1);
  io_cli();
  fifo_in(&(task_control->task_close->fifo),value->window-window_control->window+512);
  io_sti();
  close_window(value->window);
  for(;;){
    task_sleep(task);
  }
}
void close_OREconsoletask(struct TASK *task)
{
  task_sleep(task);
  free4((struct manager *)(MANAGER_ADDR),task->stack,64*1024);
  free4((struct manager *)(MANAGER_ADDR),(int)task->fifo.buffer,ORECONSOLE_BUFFER_LENGTH);
  io_cli();
  task->flag=TASK_NOT_USING;
  if(task_control->task_fpu==task){
    task_control->task_fpu=0;
  }
  io_sti();
  return;
}
void close_OREconsole(struct window *window)
{
  struct TASK *task=window->task;
  switch_window(window,-1);
  free4((struct manager *)(MANAGER_ADDR),(int)window->buffer,CONSOLE_XWIDTH*CONSOLE_YWIDTH*2);
  close_window(window);
  close_OREconsoletask(task);
  return;
}
void COMORE_newline(struct ORE *value)
{
  int i,j;
  if(value->comcur_y<(value->window->ysize-value->shift*2-WINDOW_TITLESIZE-font_ysize)){
    value->comcur_y+=font_ysize;
  }else{
    for(j=CONSOLE_YWIDTH-120;j<CONSOLE_YWIDTH-value->shift;j++){
      for(i=value->shift;i<CONSOLE_XWIDTH-value->shift;i++){
	value->window->buffer[j*value->window->xsize+i]=value->window->buffer[(j+font_ysize)*value->window->xsize+i];
      }
    }
    refresh_window(value->window,value->shift,CONSOLE_YWIDTH-120,CONSOLE_XWIDTH-value->shift,CONSOLE_YWIDTH-value->shift);
    box(value->window,value->shift,CONSOLE_YWIDTH-value->shift-font_ysize,CONSOLE_XWIDTH-value->shift,CONSOLE_YWIDTH-value->shift,KURO);
  }
  value->comcur_x=value->shift;
  return;
}

void COMORErun_cmd(struct ORE *value)
{
  if(strcmp(value->cmdline,"ls")==0){
    COMOREcmd_ls(value);
  }else if(strcmp(value->cmdline,"see")==0){
    COMOREcmd_see(value);
  }else{
    COMprint_ORE(value,"unknown\n",0xffff);
  }
  return;
}
void COMOREcmd_ls(struct ORE *value)
{
  int x,y;
  char s[30];
  struct FILEINFO *finfo=(struct FILEINFO *)(ADR_DISKIMG+0x002600);
  for(x=0;x<MAX_FILES;x++){
    if(finfo[x].name[0]==0x00){
      break;
    }
    if(finfo[x].name[0]!=0xe5){
      if((finfo[x].type&0x18)==0){
	if((finfo[x].type&0x10)==0 && (finfo[x].type&0x08)!=0){
	  COMprint_ORE(value,"DIR ",0x64bd);
	}
	sprintf(s,"filename.ext size:%7d",finfo[x].size);
	for(y=0;y<8;y++){
	  s[y]=finfo[x].name[y];
	}
	s[9]=finfo[x].ext[0];
	s[10]=finfo[x].ext[1];
	s[11]=finfo[x].ext[2];
	COMprint_ORE(value,s,0xf7a8);
	COMORE_newline(value);
      }
    }
  }
}
void COMOREcmd_see(struct ORE *value)
{
  struct FILEHANDLE fh;
  char *buffer;
  buffer=(char *)alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct msdos_dir_slot));
  file_open(&fh,"test",'r');
  file_read(&fh,buffer,sizeof (struct msdos_dir_slot));
  fat_build_slots("child",&fh,1);
  file_close(&fh);
  free4((struct manager *)(MANAGER_ADDR),(unsigned int *)buffer,sizeof (struct msdos_dir_slot));
}
int OREsearch(struct ORE *value,int start,int end)
{
  int i,j;
  for(i=start;i<=end;i++){
    j=kmp_search(value->filelist[value->position][i],value->cmdline);
    if(j>-1){
      return i;
    }
  }
  return -1;
}
