static    char    sccsid[]="%Z% %M% %I% %D% %T%";
/*
	cc -g -DLINUX -I../include test_qsort2.c -o test_qsort2
*/
#include <akxcommon.h>

static int _cmp_qsort_r(a,b,c_arg)
char *a,*b,*c_arg;
{
	int *arg,mlen,opt,dif;
	short sa,sb;
	long la,lb;
	char ca,cb;

printf("_cmp_qsort_r: a=%08x b=%08x c_arg=%08x\n",a,b,c_arg);

	arg = (int *)c_arg;
	opt  = arg[0];
	mlen = arg[1];

printf("_cmp_qsort_r: mlen=%d opt=%d\n",mlen,opt);

	if (opt & 0x02) {
		if (mlen <= sizeof(char))
			dif = *a - *b;
		else if (mlen <= sizeof(short))
			dif = *(short *)a - *(short *)b;
		else if (mlen <= sizeof(int))
			dif = *(int *)a - *(int *)b;
		else
			dif = *(long *)a - *(long *)b;
	}
	else {
		dif = memcmp(a,b,mlen);
	}
	if (opt & 0x01) dif = -dif;
printf("_cmp_qsort_r: dif=%d\n",dif);
	return dif;
}

static void _swap(a,b,size)
char *a,*b;
int size;
{
	char tmp;

	while (size--) {
		tmp = *b;
		*b = *a;
		*a = tmp;
		a++;
		b++;
	}
}

static int _compare(a,b,c_arg)
char *a,*b,*c_arg;
{
	int *arg,dif,opt,size;

	arg = (int *)c_arg;
	opt  = arg[0];
	size = arg[1];
	dif = memcmp(a,b,size);
	if (opt & 0x01) dif = -dif;
	return dif;
}

static void QuickSort(dat,iSta,iEnd,size,_compar,arg)
char *dat;
int iSta,iEnd,size;
int (*_compar)();
char *arg;
{
	int iBaseNum,iCnt,i,ii;
	char strBaseVal[256],*p_i,*p_cnt,*p_sta;

	if (iSta >= iEnd) return;
	iBaseNum = (iSta + iEnd) / 2;
	memcpy(strBaseVal,dat+iBaseNum*size,size);
	memcpy(dat+iBaseNum*size,dat+iSta*size,size);
	iCnt = iSta;
	p_sta = p_cnt = dat + iSta*size;
	p_i = p_sta + size;
	for (i = iSta + 1;i<=iEnd;i++) {
		if (_compar(p_i,strBaseVal,arg) < 0) {
			iCnt++;
			p_cnt += size;
			_swap(p_cnt,p_i,size);
		}
		p_i += size;
	}
	memcpy(p_sta,p_cnt,size);
	memcpy(p_cnt,strBaseVal,size);
	QuickSort(dat,iSta,iCnt-1,size,_compar,arg);
	QuickSort(dat,iCnt+1,iEnd,size,_compar,arg);
	return;
}

int main()
{
	static int lena[]={-8,2,4,9,1,0,-3,6,5,7};
	int i,arg[0];

	for (i=0;i<10;i++) {
		printf("i=%d lena=%d\n",i,lena[i]);
	}
	arg[0] = 0x03;
	arg[1] = 4;
	QuickSort(lena,0,9,4,_cmp_qsort_r,(char *)arg);
	for (i=0;i<10;i++) {
		printf("i=%d lena=%d\n",i,lena[i]);
	}
}
