static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi 2010.05.10		*/
/*											*/
/********************************************/
#include "akxcommon.h"

static char *gsep=" \t,;()[]{}<>='\"!^*/";

/********************************************************/
/*														*/
/********************************************************/
int memicmp(sa,sb,len)
uchar *sa,*sb;
int len;
{
	uchar ca,cb;
	int i,dif;

	if (!sa || !sb) return -1;
	dif = 0;
	for (i=0;i<len;i++) {
		ca = *sa++;
		cb = *sb++;
		if (dif=akxcupper(ca)-akxcupper(cb)) break;
	}

	return dif;
}

/********************************************************/
/*	n_min<=0 ̂Ƃ́Alen=n_max ̂ƂȊÓA			*/
/*						vȂȂ					*/
/*	n_max<0 or n_min>n_max ̂Ƃ́A					*/
/*						͈̓`FbNsȂ			*/
/*						mem[i]cmp(sa,sb,len)ƓɂȂ*/
/*	opt : 0x01 : 啶Ȃ					*/
/********************************************************/
int memrngcmp_opt(sa,len,sb,n_min,n_max,opt)
uchar *sa,*sb;
int len,n_min,n_max,opt;
{
	int ret;

	if (!n_min) n_min = n_max;
	if (n_max>=0 && n_min<=n_max) {
		if (len < n_min) return -1;
		if (len > n_max) return 1;
	}
	if (opt & 0x01) ret = memicmp(sa,sb,len);
	else ret = memcmp(sa,sb,len);
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int memrngcmp(sa,len,sb,n_min,n_max)
uchar *sa,*sb;
int len,n_min,n_max;
{
	return memrngcmp_opt(sa,len,sb,n_min,n_max,0);
}

/********************************************************/
/*														*/
/********************************************************/
int memirngcmp(sa,len,sb,n_min,n_max)
uchar *sa,*sb;
int len,n_min,n_max;
{
	return  memrngcmp_opt(sa,len,sb,n_min,n_max,1);
}

/********************************************************/
/*														*/
/********************************************************/
int memrcpy(d0, s0, len)
char *d0,*s0;
int len;
{
	int i;
	char *d,*s;

	if (!d0) return -1;
	if (len>0 && s) {
		s = s0 + len -1;
		d = d0 + len -1;
		while (len-- > 0) *d-- = *s--;
	}
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memncpy(d, s, len, n)
char *d,*s;
int len,n;
{
	if (!d) return -1;
	if (n < len) len = n;
	if (len < 0) len = 0;
	if (len>0 && s) memcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memzcpy(d, s, len)
char *d,*s;
int len;
{
	if (!d) return -1;
	if (len < 0) len = 0;
	if (len>0 && s) memcpy(d,s,len);
	*(d+len) = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memrzcpy(d, s, len)
char *d,*s;
int len;
{
	len = memrcpy(d,s,len);
	if (len >= 0) *(d+len) = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memnzcpy(d, s, len, n)
char *d,*s;
int len,n;
{
	if (!d) return -1;
	n--;	/* 2021.8.22 n͏I[null܂ޒ */
	if (n < len) len = n;
	if (len < 0) len = 0;
	memzcpy(d,s,len);
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int memcat(d, s, len)
char *d,*s;
int len;
{
	if (!d) return -1;
	memzcpy(d+strlen(d),s,len);
	return len;
}

#if !defined(SUNOS5) && !defined(SUNOS) && !defined(LINUX)
/********************************************************/
/*														*/
/********************************************************/
int stricmp(sa,sb)
uchar *sa,*sb;
{
	uchar ca,cb;
	int d=0;

	if (!sa || !sb) return -1;
	for (;;) {
		ca = *sa++;
		cb = *sb++;
		if (!ca && !cb) break;
		if (d=akxcupper(ca)-akxcupper(cb)) break;
	}

	return d;
}
#endif

#if defined(SUNOS) || defined(AIX)
/********************************************************/
/*														*/
/********************************************************/
char *strerror(err)
int err;
{
	char *p;
	extern char *sys_errlist[];
	extern int  sys_nerr;

	if (err>=0 && err<sys_nerr) p = sys_errlist[err];
	else p = AKX_NULL_PRINT;
	return p;
}
#endif

/********************************************************/
/*														*/
/********************************************************/
char *strnzcpy(d, s, len)
char *d,*s;
int len;
{
	if (!d || !s) return NULL;
	if (len < 0) len = 0;
	*(d+len) = '\0';
	return strncpy(d,s,len);
}

/****************************************/
/*										*/
/****************************************/
int akxmemwork(len,pp1,pp0,work,w_len)
int  len;
char **pp0,**pp1,*work;
int  w_len;
{
	char *p,*mem;
	int im;

	if (!pp1 || len<0) return -1;
	im = 1;
	mem = work;
	if (work && len<w_len) im = 0;
	if (im) {
		if (pp0) {
			if (p=MRealloc(*pp0,len+1)) {
				mem = *pp0 = p;
			}
		}
		else p = NULL;
		if (!p) {
			if (work) len = w_len -1;
			else len = -1;
		}
	}
	*pp1 = mem;

	return len;
}

/****************************************/
/*										*/
/****************************************/
char *strmem(s,len)
char *s;
int  len;
{
	static char wrk[256],*p0=NULL;
	char *p;

	if ((len=akxmemwork(len,&p,&p0,wrk,sizeof(wrk))) >= 0) {
		memzcpy(p,s,len);
	}
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv0(argc,argv,argl,pp0)
int   argc;
char *argv[];
int   argl[];
char **pp0;
{
	char *p,*p0,*pp,*pM;
	int  alen,blen;
	int i,len,same;

	if (!pp0) return NULL;
/*
printf("memadd0: alen=%d a=[%s] blen=%d b=[%s]\n",alen,a,blen,b);
*/
	p0 = *pp0;
	len = 1;
	same = 0;
	for (i=0;i<argc;i++) {
		len += argl[i];
		if (!argv[i]) same = 1;
	}
	if (!p0 || same) {
		if (!(pM=Malloc(len))) return NULL;
	}
	else {
		if (!(pM=Realloc(p0,len))) return NULL;
		p0 = NULL;
	}
	pp = pM;
	for (i=0;i<argc;i++) {
		if (p=argv[i]) {
			memcpy(pp,p,len=argl[i]);
			pp += len;
		}
	}
	*pp = '\0';
	if (p0) Free(p0);
/*
printf("memaddv0:%s\n",p);
*/
	*pp0 = pM;
	return pM;
}

/****************************************/
/*										*/
/****************************************/
char *memaddv(argc,argv,argl)
int   argc;
char *argv[];
int   argl[];
{
	static char *p0=NULL;

	return memaddv0(argc,argv,argl,&p0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd0(a,alen,b,blen,pp0)
char *a,*b,**pp0;
int  alen,blen;
{
	char *argv[2];
	int   argl[2];

	argv[0] = a;
	argv[1] = b;
	argl[0] = alen;
	argl[1] = blen;
	return memaddv0(2,argv,argl,pp0);
}
/****************************************/
/*										*/
/****************************************/
char *memadd(a,alen,b,blen)
char *a,*b;
int  alen,blen;
{
	static char *p0=NULL;

	return memadd0(a,alen,b,blen,&p0);
}

/****************************************/
/*										*/
/****************************************/
char *straddv(argc,argv)
int   argc;
char *argv[];
{
	static int *argl=NULL;
	int i;
	char *p;

	if (argc<=0 || !argv) return NULL;
	if (!(argl=(int *)MRealloc(argl,argc*sizeof(int)))) return NULL;
	memset(argl,0,argc*sizeof(int));
	for (i=0;i<argc;i++) {
		if (p=argv[i]) argl[i] = strlen(p);
	}
	return memaddv(argc,argv,argl);
}

/****************************************/
/*										*/
/****************************************/
char *stradd5(a,b,c,d,e)
char *a,*b,*c,*d,*e;
{
	char *argv[5];

	argv[0] = a;
	argv[1] = b;
	argv[2] = c;
	argv[3] = d;
	argv[4] = e;
	return straddv(5,argv);
}

/****************************************/
/*										*/
/****************************************/
char *stradd(a,b)
char *a,*b;
{
	if (!a) return b;
	if (!*a) return b;
	if (!b) return a;
	if (!*b) return a;
	return stradd5(a,b,NULL,NULL,NULL);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrnlen(s,len)
char *s;
int len;
{
	int i;
	char *p=s;

	for (i=0;i<len;i++) if (!*p++) break;

	return i;
}

/********************************************************/
/*														*/
/********************************************************/
char akxcupper(cc)
char cc;
{
	char c;

	if ((c=cc)>='a' && c<='z') c &= ~0x20;
	return c;
}

/********************************************************/
/*														*/
/********************************************************/
int akxqupper(cc)
char cc;
{
	char c;
	int ret;

	if ((c=cc)>='A' && c<='Z') ret = 1;
	else ret = 0;
	return ret;
}

/****************************************************************************/
/*  : akxtgwnsl															*/
/* @\ : 񂩂w肳ꂽ؂蕶ŋ؂ă[ho    		*/
/*        Xy[Xƃ^uȊŐ؂蕶IvVɂo    		*/
/*         --------------+----------------------*--------------------- 		*/
/*          " "̈    | opt & 0x200=0        | opt & 0x200<>0       		*/
/*         --------------+----------------------*--------------------- 		*/
/*          sep "  | "x" [hƂ   | " [hƂ     		*/
/*          sepT[`  | " ͋؂           | " ͋؂           		*/
/*         --------------+----------------------*--------------------- 		*/
/*          sep " Ȃ | "x" [hƂȂ | " [hƂȂ   		*/
/*          sepT[`  | "x" ΂         | " "`FbNȂ  		*/
/*         --------------+----------------------*--------------------- 		*/
/*  : buf	: ւ̃|C^B										*/
/*				  I[́ANULLA'\n'܂'\r'A񒷂܂				*/
/*				  IvVɂA'\'̌͋؂蕶̑ΏۂɂȂȂ	*/
/*		  len	: 񒷁ioCgjB										*/
/*		  sspl	: [ho\̂ւ̃|C^							*/
/*				  sp: T[`JnʒuA擪͂OoCgځB					*/
/*				  wd: [hi[GAւ̃|C^B[hi[		*/
/*					  IvVłANULL̂Ƃ́Ai[ȂB			*/
/*				  wdmax: > 0 : [hi[ő咷(oCg)						*/
/*						 = 0 : dɃ[h̐擪AhXԂ				*/
/*						 < 0 : `FbNɊi[					*/
/*				  attr[0]:[h										*/
/*							=1 :  or 							*/
/*							=5 : 'xxxx'										*/
/*							=6 : "xxxx"										*/
/*							=0x80 or asc : ؂蕶						*/
/*									 asc:؂蕶̔pR[h				*/
/*										 płȂƂ́A0x7F				*/
/*				  attr[1]:QoCgLtOB1/0=^Ȃ			*/
/*				  attr[2]:sSkQdlp̂ƂA0x01					*/
/*						  [hi[ɃI[o[t[A0x02OR	*/
/*				  attr[3]:[Qd]pɘA[Qd]p̂ƂA1 */
/*				  code: R[h = 0 : VXe̕R[h				*/
/*		  sep	: ؂蕶BNULL̂Ƃ́Agsepg				*/
/*		  opt	: IvV												*/
/* 0x01 = 0/1 : sXy[Xƃ^uXLbvȂ / XLbv			*/
/* 0x02 = 0/1 : QdpAp͂Ȃ(sSG[) / ͂	*/
/* 0x04 = 0/1 : QdpAp̘̒AQ̂PɂȂ	*/
/*              / Pɂ												*/
/* 0x08 = 0/1 : QdpAp̏ / Ȃ				*/
/* 0x10 = 0/1 : ؂蕶ȊO܂ŃXLbvȂ / L	*/
/* 0x20 = 0/1 : gpBsspl->wdmaxgp								*/
/*      wdmax= 0:ssp->wdɃ[hi[A[h̐擪AhX	*/
/*      wdmax<>0:ssp->wdɃ[hi[ (wdmax<0:`FbNȂ)	*/
/* 0x40 = 0/1 : '\n'܂'\r'I[Ƃ / I[ƂȂ					*/
/*				(=1 ́Ap̂Ƃ̂ݗL)								*/
/* 0x80  = 1 : '\'GXP[vƂBp̒ȊO'\'͍폜B	*/
/* 0x100 = 1 : p̏Ȃ											*/
/* 0x200 = 1 : Qdp̏Ȃ										*/
/* 0x400 = 1 : ؂蕶p̏ꍇA啶ʂȂB			*/
/* 0x800 = 1 : '`'pƂ											*/
/****************************************************************************/
int akxtgwnsl(buf, len, sspl, sep, opt)
char *buf, *sep;
SSPL_S *sspl;
int len, opt;
{
	int	opt_0,opt_1,opt_2,opt_3,opt_4,opt_5,opt_6,opt_8,opt_9,opt_80,opt_400,opt_800;
	int i, l, pos, nsep, lmax, m,splen,in_opt;
	char *s, ch, *w, quat, *psep, cs;
	uchar pattr[4],code_type;

	if (!buf || !sspl) return -2;
	if (!sep) sep = gsep;

	if (sspl->sp < 0) sspl->sp = 0;
	pos = sspl->sp;
/*
printf("akxtgwnsl:Enter len=%d pos=%d buf=[%s]\n",len,pos,strmem(buf,len));
*/
	w = sspl->wd;
	lmax = sspl->wdmax;
	pattr[1] = 0;
	sspl->attr[0] = 0;
	sspl->attr[1] = 0;
	sspl->attr[2] = 0;
	sspl->attr[3] = 0;
	opt_2 = opt & 0x04;
	if (lmax && w) opt_5 = 1;
	else {
		opt_2 = 0;
		opt_5 = 0;
	}
	if (opt_5) *w = '\0';
	else sspl->wd = "";

	if (pos > len) {
/*
printf("akxtgwnsl:Exit2 pos=%d w=[%s]\n",pos,sspl->wd);
*/
		return -1;
	}
	else if (pos == len) {
		sspl->sp++;
/*
printf("akxtgwnsl:Exit1 pos=%d w=[%s]\n",sspl->sp,sspl->wd);
*/
		return 0;
	}

	nsep = strlen(sep);
	s = buf + pos;
	pattr[1] = 0;
	opt_0 = opt & 0x01;
	opt_1 = opt & 0x02;
	opt_3 = !(opt & 0x08);
	opt_4 = opt & 0x10;
	opt_6 = !(opt & 0x40);
	opt_8 = !(opt & (0x100 | 0x08));
	opt_9 = !(opt & (0x200 | 0x08));
	opt_80 = opt & 0x80;
	if (opt_400 = opt & 0x400) in_opt = 1;
	else in_opt = 0;
	opt_800 = opt & 0x800;
	if (opt & 0x08) opt_800 = 0;
	l = 0;

	if ((code_type=sspl->code) == CD_TYPE_SYSTEM) code_type = akxt_get_code_type();

	/* ؂蕶ȊO܂ŃXLbv */
	if (opt_4) {
#if 1	/* 2021.4.20 */
		while((pos<len)&&((ch=*s)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			m = akxqmbsnlen(code_type,s,len-pos);
			if (akxs_in_mem_opt(sep,nsep,s,m,in_opt) <= 0) {
				l = m;
				break;
			}
			s += m;
			pos += m;
		}
/*
printf("akxtgwnsl:opt_4: pos=%d l=%d\n",pos,l);
*/
#else
		while((pos<len)&&((ch=*s++)!='\0')) {
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			for (i=0,psep=sep;i<nsep;i++) {
				cs = *psep++;
				if (opt_400) {
					ch = akxcupper(ch);
					cs = akxcupper(cs);
				}
				if (ch == cs) break;
			}
			if (i>=nsep) {
				l = 1;
				break;
			}
			pos++;
		}
#endif
		if (!ch) pos = len;	/* add 2023.3.4 NULLꂽlenɒBƂɂ */
		sspl->sp = pos;
		if (opt_5) *w = '\0';
		else sspl->wd = s;
/*
printf("akxtgwnsl:Exit3 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
	/* sXy[Xƃ^uXLbv */
	if (opt_0) {
#if 1	/* 2020.3.9 */
		while (pos<len && (ch=*s)) {
			if ((m=akxqmbsnlen(code_type,s,len-pos)) > 1) break;
			else if ((ch=*s)=='\\' && opt_80) {
				pos++;
				s++;
				if (pos < len) {
					if (!(m=akxqmbsnlen(code_type,s,len-pos))) m = 1;
					pos += m;
					s += m;
				}
			}
			else if (((ch=*s)==' ')||(ch=='\t')||
			         (!opt_6 && ((ch=='\n')||(ch=='\r')))) {
				pos++;
				s++;
			}
			else break;
#else
		while((pos<len)&&(((ch=*s)==' ')||(ch=='\t')||
		                  (!opt_6 && ((ch=='\n')||(ch=='\r'))))) {
			pos++;
			s++;
#endif
/*
printf("akxtgwnsl:1 pos=%d c=[%c]\n",pos,*s);
*/
		}
/*
printf("akxtgwnsl:2 pos=%d c=[%c]\n",pos,*s);
*/
		if (!ch) pos = len;	/* add 2023.3.4 NULLꂽlenɒBƂɂ */
		if (pos >= len) {
			sspl->sp = pos;
			if (opt_5) *w = '\0';
			else sspl->wd = s;
/*
printf("akxtgwnsl:Exit4 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
			return 0;
		}
	}
	if (!opt_5) sspl->wd = s;
	ch = *s;
#if 1	/* 2023.3.4 */
	if (!ch) {
		pos = len;	/* add 2023.3.4 NULLꂽlenɒBƂɂ */
		sspl->sp = pos;
		if (opt_5) *w = '\0';
		return 0;
	}
#endif
	m = akxqmbsnlen(code_type,s,len-pos);

/*	if (opt_3 && (pos<len) && (ch=='"' || ch=='\'')) {	*/
#if 1	/* 2020.3.9 */
  if (m == 1) {
	if (pos<len && ch=='\\' && opt_80) {	/* GXP[v̏ */
/*
printf("akxtgwnsl:4 pos=%d ch=[%c]\n",pos,ch);
*/
		pos++;
		s++;
		if (pos < len) {
#if 1
			if (!(m=akxqismbs(code_type,s))) m = 1;
			l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
			pos += m;
			s += m;
#else
			ch = *s;
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			pos++;
			s++;
#endif
			ch = *s;
		}
	}
	else
#endif
	if ((pos<len) && ((ch=='"' && opt_9) || (ch=='\'' && opt_8) || (ch=='`' && opt_800))) {	/* p */
/*
printf("akxtgwnsl:5 pos=%d c=[%c]\n",pos,ch);
*/
		if (opt_1 && !opt_5) sspl->wd++;
		if (ch=='"') sspl->attr[0] = 6;
		else if (ch=='\'') sspl->attr[0] = 5;
		else if (ch=='`') sspl->attr[0] = 7;
		quat=ch;
		pos++;
		s++;
		if (!opt_1) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
		}
		while((pos<len)&&((ch=*s)!='\0')) {
/*
printf("akxtgwnsl:3 pos=%d c=[%c]\n",pos,ch);
*/
			if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
			if (m=akxqismbs(code_type,s)) {
				l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
				pos += m;
				s += m;
				sspl->attr[1] = 1;
			}
#if 1	/* 2020.3.9 */
			else if (ch=='\\' && opt_80) {
/*
printf("akxtgwnsl:5 pos=%d ch=[%c]\n",pos,ch);
*/
#if 1	/* add 2020.10.10 */
				l = akxwdmax_chk(&w,pattr,lmax,l,ch);
#endif
				pos++;
				s++;
				ch = *s;
				if (pos < len) {
					if (!(m=akxqismbs(code_type,s))) m = 1;
					l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
					pos += m;
					s += m;
				}
			}
#endif
			else {
				pos++;
				s++;
				if (ch == quat) {
					if ((pos >= len) || (*s != quat)) {
						if (!opt_1) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						if (opt_5) *w = '\0';
						sspl->sp = pos;
						if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit5 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
						return l;
					}
					else {
						sspl->attr[3] = 1;
						if (!opt_2) {
							l = akxwdmax_chk(&w,pattr,lmax,l,ch);
						}
						l = akxwdmax_chk(&w,pattr,lmax,l,quat);
						pos++;
						s++;
					}
				}
				else {
					l = akxwdmax_chk(&w,pattr,lmax,l,ch);
				}
			}
		}
		if (opt_5) *w = '\0';
		sspl->sp = pos;
		if (!opt_1) sspl->attr[2] = 1;
		if (pattr[1]) sspl->attr[2] |= 0x02;
/*
printf("akxtgwnsl:Exit6 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
  }
	/* ؂蕶̏ */
#if 1	/* 2021.4.20 */
	m = akxqmbsnlen(code_type,s,len-pos);
	if (akxs_in_mem_opt(sep,nsep,s,m,in_opt)>0 || (ch=='`' && opt_800)) {
		l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
		if (opt_5) *w = '\0';
		pos += m;
		sspl->sp = pos;
		if (m > 1) ch = 0x7f;
		sspl->attr[0] = ch | 0x80;
		if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit7 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
		return l;
	}
#else
	for (i=0,psep=sep;i<nsep;i++) {
		cs = *psep++;
		if (opt_400) {
			ch = akxcupper(ch);
			cs = akxcupper(cs);
		}
		if (ch==cs) {
			l = akxwdmax_chk(&w,pattr,lmax,l,ch);
			if (opt_5) *w = '\0';
			pos++;
			sspl->sp = pos;
			sspl->attr[0] = ch | 0x80;
			if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit7 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
			return l;
		}
	}
#endif
	while ((pos<len)&&((ch=*s)!='\0')) {
/*
printf("akxtgwnsl: pos=%d ch=[%c]\n",pos,ch);
*/
		if (opt_6 && ((ch=='\n')||(ch=='\r'))) break;
#if 0	/* 2021.4.20 */
		if ((pos+1<len) && (m=akxqismbs(code_type,s))) {
			l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
			pos += m;
			s += m;
			sspl->attr[1] = 1;
		}
		else {
#endif
			if ((pos+1==len) && akxqismbs1(code_type,*s)) {
				pos++;
				break;
			}
			if ((pos<len) && ch=='\\' && opt_80) {
/*
printf("akxtgwnsl:6 pos=%d ch=[%c]\n",pos,ch);
*/
				pos++;
				s++;
#if 1	/* 2021.4.20 */
				m = akxqmbsnlen(code_type,s,len-pos);
				if (pos < len) {
					l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
					pos += m;
					s += m;
				}
#else
				ch = *s;
				if (pos < len) {
					l = akxwdmax_chk(&w,pattr,lmax,l,ch);
					pos++;
					s++;
				}
#endif
			}
			else {
				/* ؂蕶̏ */
#if 1	/* 2021.4.20 */
				m = akxqmbsnlen(code_type,s,len-pos);
				if (akxs_in_mem_opt(sep,nsep,s,m,in_opt)>0 || (ch=='`' && opt_800)) {
#if 1
					break;
#else
					if (opt_5) *w = '\0';
					sspl->sp = pos;
					sspl->attr[0] = 1;
					if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit8 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
					return l;
#endif
				}
				l = akxwdmax_chkm(&w,pattr,lmax,l,s,m);
				pos += m;
				s += m;
#else
				for (i=0,psep=sep;i<nsep;i++) {
					if (ch==*psep++) {
						if (opt_5) *w = '\0';
						sspl->sp = pos;
						sspl->attr[0] = 1;
						if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit8 pos=%d l=%d w=[%s]\n",pos,l,sspl->wd);
*/
						return l;
					}
				}
				l = akxwdmax_chk(&w,pattr,lmax,l,ch);
				pos++;
				s++;
#endif
			}
#if 0	/* 2021.4.20 */
		}
#endif
	}
	if (opt_5) *w = '\0';
	sspl->sp = pos;
	if (l>0) sspl->attr[0] = 1;
	if (pattr[1]) sspl->attr[2] = 0x02;
/*
printf("akxtgwnsl:Exit pos=%d i=%d w=[%s]\n",pos,l,sspl->wd);
*/
	return l;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwns(buf, len, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int len, opt;
{
	SSPL_S sspl;
	int ret;

	memcpy(&sspl,ssp,sizeof(SSP_S));
	if (opt & 0x20) sspl.wdmax = 0;
	else sspl.wdmax = -1;
	sspl.code = 0;
	ret = akxtgwnsl(buf,len,&sspl, sep, opt);
	memcpy(ssp,&sspl,sizeof(SSP_S));
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwse(buf, ssp, sep, opt)
char *buf, *sep;
SSP_S *ssp;
int opt;
{
	return akxtgwns(buf,INT_MAX,ssp,sep,opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtgwsp(buf, ssp)
char *buf;
SSP_S *ssp;
{
	return akxtgwse(buf,ssp,gsep,0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpknsl(s, slen, ssp, sep, opt)
char *s, *sep;
SSPL_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwnsl(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtpkns(s, slen, ssp, sep, opt)
char *s, *sep;
SSP_S *ssp;
int slen, opt;
{
	int pos,len;

	if (!ssp) return -1;
	pos = ssp->sp;
	len = akxtgwns(s,slen,ssp,sep,opt);
	ssp->sp = pos;
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcctox(puc,len,pux)
uchar *puc,*pux;
int len;
{
	int sw,m,n;
	uchar *pucw,*puxw,uc;

	if (!(pucw=puc) || !(puxw=pux)) return -1;
	n = len;
	m=sw=0;
	while (n--) {
		uc = *pucw++;
 		if   ((uc>='0') && (uc<='9')) uc -= '0';
		else if ((uc>='A') && (uc<='F')) uc -= 'A' - 10;
		else if ((uc>='a') && (uc<='f')) uc -= 'a' - 10;
		else uc = 0;
		if (sw) {
			*puxw |= uc;
			sw=0;
			puxw++;
		}
		else {
			*puxw = uc<<4;
			sw=1;
			m++;
		}
	}
	return m;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtsrepc(s,cs,cd)
char *s,cs,cd;
{
	int n=0;
	char c;

	while (c=*s) {
		if (c == cs) {
			n++;
			*s = cd;
		}
		s++;
	}
	return n;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_get_last_name(delm,path)
char *delm, *path;
{
	int len, i;
	char *name, *p;

	if (!path) return NULL;
	if (!delm) return path;
	if (!(*delm)) return path;

	len = strlen(name=path);
	i = akxnrskipto(name,len,delm);
	if (i >= 0) name += i;
	return name;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcxtoc(s,len,d)
char *s, *d;
int len;
{
	int i;
	uchar ucH, ucL;

	for (i=0;i<len;i++) {
		ucH = *s >> 4 & 0x0F;
		ucL  = *s++ & 0x0F;
		if (ucH >= 10) *d++ = (ucH-10) + 'a';
		else *d++ = ucH + '0';
		if (ucL >= 10) *d++ = (ucL-10) + 'a';
		else *d++ = ucL + '0';
	}
	return len*2;
}

/********1*********2*********3*********4*********5*********6**********7**/
/*  : akxcxtocn														*/
/* @\ : \[Xf[^oCgPʂ16i\ɕϊB				*/
/*		  interval0<>0 ̂Ƃ́ÅԊuŃXy[XB̂ƂA */
/*		  Ō̃Xy[X͏o͂ȂB									*/
/*  : IN    s        : \[Xf[^									*/
/*				len      : \[Xf[^̃oCg						*/
/*				d        : o͈										*/
/*				mlen     : õ͈oCg(I[null܂)			*/
/*				interval0: Xy[Xo͊Ԋu(\[Xf[^ł̃oCg)	*/
/*							=0 : len							*/
/*							<0 : o͊ԊuSă[̂ƂA'Z'o	*/
/* ԋp : ϊoCg(I[null܂܂Ȃ)							*/
/************************************************************************/
int akxcxtocn(s,len,d,mlen,interval0)
char *s, *d;
int len,mlen,interval0;
{
	int i,m,n,interval,interval1;
	char c,*p;

	n = 0;
	if ((interval1=interval0) < 0) interval1 = -interval1;
	interval = interval1;
	if (!interval) interval = len;
	if (interval > len) interval = len;
/*
printf("akxcxtocn:Enter: len=%d mlen=%d interval0=%d interva=%d\n",len,mlen,interval0,interval);
*/
	mlen--;
	while (len > 0) {
		if (mlen < 2) break;
		if (len < interval) interval = len;
		if (mlen/2 < interval) interval = mlen/2;
/*
printf("akxcxtocn: mlen=%d interval=%d\n",mlen,interval);
*/
		c = ' ';
		if (interval0<0 && interval==interval1) {
			c = '\0';
			p = s;
			for (i=0;i<interval;i++) c |= *p++;
		}
		if (!c && interval>1) {
		/*	*d = '0';
			*(d+1) = '*';
			m = 2;	*/
			*d = 'Z';
			m = 1;
		}
		else m = akxcxtoc(s,interval,d);
		len -= interval;
		s += interval;
		d += m;
		*d++ = ' ';
		m++;
		n += m;
		mlen -= m;
	}
	if (*(d-1) == ' ') {
		d--;
		n--;
	}
	*d = '\0';
	return n;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxt_add_dir2(cpDir,cpFile,cppPath)
char *cpDir,*cpFile,**cppPath;
{
	char *cpPath;
	char *p;
	int len;

	if (!cpDir) return cpFile;
	if (!(*cpDir)) return cpFile;
	if (!cpFile || !*cpFile) return cpDir;
	if (*cpFile == '/') return cpFile;
	if (!cppPath) return NULL;

	cpPath = *cppPath;
	len = strlen(cpDir) + strlen(cpFile) + 2 + 8;
	if (cpPath) {
		if (!(cpPath=Realloc(cpPath,len))) return NULL;
	}
	else {
		if (!(cpPath=Malloc(len))) return NULL;
	}
	strcpy(cpPath,cpDir);
	p = cpPath + strlen(cpPath);
	if (*(p-1) != '/') *p++ = '/';
	strcpy(p,cpFile);
	*cppPath = cpPath;
	return cpPath;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_set_bits(ipBits,iMask,iSet)
int *ipBits,iMask,iSet;
{
	int b,m,i;

	b = *ipBits;
	m = iMask;
	if (i=iSet) {
		if (i < 0) b &= ~m;
		else if (i == 1) b |= m;
		else b = m;
		*ipBits = b;
	}
	return b & m;
}

/********************************************************/
/* @\ : targetstrɈvʒuԂ				*/
/*  : target  : Ώە							*/
/*		  ltar	  : Ώە (oCg)				*/
/*		  str	  : v镶						*/
/*		  lstr	  : str (oCg)						*/
/*		  opt	  : IvV							*/
/*					0x01 : ignore case					*/
/*			0x20->	0x02 : Spp𖳎			*/
/*					0x08 : 擪݂̂r			*/
/*			0x04->	0x10 : ԋpl̒P 0/1:oCg/	*/
/*			0x02->	0x20 : reverse						*/
/*					0x40 : vsv𔽓]			*/
/*			  0x7f000000 : R[h					*/
/* ԋp : >=1 vʒu̐擪̃oCg܂	*/
/*			  									*/
/********************************************************/
int akxs_in_mem_opt(target,ltar,str,lstr,opt)
char *target,*str;
int  ltar,lstr,opt;
{
	char *pt,*ps,z1[5];
	int  i,k,n,opt01,opt02,opt04,opt08,pos,unmatch,opt40;
	int  opt20,m,optw,nn[3],mtar,mstr,len,kk,mm,opt_type,code_type;

	if ((pt=target) && (ps=str)) {
		if (!ltar || !lstr) return 0;
/*
printf("akxs_in_mem_opt: ltar=%d pt=[%s] opt=%08x\n",ltar,pt,opt);
printf("                 lstr=%d ps=[%s]\n",lstr,ps);
*/
		opt01 = opt & 0x01;	/* ignore case */
		opt02 = opt & 0x20;	/* reverse */
		opt04 = opt & 0x10;	/* return moji position */
		opt08 = opt & 0x08;	/* compare top only */
		opt20 = opt & 0x02;	/* ignore zenkaku hankaku */
		opt40 = opt & 0x40;	/* compare except */
		optw = 0x04 | opt01 | opt20 | opt40;
		opt_type = opt & CD_TYPE_OPT_MASK;
		code_type = GET_TYPE_OPT(opt);
		optw |= opt_type;
		if (opt20) {
			mtar = akxctozen_type_opt(ltar,pt,0,code_type,opt_type);
			mstr = akxctozen_type_opt(lstr,ps,0,code_type,opt_type);
			if (opt08 && (mtar != mstr)) return 0;
		}
		else {
			if (opt08 && (ltar != lstr)) return 0;
			mstr = akxqmlen_type(ps,lstr,code_type);
			mtar = akxqmlen_type(pt,ltar,code_type);
		}
		n = mtar - mstr + 1;
/*		n = ltar - lstr + 1;	*/
		if (opt08 && n>1) n = 1;
/*
printf("akxs_in_mem_opt: n=%d opt=%04x optw=%04x\n",n,opt,optw);
*/
		pos = 0;
		len = ltar;
		i = kk = 1;
#if 1
		for (k=1;k<=n;k++) {
#else
		for (k=1,i=1;i<=n;i++,k++,pt++) {
#endif
/*
printf("akxs_in_mem_opt: k=%d i=%d kk=%d len=%d\n",k,i,kk,len);
*/
#if 1
			unmatch = akxmbncmp_type_opt(pt,len,ps,lstr,code_type,optw);
#else
			if (opt01) unmatch = akxmemicmp(pt,ps,lstr);	/* ignore case */
			else       unmatch = akxmemcmp(pt,ps,lstr);
#endif
			if (!unmatch) {
				if (opt04) {
					if (opt02) pos = kk;	/* reverse */
					else return kk;
				}
				else {
					if (opt02) pos = i;	/* reverse */
					else return i;
				}
			}
			mm = m = 1;
			if (opt20) {
				akxctozen1_type_opt(len,pt,0,nn,code_type,opt_type);
				m = nn[0];
				mm = nn[2];
/*
printf("akxs_in_mem_opt:opt20: m=%d mm=%d\n",m,mm);
*/
			}
			else if (k < n) {
			/*	m = akxqkanjilen(pt);	*/
				m = akxqmbsnlen(code_type,pt,len);
/*
printf("akxs_in_mem_opt: m=%d\n",m);
*/
			}
			len -= m;
			kk += mm;
			i  += m;
			pt += m;
		}
		return pos;
	}
	else return -1;
}

/********************************************************/
/*														*/
/*					0x01 : ignore case					*/
/*					0x02 : Spp𖳎			*/
/*					0x10 : ԋpl̒P 0/1:oCg/	*/
/*					0x20 : reverse						*/
/*			  0x7f000000 : code_type					*/
/********************************************************/
int akxs_in_mem_chars(target,ltar,str,opt)
char *target,*str;
int  ltar,opt;
{
#if 0
	int pos;

	pos = akx_skip_opt(target,ltar,str,opt | 0x08) + 1;
	if (pos > ltar) pos = 0;
	return pos;
#else	/* opt=0x02𐶂akxs_in_mem_opt()g */
	char w[5],*p;
	int lstr,m,code_type,pos,mpos,opt20,rpos,rmpos,ret;

	if (!target || !str) return -1;
	pos  = mpos  = 1;
	rpos = rmpos = 0;
	code_type = GET_TYPE_OPT(opt);
	opt20 = opt & 0x20;
	p = str;
	lstr = strlen(str);
	while (lstr > 0) {
		m = akxqmbsnlen(code_type,p,lstr);
		memzcpy(w,p,m);
		if (ret = akxs_in_mem_opt(target,ltar,w,m,opt)) {
			rpos = pos;
			rmpos = mpos ;
			if (!opt20) break;
		}
		lstr -= m;
		p += m;
		pos += m;
		mpos++;
	}
	if (opt & 0x10) rpos = rmpos;
	return rpos;
#endif
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_in_str_opt(target,str,opt)
char *target,*str;
int opt;
{
	char *pt,*ps;

	if ((pt=target) && (ps=str))
		return akxs_in_mem_opt(pt,strlen(pt),ps,strlen(ps),opt);
	else
		return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int instr(target,str)
char *target,*str;
{
	return akxs_in_str_opt(target,str,0);
}

/********************************************************/
/*														*/
/********************************************************/
int inistr(target,str)
char *target,*str;
{
	return akxs_in_str_opt(target,str,1);
}

/********************************************************/
/*														*/
/********************************************************/
char *stristr(target,str)
char *target,*str;
{
	int i;

	if ((i=akxs_in_str_opt(target,str,1)) > 0) return target+i-1;
	return NULL;
}

/********************************************************/
/*														*/
/********************************************************/
int inmemstr(target,lt,str)
char *target,*str;
int lt;
{
	if (str)
		return akxs_in_mem_opt(target,lt,str,strlen(str),0);
	else
		return -1;
}

/********************************************************/
/*														*/
/********************************************************/
int instrchar_opt(target,c,opt)
char *target,c;
int opt;
{
	char str[2];
	int pos;

	if (!target) pos = -1;
	else if (*target && c) {
		str[0] = c;
		str[1] = '\0';
		pos = akxs_in_str_opt(target,str,opt & 0x01);
	}
	else pos = 0;
	return pos;
}

/********************************************************/
/*														*/
/********************************************************/
int instrchar(target,c)
char *target,c;
{
	return instrchar_opt(target,c,0);
}

/********************************************************/
/*														*/
/********************************************************/
int instrichar(target,c)
char *target,c;
{
	return instrchar_opt(target,c,1);
}

/********************************************************/
/*														*/
/********************************************************/
int inmemchars(buf,len,ptn)
char *buf,*ptn;
int  len;
{
#if 1
	return akxs_in_mem_chars(buf,len,ptn,0);
#else
	int pos;

	pos = akx_skip_opt(buf,len,ptn,0x08) + 1;
	if (pos > len) pos = 0;
	return pos;
#endif
}

/********************************************************/
/*														*/
/********************************************************/
int inmemichars(buf,len,ptn)
char *buf,*ptn;
int  len;
{
#if 1
	return akxs_in_mem_chars(buf,len,ptn,0x01);
#else
	int pos;

	pos = akx_skip_opt(buf,len,ptn,0x01 | 0x08) + 1;
	if (pos > len) pos = 0;
	return pos;
#endif
}

/********************************************************/
/*														*/
/********************************************************/
int instrchars(buf,ptn)
char *buf,*ptn;
{
	return inmemchars(buf,strlen(buf),ptn);
}

/********************************************************/
/*														*/
/********************************************************/
int instrichars(buf,ptn)
char *buf,*ptn;
{
	return inmemichars(buf,strlen(buf),ptn);
}

/****************************************/
/*	Get General-Purpose Data			*/
/*		coded by A.Kobayashi 2003.11.19	*/
/****************************************/
int akxt_get_gep_data(klen,p,kpp,plalen)
int  klen;
char *p,**kpp;
int  *plalen;
{
	int  lalen;
	INT4 lklen;

	if (!p) return -1;
	if (klen>0) lalen=lklen=klen;
	else if (klen<0) {
		memcpy(&lklen,p,sizeof(INT4));
		if (lklen<0) return -2;
		p += sizeof(INT4);
		lalen=lklen+sizeof(INT4);
	}
	else {
		lklen=strlen(p);
		lalen=lklen+1;
	}
	if (kpp) *kpp = p;
	if (plalen) *plalen = lalen;
	return lklen;
}

/****************************************/
/*	Cmp General-Purpose Data			*/
/*	klen  : >0 : Œ蒷					*/
/*			=0 : string					*/
/*			<0 : len+key				*/
/*	kp    : rL[AhX			*/
/*	lklen : rL[				*/
/*	p     : rL[AhX			*/
/*			`klenɂ			*/
/*	opt   : 0x01 : ignore case			*/
/*		coded by A.Kobayashi 2003.11.25	*/
/****************************************/
int akxt_cmp_gep_data_opt(klen,kp,lklen,p,opt)
int  klen,lklen,opt;
char *kp,*p;
{
	INT4 ldlen;
	int  s,iCASE;

	if (!kp || !p) return -256;
	iCASE = opt & 0x01;
	if (klen>0) {
		if (iCASE) s = akxmemicmp(kp,p,lklen);
		else s = memcmp(kp,p,lklen);
	}
	else {
		if (klen<0) {
			memcpy(&ldlen,p,sizeof(INT4));
			if (ldlen<0) return -257;
			if (!(s=ldlen-lklen)) {
				if (iCASE) s = akxmemicmp(kp,p,lklen);
				else s = memcmp(kp,p+sizeof(INT4),lklen);
			}
		}
		else {
			if (iCASE) s = akxstricmp(kp,p);
			else s = strcmp(kp,p);
		}
	}
	return s;
}

/********************************************************/
/*														*/
/********************************************************/
int akxt_cmp_gep_data(klen,kp,lklen,p)
int  klen,lklen;
char *kp,*p;
{
	return akxt_cmp_gep_data_opt(klen,kp,lklen,p,0);
}

/********************************************************/
/*														*/
/********************************************************/
tdtConvMsgHead *akxc_conv_msg_new(mesg)
tdtMessages mesg[];
{
	tdtConvMsgHead *p;

	if (p=(tdtConvMsgHead *)Malloc(sizeof(tdtConvMsgHead))) {
		p->cmh_try      = 1;
		p->cmh_langmax  = -1;
		p->cmh_no_max   = 0;
		p->cmh_messages = mesg;
		p->cmh_index    = NULL;
		p->cmh_xhp      = NULL;
		akxc_conv_msg(p,1,0);
	}
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxc_conv_msg(cmh,no,lang)
tdtConvMsgHead *cmh;
int no,lang;
{
	tdtRbChain *xhp;
	tdtMessages *mesg,*me,**index;
	int  langmax,no_max,i,k,ix,reg_max;
	char *p;

	if (!cmh) return NULL;
	if (!(mesg=cmh->cmh_messages)) return NULL;
	me = &mesg[0];
	if (no <= 0) return (char *)me->mm_msg;

	xhp   = cmh->cmh_xhp;
	index = cmh->cmh_index;
	p = "";
	if (cmh->cmh_try && !xhp && !index) {
		cmh->cmh_try = 0;
		for (k=0;k<3;k++) {
			if (!me->mm_msg[k] || !*me->mm_msg[k]) break;
		}
		cmh->cmh_langmax = k - 1;
		no_max = k = 0;
		reg_max = me->mm_msgno;
		me++;
		for (;(i=me->mm_msgno)>=0;me++) {
			k++;
			if (i > no_max) no_max = i;
		}
		cmh->cmh_no_max = no_max;
/*
printf("akxc_conv_msg: langmax=%d msg_count=%d no_max=%d\n",cmh->cmh_langmax,k,no_max);
*/
		if (k > no_max/2) {
			if (index = (tdtMessages **)Malloc(sizeof(tdtMessages *)*no_max)) {
				memset(index,0,sizeof(tdtMessages *)*no_max);
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					index[i-1] = me;
				}
			}
		}
		if (!index && k>100) {
			if (reg_max <= 0) reg_max = k;
			if (xhp=akxs_xhasl_new(sizeof(int),reg_max,0,0)) {
				for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
					if (akxs_xhasl(xhp,'S',i,&me) <= 0) {
						akxs_xhasl_free(xhp);
						xhp = NULL;
						break;
					}
				}
			}
		}
		cmh->cmh_xhp   = xhp;
		cmh->cmh_index = index;
/*
printf("akxc_conv_msg: xhp=%08x index=%08x\n",xhp,index);
*/
	}
	langmax = cmh->cmh_langmax;
	no_max  = cmh->cmh_no_max;
	ix = 0;
	if ((lang>=0 && lang<=langmax) && no<=no_max) {
		if (index) {
			if (me = index[no-1]) ix = no;
		}
		else if (xhp) {
			ix = akxs_xhasl(xhp,'R',no,&me);
		}
		else {
			for (me=&mesg[1];(i=me->mm_msgno)>=0;me++) {
				if (i == no) {
					ix = i;
					break;
				}
			}
		}
		if (ix > 0) {
			p = me->mm_msg[lang];
			if (!p || !*p) {
				for (k=lang+1;k<=langmax;k++) {
					if ((p=me->mm_msg[k]) && *p) break;
				}
			}
		}
	}
/*
printf("akxc_conv_msg: no=%d ix=%d\n",no,ix);
*/
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_get_gen_int_data(p)
tdtGeneralData *p;
{
	int len,i=0;
	short s;
	char *pd;

	if (p && (pd=p->gd_data)) {
		if (len == 4) memcpy(&i,pd,sizeof(INT4));
		else if ((len=p->gd_dlen) == 2) {
			memcpy(&s,pd,sizeof(short));
			i = s;
		}
		else i = *(uchar *)pd;
	}
	return i;
}

/********************************************************/
/*														*/
/********************************************************/
UINT4 akxcmb2ul(s,len)
uchar *s;
int  len;	/* >=1, <=4 */
{
	uchar *p=s;
	int n=len;
	UINT4 ul;

#if 1
	if (n <= 0) ul = 0;
	else {
		ul = *p++;
		if (n == 2) ul = ul<<8 | *p;
		else if (n == 3) ul = (ul<<8 | *p)<<8 | *(p+1);
		else if (n == 1) ;
		else ul = ((ul<<8 | *p)<<8 | *(p+1))<<8 | *(p+2);
	}
#else	/* [v̕x */
	ul = 0;
	while (n-- > 0) {
		ul = ul<<8 | *p++;
	}
#endif
	return ul;
}

/********************************************************/
/*														*/
/********************************************************/
int akxcul2mb(s,ul)
uchar *s;
UINT4 ul;
{
	uchar *p=s,uc;
	int i,len;

	if (!s) return -1;
	len = 0;
	p = s + 4;
	for (i=0;i<4;i++) {
		uc = ul & 0x000000ff;
		if (uc) {
			*(--p) = uc;
			len++;
		}
		ul >>= 8;
	}
	if (len < 4) memcpy(s,p,len);
	*(s+len) = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
int akxmbcmp(s1,m1,s2,m2)
uchar *s1,*s2;
int m1,m2;
{
	return akxcmb2ul(s1,m1) - akxcmb2ul(s2,m2);
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : ƕr									*/
/*	 :	pstr1,nstr1,pstr2,nstr2									*/
/*			type  : R[h										*/
/*			opt   : 0x01 : ignore case								*/
/*					0x02 : ignore zenkaku hankaku					*/
/*					0x04 : Ov(pstr2pstr1̑OɈv邩)	*/
/*					0x10 : gp									*/
/*					0x20 : gp									*/
/*					0x40 : compare except							*/
/*					0x80 : '\0'ƌȂ						*/
/*				  0x0100 : ǂ炩Z̑Ov					*/
/*	ԋp :	> 0 : ꍀ > 									*/
/*			= 0 : ꍀ = 									*/
/*			< 0 : ꍀ < 									*/
/********************************************************************/
int akxmbncmp_type_opt(pstr1,nstr1,pstr2,nstr2,type,opt)
uchar *pstr1,*pstr2;
int nstr1,nstr2,type,opt;
{
	uchar *s1,*s2,c1,c2;
	int len1,len2,m1,m2,opt01,opt02,opt04,opt10,dif,opt40,d,opt80,opt100;
	uchar u1[5],u2[5],z1[5],z2[5],uc,*p1,*p2;
	int n1,n2,nn[3];

	if (!(s1=pstr1) || !(s2=pstr2)) return -1;
/*
printtx("akxmbncmp_opt",pstr1,nstr1);
printtx("             ",pstr2,nstr2);
printf("             : type=%d opt=%04x\n",type,opt);
*/
	if (type <= 0) type = akxt_get_code_type();
	opt01 = opt & 0x01;	/* ignore case */
	opt02 = opt & 0x02;	/* ignore zenkaku hankaku */
	opt04 = opt & 0x04;	/* Ov 0x04 <- 0x08 *//* pstr2pstr1̑OɈv邩 */
	opt40 = opt & 0x40;	/* compare except */
	opt80 = opt & 0x80;	/* '\0'ƌȂ */
	opt100 = opt & 0x100;
	len1 = nstr1;
	len2 = nstr2;
	if (!len1 || !len2) {
		if (!len1 && !len2) dif = 0;
		else if (!len1) dif = -1;
		else if (!len2) dif =  1;
		if (opt40) {
			if (dif) dif = 0;
			else dif = 1;
		}
		return dif;
	}
#if 1	/* 2023.3.31 */
	if (opt04) {
		m1 = akxqmlen_type(pstr1,nstr1,type);
		m2 = akxqmlen_type(pstr2,nstr2,type);
		if (m1 < m2) return -1;
	}
#endif
	dif = 0;
/*	for (;;) {	*/
	while (len1>0 || len2>0) {
		c1 = c2 = '\0';
		if (len1 > 0) c1 = *s1;
		if (len2 > 0) c2 = *s2;
		if (!opt80) {
			if (!c1) len1 = 0;
			if (!c2) len2 = 0;
		}
		m1 = m2 = 1;
	/*	if (len1 >= 2) m1 = akxqkanjilen(s1);
		if (len2 >= 2) m2 = akxqkanjilen(s2);	*/
		if (len1 >= 2) m1 = akxqmbsnlen(type,s1,len1);
		if (len2 >= 2) m2 = akxqmbsnlen(type,s2,len2);
/*
printf("akxmbncmp_opt: m1=%d m2=%d\n",m1,m2);
*/
		if (m1==1 && m2==1) {
			if (opt01) {
				c1 = akxcupper(c1);
				c2 = akxcupper(c2);
			}
/*
printf("akxmbncmp_opt: c1=[%c] c2=[%c]\n",c1,c2);
*/
#if 1
			d = c1 - c2;
			if (opt40) {
				if (!d) {
					dif = 1;
					break;
				}
			}
			else if (dif=d) break;
#else
			if (dif=c1-c2) break;
#endif
			len1--;
			len2--;
			s1++;
			s2++;
		}
		else {
			n1 =m1;
			n2 =m2;
			if (opt02) {
				p1 = s1;
				p2 = s2;
				if (m1==1 || type==CD_TYPE_UTF8) {
					m1 = akxctozen1_type_opt(len1,s1,z1,nn,type,0);
					n1 = nn[0];
					p1 = z1;
/*
printtx("akxmbncmp_opt:zen1:1",p1,m1);
*/
				}
				if (m2==1 || type==CD_TYPE_UTF8) {
					m2 = akxctozen1_type_opt(len2,s2,z2,nn,type,0);
					n2 = nn[0];
					p2 = z2;
/*
printtx("akxmbncmp_optzen1:2",p2,m2);
*/
				}
				if (opt & 0x01) {
					akxcuplw(u1,z1,0);
					akxcuplw(u2,z2,0);
					p1 = u1;
					p2 = u2;
/*
printtx("akxmbncmp_opt:up:1",p1,m1);
printtx("             :up:2",p2,m2);
*/
				}
			}
			else {
				if (m1 > len1) m1 = len1;
				if (m2 > len2) m2 = len2;
				p1 = s1;
				p2 = s2;
			}
/*
printf("akxmbncmp_opt: p1=[%s] m1=%d p2=[%s] m2=%d\n",p1,m1,p2,m2);
*/
#if 1
			d = akxmbcmp(p1,m1,p2,m2);
			if (opt40) {
				if (!d) {
					dif = 1;
					break;
				}
			}
			else if (dif=d) break;
#else
			if (dif=akxmbcmp(p1,m1,p2,m2)) break;
#endif
/*
printf("akxmbncmp_opt: n1=%d n2=%d\n",n1,n2);
*/
			s1 += n1;
			s2 += n2;
			len1 -= n1;
			len2 -= n2;
		}
#if 1	/* 2023.3.31 */
		if (opt100 && (len1<=0 || len2<=0)) break;
		if (opt04 && len2<=0) break;
#else
		if (opt04 && (len1<=0 || len2<=0)) break;
#endif
	}
/*
printf("akxmbncmp_opt: dif=%d\n",dif);
*/
#if 0	/* 2023.3.31 */
	if (dif && opt04) {
		if (len1<nstr1 || len2 < nstr2) dif = 0;
	}
#endif
	return dif;
}

/********************************************************/
/*	ƕr							*/
/********************************************************/
int akxmbncmp_opt(pstr1,nstr1,pstr2,nstr2,opt)
uchar *pstr1,*pstr2;
int nstr1,nstr2,opt;
{
	akxmbncmp_type_opt(pstr1,nstr1,pstr2,nstr2,akxt_get_code_type(),opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrcmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstricmp(s1,s2)
uchar *s1,*s2;
{
	return akxmbncmp_opt(s1,strlen(s1),s2,strlen(s2),0x01);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemcmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x10);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemicmp(s1,s2,len)
uchar *s1,*s2;
int len;
{
	if (len <= 0) return 0;
	else return akxmbncmp_opt(s1,len,s2,len,0x11);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemcmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
/*
if (*s2=='%') {
int ret;
printf("len1=%d s1=[%s] len2=%d s2=[%s]\n",len1,s1,len2,s2);
	ret = akxmbncmp_opt(s1,len1,s2,len2,0x10);
printf("ret=%d\n",ret);
	return ret;
}
else
*/
	return akxmbncmp_opt(s1,len1,s2,len2,0x10);
}

/********************************************************/
/*														*/
/********************************************************/
int akxmemicmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0x11);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstrcmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxstricmp2(s1,len1,s2,len2)
char *s1,*s2;
int  len1,len2;
{
	return akxmbncmp_opt(s1,len1,s2,len2,0x01);
}

/********************************************************/
/*	(pm1,len)̕(pm2)ʒuԂ		*/
/********************************************************/
int akx_mem_chr_opt(pm1,pm2,len,opt)
uchar *pm1,*pm2;
int len,opt;
{
	uchar *s1,*s2,c1,c2;
	int pos,opt01,n,m1,m2,dif,code_type;

	if (!(s1=pm1) || !(s2=pm2)) return -1;
	opt01 = opt & 0x01;	/* ignore case */
	code_type = GET_TYPE_OPT(opt);
/*	if (!(m2=akxqiskanji(s2))) {	*/
	if (!(m2=akxqismbs(code_type,s2))) {
		c2 = *s2;
		 if (opt01) c2 = akxcupper(c2);
	}
	pos=0;
	n = len;
	while (n > 0) {
	/*	if (n >= 2) m1=akxqiskanji(s1);	*/
		if (n >= 2) m1=akxqismbs(code_type,s1);
		else m1=0;
		if (m1 && m2) {
			if (m1==m2 && n>=m1) {
				if (!memcmp(s1,s2,m1)) {
					pos=len-n+1;
					break;
				}
			}
		}
		else if (m1==m2) {
			c1 = *s1;
			if (opt01) dif=akxcupper(c1)-c2;
			else dif=c1-c2;
			if (!dif) {
				pos=len-n+1;
				break;
			}
		}
		if (m1) {
			s1+=m1;
			n -=m1;
		}
		else {
			s1++;
			n--;
		}
	}

	return pos;
}

/********************************************************/
/* @\ : bufptn̂ǂꂩ̕ɈvʒuԂ	*/
/*  : buf	  : Ώە							*/
/*		  len	  : Ώە (oCg)				*/
/*		  ptn	  : ǂꂩ̕v镶		*/
/*		  ptn_len : ptn (oCg)						*/
/*		  opt	  : IvV							*/
/*					0x01 : ignore case					*/
/*					0x08 : 0/1:in/to					*/
/*			0x04->	0x10 : ԋpl̒P 0/1:oCg/	*/
/*			0x02->	0x20 : reverse						*/
/*					0x7f000000 : code_type				*/
/* ԋp : >=0 											*/
/*		IN or TO  :XLbvoCg܂͕		*/
/*				   p^[Ɉv镶ȂƂ́A	*/
/*					IN : 0								*/
/*					TO : len or Ώە				*/
/*		RIN or RTO:XLbvʒu̐擪̃oCg	*/
/*				   ܂͕							*/
/*				   p^[Ɉv镶ȂƂ́A	*/
/*					RIN : len or Ώە				*/
/*					RTO : 0								*/
/*		yzbuf="12345678", ptn="78"					*/
/*					IN : 0								*/
/*					TO : 6								*/
/*					RIN : 6								*/
/*					RTO : 8								*/
/*		yzbuf="12345678", ptn="12"					*/
/*					IN : 2								*/
/*					TO : 0								*/
/*					RIN : 8								*/
/*					RTO : 2								*/
/********************************************************/
int akxn_skip_opt(buf,len,ptn,ptn_len,opt)
char *buf,*ptn;
int  len,ptn_len,opt;
{
	int  i,lptn,m,k,flg,flgb,code_type;
	char *p;
	int  n,opt01,opt02,opt04,opt08,pos,match;

	if (!buf || !ptn) return -1;
	if (len<=0 || (lptn=ptn_len)<=0) return 0;
	opt04 = opt & 0x10;	/* return moji position */
/*
	if (!*ptn) {
		if (opt04) pos = akxqmlen(buf,len);
		else pos = len;
		return pos;
	}
*/
	code_type = GET_TYPE_OPT(opt);
	opt01 = opt & (CD_TYPE_OPT_MASK | 0x01);	/* opt_type | ignore case */
	opt02 = opt & 0x20;	/* reverse */
	opt08 = opt & 0x08;	/* 0/1=in/to */
	if (opt02) opt08 = opt08 ? 0 : 1;
	pos = 0;
	p = buf;
	m = 1;
	flgb = 0;
	for (i=k=0;i<len;k++) {
		if (!(*p)) break;
		match = akx_mem_chr_opt(ptn,p,lptn,opt01);
/*
printf("akx_skip_opt: i=%d match=%d lptn=%d ptn=[%c] p=[%c]\n",i,match,lptn,*ptn,*p);
*/
		flg = (opt08 && match) || (!opt08 && !match);
		if (opt02) {
			if (!flgb && flg) {
				if (opt04) pos = k;
				else pos = i;
			}
			flgb = flg;
		}
		else {
			if (flg) {
				if (opt04) i = k;
				return i;
			}
		}
	/*	m=akxqkanjilen(p);	*/
		m=akxqmbslen(code_type,p);
		p += m;
		i += m;
	}
	if (opt02) {
		if (!flgb) {
			if (opt04) pos = k;
			else pos = i;
		}
	}
	else {
		if (opt04) pos = k;
		else pos = i;
	}
	return pos;
}

/********************************************************/
/*														*/
/********************************************************/
int akx_skip_opt(buf,len,ptn,opt)
char *buf,*ptn;
int  len,opt;
{
	if (!ptn) return -1;
	return akxn_skip_opt(buf,len,ptn,strlen(ptn),opt);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipin(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x20);	/* 0x02 -> 0x20 */
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnrskipto(buf,len,ptn)
char *buf,*ptn;
int  len;
{
	return akx_skip_opt(buf,len,ptn,0x08|0x20);	/* 0x02 -> 0x20 */
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipin2(buf,len,ptn,lptn)
char *buf,*ptn;
int  len,lptn;
{
	return akxn_skip_opt(buf,len,ptn,lptn,0);
}

/********************************************************/
/*														*/
/********************************************************/
int akxnskipto2(buf,len,ptn,lptn)
char *buf,*ptn;
int  len,lptn;
{
	return akxn_skip_opt(buf,len,ptn,lptn,0x08);
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : GXP[vł̒us							*/
/*		   GXP[vŎn܂ȂƂ́A̕Ԃ			*/
/*	 : IN  : s    : 										*/
/*				 len  :  (oCg)							*/
/*				 ssp  : ssp.sp		: Ώۈʒu (擪0oCg)		*/
/*						ssp.attr[0] : GXP[v				*/
/*							attr[3] : code_type						*/
/*		   OUT : ssp  : ssp.sp		:								*/
/*						ssp.wd		: <>null ̂ƂAret=1 or 2 	*/
/*										ƂA}`oCgԂ*/
/*							attr[1] : <>'\0' : uA܂́A擪	*/
/*									  = '\0' : ret=1 or 2			*/
/*							attr[2] : ret=1 or 2 ̂ƂA}`oCg	*/
/*	ԋp : = 0 : GXP[vŒuꂽA܂́A				*/
/*				 擪1oCgŃGXP[vłȂƂ		*/
/*			 1 : 擪}`oCĝƂ						*/
/*			 2 : GXP[v̎}`oCĝƂ			*/
/********************************************************************/
int akx_conv_yen1(s,len,ssp)
uchar *s;
int    len;
SSP_S *ssp;
{
	uchar *p,c,uc,escape,cc;
	char *pp;
	int i,h,n,max,rad,d,code_type,m,ret;

	i = ssp->sp;
	code_type = ssp->attr[3];
	ssp->attr[1] = '\0';
	if (i >= len) return -1;
#if 1	/* 2022.12.06 */
	p = s + i;
	m = akxqmbsnlen(code_type,p,len);
	i += m;
	if (m > 1) {
		ssp->sp = i;
		ssp->attr[2] = m;
		if (pp=ssp->wd) memzcpy(pp,p,m);
		return 1;
	}
#else
	p = s + i++;
#endif
	ret = 0;
	escape = ssp->attr[0];
	c = *p++;
	if (escape && c==escape && i<len) {
	  m = akxqmbsnlen(code_type,p,len);
	  if (m == 1) {
		c = *p;
		if ((c>='0' && c<='9') || c=='x') {
			if (c == 'x') {
				max = 2;
				rad = 16;
				i++;
				p++;
			}
			else {
				max = 3;
				rad = 8;
			}
			max = X_MIN(i+max,len);
			n=0;
			uc = '\0';
			for (;i<max;i++,p++) {
				c = *p;
				if (c>='0' && c<='7') d = c - '0';
				else d = -1;
				if (rad == 16) {
					if (c>='a' && c<='f') d = c - 'a' + 10;
					else if (c>='A' && c<='F') d = c - 'A' + 10;
				}
				if (d>=0 && d<rad) {
					uc = uc*rad + d;
					n++;
				}
				else {
					break;
				}
			}
			c = uc;
		}
		else {
			switch (c) {
				case 'a': c = '\a'; break;
				case 'b': c = '\b'; break;
				case 'f': c = '\f'; break;
				case 'n': c = '\n'; break;
				case 'r': c = '\r'; break;
				case 't': c = '\t'; break;
				case 'v': c = '\v'; break;
			}
			i++;
		}
	  }
	  else {
		ssp->attr[2] = m;
		if (pp=ssp->wd) memzcpy(pp,p,m);
		c = '\0';
		i += m;
		ret = 2;
	  }
	}
	ssp->sp = i;
	ssp->attr[1] = c;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtstrim(opt,pData,len,ptn)
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLNAȂ */
char *pData,*ptn;
int len;
{
	int  ol;
	char *p;
	ParList pa_dat;

	ol = akxtstrim2(opt,pData,len,&pa_dat,ptn);
	if (ol>0 && pData != (p=pa_dat.par)) {
		memcpy(pData,p,ol);
		if (!(opt & 0x04)) pData[ol] = '\0';
	}
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtstrim2(opt,pData,len,pa_dat,ptn)
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLNAȂ */
char *pData,*ptn;
int len;
ParList *pa_dat;
{
	int i,ol,opt1,opt2,opt4,lptn,opt_type;
	char *p;

	pa_dat->par    = pData;
	pa_dat->parlen = len;
	if (!(p=pData)) return -1;
	else if ((ol=len) <= 0) return ol;
	if (!ptn) ptn = " \t";
	else if (!(lptn = strlen(ptn))) return ol;

	opt_type = opt & CD_TYPE_OPT_MASK;
	opt4 = opt & 0x04;
	opt &= 0x03;
	if (!opt) opt = 0x03;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	if (opt2) {	/* O  */
		i = akx_skip_opt(pData,len,ptn,opt_type);	/* akxnskipin(pData,len,ptn); */
		ol = len - i;
		p = pData + i;
	}
	if (opt1 && ol>0) {	/*  */
		ol = akx_skip_opt(p,ol,ptn,0x20 | opt_type);	/* 0x02 -> 0x20 */ /* akxnrskipin(p,ol,ptn); */
	}
/*
	if (opt>=1 && i>0) memcpy(pData,p,ol);
*/
	if (!opt4 && ol<len) p[ol] = '\0';

	pa_dat->par    = p;
	pa_dat->parlen = ol;

	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
int akxtsapb(opt,pData,len)
	/* 2017.11.03 */
int opt;	/* 0:O, 0x02:O, 0x01:, 0x04:NULLtȂ */
char *pData;
int len;
{
#if 1	/* 2019.10.03 */
	int ol;

	ol = akxtstrim(opt,pData,len,NULL);
#else
	int i,ol,opt1,opt2;
	char *p, *pb, c;

	if (!(p = pData)) return -1;
	else if (len <= 0) return len;

	for (ol=0;ol<len;ol++) {
		if (!*p) break;
		p++;
	}
	p = pData;
	/* 2017.11.03 */
	if (!opt) opt = 0x03;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;
	if (opt2) {	/* O  */
		while (ol>0 && ((c = *p) == ' ') || (c == '\t')) {
			p++;
			ol--;
		}
		if (ol <= 0) {
			*pData = '\0';
			return (0);
		}
	}
	/* 2017.11.03 */
	if (opt1) {	/*  */
		pb = p + ol - 1;
		while (ol>0) {
			if (((c = *pb--) != ' ') && (c != '\t')) break;
			ol--;
		}
	}
	/* 2017.11.03 */
	if (opt2
	    && pData != p) memcpy(pData,p,ol);

	if (ol<len) pData[ol] = '\0';
#endif	/* 2019.10.03 */
	return ol;
}

/********************************************************/
/*														*/
/********************************************************/
char *akxttrim2(opt,pData,plen)
int opt;	/* 0:O, 0x02:O, 0x01:, 0x10:NULLt */
char *pData;
int *plen;
{
#if 0	/* 2019.10.03 */ /* 1-->0 2021.10.2 */
	int ol;
	ParList pa_dat;

	ol = akxtstrim2(opt,pData,len,&pa_dat,NULL);
	pp = pa_dat.par;
#else
	int i,ol,ib,len,opt_fb,opt_ts,opt_f,opt_b,opt_t,opt_s,trim_ts;
	char *p, c, *pp;

	if (!(p=pData)) return NULL;
	if (!plen) return p;
	len = *plen;
	if ((ol=len) <= 0) return p;
/*
printf("akxttrim2: len=%d p=[%s]\n",len,p);
*/
	opt_fb = opt & (AKX_TRIM_BACKWARD | AKX_TRIM_FORWARD);
	opt_ts = opt & (AKX_TRIM_DEL_TAB  | AKX_TRIM_DEL_SPACE);
	if (!opt_fb) opt_fb = AKX_TRIM_BACKWARD | AKX_TRIM_FORWARD;
	if (!opt_ts) opt_ts = AKX_TRIM_DEL_TAB  | AKX_TRIM_DEL_SPACE;
	opt_f = opt_fb & AKX_TRIM_FORWARD;
	opt_b = opt_fb & AKX_TRIM_BACKWARD;
	opt_t = opt_ts & AKX_TRIM_DEL_TAB;
	opt_s = opt_ts & AKX_TRIM_DEL_SPACE;
	if (opt_f) {	/* O  */
#if 1
		while (ol > 0) {
			if (!(c = *p)) break;
			else if (!(opt_s && c==' ' || (opt_t && c=='\t'))) break;
#else
		while (ol>0 && ((opt_s && (c=*p)==' ') || (opt_t && c=='\t'))) {
#endif
			p++;
			ol--;
		}
		if (!c || ol<=0) {
			if (opt & 0x10) *pData = '\0';
			*plen = 0;
			return pData;
		}
	}
	pp = p;
	if (opt_b) {	/*  */
#if 1	/* 2021.10.2 */
		ib = -1;
		for (i=0;i<ol;i++,p++) {
			if (!(c = *p)) {
				ol = i;
				break;
			}
			trim_ts = (opt_s && c==' ') || (opt_t && c=='\t');
/*
printf("akxttrim2: i=%d ib=%d c=[%c] trim_ts=%d\n",i,ib,c,trim_ts);
*/
			if (ib < 0) {
				if (trim_ts) ib = i;
			}
			else {
				if (trim_ts) ;
				else ib = -1;
			}
		}
		if (ib >= 0) ol = ib;
#else
		ib = -1;
		for (i=0;i<ol;i++,p++) {
			if (((c = *p)==' ') || (c=='\t')) {
				ib = i;
				for (;i<ol;i++,p++) {
					if (((c = *p)==' ') || (c=='\t')) ;
					else {
						if (c) ib = -1;
						break;
					}
				}
			}
			if (!c) {
				ol = i;
				break;
			}
		}
		if (ib >= 0) ol = ib;
#endif
	}
#endif	/* 2019.10.03 */
	if ((opt & 0x10) && ol<len) pp[ol] = '\0';
	*plen = ol;
	return pp;
}

/********************************************************/
/*														*/
/********************************************************/
int akxttrim(opt,pData,len0)
int opt;	/* 0:O 0x02:O 0x01: */
char *pData;
int len0;
{
	int len;
	char *p;

	len = len0;
	if (!opt) opt = 3;
	p = akxttrim2(opt,pData,&len);
	if ((opt & 0x02) && pData!=p) memcpy(pData,p,len);
	if (len<len0) pData[len] = '\0';
	return len;
}

/********************************************************/
/*														*/
/********************************************************/
void printtx(msg,p,len)
char *msg,*p;
int len;
{
	int i;

	printf("%s:",msg);
	printf(" len=%d text=[",len);
	for (i=0;i<len;i++) printf("%c",*p++);
	printf("]\n");
}

/********************************************************/
/*														*/
/********************************************************/
int mem_set_int(a0,val,n)
int *a0,n,val;
{
	int ret,*a;

	ret = n;
	if (a = a0) {
		while (n-- > 0) *a++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_int(d0,s0,n)
int *d0,*s0,n;
{
	int ret,*d,*s;

	if (d = d0) {
		ret = n;
		if (n>0 && (s=s0)) {
			while (n-- > 0) *d++ = *s++;
		}
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_rcpy_int(d0,s0,n)
int *d0,*s0,n;
{
	int ret,*d,*s;

	if (!d0) ret = -1;
	else {
		ret = n;
		if (n>0 && s0) {
			d = d0 + n -1;
			s = s0 + n -1;
			while (n-- > 0) *d-- = *s--;
		}
	}
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_sum_byte(s,n)
uchar *s;
int n;
{
	int ret;

	ret = 0;
	if (s) {
		while (n-- > 0) ret += *s++;
	}
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_sum_int(s,n)
int *s,n;
{
	int ret,i;

	ret = 0;
	if (s) {
		while (n-- > 0) ret += *s++;
	}
	return ret;
}

#if defined(_LP64)
/********************************************************/
/*														*/
/********************************************************/
int mem_set_long(a0,val,n)
long *a0,val;
int n;
{
	int ret;
	long *a;

	ret = n;
	if (a = a0) {
		while (n-- > 0) *a++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_long(d0,s0,n)
long *d0,*s0;
int n;
{
	int ret;
	long *d,*s;

	if (d = d0) {
		ret = n;
		if (n>0 && (s=s0)) {
			while (n-- > 0) *d++ = *s++;
		}
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_rcpy_long(d0,s0,n)
long *d0,*s0;
int n;
{
	int ret;
	long *d,*s;

	if (d0) {
		ret = n;
		if (n>0 && s0) {
			d = d0 + n -1;
			s = s0 + n -1;
			while (n-- > 0) *d-- = *s--;
		}
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_sum_long(s0,n)
long *s0;
int n;
{
	int ret;
	long *s;

	ret = 0;
	if (s = s0) {
		while (n-- > 0) ret += *s++;
	}
	return ret;
}
#else
/********************************************************/
/*														*/
/********************************************************/
int mem_set_long(a,val,n)
long *a,val;
int n;
{
	return mem_set_int(a,val,n);
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_long(d,s,n)
long *d,*s;
int n;
{
	return mem_cpy_int(d,s,n);
}

/********************************************************/
/*														*/
/********************************************************/
int mem_rcpy_long(d,s,n)
long *d,*s;
int n;
{
	return mem_rcpy_int(d,s,n);
}

/********************************************************/
/*														*/
/********************************************************/
int mem_sum_long(s,n)
long *s;
int n;
{
	return mem_sum_int(s,n);
}
#endif

/********************************************************/
/*														*/
/********************************************************/
int mem_set_addr(d0,val,n)
char *d0[],*val;
int n;
{
	int ret;
	char **d;

	if (d = d0) {
		ret = n;
		while (n-- > 0) *d++ = val;
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cpy_addr(d0,s0,n)
char *d0[],*s0[];
int n;
{
	int ret;
	char **d,**s;

	if (d = d0) {
		ret = n;
		if (n>0 && (s=s0)) {
			while (n-- > 0) *d++ = *s++;
		}
	}
	else ret = -1;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_rcpy_addr(d0,s0,n)
char *d0[],*s0[];
int n;
{
	int ret;
	char **d,**s;

	if (!d0) ret = -1;
	else {
		ret = n;
		if (n>0 && s0) {
			d = d0 + n - 1;
			s = s0 + n - 1;
			while (n-- > 0) *d-- = *s--;
		}
	}
	return ret;
}

/********************************************************/
/*														*/
/*							0x01 : 			*/
/*							0x02 : p			*/
/*							0x04 : L			*/
/*							0x08 : pJi			*/
/*							0x10 : p			*/
/*							0x20 : Sp			*/
/*							0x40 : l(+-.0-9,EDF)			*/
/*							0x80 : O(擪 A-Z,Sp,pJi)	*/
/*							0x100: - 				*/
/*							0x200: . 				*/
/********************************************************/
int akxq_char_kind(s,s_len,opt)
char *s;
int  s_len,opt;
{
	int i,opt4,ret,m,n;
	int x1,x2,x4,x8,x10,x20,x40,x80,x100,x200;
	char c,w[4];

	opt4 = opt & 0x04;
	x1=x2=x4=x8=x10=x20=x100=x200=0;
	x40=0x40;
	x80=0x80;
	i = 0;
	while (i < s_len) {
		m = n = akxqkanjilen2(s,s_len);
		if (m == 1) {
			x10 = 0x10;
		}
		else if (akxqis_hankaku_kana(s,m)) {
			x8 = 8;
		}
		else {
			x20 = 0x20;
			if (opt4) {
				m = akxctohan(m,s,w);
				if (m == 1) c = *w;
				else if (akxqis_hankaku_kana(w,m)) x8 = 8;
			}
			else x40 = 0;
		}
		if (m == 1) {
			c = akxcupper(c);
			if (c>='0' && c<='9') {
				x1 = 1;
				if (!i) x80 = 0;
			}
			else if (c>='A' && c<='Z') {
				x2 = 2;
				if (!(c=='D' || c=='E' || c=='F')) x40 = 0;
			}
			else if (c>=161 && c<=223) {
				x8 = 8;
			}
			else {
				x4 = 4;
				if (c == '.') {
					x200 = 0x200;
				}
				else if (c == '+') {
					x80 = 0;
				}
				else if (c == '-') {
					x100 = 0x100;
				}
				else if (c == '_') {
					x40 = 0;
				}
				else {
					x80 = x40 = 0;
				}
			}
		}
		i += n;
		s += n;
	}
	ret = x1 *+ x2 + x4 + x8 + x10 + x20 + x40 + x80;
	if (opt4) ret += x100 + x200;
	return ret;
}

/********************************************************/
/*														*/
/********************************************************/
char *nval1(p)
char *p;
{
	if (!p) p = "(null)";
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
char *nval(p,p1)
char *p,*p1;
{
	if (!p) {
		p = p1;
		p = nval1(p);
	}
	return p;
}

/********************************************/
/*                                          */
/********************************************/
char *nvalid(p,p1)
char *p,*p1;
{
	if (!akxm_addrchk(p)) {
		p = p1;
		if (!akxm_addrchk(p)) p = "(invalid)";
	}
	return p;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cmp_int(p1,p2,n)
int *p1,*p2;
int  n;
{
	int i,d;

	if (!p1 && !p2) d = 0;
	else if (!p1) d = -1;
	else if (!p2) d = 1;
	else {
		while (n-- > 0) {
			d = *p1++ - *p2++;
			if (d) break;
		}
	}
	return d;
}

/********************************************************/
/*														*/
/********************************************************/
int mem_cmp_int_n(p1,n1,p2,n2)
int *p1,*p2,n1,n2;
{
	int d;

	if (!p1 && !p2) d = 0;
	else if (!p1) d = -1;
	else if (!p2) d = 1;
	else {
		if (!n1 && !n2) d = 0;
		else if(n1 < n2) {
			if (!(d = mem_cmp_int(p1,p2,n1))) d = -1;
		}
		else if(n1 > n2) {
			if (!(d = mem_cmp_int(p1,p2,n2))) d = 1;
		}
		else
			d = mem_cmp_int(p1,p2,n1);
	}
	return d;
}

#if defined(_LP64)
/********************************************************/
/*														*/
/********************************************************/
long x_htonll(x)
long x;
{
	char w[8],*p,*ww,*pp;
	int i;

	pp = p = (char *)&x;
	ww = w + 7;
	for (i=0;i<8;i++) *ww-- = *pp++;
	memcpy(p,w,8);
	return x;
}
long x_ntohll(x)
long x;
{
	return x_htonll(x);
}
#endif

/********1*********2*********3*********4*********5*********6*********7***/
/*																		*/
/* 0x01 : ؂蕶̑啶ʂȂB						*/
/* 0x02 : ÕXy[Xƃ^u폜B								*/
/* 0x04 : max_argv؂񐔂ƌȂAmax_argv+1ɕB		*/
/* 0x08 : ؂蕶̂ǂꂩAƂ́A1̋؂蕶ƌȂB	*/
/* 0x10 : sep==NULLsep_len<=0̂ƂɁAJ}؂蕶ɉB	*/
/************************************************************************/
int akxtnsplit(buf,buf_len,argv,maxargv,parm,parm_len,sep,sep_len,opt)
char *buf,*argv[],*parm,*sep;
int buf_len,maxargv,parm_len,sep_len,opt;
{
	char *p,*pm,*pp,ssep[4];
	int len,pmlen,splen,m,n,pos,opt02,opt04,opt08,mlen,gw_opt,in_opt,code_type,iSETW;
	SSPL_S sspl;

	if (!(p=buf) || !argv || !(pm=parm)) return -1;
/*
printf("akxtnsplit: buf_len=%d buf=[%s] sep_len=%d sep=[%s]\n",buf_len,buf,sep_len,sep);
printf("akxtnsplit: parm_len=%d opt=%08x\n",parm_len,opt);
*/
	if ((len=buf_len)<=0 || maxargv<=0 || (pmlen=parm_len)<=0) return 0;
	opt02 = opt & 0x02;
	opt04 = opt & 0x04;
	opt08 = opt & 0x08;
	code_type = opt & 0x7f000000;
	in_opt = opt & 0x03;
	if (opt & 0x01) gw_opt = 0x400;
	else gw_opt = 0;
	gw_opt |= 0x06;	/* Öp(2dp)O + ̘A2̈p(2dp)1ɂ */
	if (!sep || (splen=sep_len)<=0) {
		sep = ssep;
		memcpy(sep," \t",3);
		if (opt & 0x10) memcpy(sep+2,",",2);
		splen = strlen(sep);
	}
	memset(&sspl,0,sizeof(SSPL_S));
	in_opt |= code_type;
	code_type >>= 24;
	sspl.code = code_type;
	n = 0;
	len = buf_len;
	pp = pm;
	*pp = '\0';
	iSETW = 0;
	while (len > 0) {
		/*  */
		if (opt08)
			pos = akxn_skip_opt(p,len,sep,splen,in_opt);
		else if (len > 0) {
			pos = akxqmbsnlen(code_type,p,len);
			if (akxs_in_mem_opt(sep,splen,p,pos,in_opt) <= 0) pos = 0;
		}
		else pos = 0;
		if (pos > 0) {
			if (!iSETW) {
				*pm = '\0';
				argv[n++] = pm;
				pm++;
				pmlen--;
			}
			p += pos;
			len -= pos;
			iSETW = 0;
/*
printf("akxtnsplit:1: iSETW=%d pos=%d len=%d n=%d pmlen=%d\n",iSETW,pos,len,n,pmlen);
*/
			if (n >= maxargv) break;
		}
		else {
		/*  */
			sspl.sp = 0;
			sspl.wd = pm;
			sspl.wdmax = pmlen - 1;
			pos = akxtgwnsl(p,len,&sspl,sep,gw_opt);
			if (pmlen <= pos) break;
		/*	memzcpy(pm,p,pos);	*/
			mlen = pos;
			if (opt02 && sspl.attr[0]!=5 && sspl.attr[0]!=6) mlen = akxttrim(0,pm,pos);
			argv[n++] = pm;
			if (!opt04 && n>=maxargv) break;
			p += sspl.sp;
			len -= sspl.sp;
			mlen++;
			pm += mlen;
			pmlen -= mlen;
			iSETW = 1;
/*
printf("akxtnsplit:2: iSETW=%d pos=%d len=%d n=%d pmlen=%d\n",iSETW,pos,len,n,pmlen);
*/
		}
		pp = pm - 1;
	}
	if (opt04 && pmlen>0) {
		mlen = memnzcpy(pm,p,len,pmlen);
		if (opt02) akxttrim(0,pm,mlen);
		argv[n++] = pm;
	}
	m = n;
	while (n < maxargv) argv[n++] = pp;
	return m;
}

/********1*********2*********3*********4*********5*********6*********/
/* @\ : Œ蒷vf̔r֐									*/
/*  : c_arg   : t										*/
/*					c_arg[0] : opt									*/
/*						opt : 0x01 : = 0 / 1 :  / ~			*/
/*							  0x02 : = 0 / 1 :  / Ll	*/
/*												r			*/
/*									l̂Ƃ́AmlenŌ^܂	*/
/*										<= 1   : char				*/
/*										 = 2   : short				*/
/*										<= 4   : int				*/
/*										̑ : long				*/
/*					c_arg[1] : mlen vf (oCg)					*/
/*		  a       : r̍ӗvf̐擪AhX					*/
/*		  b       : r̉Eӗvf̐擪AhX					*/
/* ԋp : r													*/
/*			> 0 : ӗvf > Eӗvf								*/
/*			= 0 : ӗvf = Eӗvf								*/
/*			< 0 : ӗvf < Eӗvf								*/
/********************************************************************/
static int _cmp_qsort_r(c_arg,a,b)
char *c_arg,*a,*b;
{
	int *arg,mlen,opt,dif;
	short sa,sb;
	long la,lb;
	char ca,cb;
/*
printf("_cmp_qsort_r: a=%08x b=%08x c_arg=%08x\n",a,b,c_arg);
*/
	arg = (int *)c_arg;
	opt  = arg[0];
	mlen = arg[1];
/*
printf("_cmp_qsort_r: mlen=%d opt=%d\n",mlen,opt);
*/
	if (opt & 0x02) {
		if (mlen <= sizeof(char))
			dif = *a - *b;
		else if (mlen <= sizeof(short))
			dif = *(short *)a - *(short *)b;
		else if (mlen <= sizeof(int))
			dif = *(int *)a - *(int *)b;
		else
			dif = *(long *)a - *(long *)b;
	}
	else {
		dif = memcmp(a,b,mlen);
	}
	if (opt & 0x01) dif = -dif;
/*
printf("_cmp_qsort_r: dif=%d\n",dif);
*/
	return dif;
}

/********1*********2*********3*********4*********5*******/
/* @\ : Œ蒷vf^~Ƀ\[g			*/
/*  : sel_str : \[gΏۗ̈						*/
/*		  max_sel : vf								*/
/*		  mlen    : vf̒(oCg)					*/
/*		  opt     : IvV _cmp_qsort_r()Q		*/
/* ԋp : = 0 : 									*/
/*		  < 0 : G[									*/
/********************************************************/
int akxnmstrsort_opt(sel_str,max_sel,mlen,opt)
char *sel_str;
int max_sel,mlen,opt;
{
	char max_c,c,*p,*p_max_c,*p_c,wrk[256],*p_i;
	char w1[256],w2[256];
	int i,j,max_i,dif,arg[2];
/*
printf("akxnstrsort_opt: sort : opt=%d max_sel=%d sel_str=[%s]\n",opt,max_sel,sel_str);
*/
	if (!(p=sel_str) || (mlen>sizeof(wrk))) return -1;
	if (max_sel<=0 || mlen<=0) return 0;
#if 1
	arg[0] = opt;
	arg[1] = mlen;
/*	akxqsort_r(sel_str,max_sel,mlen,_cmp_qsort_r,arg);	*/
	qsort_r(sel_str,max_sel,mlen,arg,_cmp_qsort_r);
#else
	p = sel_str;
	p_i = p;
	for (i=0;i<max_sel-1;i++,p_i+=mlen) {
		p_max_c = p_i;
	/*	max_c = sel_str[i];	*/
		max_i = i;
		p_c = p_i + mlen;
		for (j=i+1;j<max_sel;j++,p_c+=mlen) {
		/*	c = sel_str[j];
			if ((!opt && c<max_c) || (opt && c>max_c)) {
				max_c = c;
				max_i = j;
			}*/
			dif = memcmp(p_c,p_max_c,mlen);
			memzcpy(w1,p_c,mlen);
			memzcpy(w2,p_max_c,mlen);
/*
printf("i=%d j=%d dif=%d p_c=[%s] p_max_c=[%s]\n",i,j,dif,w1,w2);
*/
			if (opt) dif = -dif;
			if (dif < 0) {
				p_max_c = p_c;
				max_i = j;
			}
		}
		if (max_i != i) {
		/*	c = sel_str[i];
			sel_str[i] = max_c;
			sel_str[max_i] = c;	*/
			memcpy(wrk,p_i,mlen);
			memcpy(p_i,p_max_c,mlen);
			memcpy(p_max_c,wrk,mlen);
		}
	}
/*
printf("akxnstrsort_opt: sort : sel_str=[%s]\n",sel_str);
*/
#endif
	return 0;
}

/********************************************************/
/*	^~Ƀ\[g						*/
/*		opt : =0 / <>1 :  / ~					*/
/********************************************************/
int akxnstrsort_opt(sel_str,max_sel,opt)
char *sel_str;
int max_sel,opt;
{
	return  akxnmstrsort_opt(sel_str,max_sel,1,opt);
}

/********************************************************/
/*	ւ֐								*/
/********************************************************/
void akxtswap_mem(a,b,size)
char *a,*b;
int size;
{
	char tmp;

	while (size--) {
		tmp = *b;
		*b = *a;
		*a = tmp;
		a++;
		b++;
	}
}

/********************************************************/
/*														*/
/********************************************************/
static void _swap(a,b,size)
char *a,*b;
int size;
{
	akxtswap_mem(a,b,size);
}

/********************************************************/
/*	NCbN\[gs֐							*/
/********************************************************/
static void QuickSort_r(dat,iSta,iEnd,size,_compar,arg)
char *dat;
int iSta,iEnd,size;
int (*_compar)();
char *arg;
{
	int iBaseNum,iCnt,i,ii;
	char strBaseVal[256],*p_i,*p_cnt,*p_sta;
/*
printf("QuickSort_r: iSta=%d iEnd=%d size=%d\n",iSta,iEnd,size);
*/
	if (iSta >= iEnd) return;
	iBaseNum = (iSta + iEnd) / 2;
	memcpy(strBaseVal,dat+iBaseNum*size,size);
	memcpy(dat+iBaseNum*size,dat+iSta*size,size);
	iCnt = iSta;
	p_sta = p_cnt = dat + iSta*size;
	p_i = p_sta + size;
	for (i = iSta + 1;i<=iEnd;i++) {
/*
printf("QuickSort_r: i=%d\n",i);
*/
		if (_compar(p_i,strBaseVal,arg) < 0) {
			iCnt++;
			p_cnt += size;
			_swap(p_cnt,p_i,size);
		}
		p_i += size;
	}
	memcpy(p_sta,p_cnt,size);
	memcpy(p_cnt,strBaseVal,size);
	QuickSort_r(dat,iSta,iCnt-1,size,_compar,arg);
	QuickSort_r(dat,iCnt+1,iEnd,size,_compar,arg);
	return;
}

/********************************************************/
/*														*/
/********************************************************/
void akxqsort_r(a,nmenb,size,_compar,arg)
char *a;
int nmenb,size;
int (*_compar)();
char *arg;
{
	QuickSort_r(a,0,nmenb-1,size,_compar,arg);
	return;
}

/********************************************************/
/*														*/
/********************************************************/
static int _compar_inx_vdat(a,b,c_arg)
char *a,*b,*c_arg;
{
	char **ca,**cb,*aa,*bb;
	int  opt,dif,ia,ib,*arg;

	arg = (int *)c_arg;
	opt = arg[0];
	a += sizeof(int);
	b += sizeof(int);
	if (opt & 0x08) {
		ia = *(int *)a;
		ib = *(int *)b;
/*
printf("_compar_inx_vdat: ia=%d ib=%d\n",ia,ib);
*/
		dif = ia - ib;
	}
	else {
		aa = *(char **)a;
		bb = *(char **)b;
/*
printf("_compar_inx_vdat: aa=[%s] bb=[%s]\n",aa,bb);
*/
		dif = strcmp(aa,bb);
	}
	return dif;
}

/********************************************************/
/*														*/
/********************************************************/
static void _set_of_index(s,nDat,size,dat0,mlen)
char *s,*dat0;
int nDat,size,mlen;
{
	char *p,*pp,*dat;
	int i,index;

	p = s;
	dat = dat0;
	for (i=0;i<nDat;i++) {
		memcpy(&index,p,sizeof(int));
/*
printf("_set_of_index: index=%d\n",index);
*/
		pp = p + sizeof(int);
		memcpy(pp,dat+index*mlen,mlen);
		p += size;
	}
	p = s;
	dat = dat0;
	for (i=0;i<nDat;i++) {
		pp = p + sizeof(int);
		memcpy(dat,pp,mlen);
		p += size;
		dat += mlen;
	}
}

/********1*********2*********3*********4*********5*********6*********/
/*   : str_sort_inx_vdat										*/
/*  @\ : z\[g(CfbNXȂf[^t)		*/
/*   : IN	  : dat0()    : string data array					*/
/*					nDat      : number of dat()						/*
/*					inx0()    : index array of data					/*
/*					vdat()    : variant data array					*/
/*					Opt       : IvV							*/
/*								0x01 = 0 : 						*/
/*									 = 1 : ~						*/
/*								0x02 = 1 : inx\[gΏۂƂ	*/
/*								0x04 = 1 : vdat\[gΏۂƂ	*/
/*								0x08 = 0 : dat()\[gL[Ƃ	*/
/*									 = 1 : inx()\[gL[Ƃ	*/
/*		   OUT	  : dat()											*/
/*					inx()											*/
/*					vdat()											*/
/*  쐬 : 2016/04/06 Akito Kobayashi								*/
/*  XV : 2018/06/25 Akito Kobayashi Add opt=0x08					*/
/*	XV : 2023/04/04 Akito Kobayashi use akxqsort_r()				*/
/********************************************************************/
int akxstrsort_inx_vdat(dat0,nDat,inx0,vdat,iOpt)
char *dat0[],*vdat[];
int nDat,inx0[],iOpt;
{
#if 1
	char *s,*p,**dat,*pp;
	int i,size,arg[2],index,*inx;

	if (iOpt & 0x08) size = sizeof(int)*2;
	else size = sizeof(char *) + sizeof(int);
	if(!(s = Malloc(nDat*size))) return -1;
	p = s;
	index = 0;
	dat = dat0;
	inx = inx0;
	for (i=0;i<nDat;i++) {
		memcpy(p,&index,sizeof(int));
		p += sizeof(int);
		index++;
		if (iOpt & 0x08) {
			memcpy(p,inx,sizeof(int));
			p += sizeof(int);
			inx++;
		}
		else {
			memcpy(p,dat,sizeof(char *));
			p += sizeof(char *);
			dat++;
		}
	}

	arg[0] = iOpt;
	arg[1] = size;
	akxqsort_r(s,nDat,size,_compar_inx_vdat,arg);

	p = s;
	dat = dat0;
	inx = inx0;
	for (i=0;i<nDat;i++) {
		memcpy(&index,p,sizeof(int));
/*
printf("akxstrsort_inx_vdat: index=%d\n",index);
*/
		pp = p + sizeof(int);
		if (iOpt & 0x08) {
			memcpy(inx,pp,sizeof(int));
			inx++;
		}
		else {
			memcpy(dat,pp,sizeof(char *));
			dat++;
		}
		p += size;
	}
	if ((iOpt & 0x02) && !(iOpt & 0x08)) {
		_set_of_index(s,nDat,size,inx0,sizeof(int));
	}
	if (iOpt & 0x04) {
		_set_of_index(s,nDat,size,vdat,sizeof(char *));
	}
	if (iOpt & 0x08) {
		_set_of_index(s,nDat,size,dat0,sizeof(char *));
	}
	Free(s);
#else
	int opt1,opt2,opt4,opt8,k,i,j,max_dat,min_i,min_inx,inx_j;
	char *min_vdat,*dat_j,*min_dat;

	opt1 = iOpt & 0x1;
	opt2 = iOpt & 0x2;
	opt4 = iOpt & 0x4;
	opt8 = iOpt & 0x8;
	if (opt8) opt2 = 0x2;
	max_dat = nDat;
	for (i=0;i<max_dat-1;i++) {
		min_i = i;
		min_dat = dat[i];
		if (opt2) min_inx = inx[i];
		if (opt4) min_vdat = vdat[i];
		for (j=i+1;j<max_dat;j++) {
			k = 0;
			if (!opt8) {
				dat_j = dat[j];
				if ((!opt1 && dat_j<min_dat) || (opt1 && dat_j>min_dat)) k = 1;
			}
			else {
				inx_j = inx[j];
				if ((!opt1 && inx_j<min_inx) || (opt1 && inx_j>min_inx)) k = 1;
			}
			if (k) {
				min_i = j;
				min_dat = dat[j];
				if (opt2) min_inx = inx[j];
				if (opt4) min_vdat = vdat[j];
			}
		}
		if (min_i > i) {
			dat[min_i] = dat[i];
			dat[i] = min_dat;
			if (opt2) {
				inx[min_i] = inx[i];
				inx[i] = min_inx;
			}
			if (opt4) {
				vdat[min_i] = vdat[i];
				vdat[i] = min_vdat;
			}
		}
	}
#endif
	return 0;
}

/********1*********2*********3*********4*********5*********6*****/
/* @\ : T[`bitz̎w͈͂ɂlƈvʒuԂ	*/
/*  : bits : T[`bitz									*/
/*		  i1   : rbgʒu									*/
/*		  i2   : rbgʒu									*/
/*		  bit  : Ώ(i1`i2rbgڂ̂ǂӏ݂̂ON)	*/
/*				 0x00000001 : 1Ԗ								*/
/* ԋp : > 0 : rbgʒu										*/
/*		  = 0 : vrbgȂ(OÑrbg̐1łȂ)	*/
/****************************************************************/
static int _get_bit_num_hlf(bits,i1,i2,bit)
long bits[],bit;
int i1,i2;
{
	int i,im;
	long bitm;
/*
printf("_get_bit_num_hlf:Enter bit=%08x i1=%d i2=%d\n",bit,i1,i2);
*/
	i = 0;
	im = (i2 + i1)/2;
	if (im <= 0) {
		if (bits[i2] & bit) i = i2;
	}
	else {
		bitm = bits[im];
		if (bit & bitm) i = im;
		else if (bit < bitm)
			i = _get_bit_num_hlf(bits,i1,im-1,bit);
		else
			i = _get_bit_num_hlf(bits,im+1,i2,bit);
	}
/*
printf("_get_bit_num_hlf:Exit i=%d\n",i);
*/
	return i;
}

/********1*********2*********3*********4*********5*********6*****/
/* @\ : bit32z̐擪AhXԂ							*/
/* ԋp : bit32z̐擪AhX								*/
/****************************************************************/
long *get_bit32_array()
{
	static long bits[33]={0,1,2,4,8,0x10,0x20,0x40,0x80,0x100,0x200,0x400,0x800
	,0x1000,0x2000,0x4000,0x8000,0x10000,0x20000,0x40000,0x80000
	,0x100000,0x200000,0x400000,0x800000,0x1000000,0x2000000,0x4000000,0x8000000
	,0x10000000,0x20000000,0x40000000,0x80000000};

	return bits;
}

/********1*********2*********3*********4*********5*********6*****/
/* @\ : ʂ琔ĉԖڂ̃rbgONԂ				*/
/*  : bit : Ώ(1`32rbgڂ̂ǂӏ݂̂ON)	*/
/*				0x00000001 : 1Ԗ								*/
/* ԋp : > 0 : rbgʒu										*/
/*		  = 0 : vrbgȂ(OÑrbg̐1łȂ)	*/
/****************************************************************/
int get_bit_number(bit)
long bit;
{
	int i,im;
	long *bits,bitm;

	bits = get_bit32_array();
	if (!bit) i = 0;
	else if (bit == bits[32]) i = 32;
	else if (bit == bits[1]) i = 1;
	else {
		im = 16;
		bitm = bits[im];
		if (bit == bitm) i = im;
		else if (bit < bitm)
			i = _get_bit_num_hlf(bits,2,im-1,bit);
		else
			i = _get_bit_num_hlf(bits,im+1,31,bit);
	}
	return i;
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_mleft(s,s_len,m_len,opt)
char *s;
int s_len,m_len,opt;
{
	int code_type;

	if (!s || s_len<0) return -1;
	code_type = GET_TYPE_OPT(opt);
	return akxqm2len_type(s,s_len,m_len,code_type);
}

/********************************************************/
/*														*/
/********************************************************/
int akxs_mright(s,s_len,m_len,opt)
char *s;
int s_len,m_len,opt;
{
	int i,mlen,pos,code_type,m;

	if (!s || s_len<0) return -1;
/*
printf("akxs_mright: s_len=%d m_len=%d opt=%08x s=[%s]\n",s_len,m_len,opt,s);
*/
	code_type = GET_TYPE_OPT(opt);
	/* slenoCg̕߂ */
	mlen = akxqmlen_type(s,s_len,code_type);
/*
printf("akxs_mright: mlen=%d\n",mlen);
*/
	m = mlen - m_len;	/* 擪̕ */
	if (m > 0) {
		/* 擪̃oCg */
		m = akxqm2len_type(s,s_len,m,code_type);
/*
printf("akxs_mright: m=%d\n",m);
*/
	}
	else m = 0;
	return m;
}
