static char sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************************************
*																			*
*	ړI	F	lZ											*
*																			*
*	֐		F	int cl_cmpt_math(pAns, pOprtr, pInfoParm1, pInfoParm2)	*
*						(O)int		 *pAns									*
*						(I)char		 *pOprtr								*
*						(I)tdtINFO_PARM *pInfoParm1							*
*						(I)tdtINFO_PARM *pInfoParm2							*
*																			*
*	߂l		F	ERROR													*
*					NORMAL													*
*																			*
*	Tv	F															*
*																			*
*****************************************************************************/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
static int _cmpt_power(pAns, pOprtr, pInfoParm1, pInfoParm2,iParm)
long		*pAns;
char		*pOprtr;
tdtINFO_PARM	*pInfoParm1;
tdtINFO_PARM	*pInfoParm2;
int			iParm[];
{
	int rc;
	tdtINFO_PARM	*ppParm[2];

	ppParm[0] = pInfoParm1;
	ppParm[1] = pInfoParm2;
	if (rc=func_math((char *)pAns,"**",2,ppParm,D_FUC_POWER)) return rc;
	iParm[0] = DEF_ZOK_FLOA;
	iParm[1] = sizeof(double);
	return DEF_ZOK_FLOA;
}

/****************************************/
/*										*/
/****************************************/
static int _cmpt_mult(pAns,ntimes0,iUNSIGNED,pInfoParm1,iParm)
long *pAns;
long ntimes0;
tdtINFO_PARM	*pInfoParm1;
int iUNSIGNED,iParm[];
{
	int i,attr,rc,ntimes,atr1,iU,iCHECK_OVERFLOW;
	uint untimes;
	tdtINFO_PARM tInfoParm,tInfoParmW,tInfoParm1,tInfoParm2;
	int iAttr[3];
	long Value1,Val1z[NMPA_LONG],Val,Val0,*Val1;
	ulong uValue1,uVal,uVal0,*uVal1;
	double dValue1,dVal;
	MPA *mpa1,mpaz,*mpa;
/*
printf("_cmpt_mult: ntimes0=%d\n",ntimes0);
*/
	rc = 0;
	Val1 = cl_get_tmpMPA(&Val1z);
	mpa = (MPA *)cl_get_tmpMPA(&mpaz);
	if ((rc=cl_get_parm_mpa(pInfoParm1,Val1,"Parm1:",iAttr)) < 0) return rc;
	atr1 = pInfoParm1->pi_attr;
	if (iUNSIGNED) untimes = ntimes0;
	else ntimes = X_ABS(ntimes0);
	iParm[3] = iParm[4] = 0;
	if ((attr=iAttr[0]) == DEF_ZOK_BINA) {
		iCHECK_OVERFLOW = !(cl_get_option(2,0) & 0x40);
		iU = iAttr[D_IATTR_ULI] & AKX_NUM_U;
		iAttr[1] = sizeof(long);
		uValue1 = Val1[0];
		if (!(Value1 = Val1[0])) rc = attr;
		else if (iU) {
			iParm[D_IPARM_FLAG] = DEF_ZOK_USMASK;
			uVal = 1;
		  if (iCHECK_OVERFLOW) {
		/*	uVal0 = ULONG_MAX/X_ABS(uValue1);	*/
			uVal0 = ULONG_MAX/uValue1;
			mpa1 = (MPA *)Val1;
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
			/*	if (X_ABS(uVal) >= uVal0) {	*/
				if (uVal >= uVal0) {
					m_ui2mpa(uValue1,mpa1);
					m_ui2mpa(uVal,mpa);
					m_mul1(mpa,mpa1);
/*
printf("_cmpt_mult: i=%d mpa=%s\n",i,m_mpa2str(&mpa,NULL,0,0));
*/
					if (m_cmp_a(mpa,m_get_LONGMAX(0)) >= 0) {
						cl_set_parm_mpa(&tInfoParm1,mpa1);
						if (iUNSIGNED) ntimes = untimes-i-1;
						else ntimes = ntimes-i-1;
						if ((rc=_cmpt_mult(pAns,ntimes,iUNSIGNED,&tInfoParm1,iParm)) < 0) return rc;
						memcpy(mpa1,pAns,sizeofMPA());
/*
printf("_cmpt_mult: mpa1=%s\n",m_mpa2str(mpa1,NULL,0,0));
*/
						m_mul1(mpa,mpa1);
						cl_set_parm_mpa(&tInfoParmW,mpa);
						break;
					}
				}
				else uVal *= uValue1;
			}
		  }
		  else {
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
				uVal *= uValue1;
			}
		  }
			if (rc) rc = 0;
			else cl_set_parm_long(&tInfoParmW,uVal);
/*
printf("_cmpt_mult: Val0=%d\n",Val0);
*/
		}
		else {
#if 1	/* 2021.9.21 */
			Val = 1;
		  if (iCHECK_OVERFLOW) {
			Val0 = LONG_MAX/X_ABS(Value1);
/*
printf("_cmpt_mult: Val0=%d\n",Val0);
*/
			mpa1 = (MPA *)Val1;
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
				if (X_ABS(Val) >= Val0) {
					m_i2mpa(Value1,mpa1);
					m_i2mpa(Val,mpa);
					m_mul1(mpa,mpa1);
/*
printf("_cmpt_mult: i=%d mpa=%s\n",i,m_mpa2str(&mpa,NULL,0,0));
*/
					if (m_cmp_a(mpa,m_get_LONGMAX(0)) >= 0) {
#if 1	/* 2021.9.22 */
						cl_set_parm_mpa(&tInfoParm1,mpa1);
						if (iUNSIGNED) ntimes = untimes-i-1;
						else ntimes = ntimes-i-1;
						if ((rc=_cmpt_mult(pAns,ntimes,iUNSIGNED,&tInfoParm1,iParm)) < 0) return rc;
						memcpy(mpa1,pAns,sizeofMPA());
/*
printf("_cmpt_mult: mpa1=%s\n",m_mpa2str(mpa1,NULL,0,0));
*/
						m_mul1(mpa,mpa1);
						cl_set_parm_mpa(&tInfoParmW,mpa);
						break;
#else
						dValue1 = Value1;
						cl_set_parm_double(&tInfoParm1,dValue1);
						return _cmpt_mult(pAns,ntimes0,iUNSIGNED,&tInfoParm1,iParm);
#endif
					}
				}
				else Val *= Value1;
			}
		  }
		  else {
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
				Val *= Value1;
			}
		  }
			if (rc) rc = 0;
			else cl_set_parm_long(&tInfoParmW,Val);
#else
			cl_set_parm_long(&tInfoParm1,Value1);
			cl_set_parm_long(&tInfoParm,1);
#endif
		}
	}
	else if (attr == DEF_ZOK_FLOA) {
		memcpy(&dValue1,Val1,sizeof(double));
		if (dValue1 == 0.0) rc = attr;
		else {
#if 1	/* 2021.9.21 */
			dVal = 1.0;
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
				dVal *= dValue1;
			}
			cl_set_parm_double(&tInfoParmW,dVal);
#else
			cl_set_parm_double(&tInfoParm1,dValue1);
			cl_set_parm_double(&tInfoParm,1.0);
#endif
		}
	}
	else if (attr == DEF_ZOK_DECI) {
		mpa1 = (MPA *)Val1;
		if (mpa1->zero) rc = attr;
		else {
#if 1	/* 2021.9.21 */
			*mpa = *m_get_i(1);
#if 1
			for (i=0;;i++) {
				if (iUNSIGNED && i>=untimes) break;
				else if (i >= ntimes) break;
#else
			for (i=0;i<ntimes;i++) {
#endif
				m_mul1(mpa,mpa1);
			}
			cl_set_parm_mpa(&tInfoParmW,mpa);
#else
			cl_set_parm_mpa(&tInfoParm1,mpa1);
			cl_set_parm_mpa(&tInfoParm,m_get_i(1));
#endif
		}
	}
	else rc = -1;
	if (rc) {
/*
printf("_cmpt_mult:zero rc=%d\n",rc);
*/
		if (rc > 0) {
			memcpy(pAns,Val1,iAttr[1]);
			iParm[0] = attr;
			iParm[1] = iAttr[1];
		}
		return rc;
	}
/*	cl_set_parm_long(&tInfoParmW,0);	*/

#if 1	/* 2021.9.21 */
	cl_gx_copy_info(&tInfoParm,&tInfoParmW);
#else
	ntimes = X_ABS(ntimes0);
	iParm[4] = 0;
	for (i=0;i<ntimes;i++) {
		if ((rc=cl_gx_bexp(&tInfoParmW,&tInfoParm,"*",&tInfoParm1,0,NULL)) < 0) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ+5,"_cmpt_mult: i=%d",&tInfoParmW,i,0);

		cl_gx_copy_info(&tInfoParm,&tInfoParmW);
		if (tInfoParmW.pi_alen & D_AULN_OVERFLOW) {
			iParm[4] = D_AULN_OVERFLOW;
			pGlobTable->error = 0;
			break;
		}
	}
#endif
	if (!iUNSIGNED && ntimes0<0) {
		cl_set_parm_long(&tInfoParm2,1);
		if ((rc=cl_gx_bexp(&tInfoParm,&tInfoParm2,"/",&tInfoParmW,0,NULL)) < 0) return rc;
	}
	memcpy(pAns,tInfoParm.pi_data,tInfoParm.pi_dlen);
	iParm[0] = tInfoParm.pi_attr;
	iParm[1] = tInfoParm.pi_dlen;
	return tInfoParm.pi_attr;
}

/****************************************/
/*										*/
/****************************************/
static int _zero_devide_error(op)
char op;
{
	char *p;

	p = FORMAT(261);	/* zerofBoCh܂B */
	if (op == '%') p = stradd("MOD: ",p);
	ERROROUT(p);
	pGlobTable->exception = MATH_COMP_DEVIDE_EXCEPTION;
	return ECL_SCRIPT_ERROR;
}

/****************************************/
/*										*/
/****************************************/
static int _comp_double(pAns,op,dValue1,dValue2)
long *pAns;
char op;
double dValue1,dValue2;
{
	char *p;
	double dVal;
	int rc;

DEBUGOUTL2(LVL_GXEXOBJ,"_comp_double: dValue1=%e dValue2=%f",dValue1,dValue2);

	rc = DEF_ZOK_FLOA;
	if (op == '.') {
		*pAns = sizeof(double);
		p = (char *)(pAns+1);
		memcpy(p,&dValue1,sizeof(double));
		memcpy(p+sizeof(double),&dValue2,sizeof(double));
	}
	else {
		switch( op ) {
			case '+':
				dVal = dValue1 + dValue2;
				break;
			case '-':
				dVal = dValue1 - dValue2;
				break;
			case '*':
				dVal = dValue1 * dValue2;
				break;
			case '/':
				if (dValue2 == 0.0) rc = _zero_devide_error(op);
				else dVal = dValue1 / dValue2;
				break;
		}
		memcpy(pAns,&dVal,sizeof(double));
DEBUGOUTL1(LVL_GXEXOBJ,"_comp_double: dVal=%e",dVal);
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _comp_decimal(pAns,op,mpa1,mpa2)
long *pAns;
char op;
MPA *mpa1,*mpa2;
{
	char *p;
	int rc;

	rc = 0;
	switch( op ) {
		case '+':
			rc = m_add((MPA*)pAns,mpa1,mpa2);
			break;
		case '-':
			rc = m_sub((MPA*)pAns,mpa1,mpa2);
			break;
		case '*':
			rc = m_mul((MPA*)pAns,mpa1,mpa2);
			break;
		case '/':
		case '%':
			if (op == '/')
				rc = m_div((MPA*)pAns,mpa1,mpa2);
			else
				rc = m_mod((MPA*)pAns,mpa1,mpa2);
			if (rc == MPA_ERR_ZERODIVIDE) rc = _zero_devide_error(op);
			break;
		case '.':
			*pAns = sizeofMPA();
			p = (char *)(pAns+1);
			memcpy(p,mpa1,sizeofMPA());
			memcpy(p+sizeofMPA(),mpa2,sizeofMPA());
	}
	if (rc) {
		rc = cl_chk_error_mpa(rc,NULL,NULL,0);
		if (rc) rc = ECL_SCRIPT_ERROR;
	}
	if (!rc) rc = DEF_ZOK_DECI;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _comp_bit(pAns,op,uValue1,uValue2)
long *pAns;
char op;
ulong uValue1,uValue2;
{
	int rc;
	ulong uValue3;

	rc = DEF_ZOK_BINA;
	switch (op) {
	case '&':
		uValue3 = uValue1 & uValue2;
		break;
	case '^':
		uValue3 = uValue1 ^ uValue2;
		break;
	case '|':
		uValue3 = uValue1 | uValue2;
		break;
	case '~':
		uValue3 = ~uValue2;
		break;
	case '<':
		uValue3 = uValue1 << uValue2;
		break;
	case '>':
	case 'R':
		uValue3 = uValue1 >> uValue2;
		break;
	default:
		pGlobTable->exception = MATH_COMP_EXCEPTION;
		rc = ECL_SYSTEM_ERROR;
	}
	*pAns = uValue3;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _comp_ulong(pAns,op,uValue1,uValue2,pover_or_under)
long *pAns;
char op;
ulong uValue1,uValue2;
int *pover_or_under;
{
	int rc,iCHECK_OVERFLOW;
	ulong uValue3;
/*
printf("_comp_ulong:Enter op=[%c] uValue1=%u uValue2=%u\n",op,uValue1,uValue2);
*/
	rc = DEF_ZOK_BINA;
	*pover_or_under = 0;
	iCHECK_OVERFLOW = !(cl_get_option(2,0) & 0x40);
	if (op == '.') {
		pAns[0] = sizeof(long);
		pAns[1] = uValue1;
		pAns[2] = uValue2;
	}
	else {
		switch (op) {
		case '+':
			uValue3 = uValue1 + uValue2;
			if (iCHECK_OVERFLOW) {
				uValue3 = cl_chk_over_flow_ulong_add(uValue3,uValue1,uValue2,"uAdd",
				                                     pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '-':
			uValue3 = uValue1 - uValue2;
/*
printf("_comp_ulong: uValue3=%u uValue1=%u uValue2=%u\n",uValue3,uValue1,uValue2);
*/
			if (iCHECK_OVERFLOW) {
				uValue3 = cl_chk_over_flow_ulong_sub(uValue3,uValue1,uValue2,"uSub",
				                                     pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '*':
			uValue3 = uValue1 * uValue2;
			if (iCHECK_OVERFLOW) {
				uValue3 = cl_chk_over_flow_ulong_mult(uValue3,uValue1,uValue2,"uMult",
				                                      pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '%':
			if (!uValue2) rc = _zero_devide_error(op);
			else uValue3 = uValue1 % uValue2;
			break;
		case '/':
			if (!uValue2) rc = _zero_devide_error(op);
			else uValue3 = uValue1 / uValue2;
			break;
		case '&':
		case '^':
		case '|':
		case '~':
		case '<':
		case '>':
		case 'R':
			return _comp_bit(pAns,op,uValue1,uValue2);
		default:
			pGlobTable->exception = MATH_COMP_EXCEPTION;
			rc = ECL_SYSTEM_ERROR;
		}
		*pAns = uValue3;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _comp_long(pAns,op,Value1,Value2,pover_or_under)
long *pAns;
char op;
long Value1,Value2;
int *pover_or_under;
{
	int rc,iCHECK_OVERFLOW;
	long Value3;
/*
printf("_comp_long: op=[%c] Value1=%d Value2=%d\n",op,Value1,Value2);
*/
	rc = DEF_ZOK_BINA;
	*pover_or_under = 0;
	iCHECK_OVERFLOW = !(cl_get_option(2,0) & 0x40);
	if (op == '.') {
		pAns[0] = sizeof(long);
		pAns[1] = Value1;
		pAns[2] = Value2;
	}
	else {
		switch (op) {
		case '+':
			Value3 = Value1 + Value2;
			if (iCHECK_OVERFLOW) {
				Value3 = cl_chk_over_flow_long_add(Value3,Value1,Value2,"Add",pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '-':
			Value3 = Value1 - Value2;
			if (iCHECK_OVERFLOW) {
				Value3 = cl_chk_over_flow_long_sub(Value3,Value1,Value2,"Sub",pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '*':
			Value3 = Value1 * Value2;
			if (iCHECK_OVERFLOW) {
				Value3 = cl_chk_over_flow_long_mult(Value3,Value1,Value2,"Mult",pover_or_under,pAns);
				if (*pover_or_under) return DEF_ZOK_DECI;
			}
			break;
		case '%':
			if (!Value2) rc = _zero_devide_error(op);
			else Value3 = Value1 % Value2;
			break;
		case '/':
			if (!Value2) rc = _zero_devide_error(op);
			else Value3 = Value1 / Value2;
			break;
		case '&':
		case '^':
		case '|':
		case '~':
		case '<':
		case 'R':
			return _comp_bit(pAns,op,Value1,Value2);
		case '>':
			Value3 = Value1 >> Value2;
			break;
		default:
			pGlobTable->exception = MATH_COMP_EXCEPTION;
			rc = ECL_SYSTEM_ERROR;
		}
		*pAns = Value3;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_math_real(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM	*pInfoParmW;
char *pOperator;
tdtINFO_PARM	*pInfoParm1;
tdtINFO_PARM	*pInfoParm2;
{
	int ret,iParm[5];
	long lValz[NMPA_LONG],*lVal;

	lVal = cl_get_tmpMPA(lValz);
	if ((ret=cl_cmpt_math(lVal,pOperator,pInfoParm1,pInfoParm2,iParm)) >= 0)
		ret=cl_set_parm(pInfoParmW,lVal,0,iParm);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_math_info(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM *pInfoParmW;
char *pOperator;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
{
	int ret,iParm[5],iCOMPLEX,iIMAGE1,iIMAGE2,ope;
	long lValz[NMPA_LONG],*lVal,lValue;
	char op;

	cl_parm_set0(pInfoParmW);
	if ((pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA) || (pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA) ||
		(pInfoParm1->pi_scale & D_DATA_IMAGE) || (pInfoParm2->pi_scale & D_DATA_IMAGE)) {
		ret = cl_cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	}
	else
		ret = cl_cmpt_math_real(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_math(pAns,pOprtr,pInfoParm1,pInfoParm2,iParm)
long *pAns;
char *pOprtr;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
int iParm[];
{
	static char *_fn = "cl_cmpt_math";
	static char *C_OPRS2[]={"%","MOD","<","<<",">",">>","R",">>>",NULL};
	int    rc,atr1,atr2,iAttr[3],exception_save,over_or_under,iUNSIGNED1,iUNSIGNED2,iCHECK_OVERFLOW,pos;
	long   Val1z[NMPA_LONG],Val2z[NMPA_LONG],*Val1,*Val2;
	long   Value1,Value2,Value3;
	ulong  uValue1,uValue2,uValue3;
	double dValue1,dValue2,dVal;
	char   op,*p,w[2];
	MPA    *mpa1,*mpa2;

DEBUGOUTL1(LVL_GXEXOBJ+5,"cl_cmpt_math:Enter pOprtr=[%s]",pOprtr);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+5,"cl_cmpt_math: pInfoParm1:",pInfoParm1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+5,"cl_cmpt_math: pInfoParm2:",pInfoParm2,0,0);

	Val1 = cl_get_tmpMPA(Val1z);
	Val2 = cl_get_tmpMPA(Val2z);
	over_or_under = 0;
	iUNSIGNED1 = iUNSIGNED2 = 0;
	mem_set_int(iParm,0,5);
	if (!stricmp(pOprtr,"MOD")) op = '%';
	else op = *pOprtr;
	if (op=='*' && pOprtr[1]=='*') {
		iAttr[0] = 0;
		if ((rc=cl_get_parm_mpa(pInfoParm2,Val2,"Parm2:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		atr2 = iAttr[0];
		if (atr2 == DEF_ZOK_BINA) {
			Value2 = Val2[0];
		/*	iUNSIGNED2 = pInfoParm2->pi_scale & D_DATA_UNSIGNED;	*/
			iUNSIGNED2 = iAttr[2] & AKX_NUM_U;
/*
printf("cl_cmpt_math: atr2=%d Value2=%d\n",atr2,Value2);
*/
			if (iUNSIGNED2) {
				uValue2 = Value2;
				if (uValue2 > LONG_BIT_CNT-1) op = 'P';
			}
			else if (X_ABS(Value2) > LONG_BIT_CNT-1) op = 'P';
			else if (Value2 < 0) {
				iAttr[0] = 0;
				if ((rc=cl_get_parm_mpa(pInfoParm1,Val1,"Parm1:",iAttr)) < 0) return rc;
				else if (rc > 0) return ECL_SCRIPT_ERROR;
				atr1 = iAttr[0];
/*
printf("cl_cmpt_math: atr1=%d\n",atr1);
*/
				if (atr1 == DEF_ZOK_BINA) op = 'Z';
			}
		}
		else op = 'P';
/*
printf("cl_cmpt_math: atr2=%d op=%c\n",atr2,op);
*/
		if (op == 'Z') {	/* **() */
			Value1 = 0;
			pAns[0] = Value1;
			iParm[0] = DEF_ZOK_BINA;
			iParm[1] = sizeof(long);
			rc = DEF_ZOK_BINA;
		}
		else if (op == 'P') rc = _cmpt_power(pAns,pOprtr,pInfoParm1,pInfoParm2,iParm);
		else rc = _cmpt_mult(pAns,Value2,iUNSIGNED2,pInfoParm1,iParm);
		return rc;
	}
	exception_save = pGlobTable->exception;
	pGlobTable->exception = MATH_ETC_ERROR_EXCEPTION;

	iAttr[0] = 0;
#if 1	/* 2022.2.7 */
	if (cl_is_null_parm(pInfoParm1) || cl_is_none_parm(pInfoParm1)) {
		iAttr[0] = DEF_ZOK_BINA;
		iAttr[2] = 0;
		*Val1 = 0;
	}
	else 
#endif
	if ((rc=cl_get_parm_mpa(pInfoParm1,Val1,"Parm1:",iAttr)) < 0) return rc;
	else if (rc > 0) return ECL_SCRIPT_ERROR;
	atr1 = iAttr[0];
#if 1	/* 2021.11.4 */
	if (atr1 == DEF_ZOK_BINA) {
		Value1 = CL_GET_VAL_BIN(Val1);
/*
printf("cl_cmpt_math: Value1=%d iAttr[2]=%08x\n",Value1,iAttr[2]);
*/
		uValue1 = Value1;
	/*	iUNSIGNED1 = pInfoParm1->pi_scale & D_DATA_UNSIGNED;	*/
		iUNSIGNED1 = iAttr[2] & AKX_NUM_U;
	}
#else
	if (atr1 == DEF_ZOK_BINA) Value1 = CL_GET_VAL_BIN(Val1);
#endif
	else if (atr1 == DEF_ZOK_FLOA) memcpy(&dValue1,Val1,sizeof(double));
	else if (atr1 == DEF_ZOK_DECI) ;
	else return ECL_SCRIPT_ERROR;
	mpa1 = (MPA *)Val1;

	if (pInfoParm1 == pInfoParm2) {
		atr2 = atr1;
		Value2 = Value1;
		uValue2 = uValue1;
		dValue2 = dValue1;
		mpa2 = mpa1;
		iUNSIGNED2 = iUNSIGNED1;
	}
	else if (pInfoParm2) {
		iAttr[0] = 0;
#if 1	/* 2022.2.7 */
		if (cl_is_null_parm(pInfoParm2) || cl_is_none_parm(pInfoParm2)) {
			iAttr[0] = DEF_ZOK_BINA;
			iAttr[2] = 0;
			*Val2 = 0;
		}
		else 
#endif
		if ((rc=cl_get_parm_mpa(pInfoParm2,Val2,"Parm2:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		atr2 = iAttr[0];
#if 1	/* 2021.11.4 */
		if (atr2 == DEF_ZOK_BINA) {
			Value2 = CL_GET_VAL_BIN(Val2);
			uValue2 = Value2;
		/*	iUNSIGNED2 = pInfoParm2->pi_scale & D_DATA_UNSIGNED;	*/
			iUNSIGNED2 = iAttr[2] & AKX_NUM_U;
		}
#else
		if (atr2 == DEF_ZOK_BINA) Value2 = CL_GET_VAL_BIN(Val2);
#endif
		else if (atr2 == DEF_ZOK_FLOA) memcpy(&dValue2,Val2,sizeof(double));
		else if (atr2 == DEF_ZOK_DECI) ;
		else return ECL_SCRIPT_ERROR;
		mpa2 = (MPA *)Val2;
	}
	else {
		atr2 = atr1;
		Value2 = 0;
		dValue2 = 0.0;
		mpa2 = (MPA *)Val2;
		*mpa2 = *m_get_i(0);
	}
#if 1	/* 2021.9.24 */
	if (atr2==DEF_ZOK_DECI &&
	    (pInfoParm2->pi_alen & D_AULN_OVERFLOW) && 
	    op=='-' && cl_is_none_parm(pInfoParm1)) {
		if (!m_cmp_a(mpa2,m_get_LONGMAX(-1))) {
			Value2 = LONG_MIN;
/*
printf("cl_cmpt_math: Value2=%d\n",Value2);
*/
#if 1	/* 2021.9.26 */
			*pAns = Value2;
			iParm[0] = DEF_ZOK_BINA;
			iParm[1] = sizeof(long);
			return DEF_ZOK_BINA;
#endif
		}
#if defined(_LP64)
		else if (!m_cmp_a(mpa2,m_get_INTMAX(-1))) {
			Value2 = INT_MIN;
			*pAns = Value2;
			iParm[0] = DEF_ZOK_BINA;
			iParm[1] = sizeof(int);
			return DEF_ZOK_BINA;
		}
#endif
	}
#endif
	pGlobTable->exception = exception_save;

DEBUGOUTL5(LVL_GXEXOBJ,"cl_cmpt_math: atr1=%d iUNSIGNED1=%02x op=[%c] atr2=%d iUNSIGNED2=%02x",atr1,iUNSIGNED1,op,atr2,iUNSIGNED2);

	if (op=='+' || op=='-' || op=='*' || op=='/' || op=='.' || op=='%') {
		if ((atr1==DEF_ZOK_FLOA || atr2==DEF_ZOK_FLOA) && op!='%') {
			iParm[1] = sizeof(double);
#if 1	/* 2021.11.4 */
			if (atr1 == DEF_ZOK_BINA) {
				if (iUNSIGNED1) dValue1 = uValue1;
				else dValue1 = Value1;
			}
#else
			if (atr1 == DEF_ZOK_BINA) dValue1 = Value1;
#endif
			else if (atr1 == DEF_ZOK_DECI) m_dset(&dValue1,mpa1);
#if 1	/* 2021.11.4 */
			if (atr2 == DEF_ZOK_BINA) {
				if (iUNSIGNED2) dValue2 = uValue2;
				else dValue2 = Value2;
			}
#else
			if (atr2 == DEF_ZOK_BINA) dValue2 = Value2;
#endif
			else if (atr2 == DEF_ZOK_DECI) m_dset(&dValue2,mpa2);

			iParm[0] = DEF_ZOK_FLOA;
			return _comp_double(pAns,op,dValue1,dValue2);
		}
		else if (atr1==DEF_ZOK_DECI || atr2==DEF_ZOK_DECI ||
		         ((atr1==DEF_ZOK_FLOA || atr2==DEF_ZOK_FLOA) && op=='%')) {
			iParm[1] = sizeofMPA();
			if (atr1 == DEF_ZOK_BINA) m_i2mpa(Value1,mpa1);
			else if (atr1 == DEF_ZOK_FLOA) m_d2mpa(dValue1,mpa1);
			if (atr2 == DEF_ZOK_BINA) m_i2mpa(Value2,mpa2);
			else if (atr2 == DEF_ZOK_FLOA) m_d2mpa(dValue2,mpa2);

			iParm[0] = DEF_ZOK_DECI;
			return _comp_decimal(pAns,op,mpa1,mpa2);
		}
	}

	if (!stricmp(pOprtr,"ABS")) {
		if (atr1 == DEF_ZOK_FLOA) {
			dVal = X_ABS(dValue2);
			memcpy(pAns,&dVal,sizeof(double));
			rc = DEF_ZOK_FLOA;
			iParm[1] = sizeof(double);
		}
		else if (atr1 == DEF_ZOK_DECI) {
			mpa1->sign = 0;
			memcpy(pAns,mpa1,sizeofMPA());
			rc = DEF_ZOK_DECI;
			iParm[1] = sizeofMPA();
		}
		else {
			*pAns = X_ABS(Value2);
			rc = DEF_ZOK_BINA;
			iParm[1] = sizeof(long);
#if 1	/* 2021.11.4 */
			if (iUNSIGNED2) {
				*pAns = uValue2;
				iParm[D_IPARM_FLAG] = DEF_ZOK_USMASK;
			}
#endif
		}
		iParm[0] = rc;
		return rc;
	}

	iParm[1] = sizeof(long);
	if ((pos=akxs_seqr_str2(C_OPRS2,-1,pOprtr,1)) > 0) op = *C_OPRS2[pos-1];
/*
printf("%s: pos=%d op=%c\n",_fn,pos,op);
*/
	if (pos >= 3) {
		if (atr2 == DEF_ZOK_FLOA) Value2 = cl_chk_over_flow_d2_l(dValue2,"cl_cmpt_math:dVal2");
		else if (atr2 == DEF_ZOK_DECI) m_mpa2l(mpa2,&Value2);
		if (Value2<0 || Value2>LONG_BIT_CNT) {
			ERROROUT2(FORMAT(147),_fn,"2");	/* %s: ZpZ̑%sɌ肪܂B*/
			pGlobTable->exception = MATH_COMP_EXCEPTION;
			return ECL_SCRIPT_ERROR;
		}
		iUNSIGNED2 = 0;
		uValue2 = Value2;
	}
	if (iUNSIGNED1 || iUNSIGNED2) {
		if (atr1 == DEF_ZOK_FLOA) uValue1 = cl_chk_over_flow_d2_ul(dValue1,"cl_cmpt_math:dVal1");
		else if (atr1 == DEF_ZOK_DECI) m_mpa2ul(mpa1,&uValue1);
		if (pos < 3) {
			if (atr2 == DEF_ZOK_FLOA) uValue2 = cl_chk_over_flow_d2_ul(dValue2,"cl_cmpt_math:dVal2");
			else if (atr2 == DEF_ZOK_DECI) m_mpa2ul(mpa2,&uValue2);
		}

		rc =_comp_ulong(pAns,op,uValue1,uValue2,&over_or_under);
		iParm[D_IPARM_FLAG] = DEF_ZOK_USMASK;
	}
	else {
		if (atr1 == DEF_ZOK_FLOA) Value1 = cl_chk_over_flow_d2_l(dValue1,"cl_cmpt_math:dVal1");
		else if (atr1 == DEF_ZOK_DECI) m_mpa2l(mpa1,&Value1);
		if (pos < 3) {
			if (atr2 == DEF_ZOK_FLOA) Value2 = cl_chk_over_flow_d2_l(dValue2,"cl_cmpt_math:dVal2");
			else if (atr2 == DEF_ZOK_DECI) m_mpa2l(mpa2,&Value2);
		}

		rc =_comp_long(pAns,op,Value1,Value2,&over_or_under);
	}
	if (rc > 0) iParm[0] = rc;
	iParm[D_IPARM_FLAG] |= over_or_under;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_error_mpa(rc,pMsg,p,len)
int rc;
char *p,*pMsg;
int len;
{
	int opt;
	char buf[33];
/*
printf("cl_chk_error_mpa: rc=%d\n",rc);
*/
	opt = pGlobTable->options[15];
	if (rc==MPA_ERR_OVERFLOW || rc==MPA_ERR_OVERFLOW_I) {
		if (opt & 0x01) {
			pGlobTable->error = ECL_DEC_OVERFLOW;
			rc = 0;
		}
		if (rc || (opt & 0x02))
			ERROROUT1(FORMAT(594),"MPA");	/* (W)%s: I[o[t[܂B */
	}
	else if (rc==MPA_ERR_UNDERFLOW) {
		if (!(opt & 0x04)) {
			pGlobTable->error = ECL_DEC_UNDERFLOW;
			rc = 0;
		}
		if (rc || (opt & 0x08))
			ERROROUT1(FORMAT(595),"MPA");	/* (W)%s: A_[t[܂B */
	}
	else {
		opt = pGlobTable->options[16];
		if (rc==MPA_ERR_INVALID && (opt & 0x10)) 
			rc = 0;
		else {
			if (pMsg=cl_conv_msg_check(pMsg,rc)) {
				if (p)
					memnzcpy(buf,p,len,sizeof(buf));
				else
					*buf = '\0';
				/* %sPOi_[%s]̎w肪Ă܂(rc=%d)B */
				ERROROUT3(FORMAT(308),pMsg,buf,rc);
			}
		}
	}
	return rc;
}

#if defined(_LP64)
static long LONG_MAXd2= 4611686018427387903L;
static long LONG_MINd2=-4611686018427387904L;
static long SQRT_LONG_MAX=3037000499L;
static long ULONG_MAXd2= 9223372036854775807UL;
static long SQRT_ULONG_MAX=4294967295L;
#else
static long LONG_MAXd2= 1073741823;
static long LONG_MINd2=-1073741824;
static long SQRT_LONG_MAX=46340;
static long ULONG_MAXd2= 2147483647;
static long SQRT_ULONG_MAX=65535;
#endif
/****************************************/
/*										*/
/****************************************/
static long _chk_over_flow_long(ma3,name,pstat)
MPA *ma3;
char *name;
int *pstat;
{
	long ret;
	int over_or_under;
/*
printf("_chk_over_flow_long:Enter ma3=%s\n",m_mpa2str(ma3,0,0,0));
*/
	ret = 0;
	if (m_cmp(ma3,m_get_LONGMAX(0)) > 0) {	/* ma3 > LONG_MAX */
		ret = LONG_MAX;
	}
	else if (m_cmp(ma3,m_get_LONGMAX(-1)) < 0) {	/* ma3 < LONG_MIN */
		ret = LONG_MIN;
	}
	if (ret) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
#if 0
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
#endif
		if (pstat) *pstat = over_or_under;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_long_add(Val3,Val1,Val2,name,pstat,pAns)
long Val3,Val1,Val2;
char *name;
int *pstat;
MPA *pAns;
{
	long ret,rc;
	int chk_flg=0;
	MPA ma1z,ma2z,ma3z,*ma1,*ma2,*ma3;
/*
printf("cl_chk_over_flow_long_add:Enter [%s] Val3=%d Val1=%d Val2=%d\n",name,Val3,Val1,Val2);
*/
	ret = Val3;
#if 1	/* 2021.9.24 */
	if (Val1>0 && Val2>0 && (Val1>=LONG_MAXd2 || Val2>=LONG_MAXd2)) {
		chk_flg = 1;
	}
	else if (Val1<0 && Val2<0 && (Val1<=LONG_MINd2 || Val2<=LONG_MINd2)) {
		chk_flg = 1;
	}
	if (chk_flg) {
		ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
		ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
		ma3 = (MPA *)cl_get_tmpMPA(&ma3z);
		m_l2mpa(Val1,ma1);
		m_l2mpa(Val2,ma2);
		m_add(ma3,ma1,ma2);
		m_cpy(pAns,ma3,0);
		if (rc = _chk_over_flow_long(ma3,name,pstat)) ret = rc;
	}
#else
	if (Val1>0 && Val2>0 && Val3<0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
		ret = LONG_MAX;
	}
	else if (Val1<0 && Val2<0 && Val3>0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
		ret = LONG_MIN;
	}
	if (pstat) *pstat = over_or_under;
#endif
	return ret;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_long_sub(Val3,Val1,Val2,name,pstat,pAns)
long Val3,Val1,Val2;
char *name;
int *pstat;
MPA *pAns;
{
	long ret,rc;
	int chk_flg=0;
	MPA ma1z,ma2z,ma3z,*ma1,*ma2,*ma3;
/*
printf("cl_chk_over_flow_long_sub:Enter [%s] Val3=%d Val1=%d Val2=%d\n",name,Val3,Val1,Val2);
*/
	ret = Val3;
	if (Val1>0 && Val2<0 && (Val1>=LONG_MAXd2 || Val2<=LONG_MINd2)) {
		chk_flg = 1;
	}
	else if (Val1<0 && Val2>0 && (Val1<=LONG_MINd2 || Val2>=LONG_MAXd2)) {
		chk_flg = 1;
	}
	if (chk_flg) {
		ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
		ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
		ma3 = (MPA *)cl_get_tmpMPA(&ma3z);
		m_l2mpa(Val1,ma1);
		m_l2mpa(Val2,ma2);
		m_sub(ma3,ma1,ma2);
		m_cpy(pAns,ma3,0);
		if (rc = _chk_over_flow_long(ma3,name,pstat)) ret = rc;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_long_mult(Val3,Val1,Val2,name,pstat,pAns)
long Val3,Val1,Val2;
char *name;
int *pstat;
MPA *pAns;
{
	long ret,rc;
	int chk_flg=0;
	MPA ma1z,ma2z,ma3z,*ma1,*ma2,*ma3;

	ret = Val3;
#if 1	/* 2021.9.24 */
	if (Val1>0 && Val2>0 && (Val1>=SQRT_LONG_MAX || Val2>=SQRT_LONG_MAX)) {
		chk_flg = 1;
	}
	else if (Val1<0 && Val2<0 && (Val1<=-SQRT_LONG_MAX || Val2<=-SQRT_LONG_MAX)) {
		chk_flg = 1;
	}
	else if (Val1>0 && Val2<0 && (Val1>=SQRT_LONG_MAX || Val2<=-SQRT_LONG_MAX)) {
		chk_flg = 1;
	}
	else if (Val1<0 && Val2>0 && (Val1<=-SQRT_LONG_MAX || Val2>=SQRT_LONG_MAX)) {
		chk_flg = 1;
	}
	if (chk_flg) {
		ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
		ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
		ma3 = (MPA *)cl_get_tmpMPA(&ma3z);
		m_l2mpa(Val1,ma1);
		m_l2mpa(Val2,ma2);
		m_mul(ma3,ma1,ma2);
		m_cpy(pAns,ma3,0);
		if (rc = _chk_over_flow_long(ma3,name,pstat)) ret = rc;
	}
#else
	if (((Val1>0 && Val2>0) || (Val1<0 && Val2<0)) && Val3<0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
		ret = LONG_MAX;
	}
	else if (((Val1>0 && Val2<0) || (Val1<0 && Val2>0)) && Val3>0) {
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		ERROROUT1(FORMAT(594),name);	/* (W)%s: I[o[t[܂B */
		ret = LONG_MIN;
	}
	if (pstat) *pstat = over_or_under;
#endif
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static ulong _chk_over_flow_ulong(ma3,name,pstat)
MPA *ma3;
char *name;
int *pstat;
{
	ulong ret;
	int over_or_under;
/*
printf("_chk_over_flow_ulong:Enter ma3=%s\n",m_mpa2str(ma3,0,0,0));
*/
	ret = 0;
	if (m_cmp(ma3,m_get_ULONGMAX()) > 0) {	/* ma3 > LONG_MAX */
		ret = ULONG_MAX;
		over_or_under = D_AULN_OVERFLOW;	/* ECL_OVER_OR_UNDER; */
		if (pstat) *pstat = over_or_under;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
ulong cl_chk_over_flow_ulong_add(uVal3,uVal1,uVal2,name,pstat,pAns)
ulong uVal3,uVal1,uVal2;
char *name;
int *pstat;
MPA *pAns;
{
	ulong ret,rc;
	int chk_flg=0;
	MPA ma1z,ma2z,ma3z,*ma1,*ma2,*ma3;

	ret = uVal3;
	if (uVal1>=ULONG_MAXd2 || uVal2>=ULONG_MAXd2) {
		ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
		ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
		ma3 = (MPA *)cl_get_tmpMPA(&ma3z);
		m_ul2mpa(uVal1,ma1);
		m_ul2mpa(uVal2,ma2);
		m_add(ma3,ma1,ma2);
		m_cpy(pAns,ma3,0);
		if (rc = _chk_over_flow_ulong(ma3,name,pstat)) ret = rc;
	}
	else if (uVal1>=0 && uVal2>=0 && uVal1<uVal2) uVal3 = 0;
	
	return ret;
}

/****************************************/
/*										*/
/****************************************/
ulong cl_chk_over_flow_ulong_sub(uVal3,uVal1,uVal2,name,pstat,pAns)
ulong uVal3,uVal1,uVal2;
char *name;
int *pstat;
MPA *pAns;
{
	ulong ret;

	ret = uVal3;
	if (uVal1>=0 && uVal2>=0 && uVal1<uVal2) ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
ulong cl_chk_over_flow_ulong_mult(uVal3,uVal1,uVal2,name,pstat,pAns)
ulong uVal3,uVal1,uVal2;
char *name;
int *pstat;
MPA *pAns;
{
	ulong ret,rc;
	int chk_flg=0;
	MPA ma1z,ma2z,ma3z,*ma1,*ma2,*ma3;

	ret = uVal3;
	if (uVal1>=SQRT_ULONG_MAX || uVal2>=SQRT_ULONG_MAX) {
		ma1 = (MPA *)cl_get_tmpMPA(&ma1z);
		ma2 = (MPA *)cl_get_tmpMPA(&ma2z);
		ma3 = (MPA *)cl_get_tmpMPA(&ma3z);
		m_ul2mpa(uVal1,ma1);
		m_ul2mpa(uVal2,ma2);
		m_mul(ma3,ma1,ma2);
		m_cpy(pAns,ma3,0);
		if (rc = _chk_over_flow_long(ma3,name,pstat)) ret = rc;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
#if defined(_LP64)
int cl_get_parm_ulong_opt(pInfoParm,pValue,pMsg,iUNSIG,opt)
#else
int cl_get_parm_ubin_opt(pInfoParm,pValue,pMsg,iUNSIG,opt)
#endif
tdtINFO_PARM *pInfoParm;
long *pValue;
char *pMsg;
int iUNSIG,opt;
{
	int rc,iAttr[3],pre;
	double dValue;
	long   lValue,Valz[NMPA_LONG],*Val;

	if (!pMsg) pMsg = "cl_get_parm_long";
	Val = cl_get_tmpMPA(Valz);
	if ((rc=cl_get_parm_mpa_opt(pInfoParm,Val,pMsg,iAttr,opt)) >= 0) {
		if (iAttr[0] == DEF_ZOK_DECI) {
			if (iUNSIG) rc = m_mpa2ul((MPA *)Val,pValue);
			else rc = m_mpa2l((MPA *)Val,pValue);
			if (rc == MPA_ERR_OVERFLOW_I) {
				pre = cl_get_option(20,0) & 0xff;
				if (!(cl_get_option(11,0) & 0x200) && !pre) pre = MAXDBLPRE;
					/* (W)%s: (%s)I[ot[܂B */
				ERROROUT2(FORMAT(280),pMsg,m_mpa2str_exp((MPA *)Val,pre,0,0));
				rc = 0;
			}
		}
		else if (iAttr[0] == DEF_ZOK_FLOA) {
			memcpy(&dValue,Val,sizeof(double));
			if (iUNSIG) *pValue = cl_chk_over_flow_d2_ul(dValue,pMsg);
			else *pValue = cl_chk_over_flow_d2_l(dValue,pMsg);
		}
		else *pValue = Val[0];
		if (rc > 0) rc = -rc;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
#if defined(_LP64)
int cl_get_parm_ulong(pInfoParm,pValue,pMsg,iUNSIG)
#else
int cl_get_parm_ubin(pInfoParm,pValue,pMsg,iUNSIG)
#endif
tdtINFO_PARM *pInfoParm;
long *pValue;
char *pMsg;
int iUNSIG;
{
#if defined(_LP64)
	return cl_get_parm_ulong_opt(pInfoParm,pValue,pMsg,iUNSIG,0);
#else
	return cl_get_parm_ubin_opt(pInfoParm,pValue,pMsg,iUNSIG,0);
#endif
}

/****************************************/
/*										*/
/****************************************/
#if defined(_LP64)
int cl_get_parm_long(pInfoParm,pValue,pMsg)
tdtINFO_PARM *pInfoParm;
long *pValue;
char *pMsg;
{
	return cl_get_parm_ulong(pInfoParm,pValue,pMsg,0);
}
#else
int cl_get_parm_bin(pInfoParm,pValue,pMsg)
tdtINFO_PARM *pInfoParm;
long *pValue;
char *pMsg;
{
	return cl_get_parm_ubin(pInfoParm,pValue,pMsg,0);
}
#endif

#if defined(_LP64)
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_ubin_opt(pInfoParm,pValue,pMsg,iUNSIG,opt)
tdtINFO_PARM *pInfoParm;
int  *pValue,iUNSIG,opt;
char *pMsg;
{
	long lVal;
	int rc;

	if (!pMsg) pMsg = "cl_get_parm_bin";
	if ((rc=cl_get_parm_ulong_opt(pInfoParm,&lVal,pMsg,iUNSIG,opt)) >= 0) {
		*pValue = lVal;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_bin_opt(pInfoParm,pValue,pMsg,opt)
tdtINFO_PARM *pInfoParm;
int  *pValue,opt;
char *pMsg;
{
	return cl_get_parm_ubin_opt(pInfoParm,pValue,pMsg,0,opt);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_ubin(pInfoParm,pValue,pMsg,iUNSIG)
tdtINFO_PARM *pInfoParm;
int  *pValue,iUNSIG;
char *pMsg;
{
	return cl_get_parm_ubin_opt(pInfoParm,pValue,pMsg,iUNSIG,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_bin(pInfoParm,pValue,pMsg)
tdtINFO_PARM *pInfoParm;
int  *pValue;
char *pMsg;
{
	return cl_get_parm_ubin(pInfoParm,pValue,pMsg,0);
}
#endif

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtINFO_PARM *pInfoParm;
long *pValue;
char *pMsg;
int  iAttr[];
int  opt;
{
#ifdef GET_PARM_RANGE
	int rc;
	ushort len;

	if (!pMsg) pMsg = "cl_get_parm_mpa_opt";
	len = pInfoParm->pi_alen;
	pInfoParm->pi_alen &= ~D_AULN_RANGE_DATA;
	rc = cl_get_parm_range_mpa(pInfoParm,pValue,pMsg,iAttr,opt);
	pInfoParm->pi_alen = len;
	return rc;
#else
	int rc,len,attr,iVal;
	double dVal;
	long lVal;
	char *p;
	struct tm stm;

	if (!pInfoParm || !pValue || !iAttr) return -1;
	if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
/*
printf("cl_get_parm_mpa_opt: Attr=%d\n",pInfoParm->pi_attr);
*/
	if (!pMsg) pMsg = "cl_get_parm_mpa_opt";
	rc = 0;
	p = pInfoParm->pi_data;
	len = pInfoParm->pi_dlen;
	iAttr[2] = 0;
	if ((attr=pInfoParm->pi_attr) == DEF_ZOK_BINA) {
		if (len == sizeof(int)) lVal = cl_get_data_int(pInfoParm);
		else lVal = cl_get_data_long(pInfoParm);
		len = sizeof(long);
		memcpy(pValue,&lVal,len);
		if (pInfoParm->pi_scale & D_DATA_UNSIGNED) iAttr[2] = AKX_NUM_U;
	}
	else if (attr==DEF_ZOK_FLOA || attr==DEF_ZOK_DECI) {
		memcpy(pValue,p,len);
	}
	else if (attr == DEF_ZOK_CHAR) {
		return cl_conv_const_nsub(p,len,pValue,pMsg,iAttr,opt);
	}
	else if (attr == DEF_ZOK_DATE) {
		cl_mpa2tm(&stm,pInfoParm->pi_data);
		lVal = mktime(&stm);
		len = sizeof(long);
		memcpy(pValue,&lVal,len);
		attr = DEF_ZOK_BINA;
	}
	else {
		if (pMsg=cl_conv_msg_check(pMsg,-1)) {
			/* %s: p[^̌^(%04x)Ă܂B */
			ERROROUT2(FORMAT(285),pMsg,attr);
		}
		rc = ECL_SCRIPT_ERROR;
	}
	iAttr[0] = attr;
	iAttr[1] = len;
/*
printf("cl_get_parm_mpa_opt:Exit iAttr[0]=%d iAttr[1]=%d iAttr[2]=%08x\n",iAttr[0],iAttr[1],iAttr[2]);
*/
	return rc;
#endif
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_mpa(pInfoParm,pValue,pMsg,iAttr)
tdtINFO_PARM *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	int opt,attr;

	if (!pMsg) pMsg = "cl_get_parm_mpa";
/*
printf("cl_get_parm_mpa: iAttr[0]=%08x pMsg=[%s]\n",iAttr[0],pMsg);
*/
	opt = pGlobTable->options[16];
	attr = iAttr[0];
	if ((attr & 0xffffff00) == D_GX_OPT_USE_ATTR) attr &= 0xff;
	else attr = 0;
	iAttr[0] = attr;
	return cl_get_parm_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_double_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtINFO_PARM *pInfoParm;
double *pValue;
char *pMsg;
int  iAttr[],opt;
{
#ifdef GET_PARM_RANGE
	int rc;
	ushort len;

	if (!pMsg) pMsg = "cl_get_parm_double";
	len = pInfoParm->pi_alen;
	pInfoParm->pi_alen &= ~D_AULN_RANGE_DATA;
	rc = cl_get_parm_range_double(pInfoParm,pValue,pMsg,iAttr);
	pInfoParm->pi_alen = len;
	return rc;
#else
	int rc,atr;
	long Valz[NMPA_LONG],*Val;
	ulong uVal;
	double dval;

	if (!pMsg) pMsg = "cl_get_parm_double";
	Val = cl_get_tmpMPA(Valz);
	if ((rc=cl_get_parm_mpa_opt(pInfoParm,Val,pMsg,iAttr,opt)) >= 0) {
		if ((atr=iAttr[0]) == DEF_ZOK_DECI) rc = m_dset(pValue,(MPA *)Val);
#if 1	/* 2021.11.4 */
		else if (atr == DEF_ZOK_BINA) {
		/*	if (pInfoParm->pi_scale & D_DATA_UNSIGNED) {	*/
			if (iAttr[2] & AKX_NUM_U) {
				uVal = Val[0];
				*pValue = uVal;
			}
			else *pValue = Val[0];
		}
#else
		else if (atr == DEF_ZOK_BINA) *pValue = Val[0];
#endif
		else memcpy(pValue,Val,sizeof(double));
		if (rc > 0) rc = ECL_SCRIPT_ERROR;	/* -rc; */
		iAttr[0] = DEF_ZOK_FLOA;
		iAttr[1] = sizeof(double);
/*
printf("cl_get_parm_double:Exit Value=%g\n",*pValue);
*/
	}
	return rc;
#endif
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_double(pInfoParm,pValue,pMsg,iAttr)
tdtINFO_PARM *pInfoParm;
double *pValue;
char *pMsg;
int  iAttr[];
{
	return cl_get_parm_double_opt(pInfoParm,pValue,pMsg,iAttr,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_dec_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtINFO_PARM *pInfoParm;
MPA *pValue;
char *pMsg;
int  iAttr[],opt;
{
	int rc,atr;
	long Valz[NMPA_LONG],*Val;
	double dVal;

	if (!pMsg) pMsg = "cl_get_parm_dec";
	Val = cl_get_tmpMPA(Valz);
	if ((rc=cl_get_parm_mpa_opt(pInfoParm,Val,pMsg,iAttr,opt)) >= 0) {
/*
printf("cl_get_parm_dec: rc=%d iAttr=%d %d Val=%d\n",rc,iAttr[0],iAttr[1],Val[0]);
*/
		rc = 0;
		if ((atr=iAttr[0]) == DEF_ZOK_BINA) {
			rc = m_l2mpa(Val[0],pValue);
		}
		else if (atr == DEF_ZOK_FLOA) {
			memcpy(&dVal,Val,sizeof(double));
			rc = m_d2mpa(dVal,pValue);
		}
		else {
			memcpy(pValue,Val,sizeofMPA());
		}
		if (rc > 0) rc = ECL_SCRIPT_ERROR;	/* -rc; */
		iAttr[0] = DEF_ZOK_DECI;
		iAttr[1] = sizeofMPA();
	}
/*
printf("cl_get_parm_dec:Exit rc=%d\n",rc);
*/
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_dec(pInfoParm,pValue,pMsg,iAttr)
tdtINFO_PARM *pInfoParm;
MPA *pValue;
char *pMsg;
int  iAttr[];
{
	return cl_get_parm_dec_opt(pInfoParm,pValue,pMsg,iAttr,0);
}

/****************************************/
/*										*/
/****************************************/
long cl_get_data_long(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	long lVal;
	char *p;

	p = pInfoParm->pi_data;
#if defined(_LP64)
/*
printf("cl_get_data_long: pInfoParm->pi_dlen=%d\n",pInfoParm->pi_dlen);
*/
	if (pInfoParm->pi_dlen == sizeof(int))
		lVal = cl_get_data_int(pInfoParm);
	else
#endif
	if (pInfoParm->pi_scale == 0x40) lVal = pInfoParm->pi_pos;
	else memcpy((char *)&lVal,p,sizeof(long));
	return lVal;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_data_int(pInfoParm)
tdtINFO_PARM *pInfoParm;
{
	long lVal;
	int iVal;
	char *p;

	p = pInfoParm->pi_data;
#if defined(_LP64)
	if (pInfoParm->pi_dlen == sizeof(int)) {
		iVal = *(int *)p;
/*
printf("cl_get_data_int: iVal=%d\n",iVal);
*/
	}
	else if (pInfoParm->pi_scale == 0x40) iVal = pInfoParm->pi_pos;
	else {
		memcpy((char *)&lVal,p,sizeof(long));
		iVal = lVal;
	}
#else
	if (pInfoParm->pi_scale == 0x40) iVal = pInfoParm->pi_pos;
	else memcpy((char *)&iVal,p,sizeof(int));
#endif
	return iVal;
}

/****************************************/
/*  oۑς݃f[^w̕ϐɐݒ肷 */
/****************************************/
int _ex_xhash_set_var(pInfoParm,pInfoParmI)
tdtINFO_PARM *pInfoParm, *pInfoParmI;
{
	char cId;
	tdtINFO_PARM ***pTBL;
	int  rc,ix;
	tdtArrayIndex tIndex;

DEBUGOUT_InfoParm(194,"_ex_xhash_set_var:IN ",pInfoParmI,0,0);
	if (rc=cl_get_array_index_tbl(pInfoParm,&tIndex,&pTBL,"_ex_xhash_set_var:"))
		return ECL_SCRIPT_ERROR;
	ix = tIndex.index[3];
	cId = pInfoParm->pi_id;
	if (cId == 'R')
		pInfoParm=cl_get_array_ent(tIndex.pVarIndex,ix);
	else pInfoParm = cl_get_var_ent(pTBL,ix);
#if 1	/* 2021.10.27 */
	rc = cl_gx_rep_info_als(pInfoParm,pInfoParmI,1);
#else
	rc = cl_gx_rep_info_set(pInfoParm,pInfoParmI,1);
#endif
	if (rc) return ECL_SCRIPT_ERROR;
DEBUGOUT_InfoParm(194,"_ex_xhash_set_var: ix=%d cId=[%c]",pInfoParm,ix,cId);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_xhash(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtINFO_PARM *ppParm[];
{
	static char *_fn_="cl_ex_xhash";
	int  ret,rc;
	char w1[32],*p1,*key,*cpDat,**cppDat,cCmd,c0,c1,cId,atr;
	tdtINFO_PARM *pInfoParm,tInfoParm;
	tdtINFO_PARM ***pTBL;
	XHASHB *xhp;
	int  i,iVal[5],ix,len,klen,attr;
	static char *cval[]={"sKeyLen","lMaxReg","lPreReg","DataFlag","opt"};
	tdtArrayIndex tIndex;
	double dVal;

	if (nparm > 5) {
		/* %s: ]ȃp[^(nparm=%d)܂B */
		ERROROUT2(FORMAT(267),_fn_,nparm);
		return ECL_SCRIPT_ERROR;
	}

	pInfoParm = ppParm[0];
	if (pInfoParm->pi_attr == DEF_ZOK_CHAR) {
		memnzcpy(w1,pInfoParm->pi_data,pInfoParm->pi_dlen,sizeof(w1));
		if (!stricmp(w1,"New")) {
			mem_set_int(iVal,0,5);
			for (i=1;i<nparm;i++) {
				if (ret=cl_get_parm_bin(ppParm[i],&iVal[i-1],cval[i-1]))
					return ECL_SCRIPT_ERROR;
			}
DEBUGOUT5("_xhash: K=%d M=%d S=%d D=%d opt=%08x",iVal[0],iVal[1],iVal[2],iVal[3],iVal[4]);
			if (iVal[0] < 0) {
				ERROROUT(FORMAT(268));	/* Xhash: L[͂OȏłB */
				return ECL_SCRIPT_ERROR;
			}
			else if (iVal[0] > 0) iVal[0] += 8;
			if (iVal[3] > 0) iVal[3] = sizeof(tdtINFO_PARM);
			else iVal[3] = -2;
			xhp = akxs_xhashm_new2(iVal[0],iVal[1],iVal[2],iVal[3],iVal[4],NULL,NULL);
/*
printf("_xhash: xha_id[1]=[%c]\n",xhp->xha_id[1]);
*/
			memcpy(pWork,&xhp,sizeof(XHASHB *));
		}
		else {
			/* Xhash: Pp[^'New'ł͂܂B */
			ERROROUT1(FORMAT(269),w1);
			return ECL_SCRIPT_ERROR;
		}
	}
	else if (pInfoParm->pi_attr == DEF_ZOK_BINA) {
		/*
		 *  nbV\ւ̃|C^擾
		 */
		if (!(xhp=(XHASHB *)cl_get_data_long(pInfoParm))) {
			/* Xhash: nbVTableւ̃|C^mtkkłB */
			ERROROUT(FORMAT(270));
			return ECL_SCRIPT_ERROR;
		}
		c0 = xhp->xha_id[0];
		c1 = xhp->xha_id[1];
		if (c0=='H'||c0=='N'||c0=='U'||c1=='X'||c1=='L'||c1=='2'||c1=='H') ;
		else {
			/* Xhash: nbVTablesłBid='%c%c' */
			ERROROUT2(FORMAT(271),c0,c1);
			return ECL_SCRIPT_ERROR;
		}
		/*
		 *  R}h擾
		 */
		if (nparm < 2) {
			/* Xhash: R}h̎w肪܂B */
			ERROROUT(FORMAT(272));
			return ECL_SCRIPT_ERROR;
		}
		p1 = w1;
		if ((ret = parm_to_char(ppParm[1],&p1,NULL)) < 0) return ret;
		cCmd = toupper(*p1);
		if (!stricmp(p1,"Free")) {
			ret = akxs_xhash_free(xhp);
		}
		else if (cCmd=='U'||cCmd=='M') {
			ret = akxs_xhash2(xhp,cCmd,NULL,NULL);
		}
		else if (cCmd=='K'||cCmd=='P') {
			if (nparm < 3) {
				/* Xhash: Index̎w肪܂Bcmd=[%s] */
				ERROROUT1(FORMAT(273),w1);
				return ECL_SCRIPT_ERROR;
			}
			pInfoParm = ppParm[2];
			if (ret=cl_get_parm_bin(pInfoParm,&ix,"Index"))
				return ECL_SCRIPT_ERROR;
/*
printf("cl_ex_xhash: cmd=%c ix=%d\n",cCmd,ix);
*/
			xhp->xha_xhix = ix;
			ret = akxs_xhash2(xhp,'P',&key,&cpDat);
			if (ret > 0) {
				if (nparm>=4) {
					len = xhp->xha_keylen;
					if (len > 0) {
						p1 = key + 4;
						memcpy(&klen,p1,sizeof(int));
						len -= 8;
						p1 += 4;
						switch (key[0]) {
							case DEF_ZOK_CHAR:
								rc = cl_set_parm_char(&tInfoParm,p1,klen);
								break;
							case DEF_ZOK_BINA:
								memcpy(&ix,p1,klen);
								rc = cl_set_parm_bin(&tInfoParm,ix);
								break;
							case DEF_ZOK_FLOA:
								memcpy(&dVal,p1,klen);
								rc = cl_set_parm_double(&tInfoParm,dVal);
								break;
							case DEF_ZOK_DECI:
								if (!(rc=cl_set_parm_mpa(&tInfoParm,p1))) {
									tInfoParm.pi_hlen = key[2];	/* precision */
									tInfoParm.pi_pos = key[3];	/* scale */
								}
								break;
							case DEF_ZOK_BULK:
								rc = cl_set_parm_char(&tInfoParm,p1,klen);
								pInfoParm->pi_attr = key[0];
								break;
							default:
								rc = -100;
						}
						if (rc) return rc;
					}
					else {
						cl_set_parm_char(&tInfoParm,key,len);
					}
					rc = _ex_xhash_set_var(ppParm[3],&tInfoParm);
					if (rc < 0) return ECL_SCRIPT_ERROR;
				}
				if (nparm>=5 && xhp->xha_datlen>-2) {
					memcpy(&tInfoParm,cpDat,sizeof(tdtINFO_PARM));
					rc = _ex_xhash_set_var(ppParm[4],&tInfoParm);
					if (rc < 0) return ECL_SCRIPT_ERROR;
				}
			}
		}
		else if (cCmd=='R'||cCmd=='D'||cCmd=='S') {
			/*
			 *  L[擾
			 */
			pInfoParm = ppParm[2];
			if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
			key  = pInfoParm->pi_data;
			klen = pInfoParm->pi_dlen;
			len = xhp->xha_keylen;
/*
printf("cl_ex_xhash: len=%d klen=%d\n",len,klen);
*/
			if (len > 0) {
				len -= 8;
				atr = pInfoParm->pi_attr;
				if (atr!=DEF_ZOK_CHAR && atr!=DEF_ZOK_BULK && len<klen) {
					/* %s: L[(%d)L[`(%d) */
					ERROROUT3(FORMAT(279),_fn_,klen,len);
					return ECL_SCRIPT_ERROR;
				}
				key = cl_tmp_const_malloc(len+8);
				key[0] = atr;
				key[1] = 0;
				key[2] = pInfoParm->pi_hlen;
				key[3] = pInfoParm->pi_pos;
				p1 = key + 4;
				memcpy(p1,&klen,sizeof(int));
				p1 += 4;
				if (atr==DEF_ZOK_CHAR || atr==DEF_ZOK_BULK) {
					if (klen < len) memset(p1+klen,' ',len-klen);
				}
				memcpy(p1,pInfoParm->pi_data,klen);
			}
			else {
				key = w1;
				if ((ret=parm_to_char(pInfoParm,&key,NULL)) < 0) return ret;
			}
			/*
			 *  ۑpf[^̐ݒA܂́Aۑς݃f[^o
			 */
			cppDat = NULL;
			if (nparm >= 4) {
				if (xhp->xha_datlen > -2) {
					pInfoParm = ppParm[3];
					if (cCmd == 'S') {
						memset(&tInfoParm,0,sizeof(tdtINFO_PARM));
#if 1	/* 2021.10.27 */
						rc = cl_gx_rep_info_als(&tInfoParm,pInfoParm,1);
#else
						rc = cl_gx_rep_info_set(&tInfoParm,pInfoParm,1);
#endif
						if (rc) return ECL_SCRIPT_ERROR;
						cppDat = (char **)&tInfoParm;
DEBUGOUT_InfoParm(194,"_xhash:lDatLen=%d cmd=[%c]",&tInfoParm,xhp->xha_datlen,cCmd);
					}
					else cppDat = &cpDat;
				}
				else {
					ERROROUT(FORMAT(274));	/* Xhash: f[^͎wł܂B */
					return ECL_SCRIPT_ERROR;
				}
			}
			/*
			 *  nbV
			 */
			ret = akxs_xhash2(xhp,cCmd,key,cppDat);
/*
printf("_xhash: cmd=[%c] key=[%s] ret=%d\n",cCmd,key,ret);
*/
			if (nparm>=4 && ret>0 && (cCmd=='R'||cCmd=='D')) {
				/*
				 *  oۑς݃f[^w̕ϐɐݒ肷
				 */
				memcpy(&tInfoParm,cpDat,sizeof(tdtINFO_PARM));
DEBUGOUT_InfoParm(194,"_xhash: index=%d cmd=[%c]",&tInfoParm,ret,cCmd);
				rc = _ex_xhash_set_var(pInfoParm,&tInfoParm);
				if (rc < 0) return ECL_SCRIPT_ERROR;
			}
		}
		else {
			/* Xhash: R}hĂ܂Bcmd=[%s] */
			ERROROUT1(FORMAT(275),p1);
			return ECL_SCRIPT_ERROR;
		}
		memcpy(pWork,&ret,sizeof(int));
	}
	else {
		/* Xhash: Pp[^̌^^łl^ł܂B */
		ERROROUT(FORMAT(276));
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
long cl_chk_over_flow_d2_l(d,name)
double d;
char *name;
{
	long l;

#if defined(_LP64)
	if (d>9.223372036854775e18 || d<-9.223372036854775e18) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) l = LONG_MAX;
		else l = LONG_MIN;
	}
	else l = d;
#else
	l = cl_chk_over_flow_d2_i(d,name);
#endif
	return l;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_over_flow_d2_i(d,name)
double d;
char *name;
{
	int i;

	if (d>2147483647.0 || d<-2147483648.0) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) i = INT_MAX;
		else i = INT_MIN;
	}
	else i = d;
	return i;
}

/****************************************/
/*										*/
/****************************************/
ulong cl_chk_over_flow_d2_ul(d,name)
double d;
char *name;
{
	ulong l;

#if defined(_LP64)
	if (d>1.844674407370955e19 || d<-1.844674407370955e19) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) l = LONG_MAX;
		else l = LONG_MIN;
	}
	else l = d;
#else
	l = cl_chk_over_flow_d2_ui(d,name);
#endif
	return l;
}

/****************************************/
/*										*/
/****************************************/
uint cl_chk_over_flow_d2_ui(d,name)
double d;
char *name;
{
	uint i;

	if (d>4294967295.0 || d<-4294967296.0) {
		ERROROUT2(FORMAT(277),name,d);	/* (W)%s: (%e)I[ot[܂B */
		if (d > 0.0) i = INT_MAX;
		else i = INT_MIN;
	}
	else i = d;
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_over_flow_l2_i(l,name)
long l;
char *name;
{
	int i;

#if defined(_LP64)
	if (l>INT_MAX || l<INT_MIN) {
		ERROROUT2(FORMAT(278),name,l);	/* (W)%s: (%ll)I[ot[܂B */
		if (l > 0) i = INT_MAX;
		else i = INT_MIN;
	}
	else i = l;
#endif
	return (int)l;
}

/****************************************/
/*										*/
/****************************************/
long cl_get_val_long(val)
int val[];
{
	long lVal;

#if defined(_LP64)
	memcpy(&lVal,val,sizeof(long));
	return lVal;
#else
	return val[0];
#endif
}

#ifdef GET_PARM_RANGE
/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_mpa_opt(pInfoParm,pValue,pMsg,iAttr,opt)
tdtINFO_PARM *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[],opt;
{
	int rc,len,attr,iVal,iRANGE;
	double dVal;
	long lVal;
	char *p,*pV;

	if (!pInfoParm || !pValue || !iAttr) return -1;
	if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
/*
printf("cl_get_parm_mpa: Attr=%d\n",pInfoParm->pi_attr);
*/
	rc = 0;
	pV = (char *)pValue;
	iRANGE = pInfoParm->pi_alen & D_AULN_RANGE_DATA;
	p = pInfoParm->pi_data;
	len = pInfoParm->pi_dlen;
	if ((attr=pInfoParm->pi_attr) == DEF_ZOK_BINA) {
		if (len == sizeof(int)) lVal = cl_get_data_int(pInfoParm);
		else lVal = cl_get_data_long(pInfoParm);
		len = sizeof(long);
		memcpy(pV,&lVal,len);
		if (iRANGE) memcpy(pV,&pInfoParm->pi_hlen,len);
	}
	else if (attr==DEF_ZOK_FLOA || attr==DEF_ZOK_DECI) {
		memcpy(pV,p,len);
		if (iRANGE) memcpy(pV+len,p+len,len);
	}
	else if (attr == DEF_ZOK_CHAR) {
		if (rc = cl_conv_const_nsub(p,len,pV,pMsg,iAttr,opt)) return rc;
		if (iRANGE) rc = cl_conv_const_nsub(p+len,len,pV+iAttr[1],pMsg,iAttr);
		return rc;
	}
	else {
		if (pMsg=cl_conv_msg_check(pMsg,-1)) {
			/* %s: p[^̌^(%04x)Ă܂B */
			ERROROUT2(FORMAT(285),pMsg,attr);
		}
		rc = ECL_SCRIPT_ERROR;
	}
	iAttr[0] = attr;
	iAttr[1] = len;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_mpa(pInfoParm,pValue,pMsg,iAttr)
tdtINFO_PARM *pInfoParm;
int  *pValue;
char *pMsg;
int  iAttr[];
{
	iAttr[0] = 0;
	return cl_get_parm_range_mpa_opt(pInfoParm,pValue,pMsg,iAttr,0)
}

/****************************************/
/*										*/
/****************************************/
int cl_get_parm_range_double(pInfoParm,pValue,pMsg,iAttr)
tdtINFO_PARM *pInfoParm;
double *pValue;
char *pMsg;
int  iAttr[];
{
	int rc;
	long Valz[NMPA_LONG*2],*Val;
	double dval;
	char *pV,*pv;

	Val = cl_get_tmpMPA2(Valz,2);
	if ((rc=cl_get_parm_range_mpa(pInfoParm,Val,pMsg,iAttr)) >= 0) {
		if (iAttr[0] == DEF_ZOK_DECI) {
			rc = m_dset((double *)pValue,(MPA *)Val);
			iAttr[0] = DEF_ZOK_FLOA;
			iAttr[1] = sizeof(double);
			if (!rc && (pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
				pV = (char *)pValue + sizeofMPA();
				pv = (char *)Val + sizeof(double);
				rc = m_dset((double *)pV,(MPA *)pv);
			}
		}
		else memcpy(pValue,Val,iAttr[1]*2);
		if (rc > 0) rc = -rc;
	}
	return rc;
}
#endif
