/*******************************************/
/*						*/
/*	hex dump	 			*/
/*						*/
/*		by A.Kobayashi 1992.2.15	*/
/*		by A.Kobayashi 1993.4.2	*/
/*						*/
/*******************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#if defined(SUNOS) || defined(SUNOS5) || defined(AIX)
#include	<jctype.h>
#endif
#include	<string.h>
#include	<memory.h>

static FILE *fp;
static char dat[4096];
static char *fname;
#if defined(AIX) || defined(WIN) || defined(HPUX) || defined(CYGWIN)
static char mode='s';
#else
static char mode='e';
#endif

int issjis(c)
unsigned char c;
{
	if ((c>=0x81 && c<=0x9f) || (c>=0xe0  && c<=0xfc))
		return (1);
	else
		return (0);
}
 
int iskanji1(c1)
unsigned char c1;
{
 
	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
		if ( (c1==0x8e) || ( (c1>=0xa1) && (c1<=0xfe) ) ) return (1);
		return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
		return (issjis(c1));
	}
}

int iskanji(p)
unsigned char *p;
{
	unsigned char c1,c2;

	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
			c1 = *p++;
			c2 = *p;
			if ( (c1==0x8e) ||
				( (c1>=0xa1) && (c1<=0xfe) && (c2>=0xa1) && (c2<=0xfe) ) )
				return (1);
			return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
#if 0 /* 1994.3.18 CSK */
			return (issjis(*p));
#else
			c2 = *(p+1);
			if (issjis(*p) &&
			    ((c2>=0x40 && c2<=0x7e)||(c2>=0x80 && c2<=0xfc))) return 1;
			else return 0;
#endif
	}
}

int isank(c)
unsigned char c;
{
	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
			if ((c>=0x20 && c<=0x7e))
				return (1);
			else
				return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
			if ((c>=0x20 && c<=0x7e) ||
			    (c>=0xa1 && c<=0xdf) )
				return (1);
			else
				return (0);
	}
}

char toank(c)
unsigned char c;
{
	if (isank(c))
		return ((char)c);
	else
		return ('.');
}

int argcheck(argc,argv)
int  argc;
char *argv[];
{
	char c1,c2,*p;

	argc--;
	argv++;
	fp = NULL;
/*	mode = 'e';	*/
	fname = NULL;

	if (argc<1) return -1;

	while (argc>0) {
		p = *argv;
		c1 = *p++;
		if (c1 == '-') {
			if ((c2=*p) == 's') mode = 's';
			else if (c2 == 'e') mode = 'e';
			else if (c2 == '\0') {
				fp = stdin;
			}
			else return -3;
		}
		else if (!fname) {
			fname = *argv;
		}
		argc--;
		argv++;
	}
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{

	char *p,*pp,buf[128],pb[8];
	long i,j,jj,iend;
	int len,sjis,sflg,rc;

	rc = argcheck(argc,argv);
	if (rc || (!fp && !fname) || (fp && fname)) {
		fprintf(stderr,"usage : xdump [-s|-e] {file_name|-}\n");
		exit(1);
	}
	if (fname) {
		fp = fopen(fname,"rb");
		if (fp==0){
			fprintf(stderr,"file[%s] open error!!\n",fname);
			exit(2);
		}
	}
	else fname = "stdin";
	len=fread(dat,1,4096,fp);
/*
	len=getline(dat,4096,fp);
*/
	if (len>0)
		printf("*** %s ***\n       loc    0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15  ----+----+----+-",fname);

	sjis = sflg = 0;
	for (i=0;;) {
		p = dat;
		iend = i + (long)len;
		for (;i<iend;i+=16) {
			sprintf(buf,"\n%010d :",i);
			pp=p;
			if ((jj=i+16)>iend)
				jj=iend;
			for (j=i;j<i+16;j++)
				if (j<iend) {
					sprintf(pb," %02x",(int)*pp++ & 0xff);
					strcat(buf,pb);
				}
				else
					strcat(buf,"   ");
			strcat(buf,"  ");
			for (j=i;j<jj;j++,p++) {
				if (j==i && sflg) {
					strcpy(pb," ");
					sflg = 0;
				}
				else {
					if ((j<iend-1) && iskanji(p))
						sjis = 1;
					else
						sjis = 0;
					if (sjis) {
						sprintf(pb,"%c%c",*p,*(p+1));
						if (j<jj-1) {
							j++;
							p++;
						}
						else
							sflg = 1;
					}
					else
						sprintf(pb,"%c",toank(*p));
				}
				strcat(buf,pb);
			}
			printf("%s",buf);
		}
	/*
		printf("\n%010d   (DATA END)\n",j);
	*/
		if (len<4096) break;
		len=fread(dat,1,4096,fp);
	/*
		len=getline(dat,4096,fp);
	*/
		if (len<1) break;
	}
	printf("\n%010d   (DATA END)\n",j);
	fclose (fp);
}

/*******************************************/
/*                                         */
/*    bulk to binary                       */
/*                                         */
/*    coded   by A.Kobayashi   94.6.7      */
/*    updated by A.Kobayashi 2004.7.1      */
/*                                         */
/*******************************************/
/*
	cc butobi.c -o butobi
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void usage()
{
	static char *h[]=
	{"butobi -h -i {file|-}\n"
#if 0
	,"\t-h : help\n"
	,"\t-i : no touch CR and LF\n"
	,"\t-o : omit CR and LF\n"
#else
	,"\t-h : help\n"
	,"\t-i : sR[h(0x0d0x0a)͂̂܂܏o͂B\n"
	,"\t-o : sR[h(0x0d0x0a)폜B\n"
#endif
	,NULL
	};
	char **ph,*p;

	ph = h;
	while (p = *ph++) fprintf(stderr,p);
}

unsigned char atox1(c)
char    c;
{
	if ((c >= '0') && (c <= '9')) c -= '0';
	else if ((c >= 'a') && (c <= 'f')) c -= ('a' - 10);
	else if ((c >= 'A') && (c <= 'F')) c -= ('A' - 10);
	else c = 0xff;

	return c;
}
		 
/* Convert bulk --> Binary
butobi(bu, len, bi)
char    *bu;
char    *bi;
long    len;	*/
int main(argc, argv)
int   argc;
char *argv[];
{
	int  c,c1,iInter,iOMIT;
	char *p,*fname;
	FILE *fp;

	fp = NULL;
	fname = NULL;
	iInter = iOMIT = 0;
	while (--argc > 0) {
		argv++;
		p = argv[0];
		if ((c=*p) == '-') {
			if (!(c=*(++p))) fp = stdin;
			else {
				while (c) {
					if (c == 'i') iInter = 1;
					else if (c == 'o') iOMIT = 1;
					else {
						usage();
						exit(1);
					}
					c = *p++;
				}
			}
		}
		else fname = p;
	}

	if (!fp) {
		if (fname) {
			fp = fopen(fname,"rb");
			if (!fp){
				fprintf(stderr,"file[%s] open error!!\n",p);
				exit(2);
			}
		}
		else {
			usage();
			exit(1);
		}
	}

	while ((c=getc(fp))!=EOF) {
		if (iInter || iOMIT) {
			if (c=='\r' || c=='\n') {
				if (!iOMIT) putchar(c);
				continue;
			}
		}
		if ((c = atox1(c)) == 0xff) continue;
		if ((c1=getc(fp))==EOF) c1 = 0;
		else {
			if (iInter || iOMIT) {
				if (c1=='\r' || c1=='\n') {
					putchar(c << 4);
					if (!iOMIT) putchar(c1);
					continue;
				}
			}
			if ((c1 = atox1(c1)) == 0xff) c1 = 0;
		}
		putchar((c << 4) + c1);
	}
	exit(0);
}

/*******************************************/
/*                                         */
/*    binary to bulk                       */
/*                                         */
/*    coded   by A.Kobayashi 2004.7.2      */
/*                                         */
/*******************************************/
/*
	cc bitobu.c -o bitobu
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void usage()
{
	static char *h[]=
	{"bitobu -h -s -N -r -u -i {file|-}\n"
#if 0
	,"\t-h : help\n"
	,"\t-s : space\n"
	,"\t-N : LF by N bytes\n"
	,"\t-r : CR+LF\n"
	,"\t-u : output upper char\n"
	,"\t-i : no touch CR and LF\n"
#else
	,"\t-h : help\n"
	,"\t-s : PoCgspace(0x20)o͂B\n"
	,"\t-N : moCgɉs(0x0ao)B\n"
	,"\t-r : sƂCRLF(0x0d0a)o͂B\n"
	,"\t-u : output upper char\n"
	,"\t-i : sR[h(0x0d0x0a)͂̂܂܏o͂B\n"
#endif
	,NULL
	};
	char **ph,*p;

	ph = h;
	while (p = *ph++) fprintf(stderr,p);
}

int main(argc, argv)
int   argc;
char *argv[];
{
	int  c,c1,iNum,iCR,iSpace,iUpper,iInter,count;
	char *p,*fname,buf[3];
	FILE *fp;

	iNum = iCR = iSpace = iUpper = iInter = count = 0;
	fp = NULL;
	fname = NULL;
	while (--argc > 0) {
		argv++;
		p = argv[0];
		if ((c=*p) == '-') {
			if (!(c=*(++p))) fp = stdin;
			else if (c>='0' && c<='9') iNum = atoi(p);
			else {
				while (c) {
					if (c == 'r') iCR = 1;
					else if (c == 's') iSpace = 1;
					else if (c == 'u') iUpper = 1;
					else if (c == 'i') iInter = 1;
					else {
						usage();
						exit(1);
					}
					c = *p++;
				}
			}
		}
		else fname = p;
	}

	if (!fp) {
		if (fname) {
			fp = fopen(fname,"rb");
			if (!fp){
				fprintf(stderr,"file[%s] open error!!\n",p);
				exit(2);
			}
		}
		else {
			usage();
			exit(1);
		}
	}

	while ((c=getc(fp))!=EOF) {
		if (iInter) {
			if (c=='\r' || c=='\n') {
				putchar(c);
				continue;
			}
		}
		sprintf(buf,"%02x",c);
		if (iUpper) {
			buf[0] = toupper(buf[0]);
			buf[1] = toupper(buf[1]);
		}
		putchar(buf[0]);
		putchar(buf[1]);
		if (iSpace) putchar(' ');
		if (iNum > 0) {
			if (++count >= iNum) {
				if (iCR) putchar('\r');
				putchar('\n');
				count = 0;
			}
		}
	}
	exit(0);
}

/**********************************************/
/*                                            */
/*   sR|hϊvO (LF to CRLF)    */
/*                                            */
/*      coded by A.Kobayashi 2003.2.22        */
/*    updated by A.Kobayashi 2003.3.31        */
/*                                            */
/**********************************************/
/*
	cc f2rfe.c -o f2rfe
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
	int c,c2,i,len,sf;
	char cc,f,*p,*fname,*s=NULL,*prg;
	FILE *fp;

	prg = argv[0];
	f = 'w';
	fname = NULL;
	while (argc >= 2) {
		p = argv[1];
		if (*p++ == '-') {
			cc = *p;
			if ((cc == 'w') || (cc == 'u') || (cc == 'm')) f = cc;
			else if (cc == 's') {
				if (*(p+1)) s = p + 1;
				else if (argc >= 3) {
					argc--;
					argv++;
					s = argv[1];
				}
			}
			else {
				fprintf(stderr,"usage: %s [-[h|w|u|m]] [-s[ ]string] [in_file|<in_file] [>out_file]\n",prg);
				exit(1);
			}
		}
		else {
			if (fname) {
				fprintf(stderr,"too file [%s] !!\n",fname);
				exit(1);
			}
			fname = argv[1];
		}
		argc--;
		argv++;
	}
	if (!s) {
		if (f == 'w') s = "\r\n";
		else if (f == 'u') s = "\n";
		else s = "\r";
	}
	len = strlen(s);

	if (fname) {
		if (!(fp=fopen(fname,"r"))) {
			fprintf(stderr,"file [%s] open error!!\n",fname);
			exit(1);
		}
	}
	else fp = stdin;

	while ((c=getc(fp))!=EOF) {
		sf = 1;
		if (f == 'w') {		/* change to '\r\n' */
			if (c == '\r') {
				if ((c=getc(fp)) != '\n') ungetc(c,fp);
			}
			else if (c != '\n') sf = 0;
		}
		else if (f == 'u') {	/* change to '\n' */
			if (c == '\r') {
				if ((c=getc(fp)) != '\n') ungetc(c,fp);
			}
			else sf = 0;
		}
		else if (f == 'm') {	/* change to '\r' */
			if (c == '\r') {
				if ((c=getc(fp)) != '\n') ungetc(c,fp);
			}
			else if (c != '\n') sf = 0;
		}
		if (sf) for (i=0;i<len;i++) putchar(s[i]);
		else putchar(c);
	}
	exit(0);
}

#"%Z% %M% %I% %E% %U%"

include ../../os_depend.mk
include ../../unix_command.mk
include ../../directory.mk
include ../../flags.mk

#---------------------------------------------------------------
#			akb options
#---------------------------------------------------------------
#CPFOPTS	= -DNOTICE -DPERROR
AKBOPTS		= -DPERROR -DMEMCTL

#---------------------------------------------------------------
#			C Compiler Options
#---------------------------------------------------------------
CFLAGS		= \
			$(OSDEPEND) \
			$(INCLUDES) \
			$(AKBOPTS) \
			$(DEBUGOPTS)
#---------------------------------------------------------------
all:bitobu butobi f2rf f2rfe substr stepcnt timecopy xdump

#---------------------------------------------------------------
bitobu:bitobu.o
	$(CC) -o bitobu bitobu.o

butobi:butobi.o
	$(CC) -o butobi butobi.o

f2rf:f2rf.o
	$(CC) -o f2rf f2rf.o

f2rfe:f2rfe.o
	$(CC) -o f2rfe f2rfe.o

substr:substr.o
	$(CC) -o substr substr.o

stepcnt:stepcnt.o
	$(CC) $(CFLAGS) -o stepcnt stepcnt.o

timecopy:timecopy.o
	$(CC) $(CFLAGS) -o timecopy timecopy.o

xdump:xdump.o
	$(CC) $(CFLAGS) -o xdump xdump.o

.c.o : $(HEADERS)
	$(CC) $(CFLAGS) -c $*.c

-------------------------------------------------------------
xdump [-s|-e] {file_name|-}

substr -h {file|-} [start [len]]

butobi -h -i {file|-}
	PoCgڂLȕłȂƂ́ÂĂB
	QoCgڂLȕłȂƂ́A0ƌȂB
	LȕƂ́A0-9, A-Z, a-z

	-h : help
	-i : sR[h(0x0d0x0a)͂̂܂܏o͂B

bitobu -h -s -N -r -u -i {file|-}
	-h : help
	-s : PoCgspace(0x20)o͂B
	-N : moCgɉs(0x0ao)B
	-r : sƂCRLF(0x0d0a)o͂B
	-u : upper
	-i : sR[h(0x0d0x0a)͂̂܂܏o͂B
