#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

set -eu

# path/binary setting
cd `dirname $0`	#base $0 dir
fdir=`pwd`
cd ../..
topdir=`pwd`	#configure root
cp -Rf $fdir ./
cd _tests
wdir=`pwd`
PATH="$wdir:$PATH"
touch log.txt
#-----

#cp -RLf "$topdir"/src/txt2lit ./
#cp -RLf "$topdir"/src/liblbc.a ./
#cp -RLf "$topdir"/src/lbc.h ./
#cp -RLf "$topdir"/src/tests.code ./tests.c

eval "`shunit_m`"
echo "--- run binary test: `pwd`/$0
..."

set +e
( set -x

### -- test_maincode
# cc [!_]*.c [!_]*.a -lm -ldl
# _suc
# ./a.out
# _suc

# info
cat <<-'EEE'> _buf.c
	#include <stdio.h>
	int main(){	puts("hw");	return 0; }
EEE
cc _buf.c; _suc
./a.out; _suc

_res 2>&3
echo "--- SUCCESS for all tests. see $0, log.txt if needs" >&3
) 3>&2 >log.txt 2>&1 
test $? = 0 && flg=0 || flg=1

#clean
#cp -rf "$bdir" "$topdir"
#af=`ls *`
#buf=`printf '%s\n' $af $bf|sort|uniq -u`
#rm -rf $buf

test "$flg" = 0 && exit 0
#err
tail log.txt >/dev/stderr
echo "--- test FAILED, see $0, log.txt" >/dev/stderr
exit 1
