/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.command;

import java.util.List;
import org.ccc.atools.command.AbstractCommand;
import org.ccc.atools.command.CommandManager;
import org.ccc.atools.command.ICommand;
import org.eclipse.swt.widgets.Display;

public class QueueCommandManager
extends CommandManager {
    private CommandManager commandManagerDelegate;
    private boolean scheduled = false;
    private ICommand queueCommand;
    private Runnable timer = new Runnable(){

        @Override
        public void run() {
            Display display;
            Display display2 = display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
            if (display.isDisposed()) {
                return;
            }
            this.queueUpdateCommand();
            List<ICommand> commands = QueueCommandManager.this.findTerminatedCommands();
            if (commands.size() < QueueCommandManager.this.getCommandHistory().size()) {
                display.timerExec(100, (Runnable)this);
            }
        }

        private void queueUpdateCommand() {
            List<ICommand> commands = QueueCommandManager.this.findTerminatedCommands();
            if (commands.size() < QueueCommandManager.this.getCommandHistory().size()) {
                int terminatedIndex = commands.size() - 1;
                int currentIndex = terminatedIndex + 1;
                ICommand currentCommand = QueueCommandManager.this.getCommandHistory().get(currentIndex);
                if (QueueCommandManager.this.queueCommand == currentCommand) {
                    return;
                }
                try {
                    currentCommand.execute();
                }
                finally {
                    QueueCommandManager.this.queueCommand = currentCommand;
                }
            }
        }
    };

    public CommandManager getCommandManagerDelegate() {
        return this.commandManagerDelegate;
    }

    public void setCommandManagerDelegate(CommandManager commandManagerDelegate) {
        this.commandManagerDelegate = commandManagerDelegate;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    @Override
    public void execute() {
        ICommand command = this.preExecute();
        try {
            if (this.scheduled) {
                Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
                display.timerExec(100, this.timer);
            } else {
                command.execute();
            }
        }
        finally {
            this.postExecute();
        }
    }

    public ICommand findQueueCommand(String input, String output) {
        if (this.scheduled && this.queueCommand instanceof AbstractCommand) {
            int result;
            AbstractCommand abstractCommand = (AbstractCommand)this.queueCommand;
            String sourcePath = abstractCommand.getInput();
            String targetPath = abstractCommand.getOutput();
            if (sourcePath != null && targetPath != null && sourcePath.equals(input) && targetPath.equals(output) && (result = this.queueCommand.getResult(sourcePath, targetPath)) == 0) {
                return this.queueCommand;
            }
        }
        return null;
    }

    @Override
    public List<ICommand> getCommandHistory() {
        return this.commandManagerDelegate.getCommandHistory();
    }

    @Override
    public void setCommand(ICommand command) {
        this.commandManagerDelegate.setCommand(command);
    }

    @Override
    protected ICommand preExecute() {
        return this.commandManagerDelegate.preExecute();
    }

    @Override
    protected ICommand postExecute() {
        return this.commandManagerDelegate.postExecute();
    }

    @Override
    public int getResult(String input, String output) {
        return this.commandManagerDelegate.getResult(input, output);
    }

    @Override
    public List<ICommand> findTerminatedCommands() {
        return this.commandManagerDelegate.findTerminatedCommands();
    }

    @Override
    public ICommand findTerminatedCommand(String input, String output) {
        return this.commandManagerDelegate.findTerminatedCommand(input, output);
    }
}

