# git-pre-commit-verify.sh
# ------------------------------------------------------------------------------
#
# Verification support script, to confirm that any pre-existing pre-commit
# hook is that supplied by Git-MQ, or to make it so; every Git-MQ command
# runs this, during its standard initialization phase of execution.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
#
# This file is part of the Git-MQ program suite.
#
# The Git-MQ program suite is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public Licence
# as published by the Free Software Foundation, either version 3 of
# the Licence, or (at your option) any later version.
#
# The Git-MQ program suite is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public Licence for more details.
#
# You should have received a copy of the GNU General Public Licence
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# ------------------------------------------------------------------------------
#
# Invoked only within the scope of an "mq_require" function call, and then
# only when there is a $GIT_DIR/hooks/pre-commit script already in place, we
# compute the git hash for that script, and verify that it matches the hash
# of the Git-MQ pre-commit script, as computed at build-time; if not, then
# we attempt to relocate the existing script into the Git-MQ pre-commit.dir
# chain, and install the Git-MQ pre-commit hook in its place.
#
  local mq_facility=git-mq mq_hash=6b1bf4a104508aa5a4c8fb8ec91fd3700be026dc
  test `git hash-object -t blob $GIT_DIR/hooks/pre-commit` = $mq_hash || {
    mq_require git-pre-commit-setup relocate
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
