# git-pre-commit-setup.sh
# ------------------------------------------------------------------------------
#
# Installation support script; invoked via "mq_require", it provides the
# mechanisms for creation of the Git-MQ specific pre-commit hook directory
# infrastructure, relocation of any pre-existing repository specific hooks
# within this infrastructure, and installation of Git-MQ's own pre-commit
# hook, which is required to protect the integrity of a patch series.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
#
# This file is part of the Git-MQ program suite.
#
# The Git-MQ program suite is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public Licence
# as published by the Free Software Foundation, either version 3 of
# the Licence, or (at your option) any later version.
#
# The Git-MQ program suite is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public Licence for more details.
#
# You should have received a copy of the GNU General Public Licence
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# ------------------------------------------------------------------------------
#
# Before attempting to set up the Git-MQ pre-commit hook, first check the
# integrity of the Git-MQ installation itself, to ensure that the required
# script is available.
#
  local mq_facility="git-mq"
  local mq_libdir=`cd "$libexecdir/../hooks" && pwd`
  test -f "$mq_libdir/pre-commit" || {
    mq_complain "fatal: '$mq_libdir/pre-commit': file not found"
    mq_abort 2 "fatal: cannot initialize pre-commit hook"
  }
# Irrespective of whether relocation of an existing pre-commit script is
# required, or not, we must ensure that the pre-commit.dir subdirectory of
# git's hooks directory is available, and populated by at least any sample
# pre-commit hook, which git itself would have provided.
#
  local git_mq_pre_commit_dir="$GIT_DIR/hooks/pre-commit.dir"
  test -d "$git_mq_pre_commit_dir" || mkdir "$git_mq_pre_commit_dir"
  test -f "$git_mq_pre_commit_dir/pre-commit.sample" || {
    test -f "$GIT_DIR/hooks/pre-commit.sample" && {
      mv "$GIT_DIR/hooks/pre-commit.sample" "$git_mq_pre_commit_dir"
    }
  }
# In the case of a "relocate" request, then it has already been determined
# that there is an existing pre-commit script in git's hooks directory; we
# must relocate it to Git-MQ's pre-commit.dir, provided that doing so does
# not relocate a similar, but distinct, artefact from some previous Git-MQ
# version, and does not overwrite an existing, but different script of the
# same name, which may have been placed in the pre-commit.dir already.
#
  test ${1-x} = relocate && {
    local mq_signature="installed by Git-MQ, from git-pre-commit.shar"
    grep "$mq_signature" "$GIT_DIR/hooks/pre-commit" > /dev/null 2>&1 && {
      rm "$GIT_DIR/hooks/pre-commit"
    } || {
      local git_mq_pre_commit_hook="$git_mq_pre_commit_dir/pre-commit"
      test -f "$git_mq_pre_commit_hook" && {
	cmp -s "$git_mq_pre_commit_hook" "$GIT_DIR/hooks/pre-commit" || {
	  mq_complain "fatal: cannot relocate git's pre-commit hook"
	  mq_complain "fatal: 'pre-commit.dir/pre-commit' is in the way"
	  mq_abort 2 "fatal: invalid pre-commit hook configuration"
	}
	rm "$GIT_DIR/hooks/pre-commit"
      } || mv "$GIT_DIR/hooks/pre-commit" "$git_mq_pre_commit_hook"
    }
  }
# Having now ensured that there is no pre-existing pre-commit script in
# the way, we may now safely install the Git-MQ hook; we first attempt to
# link to the appropriate Git-MQ script, then, failing that, to create a
# symbolic link to it, and, as a last resort, copy it into place.
#
  ( cd "$GIT_DIR/hooks" && {
      ln "$mq_libdir/pre-commit" . || ln -s "$mq_libdir/pre-commit" . ||
      cp "$mq_libdir/pre-commit" .
    }
  )
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
