.nr HY 0
.TH GIT\-QREFRESH 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qrefresh \- update the current patch
.
.
.SH SYNOPSIS
.B git\ qrefresh\c
.RB \ [ \-e ]\ [[[ \-m \ < \fItext >]\  ... ]\ |\ [ \-F \ < \fIfile >]]\c
.RB \ [ \-s ]\ [< \fIpath >\  ... ]
.br
.B git\ qrefresh\c
.RB \ [ \-e ]\ [[[ \-m \ < \fItext >]\  ... ]\ |\ [ \-F \ < \fIfile >]]\c
.RB \ [ \-a ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qrefresh
command updates the topmost \%currently\(hyapplied patch,
to incorporate changes staged in git\(aqs index,
and optionally, when the
.BR \-a \ (or\  \-\-all )
option is specified,
unstaged changes to tracked files in the working tree.
.
.LP
If the
.B \-\-all
option is
.I not
specified,
and a list of one or more
.RI < path >
arguments
.IR is ,
either explicitly as such,
or implicitly by means of specifying the
.BR \-s \ (or\  \-\-short )
option,
(which has the effect of implicitly naming all files
which are already referenced within the patch),
the updated content of the patch is restricted
to include only the named files.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-all
Stage any currently unstaged changes in tracked files,
before updating the patch;
this option cannot be combined with the
.BR \-s \ (or\  \-\-short)
option,
or with any explicit list of
.RI < path >
arguments.
.
.TP
.BR \-e ,\  \-\-edit
Open an editor,
to facilitate further modification of the amended commit message,
(which has been specified by use of
.BR \-\-file ,
or
.B \-\-message
options,
or retrieved by default,
from the current commit whence the patch is derived),
before amending the current commit,
(effectively,
this option is simply passed on to the
.B git\ commit\ \-\-amend
command which refreshes this commit).
.
.TP
.BR \-F \ < \fIname >,\  \-\-file =< \fIname >
.TQ
.BR \-l \ < \fIname >,\  \-\-logfile =< \fIname >
Read the text,
to be used as the amended commit message,
from the file specified by
.RI < name >;
if
.RI < name >
is specified as
.RB \(oq - \(cq,
read the commit message text from standard input.
By convention,
git expects the
.B \-F
(or
.BR \-\-file )
variant of this option;
the
.B \-l
(or
.BR \-\-logfile )
alias is accepted for compatibility with
.B hg\ qrefresh
usage.
.
.TP
.BR \-m \ < \fItext >,\  \-\-message =< \fItext >
Use
.RI < text >
for the amended commit message.
If more than one instance of this option is specified,
each individual
.RI < text >
block is appended to the commit message,
as a separate paragraph.
This feature
.I cannot
be used in conjunction with the
.B \-F
(or
.BR \-\-file )
option.
.TP
.BR \-s ,\  \-\-short
Short-list files which are already referenced within the patch,
for inclusion in a restricted content update;
this has the effect of implicitly adding the path names for
such files to the (possibly empty) list of explicitly specified
.RI < path >
name arguments.
.
.TP
.BR \-D ,\  \-\-currentdate
Use the current date as the commit date,
(as would be the normal case,
if no commit date has been recorded previously);
record it within the patch header,
such that it will be preserved as the patch creation date,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch;
this has the effect of overriding any commit date
which may have been recorded previously,
within the patch header.
.
.TP
.BR \-d \ < \fIdatespec >,\  \-\-date =< \fIdatespec >
Set the commit date,
and hence the patch creation date,
to
.RI < datespec >,
(which may be specified using any date format recognized by
.BR git\ commit );
record this within the patch header,
such that it will be preserved as the patch creation date,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch;
this has the effect of overriding any commit date
which may have been recorded previously,
within the patch header.
.
.TP
.BR \-U ,\  \-\-currentuser
Record the identity of the current user as the author of the patch,
and of its associated commit,
such that this will be preserved,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch;
this has the effect of overriding any author identification
which may have been recorded previously,
within the patch header.
.
.TP
.BR \-u \ < \fIuserspec >,\  \-\-user =< \fIuserspec >
Record the identity of the user specified by
.RI < userspec >,
(which may be specified in any form recognized by
.BR git\ commit ),
as the author of the patch,
and of its associated commit,
such that this will be preserved,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch;
this has the effect of overriding any author identification
which may have been recorded previously,
within the patch header.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qrefresh
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Although inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the behaviour of the
.B git\ qrefresh
command differs from that of its
.B hg\ qrefresh
counterpart in the following respects:\(em
.
.IP \(bu 3m
The
.BR \-\-include ,
and
.B \-\-exclude
options, which are supported by
.BR hg\ qrefresh ,
are not (currently) supported by
.BR git\ qrefresh .
.
.IP \(bu 3m
The
.B \-\-all
option, described above,
is neither supported by,
nor required by
.BR hg\ qrefresh ;
it is provided,
as a
.B Git\-MQ
specific extension to the
.B Mercurial Queues
model,
to achieve more flexible interaction with git\(aqs index.
The command:
.RB \(lq git\ qrefresh\ \-\-all \(rq
will deliver behaviour which is effectively equivalent to that of the
.RB \(lq hg\ qrefresh \(rq
command.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-commit (1),
.BR git\-qimport (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
