.nr HY 0
.TH GIT\-QFOLD 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qfold \- merge additional patches into the current patch
.
.
.SH SYNOPSIS
.B git qfold
.RB [ \-e ]\ [ \-m \ < \fItext >]\ [ \-F \ < \fIfile >]\ [\c
.BR \-k ]\ < \fIpatch >\ ...
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qfold
command merges the content of a series of
.I unapplied
patches,
specified by the list of
.RI < patch >\ ...
arguments,
into the topmost
.I applied
patch.
All patches to be merged (i.e.\& folded)
.I must
be registered in the series file, and
.IR unapplied ;
any guards,
which are applicable,
will be overridden.
.
.LP
After folding, the folded patches will be removed from the series,
and the associated patch files will be deleted; the
.BR \-k \~(or\  \-\-keep )
option may be specified,
to prevent deletion of the patch files.
.
.
.SH OPTIONS
.TP 4n
.BR \-e ,\  \-\-edit
Open an editor,
to facilitate modification of the commit message
for the cumulative patch,
(which has been specified by use of
.BR \-\-file ,
or
.B \-\-message
options,
or by concatenation of folded patch header messages),
before completing the amended commit
whence the cumulative patch is derived;
(effectively,
this option is simply passed on to the
.B git\ commit
command which amends this commit).
.
.TP
.BR \-F \ < \fIname >,\  \-\-file =< \fIname >
.TQ
.BR \-l \ < \fIname >,\  \-\-logfile =< \fIname >
Read the text,
to be used as the replacement commit message,
from the file specified by
.RI < name >;
if
.RI < name >
is specified as
.RI \(oq - \(cq,
read the commit message text from standard input.
By convention,
git expects the
.B \-F
(or
.BR \-\-file )
variant of this option;
the
.B \-l
(or
.BR \-\-logfile )
alias is accepted for compatibility with
.B hg\ qfold
usage.
.
.TP
.BR \-m \ < \fItext >,\  \-\-message =< \fItext >
Use
.RI < text >
for the commit message.
If more than one instance of this option is specified,
each individual
.RI < text >
block is appended to the commit message,
as a separate paragraph.
This feature
.I cannot
be used in conjunction with the
.B \-F
(or
.BR \-\-file )
option.
.
.TP
.BR \-k ,\  \-\-keep
Do not delete the patch files,
which were associated with the folded patches,
after folding;
(this will leave the patch files without corresponding
series file entries,
as may be seen by invoking
.BR git\ qseries\ \-\-missing ).
.
.LP
If no replacement commit message is specified,
by use of the
.BR \-\-file ,
or
.B \-\-message
options,
a default message will be constructed by concatenating any
\%non\(hyempty messages which are recorded in the folded patch headers
with that from the current topmost patch, if also \%non\(hyempty,
separating each from its last \%non\(hyempty predecessor
by a line of the form \(lq*\ *\ *\(rq.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qfold
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qfold
command exhibits fundamentally the same behaviour as its
.B hg\ qfold
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
