/*******************************************/
/*						*/
/*	dar	 			*/
/*						*/
/*		by A.Kobayashi 2003.2.12	*/
/*						*/
/*******************************************/
#include	"akxcommon.h"

#define MAX_REP	100
#define MAX_LEN	4096

typedef struct {
	int  col;
	int  nmj;
	int  nkr;
	char *rep;
} tdtRep;
tdtRep *tpRep=NULL;
int  lrecl=0,nrep=0,sta_rec=1,num_rec=0,nrec=0,trec=0,max_rep=0,rec_mode=0;
int  buf_len=MAX_LEN,dat_len;
char *rec=NULL;
FILE *fp=NULL;
char *fname=NULL,*tfile=NULL;

void _Exit(stat)
int stat;
{
	if (fp) fclose (fp);
	if (tpRep) Free(tpRep);
	if (rec) Free(rec);
	exit(stat);
}

int _getopt(argc, argv)
int  argc;
char *argv[];
{
	uchar c1,c2,*p;
	char *p1,*p2,*pr;
	int n,ret,i,kr,nm;
	char parm[256],*argv2[8],buf[256],*pp;
	tdtRep *pRep=NULL;

	argc--;
	argv++;
	fp = NULL;
	fname = NULL;

	while (argc-- > 0) {
		p = (uchar *)*argv++;
		c1 = *p;
		if (c1 == '-') {
			p++;
			c2 = *p;
			if (c2 == 'l') {
				p++;
				if (*p) lrecl = atoi((char *)p);
				else {
					argc--;
					lrecl = atoi(*argv++);
				}
				if (lrecl <= 0) {
					XERROROUTL5(0,"lrecl(%d) <= 0",lrecl,0,0,0,0);
					_Exit(10);
				}
				if (!(rec=Malloc(lrecl+1))) {
					XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
					_Exit(3);
				}
				rec_mode = 1;
				dat_len = lrecl;
				if (!max_rep) {
					if ((max_rep = lrecl/10)<MAX_REP) max_rep = MAX_REP;
				}
			}
			else if (c2 == 'n') {
				p++;
				if (*p) pp = (char *)p;
				else {
					argc--;
					pp = *argv++;
				}
				n = akxtgetargv2(pp,argv2,2,parm,sizeof(parm),5);
				if (n >= 1) {
					sta_rec = atoi(argv2[0]);
				}
				if (n >= 2) {
					num_rec = atoi(argv2[1]);
				}
			}
			else if (c2 == 'a') {
				p++;
				if (*p) pp = (char *)p;
				else {
					argc--;
					pp = *argv++;
				}
				if (!tpRep) {
				/*
					if (lrecl <= 0) {
						XERROROUTL5(0,"lrecl undefined",0,0,0,0,0);
						_Exit(10);
					}
				*/
					if (!max_rep) max_rep = MAX_REP;
					if (!(tpRep=(tdtRep *)Malloc(max_rep*sizeof(tdtRep)))) {
						XERROROUTL5(0,"Rep table malloc error!!",0,0,0,0,0);
						_Exit(3);
					}
					pRep = tpRep;
				}
				
				n = akxtgetargv2(pp,argv2,2,parm,sizeof(parm),0x17);
				if (n < 2) {
					XERROROUTL5(0,"Rep field invalid [%s]!!",pp,0,0,0,0);
					_Exit(3);
				}
				else {
					if ((i=atoi(argv2[0]))<0 || (lrecl>0 && i>lrecl)) {
						XERROROUTL5(0,"column(%d) invalid!!",i,0,0,0,0);
						_Exit(3);
					}
					pRep->col = i - 1;

					if (pr=strstr(argv2[0],"/r")) kr = atoi(pr+2);
					else kr = 1;
					if (kr <= 0) kr = 1;
					pRep->nkr = kr;

					if (strstr(argv2[0],"/x")) {
						nm = akxcctox(argv2[1],strlen(argv2[1]),buf);
						buf[nm] = '\0';
						pr = buf;
					}
					else {
						nm = strlen(argv2[1]);
						pr = argv2[1];
					}
					pRep->nmj = nm;
					pRep->rep = Strdup(pr);
					nrep++;
					pRep++;
				}
			}
			else if (c2 == '-') {
				p++;
				if (akx_log_set_command_parm(*p,p+1) < 0) return -4;
			}
			else return -3;
		}
		else {
			fname = (char *)p;
			XDEBUGOUTL5(0,"fname=[%s]",fname,0,0,0,0);
		}
	}
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	char *p;

	p = akxt_get_last_name("\\/",argv[0]);
	akx_log_set_up_name(p);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	if (_getopt(argc, argv) < 0) {
		fprintf(stderr,"usage : %s [-h|-?][--{e|p|d|l}LOG_PARAMETER]\n",p);
		fprintf(stderr,"            [-l[ ]R[h] [-n[ ][Jns][,s]]\n");
		fprintf(stderr,"            [-a[ ]J[/x][/rJԂ]='']\n");
		fprintf(stderr,"            [̓t@C]\n");
		fprintf(stderr,"  here\n    LOG_PARAMETER := [FLAG],[LEVEL],[SIZE_MAX],[FILE_MAX],[OPTION],[FILE]]\n\n");
		_Exit(0);
	}

	if (fname) {
		fp = fopen(fname,"rb");
		if (!fp) {
			XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
			_Exit(2);
		}
	}
	else {
		fname = "stdin";
		fp = stdin;
	}

	if (lrecl <= 0) {
		if (!(rec=Malloc(buf_len))) {
			XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
			_Exit(3);
		}
	}

	_dar();

	_Exit(0);
}

int _dar()
{
	int i,j,nm,pos,len;
	char *p,*pr;

	for (;;) {
		if (rec_mode) {
			if (!fread(rec,1,lrecl,fp)) break;
		}
		else {
			if ((len=akxa_get_line(rec ,buf_len , fp, 0x01)) < 0) break;
			XDEBUGOUTL5(0,"1st  len=%d",len,0,0,0,0);
			pos = 0;
			lrecl = len;
			while (rec[lrecl-1] != '\n') {
				pos += len;
				buf_len += MAX_LEN;
				if (!(rec=Realloc(rec,buf_len))) {
					XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
					_Exit(3);
				}
				if ((len=akxa_get_line(rec+pos ,MAX_LEN , fp, 0x01)) < 0) break;
				XDEBUGOUTL5(0,"next len=%d",len,0,0,0,0);
				lrecl += len;
			}
			dat_len = lrecl - 1;
		}
		if (++trec >= sta_rec) {
			for (i=0;i<nrep;i++) {
				pos = tpRep[i].col;
				p = rec+pos;
				pr = tpRep[i].rep;
				nm = tpRep[i].nmj;
				for (j=0;j<tpRep[i].nkr;j++,p+=nm,pos+=nm) {
					if (pos > dat_len) break;
					if ((len=dat_len-pos) > nm) len = nm;
					memcpy(p,pr,len);
				}
			}
			fwrite(rec,1,lrecl,stdout);
			nrec++;
			if (num_rec>0 && nrec>=num_rec) break;
		}
	}
	return 0;
}
