/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.command.extention;

import java.util.HashMap;
import java.util.Map;
import org.ccc.atools.command.extention.CommandInfo;
import org.ccc.atools.command.extention.ICommandDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class CommandRegistry {
    private static final String COMMAND_EXTENSION_POINT = "org.ccc.atools.commands";
    public static final String EXTENSION_NAME = "command";
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_ENCODE = "encode";
    public static final String ATT_CLASS = "class";
    public static final String ATT_PRIORITY = "priority";
    private static CommandRegistry singleton;
    private Map<String, CommandInfo> encodeToCommandInfos;

    private CommandRegistry() {
    }

    public static CommandRegistry getInstance() {
        if (singleton == null) {
            singleton = new CommandRegistry();
        }
        return singleton;
    }

    public Map<String, CommandInfo> getEncodeToCommandInfos() {
        if (this.encodeToCommandInfos == null) {
            this.encodeToCommandInfos = this.createEncodeToCommandInfos();
        }
        return this.encodeToCommandInfos;
    }

    private Map<String, CommandInfo> createEncodeToCommandInfos() {
        HashMap<String, CommandInfo> result = new HashMap<String, CommandInfo>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(COMMAND_EXTENSION_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block6: {
                    ICommandDelegate command;
                    CommandInfo commandInfo;
                    String priority;
                    String encode;
                    String category;
                    block5: {
                        IConfigurationElement ce;
                        block7: {
                            int lowerPriorityInt;
                            ce = iConfigurationElementArray[n4];
                            if (!ce.getName().equals(EXTENSION_NAME)) break block6;
                            category = ce.getAttribute(ATT_CATEGORY);
                            encode = ce.getAttribute(ATT_ENCODE);
                            priority = ce.getAttribute(ATT_PRIORITY);
                            if (priority == null) break block7;
                            int priorityInt = Integer.parseInt(priority);
                            commandInfo = (CommandInfo)result.get(encode);
                            if (commandInfo != null && (lowerPriorityInt = commandInfo.getPriority()) != -1 && priorityInt >= lowerPriorityInt) break block6;
                        }
                        command = null;
                        try {
                            Object aClass = ce.createExecutableExtension(ATT_CLASS);
                            if (!(aClass instanceof ICommandDelegate)) break block5;
                            command = (ICommandDelegate)aClass;
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            break block6;
                        }
                    }
                    commandInfo = new CommandInfo();
                    commandInfo.setCategory(category != null ? category : "");
                    commandInfo.setEncode(encode);
                    commandInfo.setCommand(command);
                    commandInfo.setPriority(priority != null ? Integer.parseInt(priority) : -1);
                    result.put(encode, commandInfo);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

