/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.command;

import java.util.ArrayList;
import java.util.List;
import org.ccc.atools.command.AbstractCommand;
import org.ccc.atools.command.ICommand;

public class CommandManager {
    private ICommand command;
    private List<ICommand> commandHistory = new ArrayList<ICommand>();

    protected void finalize() throws Throwable {
        this.commandHistory.clear();
        super.finalize();
    }

    public List<ICommand> getCommandHistory() {
        return this.commandHistory;
    }

    public void setCommand(ICommand command) {
        this.command = command;
    }

    public void execute() {
        ICommand command = this.preExecute();
        try {
            command.execute();
        }
        finally {
            this.postExecute();
        }
    }

    protected ICommand preExecute() {
        return this.command;
    }

    protected ICommand postExecute() {
        this.commandHistory.add(this.command);
        return this.command;
    }

    public int getResult(String input, String output) {
        if (this.command != null && this.command.getResult(input, output) == 1) {
            return 1;
        }
        for (ICommand command : this.commandHistory) {
            if (command.getResult(input, output) != 1) continue;
            return 1;
        }
        return 0;
    }

    public List<ICommand> findTerminatedCommands() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (ICommand command : this.commandHistory) {
            int result;
            if (!(command instanceof AbstractCommand)) continue;
            AbstractCommand abstractCommand = (AbstractCommand)command;
            String sourcePath = abstractCommand.getInput();
            String targetPath = abstractCommand.getOutput();
            if (sourcePath == null || targetPath == null || (result = command.getResult(sourcePath, targetPath)) != 1) continue;
            commands.add(command);
        }
        return commands;
    }

    public ICommand findTerminatedCommand(String input, String output) {
        for (ICommand command : this.commandHistory) {
            int result;
            if (!(command instanceof AbstractCommand)) continue;
            AbstractCommand abstractCommand = (AbstractCommand)command;
            String sourcePath = abstractCommand.getInput();
            String targetPath = abstractCommand.getOutput();
            if (sourcePath == null || targetPath == null || !sourcePath.equals(input) || !targetPath.equals(output) || (result = command.getResult(sourcePath, targetPath)) != 1) continue;
            return command;
        }
        return null;
    }
}

