static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*																		*
*	ړI	F Oo												*
*																		*
*	Tv	F 														*
*																		*
*************************************************************************/
#include <colmn.h>

extern CLCOMMON  CLcommon;
extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int _add_err_msg(err_hist,add_msg,add_len)
ParList *err_hist;
char *add_msg;
int add_len;
{
	char *err_msg;
	int err_msg_len,iADD;

	err_msg = err_hist->par;
	err_msg_len = err_hist->parlen;
	iADD = 1;
	if (err_msg && err_msg_len>0) {
		if (akxs_sseq_mline(add_msg,add_len,err_msg,err_msg_len) > 0) iADD = 0;
	}
	if (iADD) {
		if (err_msg = MRealloc(err_msg,err_msg_len+add_len+3)) {
			if (err_msg_len > 0) err_msg_len += akxa_log_new_line_str(err_msg+err_msg_len,pGlobTable->options[2]);
			memzcpy(err_msg+err_msg_len,add_msg,add_len);
			err_msg_len += add_len;
		}
		else err_msg_len = 0;
		err_hist->par = err_msg;
		err_hist->parlen = err_msg_len;
	}
	return err_msg_len;
}

/****************************************/
/*										*/
/* XV 2020.04.29 TRYłG[̓t@Cɏo͂ */
/****************************************/
int cl_log_out_opt_l5(log_no,level,opt,file,line,fmt,a1,a2,a3,a4,a5)
int log_no,level,opt,line;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	int max_len,iOUT,i,log_flg,len;
	char buf[600],*argv[5],*p,*pp;
	int  (*logout)();
	ProcCT *proc;
/*
cl_str_conv_put(&p,fmt,strlen(fmt));
printf("cl_log_out_opt_l5:Enter log_no=%d level=%d opt=%08x file=[%s]\nline=%d fmt=[%s]\n",
log_no,level,opt,file,line,p);
if (p != fmt) Free(p);
printf("cl_log_out_opt_l5: err_msg_len =%d err_msg =%08x\n",pGlobTable->err_hist[0].parlen,pGlobTable->err_hist[0].par);
printf("cl_log_out_opt_l5: err_hpld_len=%d hold_msg=%08x\n",pGlobTable->err_hist[1].parlen,pGlobTable->err_hist[1].par);
*/
	iOUT = 1;
	if (log_no==0 && fmt) {
/*
printf("cl_log_out_l5: pGlobTable->try_level=%d opt=%d at %s(%d)\n",pGlobTable->try_level,opt,file,line);
*/
		if (pGlobTable->try_level > 0) {
			iOUT = -1;
			pGlobTable->Quot[2] = 0;
		}
		if (LOGLEVEL(log_no,-1) < level) iOUT = 0;
	}
/*
printf("cl_log_out_l5: iOUT=%d\n",iOUT);
*/
	if (iOUT && !(opt & 0x01)) {
		if (iOUT<0 && log_no==0) {
			log_flg = LOGFLG(log_no,-1);
			LOGFLG(log_no,(log_flg & ~(D_LOG_FLG_STDOUT | D_LOG_FLG_STDERR)) | D_LOG_FLG_FILE);
/*
printf("cl_log_out_l5: logflg=%08x\n",LOGFLG(log_no,-1));
*/
			akb_error_out_level(level,file,line,fmt,a1,a2,a3,a4,a5);
			LOGFLG(log_no,log_flg);
		}
		else if (log_no>=0 && log_no<=2) {
			if      (log_no == 0) logout = akb_error_out_level;
			else if (log_no == 1) logout = akb_print_out_level;
			else if (log_no == 2) logout = akb_debug_out_level;
			logout(level,file,line,fmt,a1,a2,a3,a4,a5);
		}
		else akb_log_out_level_main(log_no,level,file,line,fmt,a1,a2,a3,a4,a5);

		if (pGlobTable->Quot[2]) {
			pGlobTable->err_hist[0].parlen = 0;
			pGlobTable->Quot[2] = 0;
		}
	}
	if (iOUT) {
		max_len = sizeof(pGlobTable->errmsg) - 1;
		argv[0] = a1;
		argv[1] = a2;
		argv[2] = a3;
		argv[3] = a4;
		argv[4] = a5;
		akxa_log_printf_len(buf,max_len,fmt,5,argv);
/*
printf("cl_log_out_l5: buf=[%s] max_len=%d\n",buf,max_len);
*/
		sprintf(pGlobTable->errmsg,buf,
		        argv[0],argv[1],argv[2],argv[3],argv[4]);
		p = pGlobTable->errmsg;
		len = strlen(p);
/*
cl_str_conv_put(&pp,p,len);
printf("cl_log_out_l5: len=%d errmsg=[%s]\n",len,pp);
if (pp != p) Free(pp);
*/
		if (opt & 0x01) i = 1;
		else i = 0;
		_add_err_msg(&pGlobTable->err_hist[i],p,len);
		if (opt & 0x01) *p = '\0';
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_log_out_l5(log_no,level,file,line,fmt,a1,a2,a3,a4,a5)
int log_no,level,line;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	return cl_log_out_opt_l5(log_no,level,0,file,line,fmt,a1,a2,a3,a4,a5);
}

/****************************************/
/*										*/
/****************************************/
static int _skip(buf,ptn,opt)
char *buf,*ptn;
int  opt;
{
	int i;
	char *p,c;

	p = buf;
	i = 0;
	while (c = *p++) {
		if (!strchr(ptn,c)) break;
		i++;
	}
	return i;
}

/****************************************/
/*										*/
/****************************************/
static int _per_check(fmt,buf)
char *buf,*fmt;
{
	int len,i;
	char *pf,*pb,c,cc;
/*
printf("_per_chack: fmt=[%s]\n",fmt);
*/
	len = 0;
	pf = fmt;
	pb = buf;
	while (c = *pf++) {
		*pb++ = c;
		len++;
		if (c == '%') {
			*pb++ = c;
			len++;
		}
	}
	*pb++ = c;
/*
printf("_per_chack: buf=[%s]\n",buf);
*/
	return len;
}

/****************************************/
/*										*/
/****************************************/
static int _per_check_snprintf(buf,buf_size,fmt,argc,argv)
char *buf,*fmt,*argv[];
int buf_size,argc;
{
	int len,i,j,k,slen,bmax;
	char *pf,*pb,c,cc,wrk[256],*p;

printf("_per_chack_snprintf: buf_size=%d fmt=[%s]\n",buf_size,fmt);

	bmax = buf_size - 1;
	k=len = 0;
	pf = fmt;
	pb = buf;
	while ((c=*pf) && len<bmax) {
		if (c == '%') {
			if (k >= argc) break;
			if (*(pf+1) == c) {
				*pb++ = c;
				len++;
				if (len < bmax) {
					*pb++ = c;
					len++;
				}
				pf++;
			}
			else {
				i = _skip(pf+1,".+-0123456789",0);
				cc = *(pf+1+i);
				if (cc == 's') {
					p = argv[k++];
					slen = strlen(p);
					for (j=0;j<slen && len<bmax;j++) {
						cc = *p++;
						*pb++ = cc;
						len++;
						if (cc=='%' && len<bmax) {
							*pb++ = cc;
							len++;
						}
					}
				}
				else if (len+10<bmax) {
					memzcpy(wrk,pf,i+2);
					sprintf(pb,wrk,argv[k++]);
					pb += strlen(pb);
					len += strlen(pb);
				}
				pf += i+1;
			}
		}
		else {
			*pb++ = c;
			len++;
		}
		pf++;
	}
	strnzcpy(pb,pf,bmax-len);

printf("_per_chack_snprintf: len=%d buf=[%s]\n",len,buf);

	return len;
}

/****************************************/
/*										*/
/****************************************/
int  cl_debug_array_info(fmt,len,pInfo)
char *fmt;
int  len;
tdtInfoParm *pInfo;
{
	tdtArrayIndex *pIndex;
	ScrPrCT *pScCT;
	XHASHB *xhp;
	int i,ndim,*index;
	char *p;

	pIndex = (tdtArrayIndex *)pInfo->pi_data;
	pScCT = (ScrPrCT *)pInfo->pi_len;
	sprintf(&fmt[len]," pInfo=%08x id=%c attr=%d scale=0x%02x dlen=%d len(pScCT)=%08x hlen(gid)=%d aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x",
	        pInfo,pInfo->pi_id,pInfo->pi_attr,pInfo->pi_scale,
	        pInfo->pi_dlen,pScCT,pInfo->pi_hlen,pInfo->pi_aux[0],pInfo->pi_aux[1],
	        pInfo->pi_alen,pInfo->pi_paux,pInfo->pi_data);
	len = strlen(fmt);
	if (pIndex) {
		sprintf(&fmt[len],
			"(VarIndex=%08x Attr=%d %d %d %d size=%d xhp=%08x  pInfoType=%08x index=[",
			pIndex->pVarIndex,
			pIndex->uAttr[0],pIndex->uAttr[1],
			pIndex->uAttr[2],pIndex->uAttr[3],
			pIndex->size,
			pIndex->xhp,
			pIndex->pInfoType);
			len = strlen(fmt);
		index = pIndex->index;
		ndim = index[0]*2 + 4;
		if (ndim > MAX_ARRAY_DIM) ndim = MAX_ARRAY_DIM;
		p = &fmt[len];
		for (i=0;i<ndim;i++) {
			if (i > 0 ) *p++ = ',';
			sprintf(p,"%d",index[i]);
			p += strlen(p);
		}
		strcpy(p,"]");
		if (xhp = pIndex->xhp) {
			len = strlen(fmt);
			sprintf(&fmt[len],"(_xhash Id=%c%c keylen=%d max=%d pre=%d ha=%08x next=%08x datlen=%d dreg=%08x)",
			        xhp->xha_id[0],xhp->xha_id[1],xhp->xha_keylen,
			        xhp->xha_maxreg,xhp->xha_prereg,
			        xhp->xha_hashb,xhp->xha_xhnext,
			        xhp->xha_datlen,xhp->xha_datreg);
		}
		len = strlen(fmt);
		strcpy(&fmt[len],")");
	}
	else strcpy(&fmt[len]," Index=NULL");
	len = strlen(fmt);
	return len;
}

/****************************************/
/*										*/
/****************************************/
void cl_debug_out_info_parm5(level,file,line,format,pInfo,a1,a2,a3,a4,a5)
int  level,line;
char *file,*format,*a1,*a2,*a3,*a4,*a5;
tdtInfoParm *pInfo;
{
	static char *dfmt="[YYYY-MM-DD HH:MI:SS.U P DY DDD]";
	char   c,*p,buf[256*2+256/4+1],fmt[300],*argv[5],*varnam,*pdat,*fm,*pb,wrk[3];
	int    len,ix,attr,iRANGE,dlen,i,pb_len,iINTVAL;
	long   lVal,lVal2,lVal3;
	double dVal,dVal2,dVal3;
	tdtArrayIndex *pIndex;
	ScrPrCT *pScCT;
	tdtInfoParm *pInfoParm;
	XHASHB *xhp;
	parmList  **parmName;
	tdtDefType *pDeftype;
	int ntype,ihx,nlen;
	tdtRbCtl *pRb;
	MPA *ma;

	if (akb_log_out_check(D_LOG_NO_DEBUG,level,file,line) > 0) {
		if (!akxm_addrchk(pInfo)) {
			akb_debug_out_level(0,file,line,"cl_debug_out_info_parm5: invalid addr pInfo=%08x",pInfo,0,0,0,0);
			return;
		}
		argv[0] = a1;
		argv[1] = a2;
		argv[2] = a3;
		argv[3] = a4;
		argv[4] = a5;
		akxa_log_printf_len(buf,sizeof(buf)-100,format,5,argv);
		sprintf(fmt,buf,argv[0],argv[1],argv[2],argv[3],argv[4]);
		len = strlen(fmt);
		if (!pInfo) {
			akb_debug_out_level(0,file,line,"%s pInfoParm is NULL",fmt,0,0,0,0);
			return;
		}
		if ((c=pInfo->pi_id) == 'A' || c == 'R') {
			len = cl_debug_array_info(fmt,len,pInfo);
			varnam = (char *)pInfo->pi_pos;
			akb_debug_out_level(0,file,line,"%s varnam=[%s]",fmt,varnam,0,0,0);
		}
		else if (c=='S' || (c==D_DATA_ID_PNAME && pInfo->pi_attr==2)) {
			memcpy(&pInfoParm,pInfo->pi_data,pInfo->pi_dlen);
			sprintf(&fmt[len]," pInfo=%08x id=0x%02x[%c] attr=%d scale=0x%02x dlen=%d len(gid)=%d hlen=%08x aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x",
			        pInfo,pInfo->pi_id,c,pInfo->pi_attr,pInfo->pi_scale,
			        pInfo->pi_dlen,pInfo->pi_len,pInfo->pi_hlen,pInfo->pi_aux[0],pInfo->pi_aux[1],
			        pInfo->pi_alen,pInfo->pi_paux,pInfoParm);
			akb_debug_out_level(0,file,line,"%s",fmt,0,0,0,0);
			if (pInfo == pInfoParm) akb_debug_out_level(0,file,line,"pInfoParm==pInfoParm->pi_data",0,0,0,0,0);
			else {
				if (c==D_DATA_ID_PNAME && (p=pInfo->pi_paux)) {
					fm = "pi_paux=[%s]";
				}
				else fm = "";
				cl_debug_out_info_parm(level,file,line,fm,pInfoParm,p,0);
			}
		}
		else {
			if (!(c=pInfo->pi_id)) c = ' ';
			attr = pInfo->pi_attr;
			dlen = pInfo->pi_dlen;
			pdat = pInfo->pi_data;
			iRANGE = pInfo->pi_alen & D_AULN_RANGE_DATA;
			iINTVAL = pInfo->pi_alen & D_AULN_RANGE_INTVAL;
			sprintf(&fmt[len]," pInfo=%08x id=0x%02x[%c] attr=%d scale=0x%02x code=%d dlen=%d len(gid)=%d hlen=%d pos=%d(%08x) aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x ",
			        pInfo,pInfo->pi_id,c,attr,pInfo->pi_scale,
			        pInfo->pi_code,dlen,pInfo->pi_len,pInfo->pi_hlen,pInfo->pi_pos,pInfo->pi_pos,
			        pInfo->pi_aux[0],pInfo->pi_aux[1],pInfo->pi_alen,pInfo->pi_paux,pdat);
			len = strlen(fmt);
/*
printf("cl_debug_out_info_parm: len=%d fmt=[%s]\n",len,fmt);
*/
			if (c == 'P' || c == 'T') {
				varnam = (char *)pInfo->pi_pos;
				pDeftype = (tdtDefType *)pdat;
				sprintf(&fmt[len]," size=%d data=0x%08x ntype=%d vname=0x%08x pType=0x%08x",
				        pDeftype->size,pDeftype->data,pDeftype->ntype,pDeftype->vname,pDeftype->pType);
				akb_debug_out_level(0,file,line,"%s varnam=[%s]",fmt,varnam,0,0,0);
				if (c == 'T') {
					ihx = akxs_xhasl(pGLprocTable->pha_gid,'R',pInfo->pi_len,0);
/*
printf("cl_debug_out_info_parm: R gid=%ld ihx=%d\n",pInfo->pi_len,ihx);
*/
				}
				else ihx = 1;
				if (ihx) {
					parmName = pDeftype->vname;
				}
				else {
					nlen = 0;
					p = "***";
				}
				for (ix=0;ix<pDeftype->ntype;ix++) {
					if (ihx) {
						nlen = parmName[ix]->prmlen;
						p = parmName[ix]->prp;
					}
					cl_debug_out_info_parm(level,file,line," vnlen=%d %s:",pDeftype->pType[ix],nlen,p);
				}
			}
			else if (c=='L' || c=='N') {
				pRb = (tdtRbCtl *)pdat;
				sprintf(&fmt[len],"\n rb_bfsize=%d rb_max=%d rb_num=%d rb_used=%d rb_pos=%d rb_raddr=0x%08x rb_waddr=0x%08x rb_wpriv=0x%08x rb_cur=0x%08x",
				        pRb->rb_bfsz,pRb->rb_max,pRb->rb_num,pRb->rb_used,pRb->rb_pos,
						pRb->rb_raddr,pRb->rb_waddr,pRb->rb_wpriv,pRb->rb_cur);
				akb_debug_out_level(0,file,line,"%s",fmt,0,0,0,0);
			}
			else {
				if (!pdat) {
					akb_debug_out_level(0,file,line,"%sNULL",fmt,0,0,0,0);
				}
				else if (attr == DEF_ZOK_CHAR) {
/*
printf("cl_debug_out_info_parm: fmt=[%s]\n",fmt);
*/
					if (iRANGE) {
						if (iINTVAL) {
							fm = "%s[%s]..[%s]..%d";
							lVal3 = pInfo->pi_hlen;
						}
						else fm = "%s[%s]..[%s]";
					}
					else fm = "%s[%s]";
					akb_debug_out_level(0,file,line,fm,fmt,pdat,pdat+dlen,lVal3,0);
				}
				else if (attr == DEF_ZOK_BINA) {
					lVal = cl_get_data_long(pInfo);
					if (iRANGE) {
						if (iINTVAL) {
							fm = "%s%d..%d..%d";
							memcpy(&lVal2,pInfo->pi_data+dlen,dlen);
							lVal3 = pInfo->pi_hlen;
						}
						else {
							fm = "%s%d..%d";
							lVal2 = pInfo->pi_hlen;
						}
					}
					else fm = "%s%d";
					akb_debug_out_level(0,file,line,fm,fmt,lVal,lVal2,lVal3,0);
				}
				else if (attr == DEF_ZOK_FLOA) {
					memcpy(&dVal,pdat,sizeof(double));
					if (iRANGE) {
						memcpy(&dVal2,pdat+dlen,sizeof(double));
						if (iINTVAL) {
							fm = "%s%e..%e..%e";
							memcpy(&dVal3,pdat+dlen+dlen,sizeof(double));
						}
						else {
							fm = "%s%e..%e";
						}
					}
					else fm = "%s%e";
					akb_debug_out_level(0,file,line,fm,fmt,dVal,dVal2,dVal3,0);
				}
				else if (attr == DEF_ZOK_DECI) {
					ma = (MPA *)pdat;
					pb_len = sizeof(buf)-140;
					m_mpa2an(ma,buf,pb_len,pGlobTable->options[10]);
					ix = strlen(buf) + 1;
					p = buf + ix;
					pb_len -= ix;
					if (iRANGE) {
						fm = "%s%s..%s";
						ma = (MPA *)(pdat+dlen);
						m_mpa2an(ma,p,pb_len,pGlobTable->options[10]);
						p += strlen(p);
						if (iINTVAL) {
							strcpy(p,"..");
							p += 2;
							ma = (MPA *)(pdat+dlen+dlen);
							m_mpa2an(ma,p,pb_len,pGlobTable->options[10]);
							p += strlen(p);
						}
					}
					else fm = "%s%s";
					ma = (MPA *)pdat;
					dlen = ma->len;
					sprintf(p," e/z/l=%d/%d/%d num=",ma->exp,ma->zero,ma->len);
					p += strlen(p);
					if(ma->sign) *p = '-';
					else *p = '+';
					p++;
					strcpy(p,"0");
					pdat = ma->num;
					for (i=0;i<dlen;i++) {
						sprintf(p,"%d ",*pdat++);
						p += strlen(p);
					}
					akb_debug_out_level(0,file,line,fm,fmt,buf,buf+ix,0,0);
				}
				else if (attr == DEF_ZOK_DATE) {
					ma = (MPA *)pdat;
					pb_len = sizeof(buf)-140;
					cl_date2str(buf,--pb_len,dfmt,strlen(dfmt),ma);
					ix = strlen(buf)+1;
					p = buf + ix;
					pb_len -= ix;
					if (iRANGE) {
						fm = "%s%s..%s";
						ma = (MPA *)(pdat+dlen);
						cl_date2str(p,--pb_len,dfmt,strlen(dfmt),ma);
						p += strlen(p);
						if (iINTVAL) {
							strcpy(p,"..");
							p += 2;
							wrk[0] = cl_get_term_char(pInfo->pi_hlen);
							wrk[1] = '\0';
							sprintf(p,"'%s %d'",wrk,pInfo->pi_pos);
							p += strlen(p);
						}
					}
					else fm = "%s%s";
					ma = (MPA *)pdat;
					*p++ = ' ';
					dlen = 7;
					pdat = ma->num;
					for (i=0;i<dlen;i++) {
						sprintf(p,"%d ",*pdat++);
						p += strlen(p);
					}
					sprintf(p,"%d ",akxcmb2ul(pdat,3));
					p += strlen(p);
					pdat += 3;
					sprintf(p,"%d %d ",*pdat,*(pdat+1));
					p += strlen(p);
					pdat += 2;
					sprintf(p,"%d ",akxcmb2ul(pdat,2));
					akb_debug_out_level(0,file,line,fm,fmt,buf,buf+ix,0,0);
				}
				else if (attr==DEF_ZOK_BULK || c=='2') {
					if ((len=dlen) > 256) len = 256;
					len = akxcxtocn(pdat,len,buf,sizeof(buf),-4);
					akb_debug_out_level(0,file,line,"%s%s",fmt,buf,0,0,0);
				}
				else {
					akb_debug_out_level(0,file,line,"%s%s",fmt,"**INVALID**",0,0,0);
				}
			}
		}
		if (pInfo->pi_alen & D_AULN_PARMINFO2)
			cl_debug_out_info_parm(level,file,line,"PARMINFO2:",pInfo+1,0,0);
	}
}

/****************************************/
/*										*/
/****************************************/
void cl_debug_out_info_parm(level,file,line,format,pInfo,a1,a2)
int  level,line;
char *file,*format,*a1,*a2;
tdtInfoParm *pInfo;
{
	cl_debug_out_info_parm5(level,file,line,format,pInfo,a1,a2,0,0,0);
/*
	if (akxm_addrchk(pInfo)) {
		if (pInfo->pi_alen & D_AULN_PARMINFO2) {
			pInfo++;
			if (pInfo->pi_id == '2')
				cl_debug_out_info_parm5(level,file,line,"",pInfo,0,0,0,0,0);
		}
	}
*/
}

/****************************************/
/*										*/
/****************************************/
int cl_debug_out_return(file,line,func,ret)
char *file,*func;
int  line,ret;
{
	if (((CLcommon.dbgopt[2] & 0x10) && ret<0) ||
	    ((CLcommon.dbgopt[2] & 0x20) && ret!=0))
		cl_log_out_l5(D_LOG_NO_DEBUG,0,file,line,"<---%s: return %d",func,ret,0,0,0);
	return ret;
}
#if 0
/****************************************/
/*										*/
/****************************************/
int func_log(pAns,pOperator,nparm,ppParm,ope)
char *pAns;
char *pOperator;
tdtInfoParm **ppParm;
int nparm,ope;
{
	tdtInfoParm *pInfoParm;
	ScrPrCT *scrprct;
	int  line,logno,level,pri,syspri,iRc,len_f;
	char buf[256],*pWork,*format,*file,*p;

	if (iRc=cl_get_parm_bin(ppParm[0],&logno,"func_log:log_no/syspri:")) return -1;

	if (scrprct = cl_search_src_ct()) file = scrprct->pId;
	else file = AKX_NULL_PRINT;
	line = pGlobTable->script_line;

	pInfoParm = ppParm[1];
	len_f = pInfoParm->pi_dlen;
	if (len_f > 0) {
		if (pInfoParm->pi_attr != DEF_ZOK_CHAR) return -2;
		format = pInfoParm->pi_data;
		if ((iRc=cl_edit_sub(&pWork,format,nparm-2,&ppParm[2])) < 0) return iRc;
	}
	else pWork = "";

	if (ope==D_FUC_LOGOUT) {
		level = 0;
		pri = 0;
		akb_log_out_level_pri_main(logno,level,file,line,pri,pWork,0,0,0,0,0);
	}
	else if (ope==D_FUC_SYSLOG) {
		p = akb_log_get_proc_name();
		if (strlen(p)+strlen(file)+16 <= sizeof(buf)) {
			sprintf(buf,"%s/%s(%d): ",p,file,line);
		}
		else buf[0] = '\0';
		syspri = logno;
		syslog(syspri,"%s%s",buf,pWork);
	}
	iRc = 0;
	memcpy(pAns,&iRc,sizeof(int));
	return 0;
}

#define MAXLOGPARM	7

/****************************************/
/*										*/
/****************************************/
int func_get_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int rc,iRc,i,maxargs,ix,*index;
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	char *fn;
	tdtArrayIndex tIndex,*pIndex;
	long iParm[MAXLOGPARM];

	if (rc=cl_set_log_parmi(ppParm[0],NULL,iParm,0)) return rc;
	else if (iParm[0] < 0) iParm[0] = 0;

	pIndex = &tIndex;
	if (iRc=cl_get_ITBL_maxargs_ref(nparm-1,&ppParm[1],&pIndex,&pTBL,1,MAXLOGPARM,&maxargs,NULL)) return iRc;

	akb_log_set_parm2(1,NULL,maxargs,iParm);

	index = pIndex->index;
	ix = index[3];
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
		if (pInfoParm) {
			if (i == 6) {
				if (!(fn=(char *)iParm[i])) fn = AKX_NULL_PRINT;
				cl_set_parm_char(&rInfoParm,fn,strlen(fn));
			}
			else {
				cl_set_parm_long(&rInfoParm,iParm[i]);
			}
			if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
	}
	memcpy(pAns,&maxargs,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_log_parmi(pInfoParm,argv,iParm,ix)
tdtInfoParm *pInfoParm;
char *argv[];
long iParm[];
int ix;
{
	int i,rc;
	long logno;
	char c;

	i = ix;
	iParm[i] = -1;
	if (!pInfoParm) return -1;
	if (pInfoParm->pi_dlen > 0) {
		if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
		c = pInfoParm->pi_attr;
		if (i==0 || i==6) {
			if (i == 0) {
				if (c == DEF_ZOK_CHAR) {
					if ((logno=akb_get_log_no(strname(pInfoParm->pi_data,pInfoParm->pi_dlen))) >= 0) {
						iParm[i] = logno;
						goto L_ix0;
					}
				}
			}
			else if (c == DEF_ZOK_CHAR) {
				if (argv) argv[i] = pInfoParm->pi_data;
				else iParm[i] = (long)pInfoParm->pi_data;
				return 0;
			}
			else {
				/* cl_set_logparmi: Ot@Č^(%d)Ă܂B */
				ERROROUT1(FORMAT(414),c);
 				return ECL_SCRIPT_ERROR;
			}
		}
		if (i>0 && c==DEF_ZOK_CHAR && argv) argv[ix] = pInfoParm->pi_data;
		else {
			if (rc=cl_get_parm_long(pInfoParm,&iParm[i],"cl_set_logparmi: ")) return rc;
			if (i == 0) goto L_ix0;
			if (argv) argv[i] = ".";
		}
	}
	else if (argv) argv[i] = ".";
	return 0;
L_ix0:
	if (!akb_get_log_name(iParm[i])) {
		/* cl_set_logparmi: Oԍ(%d)słB */
		ERROROUT1(FORMAT(415),logno);
		return -1;
	}
	if (argv) argv[i] = ".";
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int func_set_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int i,rc,nm;
	long iParm[MAXLOGPARM];
	char *argv[MAXLOGPARM];

	nm = X_MIN(nparm,MAXLOGPARM);
	for (i=0;i<nm;i++) {
		if (rc=cl_set_log_parmi(ppParm[i],argv,iParm,i)) return rc;
/*
printf("func_set_log_parm: i=%d argv=[%s] iParm=%08x\n",i,argv[i],iParm[i]);
*/
	}
	akb_log_set_parm2(-nm,argv,nm,iParm);
	memcpy(pAns,&nm,sizeof(int));
	_set_log_flg_cd_opt(-1,0x02);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int func_res_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int rc,i,maxargs,ix,*index;
	tdtInfoParm *pInfoParm;
	tdtInfoParm ***pTBL;
	char c;
	tdtArrayIndex tIndex,*pIndex;
	long iParm[MAXLOGPARM];

	pIndex = &tIndex;
	if (rc=cl_get_ITBL_maxargs_ref(nparm,ppParm,&pIndex,&pTBL,1,MAXLOGPARM,&maxargs,NULL)) return rc;
	index = pIndex->index;
	ix = index[3];
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
		if (pInfoParm) {
			c = pInfoParm->pi_attr;
			if ((i==6 && c!=DEF_ZOK_CHAR) || (i!=6 && c!=DEF_ZOK_BINA)) {
				/* let_log_parm: p[^̌^(%d)Ă܂B */
				ERROROUT2(FORMAT(285),"cl_res_logparm:",c);
				return -1;
			}
			if (i == 6) iParm[i] = (long)pInfoParm->pi_data;
			else iParm[i] = cl_get_data_long(pInfoParm);
		}
		else return -1;
	}
	akb_log_set_parm2(maxargs,NULL,maxargs,iParm);
	memcpy(pAns,&maxargs,sizeof(int));
	_set_log_flg_cd_opt(-1,0x02);
	return 0;
}
#endif
