static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*     akxccvn ( rad, s, n, pnum )                    */
/*                                                   */
/*****************************************************/
#include "akxcommon.h"

static char *sep=" \t\n\r";

/********************************/
/*	akxqsign					*/
/********************************/
int akxqsign(char *s, int len_s, int parm[], char *sep, int opt)
{
	char *p,cc;
	int  sign,nzflag,lens,zero,at,i_sig,nsign,opt2;

	if (!s || !parm) return -1;
	if (!sep) sep = " \t";
	lens = len_s;
	p = s;
	at = zero = nsign = i_sig = 0;
	sign = nzflag = 1;
	opt2 = opt & AKX_CNVN_OPT_COMMA;
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (nzflag == 1) {
			if (cc == '-' || cc == '+') {
				if (cc == '-') sign = -sign;
				nsign++;
				if (nsign >= 2) i_sig = at;
			}
			else if (cc == '0') {
				zero++;
				nzflag = 0;
			}
		/*
			else if (opt2) {
				if (cc==',' && lens>=1 && (cc=*p)>='0' && cc<='9') ;
				else break;
			}
		*/
			else if (!strchr(sep,cc)) break;
		}
		else {
			if (cc != '0') break;
			zero++;
		}
	}
	parm[0] = sign;
	parm[1] = nsign;
	parm[2] = i_sig;
	parm[3] = zero;
	parm[4] = nzflag;
/*
printf("akxqsign: at=%d sign=%d nsign=%d i_sig=%d zero=%d nzflag=%d\n",
at,sign,nsign,i_sig,zero,nzflag);
*/
	return at;
}

/****************************************************/
/*	ss : ϊ									*/
/*	     ́AG[							*/
/*	ppos	: _ȊO\ꂽʒu		*/
/*	ret = 0 : 									*/
/*	     -1 : Ȃ							*/
/*	     -2 : rads								*/
/*	    > 0 : _܂ߐȊO\ꂽʒu		*/
/****************************************************/
/* len = akxtstrim(5,ss,len,sep);𐶂			*/
/*	     ̌' ','\t','\0','\n','\r'ȊO	*/
/*	     ΃G[ 								*/
/****************************************************/
static int _cvl(rad,ss,len,pnum,ppos)
int rad,len,*ppos;
char *ss;
long *pnum;
{
	char c,*s;
	long num,num0,radm1,d;
	int i,sig,ret,parm[5],skip;

	if (ppos) *ppos = 0;
	if (pnum) *pnum = 0;
	if (!(s=ss)) return -1;
	if (rad<2 || rad>16) return -2;
/*	len = akxtstrim(5,ss,len,sep);	*/
#if 0	/* 2018.5.26 */
	i = akxqsign(ss,len,parm,sep,0);
	rc = parm[2];
	if (i>=len && !parm[3]) rc = -1;
	if (rc) return rc;
	s += i;
	sig = parm[0];
#else
	sig = 0;
	for (i=0;i<len;i++) {
		if ((c=*s) == '-') {
			if (sig) break;
			sig = -1;
		}
		else if (c == '+') {
			if (sig) break;
			sig = 1;
		}
		else if (!strchr(sep,c)) break;
		s++;
	}
	if (ppos) *ppos = i;
	if (i>=len) return -1;
#endif
	ret = 0;
	radm1 = rad - 1;
	num0 = num = 0;
	d = -1;
	skip = 0;
	for (;i<len;i++) {
		c = *s++;
	/*	if (c=='\0' || strchr(sep,c)) break;	*/
		if (c>='0' && c<='9') d = c - '0';
		else if (c=='.') {
			skip++;
			d = 0;
			if (!ret) ret = i + 1;
		}
		else if (rad>10) {
			if (c>='a' && c<='f') d = c - 'a' + 10;
			else if (c>='A' && c<='F') d = c - 'A' + 10;
			else d = -1;
		}
		else d = -1;
		if (d<0 || d>radm1) {
			if (!ret) ret = i + 1;
			break;
		}
		else if (skip > 1) break;
		if (!skip) {
			if (sig>=0) {
				num = num*rad + d;
				if (num<num0) {
					ret = -3;
					num = LONG_MAX;
					break;
				}
			}
			else {
				num = num*rad - d;
				if (num>num0) {
					ret = -3;
					num = LONG_MIN;
					break;
				}
			}
			num0 = num;
		}
	}
	if (pnum) *pnum = num;
	if (!ret && d<0) ret = -1;
	if (ppos) *ppos = i;
	return ret;
}

int akxccvl(rad,ss,len,pnum)
int rad,len;
char *ss;
long *pnum;
{
	return _cvl(rad,ss,len,pnum,NULL);
}

int akxccvn(rad,ss,len,pnum)
int rad,len;
char *ss;
int *pnum;
{
	return akxccvn2(rad,ss,len,pnum,NULL);
}

#if 1	/* 2020.5.24 */
static int _chk_int_over(lnum,pnum)
long lnum;
int  *pnum;
{
	int ret,num;

	ret = 0;
	if (lnum > INT_MAX) {
		num = INT_MAX;
		ret = -3;
	}
	else if (lnum <INT_MIN) {
		num = INT_MIN;
		ret = -3;
	}
	else num = lnum;
	if (pnum) *pnum = num;
	return ret;
}
#endif
int akxccvn2(rad,ss,len,pnum,ppos)
int rad,len;
char *ss;
int *pnum,*ppos;
{
#if defined(_LP64)
	int ret,num;
	long lnum;

	ret=_cvl(rad,ss,len,&lnum,ppos);
#if 1	/* 2020.5.24 */
	if (rc = _chk_int_over(lnum,pnum)) ret = rc;
#else
	if (lnum > INT_MAX) {
		num = INT_MAX;
		ret = -3;
	}
	else if (lnum <INT_MIN) {
		num = INT_MIN;
		ret = -3;
	}
	else num = lnum;
	if (pnum) *pnum = num;
#endif
	return ret;
#else
	return _cvl(rad,ss,len,pnum,ppos);
#endif
}

/********************************************************************/
/*  @\ : int̒l𕶎ɕϊ								*/
/*   : IN : value   : T[`Ώە|C^z				*/
/*				str     : o͂GAւ̃|C^		*/
/*				radix   : i (2,8,10,16)							*/
/*				str_len : str̒(oCg)							*/
/*						  ENULLI[܂߂		*/
/*						  EȂƂ́AtāA	*/
/*						  @ʂ							*/
/*						  <0 ̂Ƃ́A`FbNȂ				*/
/*  ԋp : = -1 : str == NULL										*/
/*		   = -2 : radix s										*/
/*		   >= 0 :  (oCg)									*/
/********************************************************************/
int akxcitoa(value,str,radix,str_len)
int value;
char *str;
int radix,str_len;
{
	long lval=value;

	return akxcltoa(lval,str,radix,str_len);
}

int akxcltoa(value,str,radix,str_len)
long value;
char *str;
int radix,str_len;
{
	int i,sign,m,adjust;
	char *p,c;

	if (!(p=str)) return -1;
	if (!(radix==2 || radix==8 || radix==10 || radix==16)) return -2;

	if (str_len > 0) str_len--;

	adjust = 0;
	if ((sign = value) < 0) {
		if (value == LONG_MIN) {
			value += 1;
			adjust = 1;
		}
		value = -value;
		if (str_len > 0) str_len--;
	}
	i = 0;
#if 1
	if (str_len<0 || i<str_len) {
		i++;
		m = value % radix + adjust;
		if (radix==16 && m>=10) c = m - 10 + 'a';
		else c = m + '0';
		*p++ = c;
	}
	while ((value /= radix) > 0) {
		if (str_len>=0 && i>=str_len) break;
		i++;
		m = value % radix;
		if (radix==16 && m>=10) c = m - 10 + 'a';
		else c = m + '0';
		*p++ = c;
	}
#else
	do {
		if (str_len >= 0) {
			if (i >= str_len) break;
		}
		i++;
		m = value % radix;
		if (adjust) {
			m++;
			adjust = 0;
		}
		c = m + '0';
		if (radix==16 && m>=10) c = m - 10 + 'a';
		*p++ = c;
	} while ((value /= radix) > 0);
#endif
	if (sign < 0) {
		*p++ = '-';
		i++;
	}
	*p = '\0';

	return akxtreverse(str,i);
}

int akxtreverse(str,len)
char *str;
int len;
{
	int c,i,j;

	for (i=0,j=len-1;i<j;i++,j--) {
		c = str[i];
		str[i] = str[j];
		str[j] = c;
	}
	return len;
}

/*
	xxx.xxx.xxx.xxx
*/
int akxccvdotn(ss,len,pnum)
char *ss;
int len;
int *pnum;
{
	int nn,v,v1,m,pos;
	char *pp;

	if (pnum) *pnum = 0;
	if (!(pp=ss)) return -1;

	nn = len;
	v = 0;
	while (nn > 0) {
		pos = instrchar(pp,'.');
/*
printf("akxccvdotn: pos=%d nn=%d v=%08x pp=[%s]\n",pos,nn,v,pp);
*/
		if (pos > 0) m = pos - 1;
		else m = nn;
		akxcgcvn(pp,m,&v1);
		v <<= 8;
		v |= v1 & 0xff;
		if (pos > 0) {
			pp += pos;
			nn -= pos;
		}
		else break;
	}
	if (pos > 0) v <<= 8;
	if (pnum) *pnum = v;
	return 0;
}
