static char sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */
/*                                                   */
/*           coded by A.Kobayashi  1996.05.28        */
/*         updated by A.Kobayashi  1998.10.01        */
/*         updated by A.Kobayashi  1999.11.11        */
/*         updated by A.Kobayashi  2000.01.28        */
/*                                                   */
/*===================================================*/
/* int        fil_init_cache()                       */
/* void       fil_IndexFree(tpIx)                    */
/* int        fil_indexclr(table)                    */
/* TABLECASH *fil_cache(table,cpCmp)                 */
/* int        fil_addindex(tpIx,iLen)                */
/* int        fil_openindex(cp)                      */
/* int        fil_modindex(tpIx,ix,ihi,cpRec,lRecLen)*/
/* int        fil_addindex2(tpIx,iLen,cpRec,lRecLen) */
/* int        fil_mkixrec(bndp,buf,iLen,ixrec,ixlen,iform) */
/* int        fil_indexlen(bndp)                     */
/*****************************************************/
#include "somn.h"
#define CACHEEXT	1000

extern SQLCA_FIL sqlca_fil;

static tdtCACHE_CTL_HEAD *pCacheHead=NULL;

int fil_init_cache(iExt,iInterval)
int iExt,iInterval;
{
	pCacheHead = akxs_cache_new(iExt);
	if (pCacheHead) {
		pCacheHead->ch_interval = iInterval;
		pCacheHead->ch_opt     = AKX_CACHE_IGNCHKERR;
	}
	else return -1;
	return 0;
}

void fil_IndexFree(tpIx)
INDEX *tpIx;
{
	if (tpIx) {
		if (tpIx->cppData) Free(tpIx->cppData);
		if (tpIx->lpPos)   Free(tpIx->lpPos);
		Free(tpIx);
	}
}

int fil_indexclr(table)
char *table;
{
	int iRc;
	TABLECACHE *tptc;
	tdtCACHE_CTL qCt;
	INDEX *tpIx;

	iRc = akxs_cache_chk(pCacheHead,table,&qCt);
	if (!iRc) {
		tptc = (TABLECACHE *)qCt.ca_data;
		fil_IndexFree(tptc->tpIndex);
		tptc->tpIndex = NULL;
	}
	else if (iRc == -22) iRc = 0;
	return iRc;
}

TABLECACHE *fil_cache(table,cpCmp)
char *table, *cpCmp;
{
	int i;
	TABLECACHE *tptc;
	tdtCACHE_CTL qCt;
	INDEX *tpIx;

	i = akxs_cache_chk(pCacheHead,table,&qCt);
/*
printf("fil_cache: CacheChk table=[%s] rc=%d\n",table,i);
*/
	if (i < 0) {
		if (!(tptc=(TABLECACHE *)Malloc(sizeof(TABLECACHE)))) return NULL;
		qCt.ca_key  = table;
		qCt.ca_cmp1 = cpCmp;
		qCt.ca_data = (char *)tptc;
		i = akxs_cache_set(pCacheHead,&qCt);
/*
printf("fil_cache: CacheSet i=%d table=[%s]\n",i,table);
*/
		if (i > 0) {
			tptc->tpIndex = NULL;
			tptc->tblnam = NULL;
			tptc->bndp = NULL;
		}
		else {
			Free(tptc);
			tptc = NULL;
		}
	}
	else {
		tptc = (TABLECACHE *)qCt.ca_data;
		if (i) {
			if (tpIx=tptc->tpIndex) {
				fil_IndexFree(tpIx);
				tptc->tpIndex = NULL;
			}
			if (tptc->bndp) {
				sqlclu_fil(tptc->bndp);
				tptc->bndp = NULL;
			}
#ifndef OLD_CACHE
			if (tptc->tblnam) {
				Free(tptc->tblnam);
				tptc->tblnam = NULL;
			}
#endif
		}
	}
	return tptc;
}

int fil_addindex(tpIx,iLen)
INDEX *tpIx;
int   iLen;
{
	long *lpPosi;
	int i, l;

	if (!tpIx) return -1;
	i = tpIx->iUsed;
	i++;
	lpPosi = tpIx->lpPos;
	if (i >= tpIx->iAlloc) {
		tpIx->iAlloc += CACHEEXT;
		l = tpIx->iAlloc*sizeof(long);
		if (lpPosi) lpPosi=(long *)Realloc(lpPosi,l);
		else {
			lpPosi=(long *)Malloc(l);
			lpPosi[0] = 0;
		}
		if (!lpPosi) return ERROR_MALLOC;
		tpIx->lpPos = lpPosi;
	}
	lpPosi[i] = lpPosi[i-1] + iLen;
	tpIx->iUsed = i;
/*
printf("fil_addindex: i=%d iLen=%d lPos=%d\n",i,iLen,lpPosi[i]);
*/
	return 0;
}

int fil_openindex(cp)
CURSOR *cp;
{
	TABLECACHE *tptc;
	INDEX *tpIx;
	long  *lpPosi;
	int c,i,ret,iLen;
	int ixpos, ixlen;
	char ixrec[256],buf[4096];

	if (!(tptc = cp->tptc)) return -1;
	if (!(tpIx=tptc->tpIndex)) {
		if (!(tpIx=(INDEX *)Malloc(sizeof(INDEX)))) return ERROR_MALLOC;
		tpIx->iAlloc = 0;
		tpIx->iUsed  = 0;
		tpIx->cppData = NULL;
		tpIx->lpPos = NULL;
		tptc->tpIndex = tpIx;
		if (cp->fp) {
			ixlen = fil_indexlen(cp->bind) + 1;
			if (ixlen > sizeof(ixrec)) return ERROR_TOO_MANY;
			iLen = 0;
			while ((c=getc(cp->fp))!=EOF) {
				buf[iLen] = c;
				iLen++;
				if (c == '\n') {
#ifndef NO_INDEX
					memset(ixrec,0,ixlen);
					ret = fil_mkixrec(cp->bind,buf,iLen,ixrec,ixlen,cp->inflg);
					if (ret=fil_addindex2(tpIx,iLen,ixrec,ixlen)) {
#else
					if (ret=fil_addindex(tpIx,iLen)) {
#endif
						Free(tpIx);
						tptc->tpIndex = NULL;
						return ret;
					}
					iLen = 0;
				}
			}
			fseek(cp->fp,0,SEEK_SET);
		}
/*
printf("fil_openindex: iAlloc=%d iUsed=%d\n",tpIx->iAlloc,tpIx->iUsed);
*/
	}
	return 0;
}

int fil_modindex(tpIx,ix,ihi,cpRec,lRecLen)
INDEX *tpIx;
int   ix,ihi;/* ix=0:add */
char  *cpRec;
long  lRecLen;
{
	long *lpPosi;
	char **cppDat;
	int i, l, is, n;
/*
printf("fil_modindex: ix=%d ihi=%d cpRec=%08x\n",ix,ihi,cpRec);
*/
	if (!tpIx) return -1;
	if (ix == 0) {
		ix = ++(tpIx->iUsed);
	}
	else if (ix > tpIx->iUsed) return -2;
	i = ix - 1;
	lpPosi = tpIx->lpPos;
	cppDat = tpIx->cppData;
	if (i >= tpIx->iAlloc) {
		tpIx->iAlloc += CACHEEXT;
		l = tpIx->iAlloc*sizeof(long);
		n = CACHEEXT*sizeof(long);
		if (lpPosi) {
			is = l - n;
			lpPosi=(long *)Realloc(lpPosi,l);
		}
		else {
			is = 0;
			lpPosi=(long *)Malloc(l);
		}
		if (!lpPosi) {
			tpIx->iUsed = 0;
			return ERROR_MALLOC;
		}
		tpIx->lpPos = lpPosi;
		memset((char *)lpPosi+is,0,n);

		l = tpIx->iAlloc*sizeof(char *);
		n = CACHEEXT*sizeof(char *);
		if (cppDat) {
			is = l - n;
			cppDat=(char **)Realloc(cppDat,l);
		}
		else {
			is = 0;
			cppDat=(char **)Malloc(l);
		}
		if (!cppDat) {
			tpIx->iUsed = 0;
			return ERROR_MALLOC;
		}
		tpIx->cppData = cppDat;
		memset((char *)cppDat+is,0,n);
	}
	lpPosi[i] = ihi;
	if (!cppDat[i]) {
		if (!(cppDat[i] = Malloc(lRecLen))) return -1;
	}
	memcpy(cppDat[i],cpRec,lRecLen);
/*
printf("fil_modindex: i=%d iused=%d iAlloc=%d\n",
i,tpIx->iUsed,tpIx->iAlloc);
*/
	return i+1;
}

int fil_addindex2(tpIx,iLen,cpRec,lRecLen)
INDEX *tpIx;
int   iLen;
char  *cpRec;
long  lRecLen;
{
	long *lpPosi;
	char **cppDat;
	int i, l;

	if (!tpIx) return -1;
	i = tpIx->iUsed;
	i++;
	lpPosi = tpIx->lpPos;
	cppDat = tpIx->cppData;
	if (i >= tpIx->iAlloc) {
		tpIx->iAlloc += CACHEEXT;
		l = tpIx->iAlloc*sizeof(long);
		if (lpPosi) lpPosi=(long *)Realloc(lpPosi,l);
		else {
			lpPosi=(long *)Malloc(l);
			lpPosi[0] = 0;
		}
/*
printf("fil_addindex2: lpPosi=%08x\n",lpPosi);
*/
		if (!lpPosi) return ERROR_MALLOC;
		tpIx->lpPos = lpPosi;

		l = tpIx->iAlloc*sizeof(char *);
		if (cppDat) {
			cppDat=(char **)Realloc(cppDat,l);
		}
		else {
			cppDat=(char **)Malloc(l);
		}
/*
printf("fil_addindex2: cppDat=%08x\n",cppDat);
*/
		if (!cppDat) {
			return ERROR_MALLOC;
		}
		tpIx->cppData = cppDat;
	}
	lpPosi[i] = lpPosi[i-1] + iLen;
	tpIx->iUsed = i;
/*
printf("fil_addindex2: i=%d iused=%d iAlloc=%d\n",
i,tpIx->iUsed,tpIx->iAlloc);
*/
	if (!(cppDat[--i] = Malloc(lRecLen))) return ERROR_MALLOC;
/*
printf("fil_addindex2: cppDat[i]=%08x\n",cppDat[i]);
*/
	memcpy(cppDat[i],cpRec,lRecLen);

	return 0;
}

/* f[^ȂƂ́AixposCfbNXɂȂȂ̂ŁAixlenKv */
int fil_mkixrec(bndp,buf,iLen,ixrec,ixlen,iform)
SQLDA_FIL *bndp;
char  *buf,*ixrec;
int    iLen,ixlen,iform;
{
	SSP_S ssp,ssparg;
	int i,ret,ixpos,len;
	char w[30],*p,work[256];

	ixpos = 0;
	ssp.sp = 0;
	for (i=1;i<bndp->F;i++) {
		len = bndp->L[i];
		if (iform & (FIL_FORM_FIXED | FIL_FORM_FREE)) {	 /* fixed  or free */
			if (ssp.sp > iLen) break;
			p = buf + ssp.sp;
			ssp.sp += len;
			if (ssp.sp > iLen) len -= ssp.sp - iLen;
		}
		else if (iform & FIL_FORM_SSV) {	/* ssv */
			if ((len = akxtgwse(buf,&ssp,"",0x27))<0) break;
		}
		else {	/* csv */
			if (akxtcsvgw(buf,iLen,&ssp,&ssparg)<0) break;
		}
/*
printf("fil_mkixrec:i=%d sp=%d\n",i,ssparg.sp);
*/
		if (bndp->M[i]) {
			if (iform) {
				memcpy(work,p,len);
				work[len] = '\0';
				p = work;
			}
			else {
				p = ssparg.wd;
			}
			if (bndp->T[i] == TYPE_FIL_DATE) {
				if (!fil_chk_date(p,w)) p = w;
				 
			}
			strmemcpy(ixrec+ixpos,p,len);
/*
printf("fil_mkixrec:i=%d ixpos=%d\n",i,ixpos);
*/
			ixpos += len + 1;
		}
	}
	/* add start 1999.11.10 Koba */
	*(ixrec+ixlen-1) = '\n';
	ixpos++;
	/* add end   1999.11.10 Koba */
	return ixlen;
}

int fil_indexlen(bndp)
SQLDA_FIL *bndp;
{
	int i, ixlen=0;

	for(i=1;i<bndp->F;i++) {
		if (bndp->M[i]) {
			ixlen += bndp->L[i] + 1;
/*
printf("fil_indexlen:i=%d L=%d\n",i,bndp->L[i]);
*/
		}
	}
/*
printf("fil_indexlen:ixlen=%d\n",ixlen);
*/
	return ixlen;
}
