package com.xxxxxxx.drvpp.fw.common.mybatis;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

import com.xxxxxxx.drvpp.fw.common.exception.FwUnsupportedOperationException;

/**
 * フレームワークSQLセション
 */
public class FwSqlSession implements SqlSession {
	/** SQLセッション */
	private SqlSession sqlSession;
	/** コミットフラグ */
	private boolean isCommittable = false;

	/**
	 * コンストラクタ.
	 * 
	 * @param sqlSession
	 *            SQLセッション
	 */
	public FwSqlSession(SqlSession sqlSession) {
		this.sqlSession = sqlSession;
	}

	/**
	 * SQLセッション取得.
	 * @return SQLセッション
	 */
	public SqlSession getSqlSession() {
		return sqlSession;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectOne(java.lang.String)
	 */
	@Override
	public <T> T selectOne(String statement) {
		T result = sqlSession.selectOne(statement);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectOne(java.lang.String, java.lang.Object)
	 */
	@Override
	public <T> T selectOne(String statement, Object parameter) {
		T result = sqlSession.selectOne(statement, parameter);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectList(java.lang.String)
	 */
	@Override
	public <E> List<E> selectList(String statement) {
		List<E> result = sqlSession.selectList(statement);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectList(java.lang.String, java.lang.Object)
	 */
	@Override
	public <E> List<E> selectList(String statement, Object parameter) {
		List<E> result = sqlSession.selectList(statement, parameter);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectList(java.lang.String, java.lang.Object, org.apache.ibatis.session.RowBounds)
	 */
	@Override
	public <E> List<E> selectList(String statement, Object parameter,
			RowBounds rowBounds) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectMap(java.lang.String, java.lang.String)
	 */
	@Override
	public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectMap(java.lang.String, java.lang.Object, java.lang.String)
	 */
	@Override
	public <K, V> Map<K, V> selectMap(String statement, Object parameter,
			String mapKey) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#selectMap(java.lang.String, java.lang.Object, java.lang.String, org.apache.ibatis.session.RowBounds)
	 */
	@Override
	public <K, V> Map<K, V> selectMap(String statement, Object parameter,
			String mapKey, RowBounds rowBounds) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#select(java.lang.String, java.lang.Object, org.apache.ibatis.session.ResultHandler)
	 */
	@Override
	public void select(String statement, Object parameter, ResultHandler handler) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#select(java.lang.String, org.apache.ibatis.session.ResultHandler)
	 */
	@Override
	public void select(String statement, ResultHandler handler) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#select(java.lang.String, java.lang.Object, org.apache.ibatis.session.RowBounds, org.apache.ibatis.session.ResultHandler)
	 */
	@Override
	public void select(String statement, Object parameter, RowBounds rowBounds,
			ResultHandler handler) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#insert(java.lang.String)
	 */
	@Override
	public int insert(String statement) {
		int result = sqlSession.insert(statement);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#insert(java.lang.String, java.lang.Object)
	 */
	@Override
	public int insert(String statement, Object parameter) {
		int result = sqlSession.insert(statement, parameter);
		return result;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#update(java.lang.String)
	 */
	@Override
	public int update(String statement) {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#update(java.lang.String, java.lang.Object)
	 */
	@Override
	public int update(String statement, Object parameter) {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#delete(java.lang.String)
	 */
	@Override
	public int delete(String statement) {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#delete(java.lang.String, java.lang.Object)
	 */
	@Override
	public int delete(String statement, Object parameter) {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#commit()
	 */
	@Override
	public void commit() {
		if (!isCommittable) {
			throw new FwUnsupportedOperationException();
		}
		sqlSession.commit();
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#commit(boolean)
	 */
	@Override
	public void commit(boolean force) {
		if (!isCommittable) {
			throw new FwUnsupportedOperationException();
		}
		sqlSession.commit(force);
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#rollback()
	 */
	@Override
	public void rollback() {
		if (!isCommittable) {
			throw new FwUnsupportedOperationException();
		}
		sqlSession.rollback();
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#rollback(boolean)
	 */
	@Override
	public void rollback(boolean force) {
		if (!isCommittable) {
			throw new FwUnsupportedOperationException();
		}
		sqlSession.rollback(force);
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#flushStatements()
	 */
	@Override
	public List<BatchResult> flushStatements() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#close()
	 */
	@Override
	public void close() {
		throw new FwUnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#clearCache()
	 */
	@Override
	public void clearCache() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#getConfiguration()
	 */
	@Override
	public Configuration getConfiguration() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#getMapper(java.lang.Class<T>)
	 */
	@Override
	public <T> T getMapper(Class<T> type) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.ibatis.session.SqlSession#getConnection()
	 */
	@Override
	public Connection getConnection() {
		throw new FwUnsupportedOperationException();
	}
}
