package com.xxxxxxx.drvpp.fw.common.log;

import org.springframework.context.ApplicationContext;

import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

/**
 * ロガーファクトリビルダ
 */
public class LoggerFactoryBuilder {
	/** ロガーファクトリ */
	private LoggerFactory loggerFactory;

	/**
	 * シングルトン保持
	 */
	private static class LoggerFactoryBuilderHolder {
		/**
		 * インスタンス
		 */
		private static final LoggerFactoryBuilder instance = new LoggerFactoryBuilder();
	}

	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static LoggerFactoryBuilder getInstance() {
		LoggerFactoryBuilderHolder.instance.init();
		return LoggerFactoryBuilderHolder.instance;
	}

	/**
	 * コンストラクタ.
	 */
	private LoggerFactoryBuilder(){
		
	}

	/**
	 * 初期化.
	 */
	private void init() {
		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		loggerFactory = (LoggerFactory) applicationContext.getBean("loggerFactory");
	}
	
	/**
	 * ロガーファクトリ取得.
	 * @return ロガーファクトリ
	 */
	public LoggerFactory getLoggerFactory(){
		return loggerFactory;
	}

	/**
	 * ロガーファクトリ設定.
	 * @param loggerFactory ロガーファクトリ
	 */
	public void setLoggerFactory(LoggerFactory loggerFactory) {
	    this.loggerFactory = loggerFactory;
	}
}
