#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'fileutils'


# ==============================================================================
# generate_tarball
# ==============================================================================

generate_tarball = Proc.new do
	template = File.new("mozc_tmp/mozc/src/data/version/mozc_version_template.bzl", "r")
		lines = template.readlines
	template.close

	lines.length.times do |i|
		if lines[i].index("MAJOR=") == 0
			$s = "mozc-" + lines[i].chomp.split("=")[1]
			$s = $s + "." + lines[i + 1].chomp.split("=")[1]
			$s = $s + "." + lines[i + 2].chomp.split("=")[1]
			$s = $s + "." + lines[i + 3].chomp.split("=")[1]
		end
	end

	FileUtils.cd("mozc_tmp")
	FileUtils.mv("mozc", $s)
	`tar -jcf #{$s}.tar.bz2 #{$s}`
end


# ==============================================================================
# main
# ==============================================================================

generate_tarball.call
