#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# modify_hits
# ==============================================================================

modify_hits = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	lines.length.times do |i|
		s = lines[i].chomp.split("	")
		lines[i] = [s[0], s[1], s[2].to_i]
	end

	# ヒット数の多い順に並べる
	lines = lines.sort.reverse

	lines2 = []
	c = 0

	lines.length.times do |i|
		s = lines[i]
		p = lines[i - 1]

		# 重複エントリを除外
		if s[0..1] != p[0..1] &&
		# ヒット数が2件以上のものを収録
		s[2] >= 2
			lines2[c] = s
			c = c + 1
		end
	end

	lines = lines2
	lines2 = []

	# [ヒット数(to_i), 読み, 表記] の順に並べ替える
	lines.length.times do |i|
		s = lines[i]
		lines[i] = [s[2], s[0], s[1]]
	end

	# ヒット数が10000以上のものを除外する
	# 上位のヒット数は桁違いに多いので、
	# 残していると下位のエントリの優劣がつきにくくなる
	lines = lines.sort

	lines.length.times do |i|
		s = lines[i]

		if s[0] > 10000
			lines = lines[0..(i - 1)]
			s = lines[i - 1]
			s = [s[1], s[2], s[0].to_s]
			puts "max hits = " + s.join("　")
			break
		end
	end

	lines = lines.sort[0..(lines.length * 0.99).to_i]

	# 最大ヒット数が3000になる対数を計算
	p = Math.log(3000, lines[-1][0])

	# 対数の小数点5桁以下を切り捨てる
	# 1.12345 * 10000 = 11234.5
	# 11234 / 10000.0 = 1.1234
	p = (p * 10000).to_i / 10000.0
	puts "log = " + p.to_s

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		s = lines[i]
		# ヒット数が大きいほどコストを小さくする
		# コストの範囲は5000から8000程度にする
		# コストが9000近くになると人名が途中で切れやすい
		# 「青木さやか|さん」が「青木|さやかさん」になる
		s[0] = 8000 - (s[0] ** p).to_i

		s = [s[1], s[2], s[0]]
		dicfile.puts s.join("	")
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".costs"

	modify_hits.call
end
