#!/bin/sh

# ニコニコ大百科IME辞書を取得
rm -rf nicoime/
mkdir nicoime
cd nicoime/
wget http://tkido.com/data/nicoime.zip
unzip nicoime.zip
mv nicoime_msime.txt ..
cd ../

# 辞書を作成
ruby modify-nico.rb nicoime_msime.txt

cp niconico.hits niconico.hits_bak

ruby ../src/get-yomigana-hyouki.rb nicoime_msime.txt.modnico
ruby ../src/remove-duplicates.rb nicoime_msime.txt.modnico.pairs

cat ../src/dictionary_oss/dictionary*.txt.mozc ../*/*.hits nicoime_msime.txt.modnico.pairs.remdup > allwords
ruby ../src/apply-previous-hits.rb allwords

split -d -l $(expr $(grep '' allwords.new | wc -l) / 3 + 1) allwords.new allwords.new

ruby ../src/get-jawiki-hits.rb allwords.new00 &
ruby ../src/get-jawiki-hits.rb allwords.new01 &
ruby ../src/get-jawiki-hits.rb allwords.new02 &
wait

cat allwords.exist allwords.new*.hits > niconico.hits
ruby ../src/sortdic.rb niconico.hits

rm -rf nicoime/
rm nicoime_msime.txt.*
rm allwords*
