#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# get_ekimei
# ==============================================================================

get_ekimei = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	# 品詞idを取得
	file = File.new("../src/id.def", "r")
		while s = file.gets
			if s.index(" 名詞,一般,*,*,*,*,*") != nil
				id = s.chomp.split(" ")[0]
				break
			end
		end
	file.close

	hitfile = File.new("ekimei.hits", "w")

	ekihits = []
	c = 0

	lines.length.times do |i|
		s = lines[i].chomp

		if s.index(/ title=".*駅.*えき/) == nil
			next
		end

		# （例）" title="西鉄福岡（天神）駅">西鉄福岡（天神）駅</a>（にしてつふくおか（てんじん）えき）</li>
		# （例）" title="皿倉山ケーブルカー">山上駅 (福岡県)</a>（さんじょうえき・皿倉山ケーブルカー）</li>
		s = s.split(' title="')[1]
		s = s.split('>')[1..-1].join(">")
		# 全角英数を半角に変換
		s = NKF.nkf('-m0Z1 -w -W', s)
		# split('駅') だと「天王寺駅前駅」が「天王寺駅」になる
		hyouki = s.match(/.*駅/).to_s
		yomi = s.split("</a>")[1]
		# split('えき') だと「うえきえき」が「うえき」になる
		yomi = yomi.match(/.*えき/).to_s
		yomi = yomi.tr('・() ', '')
		yomi = NKF.nkf("--hiragana -w -W", yomi)

		t = [yomi, hyouki, "0"]
		ekihits[c] = t.join("	")
		c = c + 1

		# 「津駅」のように2文字の駅名のときは「津」のエントリを作らない
		if hyouki.length < 3
			next
		end

		t = [yomi[0..-3], hyouki[0..-2], "0"]
		ekihits[c] = t.join("	")
		c = c + 1
	end

	lines.length.times do |i|
		s = lines[i].chomp

		if s.index(/ title=".*停留場.*ていりゅうじょう/) == nil
			next
		end

		# （例）" title="朝日通停留場">朝日通停留場</a>（あさひどおりていりゅうじょう）</li>
		s = s.split(' title="')[1]
		s = s.split('>')[1..-1].join(">")
		# 全角英数を半角に変換
		s = NKF.nkf('-m0Z1 -w -W', s)
		# split('駅') だと「天王寺駅前駅」が「天王寺駅」になる
		hyouki = s.match(/.*停留場/).to_s
		yomi = s.split("</a>")[1]
		# split('えき') だと「うえきえき」が「うえき」になる
		yomi = yomi.match(/.*ていりゅうじょう/).to_s
		yomi = yomi.tr('・() ', '')
		yomi = NKF.nkf("--hiragana -w -W", yomi)

		t = [yomi, hyouki, "0"]
		ekihits[c] = t.join("	")
		c = c + 1

		# 「津停留場」のように4文字の停留場名のときは「津」のエントリを作らない
		if hyouki.length < 5
			next
		end

		t = [yomi[0..-9], hyouki[0..-4], "0"]
		ekihits[c] = t.join("	")
		c = c + 1
	end

	ekihits = ekihits.uniq.sort
	hitfile.puts ekihits

	hitfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]

	get_ekimei.call
end
