#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# convert_neologd_format_to_mozc_format
# ==============================================================================

convert_neologd_format_to_mozc_format = Proc.new do
	file = File.new("id.def", "r")
		lines = file.readlines
	file.close

	id_num = []
	id_str = []
	p = 0

	# mozcのid.defからmozcのidとneologdの品詞のペアを作る
	# 収録対象は「名詞,一般,*,*,*,*,*」と「名詞,固有名詞」
	lines.length.times do |i|
		s = lines[i].chomp

		if s.index(" 名詞,一般,*,*,*,*,*") != nil
			# neologdの品詞は「,*」が1つ少ない
			s = s.split(",")[0..-2].join(",")
			s = s.split(" ")
			id_num[p] = s[0]
			id_str[p] = s[1]
			p = p + 1

		# 固有名詞から地名を除外。地名は郵便番号データから生成する
		elsif s.index(" 名詞,固有名詞,") != nil && s.index(",地域,") == nil
			# neologdの品詞は「,*」が1つ少ない
			s = s.split(",")[0..-2].join(",")
			s = s.split(" ")
			id_num[p] = s[0]
			id_str[p] = s[1]
			p = p + 1
		end
	end

	# mecab-user-dict-seedを読み込む
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	l2 = []
	p = 0

	# neologdの品詞をmozcのidに変換
	lines.length.times do |i|
		# 並びの例
		# 古城,1288,1288,4607,名詞,固有名詞,一般,*,*,*,古城,コジョウ,コジョー
		s = lines[i].chomp.split(",")

		hinsi = s[4..-4].join(",")

		# 「明石家さんま」より「明石屋さんま」が優先されるのを防ぐ
		if hinsi.index("名詞,固有名詞,人名,一般,*,*") == 0
			hinsi = "名詞,固有名詞,一般,*,*,*"
		end

		# neologの品詞にマッチするid_strの配列番号を取得
		hinsi = id_str.index(hinsi)

		# id_strの配列番号からidを取得
		if hinsi != nil
			id = id_num[hinsi]
		else
			# 収録対象外の品詞はスキップ
			next
		end

		# 全角のカンマが混じっているので半角に変換
		if s[-3][-1] == "，"
			s[-3][-1] = ","
		else
			s[-3] = s[-3].gsub("，", ", ")
		end

		# 20文字を超える表記を除外
		if s[-3].length > 20 ||
		# 英数字のみの表記を除外
		s[-3].length == s[-3].bytesize ||
		# 1文字の表記を除外
		s[-3].length == 1 ||
		# 数字を含む表記を除外
		# 「712円」「青森県道39号」「第1231話」などキリがないので
		s[-3].match(/[0-9]/) != nil ||
		# 選挙や県名などを除外
		s[-3].match(/議会|選挙/) != nil ||
		s[-3].match(/村立|町立|市立|区立|県立|府立|都立|道立/) != nil ||
		s[-3].match(/北海道|青森県|岩手県|宮城県|秋田県/) != nil ||
		s[-3].match(/山形県|福島県|東京都|神奈川県|埼玉県/) != nil ||
		s[-3].match(/千葉県|茨城県|栃木県|群馬県|山梨県/) != nil ||
		s[-3].match(/新潟県|長野県|富山県|石川県|福井県/) != nil ||
		s[-3].match(/愛知県|岐阜県|静岡県|三重県|大阪府/) != nil ||
		s[-3].match(/兵庫県|京都府|滋賀県|奈良県|和歌山県/) != nil ||
		s[-3].match(/鳥取県|島根県|岡山県|広島県|山口県/) != nil ||
		s[-3].match(/徳島県|香川県|愛媛県|高知県|福岡県/) != nil ||
		s[-3].match(/佐賀県|長崎県|熊本県|大分県|宮崎県/) != nil ||
		s[-3].match(/鹿児島県|沖縄県/) != nil
			next
		end

		# 組織のうち会社と法人を除外（数が多すぎるので）
		if s[6] == "組織" && s[-2].index("ガイシャ") != nil
			next
		elsif s[6] == "組織" && s[-2].index("カイシャ") != nil
			next
		elsif s[6] == "組織" && s[-3].index("法人") != nil
			next
		elsif s[6] == "組織" && s[-3].index("ホールディングス") != nil
			next
		elsif s[6] == "組織" && s[-3].index("事務所") != nil
			next
		end

		# [読み,表記,id,コスト] の順に並べる
		l2[p] = [s[-2], s[-3], id, s[3].to_i]
		p = p + 1
	end

	lines = l2.sort
	l2 = []

	dicfile = File.new("neologd.costs", "w")

	# 不要なエントリを除外する、読みをひらがなにする、コストを計算する
	lines.length.times do |i|
		s1 = lines[i]
		hyoukitmp = s1[1].gsub("・", "")
		hyoukitmp = hyoukitmp.gsub("=", "")

		s2 = lines[i - 1]

		# [読み..表記]が重複するエントリを除外
		if s1[0..1] == s2[0..1] ||
		# 読みの文字数より表記の文字数が多いものを除外
		# （例）ミョウジョウ 明星食品株式会社
		s1[0].length < hyoukitmp.length ||
		# 読みの文字数が表記の文字数の4倍以上のものを除外
		# 多少の不具合が出るかもしれないが割り切る
		# （例）アカシショウガッコウアカイシショウガッコウ 明石小学校
		s1[0].length >= s1[1].length * 4
			next
		end

		# 読みのカタカナをひらがなに変換
		# 「tr('ァ-ヴ', 'ぁ-ゔ')」よりnkfのほうが速い
		yomi = NKF.nkf("--hiragana -w -W", s1[0])
		yomi = yomi.tr('ゐゑ', 'いえ')

		# コストがマイナスのものは桁を減らす
		if s1[3] < 0
			s1[3] = s1[3] / 10
		end

		# コストを6000前後に収める
		s1[3] = 6000 + (s1[3] / 10)

		# [読み,id,id,コスト,表記] の順に並べる
		t = [yomi, s1[2], s1[2], s1[3].to_s, s1[1]]
		dicfile.puts t.join("	")
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]

	convert_neologd_format_to_mozc_format.call
end
