/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "projectFrom"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodProjectFrom.java,v 1.5 2000/04/20 13:27:54 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.5 $
 * @author $Author: ryo $
 */

public class JudanMethodProjectFrom extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodProjectFrom(JgclGeometry geometry,
				 String methodName,
				 Class[] argClasses,
				 Object[] argEntities) {
	// Jgcl*Point2D -> JgclPoint2D ɕύX
	// Jgcl*Point3D -> JgclPoint3D ɕύX
 	try {
	    Class cls;
	    // 2̓_Ȃ Point2D ɓւ
	    if ((cls = Class.forName("jp.go.ipa.jgcl.JgclPoint2D")).isAssignableFrom(argClasses[0])) {
		argClasses[0] = cls;
	    }
	    // 3̓_Ȃ Point3D ɓւ
	    else if ((cls = Class.forName("jp.go.ipa.jgcl.JgclPoint3D")).isAssignableFrom(argClasses[0])) {
		argClasses[0] = cls;
	    }
	    // ͂Ă͂ȂP[X
	    else {
		throw new JgclFatal();
	    }
 	}
 	catch (ClassNotFoundException e) {
 	    throw new JgclFatal();
 	}
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	JgclGeometry[] res = (JgclGeometry[])result;
	if (res.length == 0) {
	    System.out.println("Number of solution is 0");
	    return;
	}

	for (int ijk = 0; ijk < res.length; ijk++) {
	    res[ijk].output(System.out);
	}
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    // {ȂAʂ̃IuWFNg view() \bhs悤ɂ
    public static void view(Object result, JgclPoint sourcePnt) {
	JudanTransformer resultView = makeView(result, sourcePnt);
	resultView.show();
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(e_̔z)
     * @param sourcePnt	e
     */
    public static JudanTransformer makeView(Object result, JgclPoint sourcePnt) {
	JgclGeometry[] res = (JgclGeometry[])result;
	int nSolution = res.length;
	if (nSolution == 0) {
	    System.out.println("Number of solution is 0");
	    return null;
	}

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());

  	if (res[0].is2D()) {
  	    JgclPointOnCurve2D[] result2d = (JgclPointOnCurve2D[])result;
  	    JgclPoint2D source = (JgclPoint2D)sourcePnt;
	    resultView.transform(source, Color.blue);
  	    JgclParametricCurve2D curve = result2d[0].basisCurve();
	    resultView.transform(curve, Color.green);

  	    for (int i = 0; i < nSolution; i++) {
  		JgclPoint2D point = new JgclCartesianPoint2D(result2d[i].x(),
  							     result2d[i].y());
		resultView.transform(point, Color.red);
  		JgclVector2D tangVec = curve.tangentVector(result2d[i].parameter());
  		JgclLine2D tang = new JgclLine2D(result2d[i], tangVec);
		resultView.transform(tang, Color.gray);
		if (!result2d[i].identical(source)) {
		    JgclLine2D norm = new JgclLine2D(result2d[i], source);
		    resultView.transform(norm, Color.gray, 5);
		}
  	    }
  	}
  	else if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnCurve3D) {
  	    JgclPointOnCurve3D[] result3d = (JgclPointOnCurve3D[])result;
  	    JgclPoint3D source = (JgclPoint3D)sourcePnt;
	    resultView.transform(source, Color.blue);
  	    JgclParametricCurve3D curve = result3d[0].basisCurve();
	    resultView.transform(curve, Color.green);

  	    for (int i = 0; i < nSolution; i++) {
  		JgclPoint3D point = new JgclCartesianPoint3D(result3d[i].x(),
  							     result3d[i].y(),
  							     result3d[i].z());
		resultView.transform(point, Color.red);
  		JgclVector3D tangVec = curve.tangentVector(result3d[i].parameter());
  		JgclLine3D tang = new JgclLine3D(result3d[i], tangVec);
		resultView.transform(tang, Color.gray);
		if (!result3d[i].identical(source)) {
		    JgclLine3D norm = new JgclLine3D(result3d[i], source);
		    resultView.transform(norm, Color.gray, 5);
		}
  	    }
  	}
  	else if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnSurface3D) {
  	    JgclPointOnSurface3D[] result3d = (JgclPointOnSurface3D[])result;
  	    JgclPoint3D source = (JgclPoint3D)sourcePnt;
	    resultView.transform(source, Color.blue);
  	    JgclParametricSurface3D surface = result3d[0].basisSurface();
	    resultView.transform(surface, Color.green);

  	    for (int i = 0; i < nSolution; i++) {
  		JgclPoint3D point = new JgclCartesianPoint3D(result3d[i].x(),
  							     result3d[i].y(),
  							     result3d[i].z());
		resultView.transform(point, Color.red);
  		JgclVector3D[] tangVec = surface.tangentVector(result3d[i].uParameter(),
							       result3d[i].vParameter());
  		JgclLine3D uTang = new JgclLine3D(result3d[i], tangVec[0]);
		resultView.transform(uTang, Color.gray);
  		JgclLine3D vTang = new JgclLine3D(result3d[i], tangVec[1]);
		resultView.transform(vTang, Color.gray);
		if (!result3d[i].identical(source)) {
		    JgclLine3D norm = new JgclLine3D(result3d[i], source);
		    resultView.transform(norm, Color.gray, 5);
		}
  	    }
	}
	else {
	    throw new JgclFatal();
	}
	return resultView;
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(e_̔z)
     * @param sourcePnt	e
     */
    public JudanTransformer makeView() {
	return makeView(result, (JgclPoint)argEntities[0]);
    }

}
