/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "Inflexion"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodInflexion.java,v 1.3 2000/04/20 13:27:53 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import java.util.Vector;
import java.awt.Color;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * @version $Revision: 1.3 $
 * @author $Author: ryo $
 */
public class JudanMethodInflexion extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodInflexion(JgclGeometry geometry,
			       String methodName,
			       Class[] argClasses,
			       Object[] argEntities) {
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output(){
	Object[] res = (Object[])result;
	if (res.length == 0) {
	    System.out.println("Number of solution is 0");
	    return;
	}

	if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnCurve2D) {
	    JgclPointOnCurve2D[] result2d = (JgclPointOnCurve2D[])result;
	    for (int ijk = 0; ijk < result2d.length; ijk++) {
		result2d[ijk].output(System.out);
	    }
	}
	else if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnCurve3D) {
	    JgclPointOnCurve3D[] result3d = (JgclPointOnCurve3D[])result;
	    for (int ijk = 0; ijk < result3d.length; ijk++) {
		result3d[ijk].output(System.out);
	    }
	}
	else {
	    throw new JgclFatal();
	}
    }

    /**
     * sʂOtBbN
     */
    public JudanTransformer makeView() {
	Object[] res = (Object[])result;
	int nSolution = res.length;
	if (nSolution == 0) {
	    System.out.println("Number of solution is 0");
	    return null;
	}

	resultView = new JudanTransformer(new JudanTransformerJun());

	if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnCurve2D) {
	    JgclPointOnCurve2D[] result2d = (JgclPointOnCurve2D[])result;
	    JgclParametricCurve2D curve = result2d[0].basisCurve();
	    resultView.transform(curve, Color.green);
	    for (int i = 0; i < nSolution; i++) {
		JgclPoint2D point = new JgclCartesianPoint2D(result2d[i].x(),
							     result2d[i].y());
		resultView.transform(point, Color.red);
	    }
	}
	else if (res[0] instanceof jp.go.ipa.jgcl.JgclPointOnCurve3D) {
	    JgclPointOnCurve3D[] result3d = (JgclPointOnCurve3D[])result;
	    JgclParametricCurve3D curve = result3d[0].basisCurve();
	    resultView.transform(curve, Color.green);
	    for (int i = 0; i < nSolution; i++) {
		JgclPoint3D point = new JgclCartesianPoint3D(result3d[i].x(),
							     result3d[i].y(),
							     result3d[i].z());
		resultView.transform(point, Color.red);
	    }
	}
	else {
	    throw new JgclFatal();	    
	}
	return resultView;
    }
}
