/*
 * p[^l̋e덷\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclToleranceForParameter.java,v 1.8 2000/04/26 09:39:26 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * p[^l̋e덷\NXB
 * <p>
 * JGCL ł́A
 * 􉽉Zi߂ۂ̋e덷ɂĎQƂׂe̋e덷l
 * Z {@link JgclConditionOfOperation JgclConditionOfOperation} ƂāA
 * ܂Ƃ߂ĊǗB
 * </p>
 *
 * @version $Revision: 1.8 $, $Date: 2000/04/26 09:39:26 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclConditionOfOperation
 * @see	JgclToleranceForDistance
 * @see	JgclToleranceForAngle
 * @see	JgclTolerance
 */

public class JgclToleranceForParameter extends JgclTolerance {

    /**
     * ^ꂽle덷lƂIuWFNg\zB
     * <p>
     * value ̒l̎舵ɊւẮA
     * {@link JgclTolerance#JgclTolerance(double) X[p[NX̃RXgN^}
     * ɏB
     * </p>
     * 
     * @param value	p[^l̋e덷
     */
    public JgclToleranceForParameter(double value) {
	super(value);
    }

    /**
     * ̃p[^l̋e덷A
     * ^ꂽQ̋Ȑ̎w̃p[^lł
     * uȐ̓̂vɕϊB
     * <p>
     * ̃p[^l̋e덷̒lɁA
     * curve  t ɂڃxNg̑傫|āA
     * ̋e덷ɕϊlԂB
     * </p>
     * 
     * @param curve	Ȑ
     * @param t		p[^l
     * @return		̃p[^l̋e덷ɑ鋗̋e덷
     */
    public JgclToleranceForDistance
	toToleranceForDistance(JgclParametricCurve2D curve, double t)
    {
        return new
            JgclToleranceForDistance(this.value() * curve.tangentVector(t).length());
    }

    /**
     * ̃p[^l̋e덷A
     * ^ꂽR̋Ȑ̎w̃p[^lł
     * uȐ̓̂vɕϊB
     * <p>
     * ̃p[^l̋e덷̒lɁA
     * curve  t ɂڃxNg̑傫|āA
     * ̋e덷ɕϊlԂB
     * </p>
     * 
     * @param curve	Ȑ
     * @param t		p[^l
     * @return		̃p[^l̋e덷ɑ鋗̋e덷
     */
    public JgclToleranceForDistance
	toToleranceForDistance(JgclParametricCurve3D curve, double t)
    {
        return new
            JgclToleranceForDistance(this.value() * curve.tangentVector(t).length());
    }

    /**
     * ̃p[^l̋e덷A
     * ^ꂽR̋Ȗʂ̎w̃p[^l (u, v) ł
     * uU ̓p[^Ȑ̓̂vɕϊB
     * <p>
     * ̃p[^l̋e덷̒lɁA
     * surface  (u, v) ɂ U ̈ꎟΓ֐̑傫|āA
     * ̋e덷ɕϊlԂB
     * </p>
     * 
     * @param surface	Ȗ
     * @param u		U ̃p[^l
     * @param v		V ̃p[^l
     * @return		̃p[^l̋e덷ɑ鋗̋e덷
     */
    public JgclToleranceForDistance
	toToleranceForDistanceU(JgclParametricSurface3D surface,
				double u, double v)
    {
        return new
            JgclToleranceForDistance(this.value() * surface.tangentVector(u,v)[0].length());
    }

    /**
     * ̃p[^l̋e덷A
     * ^ꂽR̋Ȗʂ̎w̃p[^l (u, v) ł
     * uV ̓p[^Ȑ̓̂vɕϊB
     * <p>
     * ̃p[^l̋e덷̒lɁA
     * surface  (u, v) ɂ V ̈ꎟΓ֐̑傫|āA
     * ̋e덷ɕϊlԂB
     * </p>
     * 
     * @param surface	Ȗ
     * @param u		U ̃p[^l
     * @param v		V ̃p[^l
     * @return		̃p[^l̋e덷ɑ鋗̋e덷
     */
    public JgclToleranceForDistance
	toToleranceForDistanceV(JgclParametricSurface3D surface,
				double u, double v)
    {
        return new
            JgclToleranceForDistance(this.value() * surface.tangentVector(u,v)[0].length());
    }
}

