/*
 * ̋e덷\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclToleranceForDistance.java,v 1.11 2000/08/11 06:19:03 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ̋e덷\NXB
 * <p>
 * JGCL ł́A
 * 􉽉Zi߂ۂ̋e덷ɂĎQƂׂe̋e덷l
 * Z {@link JgclConditionOfOperation JgclConditionOfOperation} ƂāA
 * ܂Ƃ߂ĊǗB
 * </p>
 *
 * @version $Revision: 1.11 $, $Date: 2000/08/11 06:19:03 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclConditionOfOperation
 * @see	JgclToleranceForAngle
 * @see	JgclToleranceForParameter
 * @see	JgclTolerance
 */

public class JgclToleranceForDistance extends JgclTolerance {
    /**
     * ̋e덷l̎B
     * <p>
     * ̎l͕pɂɎQƂ̂ŁA\ߌvZĂB
     * </p>
     */
    private double value2;

    /**
     * ^ꂽle덷lƂIuWFNg\zB
     * <p>
     * value ̒l̎舵ɊւẮA
     * {@link JgclTolerance#JgclTolerance(double) X[p[NX̃RXgN^}
     * ɏB
     * </p>
     * 
     * @param value	̋e덷l
     */
    public JgclToleranceForDistance(double value) {
	super(value);
	this.value2 = value * value;
    }

    /**
     * ̋̋e덷̒l̎ԂB
     * 
     * @return		e덷l̎
     */
    public double value2() {
	return this.value2;
    }

    /**
     * ̋̋e덷̒l̎ԂB
     * 
     * @return		e덷l̎
     */
    public double squared() {
	return this.value2;
    }

    /**
     * ̋̋e덷A
     * ^ꂽQ̋Ȑ̎w̃p[^lł
     * up[^l̍vɕϊB
     * <p>
     * ̋̋e덷̒lA
     * curve  t ɂڃxNg̑傫ŊA
     * p[^l̋e덷ɕϊlԂB
     * </p>
     * 
     * @param curve	Ȑ
     * @param t		p[^l
     * @return		̋̋e덷ɑp[^l̋e덷
     */
    public JgclToleranceForParameter
    toToleranceForParameter(JgclParametricCurve2D curve, double t)
    {
        return new JgclToleranceForParameter(this.value() / curve.tangentVector(t).length());
    }

    /**
     * ̋̋e덷A
     * ^ꂽR̋Ȑ̎w̃p[^lł
     * up[^l̍vɕϊB
     * <p>
     * ̋̋e덷̒lA
     * curve  t ɂڃxNg̑傫ŊA
     * p[^l̋e덷ɕϊlԂB
     * </p>
     * 
     * @param curve	Ȑ
     * @param t		p[^l
     * @return		̋̋e덷ɑp[^l̋e덷
     */
    public JgclToleranceForParameter
	toToleranceForParameter(JgclParametricCurve3D curve, double t)
    {
        return new
            JgclToleranceForParameter(this.value() / curve.tangentVector(t).length());
    }

    /**
     * ̋̋e덷A
     * ^ꂽR̋Ȗʂ̎w̃p[^l (u, v) ł
     * uU ̃p[^l̍vɕϊB
     * <p>
     * ̋̋e덷̒lA
     * surface  (u, v) ɂ U ̈ꎟΓ֐̑傫ŊA
     * p[^l̋e덷ɕϊlԂB
     * </p>
     * 
     * @param surface	Ȗ
     * @param u		U ̃p[^l
     * @param v		V ̃p[^l
     * @return		̋̋e덷ɑp[^l̋e덷
     */
    public JgclToleranceForParameter
	toToleranceForParameterU(JgclParametricSurface3D surface,
				 double u, double v)
    {
        return new
            JgclToleranceForParameter(this.value() / surface.tangentVector(u,v)[0].length());
    }

    /**
     * ̋̋e덷A
     * ^ꂽR̋Ȗʂ̎w̃p[^l (u, v) ł
     * uV ̃p[^l̍vɕϊB
     * <p>
     * ̋̋e덷̒lA
     * surface  (u, v) ɂ V ̈ꎟΓ֐̑傫ŊA
     * p[^l̋e덷ɕϊlԂB
     * </p>
     * 
     * @param surface	Ȗ
     * @param u		U ̃p[^l
     * @param v		V ̃p[^l
     * @return		̋̋e덷ɑp[^l̋e덷
     */
    public JgclToleranceForParameter
	toToleranceForParameterV(JgclParametricSurface3D surface,
				 double u, double v)
    {
        return new
            JgclToleranceForParameter(this.value() / surface.tangentVector(u,v)[1].length());
    }

    /**
     * ̋̋e덷A
     * ^ꂽả~ł
     * upx̍vɕϊB
     * <p>
     * ̋̋e덷̒lA
     * a radius ̒lŊA
     * px̋e덷ɕϊlԂB
     * </p>
     * 
     * @param radius	a
     * @return		̋̋e덷ɑpx̋e덷
     */
    public JgclToleranceForAngle toToleranceForAngle(double radius) {
        return new JgclToleranceForAngle(this.value() / radius);
    }
}

