/*
 * 3D Ȗʏ̗vf^āÃp[^Ԃł2\𓾂B
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclToParameterSpaceOfSurface3D.java,v 1.7 2000/04/26 09:39:25 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * 3D Ȗʏ̗vf^āÃp[^Ԃł2\𓾂B
 *
 * @version $Revision: 1.7 $, $Date: 2000/04/26 09:39:25 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclToParameterSpaceOfSurface3D {
    private static final int MYDEF_UIP = 21;
    private static final double MYDEF_PAR_BIAS = 0.1;

    // 0.03 (GHL ȂĂ) ͂ǂ
    // private static final double MYDEF_HYP_BIAS = 0.03;
    private static final double MYDEF_HYP_BIAS = 0.1;

    private JgclElementarySurface3D surface;
    private JgclCartesianTransformationOperator3D trns;

    private JgclToParameterSpaceOfSurface3D(JgclElementarySurface3D surface) {
	this.surface = surface;
	trns = new JgclCartesianTransformationOperator3D(surface.position(), 1.0);
    }

    /**
     * _𕽖ʂ̃p[^Ԃł2\ɕϊ
     *
     * @param ffc	_Ȑ
     * @return		ʂ̃p[^Ԃł2\(_)
     */
    private JgclPoint2D[]
    to2DControlPointsOfPlane(JgclFreeformCurveWithControlPoints3D ffc) {
	int npnts = ffc.nControlPoints();
	JgclPoint2D[] pnts2D = new JgclPoint2D[npnts];
	for (int i = 0; i < npnts; i++) {
	    pnts2D[i] = ffc.controlPointAt(i).to2D(trns);
	}
	return pnts2D;
    }

    /**
     * ȐʏɂƉ肵āAʂ̃p[^Ԃł2\𓾂
     *
     * @param curve	Ȑ
     * @return		ʂ̃p[^Ԃł2\(Ȑ)
     */
    private JgclParametricCurve2D
    convertCurvePlane(JgclParametricCurve3D curve) {
	switch (curve.type()) {
	case JgclParametricCurve3D.LINE_3D:
	    {
		JgclLine3D lin = (JgclLine3D)curve;
		return lin.toLocal2D(trns);
	    }
	case JgclParametricCurve3D.CIRCLE_3D:
	case JgclParametricCurve3D.ELLIPSE_3D:
	case JgclParametricCurve3D.HYPERBOLA_3D:
	case JgclParametricCurve3D.PARABOLA_3D:
	    {
		JgclConic3D cnc = (JgclConic3D)curve;
		return cnc.toLocal2D(trns);
	    }
	case JgclParametricCurve3D.POLYLINE_3D:
	    {
		JgclPolyline3D pol = (JgclPolyline3D)curve;
		int npnts = pol.nPoints();
		JgclPoint2D[] pnts2D = new JgclPoint2D[npnts];
		for (int i = 0; i < npnts; i++) {
		    pnts2D[i] = pol.pointAt(i).to2D(trns);
		}
		return new JgclPolyline2D(pnts2D, pol.closed());
	    }
	case JgclParametricCurve3D.PURE_BEZIER_CURVE_3D:
	    {
		JgclPureBezierCurve3D bzc = (JgclPureBezierCurve3D)curve;
		return new JgclPureBezierCurve2D(to2DControlPointsOfPlane(bzc),
						 bzc.weights());
	    }
	case JgclParametricCurve3D.BSPLINE_CURVE_3D:
	    {
		JgclBsplineCurve3D bsc = (JgclBsplineCurve3D)curve;
		return new JgclBsplineCurve2D(bsc.knotData(), to2DControlPointsOfPlane(bsc),
					      bsc.weights());
	    }
	}
	throw new JgclNotSupported();
    }

    /*
     * for Circle/Ellipse
     */
    private JgclPoint3D[] transformCirEllPol(JgclConic3D cirell) {
	JgclPoint3D[] pnts = new JgclPoint3D[MYDEF_UIP];
	double step, t;

	step = JgclMath.PI2 / (MYDEF_UIP - 1);

	for (int i = 1; i < MYDEF_UIP; i++) {
	    t = i * step;
	    pnts[i] = cirell.coordinates(t);
	}
	pnts[0] = pnts[MYDEF_UIP - 1];
	return pnts;
    }

    /*
     * for Parabola
     */
    private JgclPoint3D[] transformParPol(JgclParabola3D par) {
	JgclPoint3D[] pnts = new JgclPoint3D[MYDEF_UIP];
	double t;
	int half_uip;

	half_uip = (MYDEF_UIP - 1) / 2;

	for (int i = 1; i <= half_uip; i++) {
	    t = MYDEF_PAR_BIAS * i * i;
	    pnts[half_uip + i] = par.coordinates(t);
	    pnts[half_uip - i] = par.coordinates(-t);
	}
	pnts[half_uip] = par.position().location();
	return pnts;
    }

    /*
     * for Hyperbola
     */
    private JgclPoint3D[] transformHypPol(JgclHyperbola3D hyp) {
	JgclPoint3D[] pnts = new JgclPoint3D[MYDEF_UIP];
	double t;
	int half_uip;

	half_uip = (MYDEF_UIP - 1) / 2;

	for (int i = 1; i <= half_uip; i++) {
	    t = MYDEF_HYP_BIAS * i * i;
	    pnts[half_uip + i] = hyp.coordinates(t);
	    pnts[half_uip - i] = hyp.coordinates(-t);
	}
	pnts[half_uip]
	    = hyp.position().location().add(hyp.position().x().multiply(hyp.xRadius()));
	return pnts;
    }

    private int getNeighborNonPoleIdx(boolean[] is_pole, int ith, boolean inc) {
	int uip = is_pole.length;
	int src = ith;

	if (inc) {
	    while (is_pole[ith]) {
		if (++ith >= uip)
		    ith = 0;
		if (ith == src)
		    return (- 1);
	    }
	} else {
	    while (is_pole[ith]) {
		if (--ith <= 0)
		    ith = uip - 1;
		if (ith == src)
		    return (- 1);
	    }
	}

	return ith;
    }

    private void adjustPole(JgclPoint2D[] pnts, boolean[] is_pole) {
	int ip;		// prev. non pole
	int in;		// next  non pole
	double x_ip;	// prev. X
	double x_in;	// next  X

	int uip = pnts.length;
	for (int i = 0; i < uip; i++) {
	    if (!is_pole[i])
		continue;

	    if (((ip = getNeighborNonPoleIdx(is_pole, i, false)) < 0) ||
		((in = getNeighborNonPoleIdx(is_pole, i, true))  < 0))
		return;

	    x_ip = pnts[ip].x();
	    x_in = pnts[in].x();
	    if (x_ip > x_in)
		x_in += JgclMath.PI2;

	    pnts[i] = new JgclCartesianPoint2D((x_ip + x_in) / 2.0, pnts[i].y());
	}
    }

    private class PointOnPolarSurface {
	JgclPoint2D pnt;
	boolean isPole;

	PointOnPolarSurface(JgclPoint2D pnt, boolean isPole) {
	    super();
	    this.pnt = pnt;
	    this.isPole = isPole;
	}

	PointOnPolarSurface(double x, double y, boolean isPole) {
	    super();
	    this.pnt = new JgclCartesianPoint2D(x, y);
	    this.isPole = isPole;
	}
    }

    private PointOnPolarSurface pntOnSph(JgclPoint3D pnt3d, double radius) {
	double x, y;
	boolean isPole;
	JgclPoint3D epnt;
	JgclPoint2D epnt2d;

	epnt = trns.toLocal(pnt3d);
	epnt = epnt.divide(radius);
      
	double ework = JgclMath.midOf3(-1.0, epnt.z(), 1.0);
	y = Math.asin(ework);

	ework = Math.sqrt(1.0 - (ework * ework));
	epnt2d = epnt.to2D().divide(ework);
      
	ework = JgclMath.midOf3(-1.0, epnt2d.x(), 1.0);
	x = Math.acos(ework);
	if (epnt2d.y() < 0.0)
	    x = JgclMath.PI2 - x;

	if (epnt2d.toVector2D().length() < pnt3d.getToleranceForDistance())
	    isPole = true;	// pole
	else
	    isPole = false;	// normal

	return new PointOnPolarSurface(x, y, isPole);
    }

    private JgclPoint2D pntOnCyl(JgclPoint3D pnt3d, double radius) {
	JgclPoint3D epnt;
	double x, y;

	epnt = trns.toLocal(pnt3d);
	epnt = epnt.divide(radius);

	double ework = JgclMath.midOf3(-1.0, epnt.x(), 1.0);
	x = Math.acos(ework);
	if (epnt.y() < 0.0)
	    x = JgclMath.PI2 - x;

	y = epnt.z();
	return new JgclCartesianPoint2D(x, y);
    }

    private PointOnPolarSurface pntOnCon(JgclPoint3D pnt3d, double radius, double semiAngle) {
	double x, y;
	JgclPoint3D epnt;
	JgclPoint2D epnt2d;

	epnt = trns.toLocal(pnt3d);

	y = epnt.z();
  
	double ework = radius + (Math.tan(semiAngle) * epnt.z());
  
	if (Math.abs(ework) < pnt3d.getToleranceForDistance()) {	// apex of cone
	    return new PointOnPolarSurface(0.0, y, true);
	}

	epnt = epnt.divide(ework);

	ework = JgclMath.midOf3(-1.0, epnt.x(), 1.0);
	x = Math.acos(ework);
	if (epnt.y() < 0.0)
	    x = JgclMath.PI2 - x;

	return new PointOnPolarSurface(x, y, false);
    }

    /**
     * ȐɂƉ肵āÃp[^Ԃł2\𓾂
     *
     * @param curve	Ȑ
     * @return		̃p[^Ԃł2\(Ȑ)
     */
    private JgclParametricCurve2D convertCurveSphere(JgclParametricCurve3D curve) {
	JgclSphericalSurface3D sph = (JgclSphericalSurface3D)surface;
	JgclPoint2D[] pnts2d;
	boolean[] isPole;
	PointOnPolarSurface pos;

	switch (curve.type()) {
	case JgclParametricCurve3D.POLYLINE_3D:
	    {
		JgclPolyline3D pol = (JgclPolyline3D)curve;
		int uip = pol.nPoints();
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnSph(pol.pointAt(i), sph.radius());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		sph.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, pol.closed());
	    }
	case JgclParametricCurve3D.CIRCLE_3D:
	    {
		JgclCircle3D cir = (JgclCircle3D)curve;
		JgclPoint3D[] pnts = transformCirEllPol(cir);
		int uip = pnts.length;
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnSph(pnts[i], sph.radius());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		sph.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, false);
	    }
	}
	throw new JgclNotSupported();
    }

    /**
     * Ȑ~ɂƉ肵āÃp[^Ԃł2\𓾂
     *
     * @param curve	Ȑ
     * @return		~̃p[^Ԃł2\(Ȑ)
     */
    private JgclParametricCurve2D convertCurveCylinder(JgclParametricCurve3D curve) {
	JgclCylindricalSurface3D cyl = (JgclCylindricalSurface3D)surface;
	JgclPoint2D[] pnts2d;

	switch (curve.type()) {
	case JgclParametricCurve3D.LINE_3D:
	    {
		JgclLine3D lin = (JgclLine3D)curve;
		JgclPoint2D spnt = pntOnCyl(lin.pnt(), cyl.radius());
		JgclPoint2D epnt = pntOnCyl(lin.pnt().add(lin.dir()), cyl.radius());
		return new JgclLine2D(spnt, epnt);
	    }
	case JgclParametricCurve3D.POLYLINE_3D:
	    {
		JgclPolyline3D pol = (JgclPolyline3D)curve;
		int uip = pol.nPoints();
		pnts2d = new JgclPoint2D[uip];
		for (int i = 0; i < uip; i++) {
		    pnts2d[i] = pntOnCyl(pol.pointAt(i), cyl.radius());
		}
		cyl.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, pol.closed());
	    }
	case JgclParametricCurve3D.CIRCLE_3D:
	case JgclParametricCurve3D.ELLIPSE_3D:
	    {
		JgclConic3D cnc = (JgclConic3D)curve;
		JgclPoint3D[] pnts = transformCirEllPol(cnc);
		int uip = pnts.length;
		pnts2d = new JgclPoint2D[uip];
		for (int i = 0; i < uip; i++) {
		    pnts2d[i] = pntOnCyl(pnts[i], cyl.radius());
		}
		cyl.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, false);
	    }
	}
	throw new JgclNotSupported();
    }

    /**
     * Ȑ~ɂƉ肵āÃp[^Ԃł2\𓾂
     *
     * @param curve	Ȑ
     * @return		~̃p[^Ԃł2\(Ȑ)
     */
    private JgclParametricCurve2D convertCurveCone(JgclParametricCurve3D curve) {
	JgclConicalSurface3D con = (JgclConicalSurface3D)surface;
	JgclPoint2D[] pnts2d;
	boolean[] isPole;
	PointOnPolarSurface pos;

	switch (curve.type()) {
	case JgclParametricCurve3D.LINE_3D:
	    {
		JgclLine3D lin = (JgclLine3D)curve;
		isPole = new boolean[2];
		pos = pntOnCon(lin.pnt(), con.radius(), con.semiAngle());
		JgclPoint2D spnt = pos.pnt;
		isPole[0] = pos.isPole;
		pos = pntOnCon(lin.pnt().add(lin.dir()), con.radius(), con.semiAngle());
		JgclPoint2D epnt = pos.pnt;
		isPole[1] = pos.isPole;
		if (isPole[0]&& !isPole[1]) {
		    spnt = new JgclCartesianPoint2D(epnt.x(), spnt.y());
		} else if (!isPole[0] && isPole[1]) {
		    epnt = new JgclCartesianPoint2D(spnt.x(), epnt.y());
		}
		return new JgclLine2D(spnt, epnt);
	    }
	case JgclParametricCurve3D.POLYLINE_3D:
	    {
		JgclPolyline3D pol = (JgclPolyline3D)curve;
		int uip = pol.nPoints();
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnCon(pol.pointAt(i), con.radius(), con.semiAngle());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		con.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, pol.closed());
	    }
	case JgclParametricCurve3D.CIRCLE_3D:
	case JgclParametricCurve3D.ELLIPSE_3D:
	    {
		JgclConic3D cnc = (JgclConic3D)curve;
		JgclPoint3D[] pnts = transformCirEllPol(cnc);
		int uip = pnts.length;
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnCon(pnts[i], con.radius(), con.semiAngle());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		con.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, false);
	    }
	case JgclParametricCurve3D.PARABOLA_3D:
	    {
		JgclParabola3D par = (JgclParabola3D)curve;
		JgclPoint3D[] pnts = transformParPol(par);
		int uip = pnts.length;
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnCon(pnts[i], con.radius(), con.semiAngle());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		con.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, false);
	    }
	case JgclParametricCurve3D.HYPERBOLA_3D:
	    {
		JgclHyperbola3D hyp = (JgclHyperbola3D)curve;
		JgclPoint3D[] pnts = transformHypPol(hyp);
		int uip = pnts.length;
		pnts2d = new JgclPoint2D[uip];
		isPole = new boolean[uip];
		for (int i = 0; i < uip; i++) {
		    pos = pntOnCon(pnts[i], con.radius(), con.semiAngle());
		    pnts2d[i] = pos.pnt;
		    isPole[i] = pos.isPole;
		}
		adjustPole(pnts2d, isPole);
		con.confirmConnectionOfPointsOnSurface(pnts2d);
		return new JgclPolyline2D(pnts2d, false);
	    }
	}
	throw new JgclNotSupported();
    }

    static JgclParametricCurve2D convertCurve(JgclParametricCurve3D curve,
					      JgclElementarySurface3D surface) {
	JgclToParameterSpaceOfSurface3D doObj
	    = new JgclToParameterSpaceOfSurface3D(surface);

	switch (surface.type()) {
	case JgclParametricSurface3D.PLANE_3D:
	    return doObj.convertCurvePlane(curve);
	case JgclParametricSurface3D.SPHERICAL_SURFACE_3D:
	    return doObj.convertCurveSphere(curve);
	case JgclParametricSurface3D.CYLINDRICAL_SURFACE_3D:
	    return doObj.convertCurveCylinder(curve);
	case JgclParametricSurface3D.CONICAL_SURFACE_3D:
	    return doObj.convertCurveCone(curve);
	}
	throw new JgclNotSupported();
    }
}
