/*
 * ^uVʂ𐶐邽߂̃NX(3D)
 * ؎ 7.2.1
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclTabcylSurface3D.java,v 1.4 2000/04/26 09:39:25 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ^uVʂ𐶐邽߂̃NX(3D)
 *
 * @version $Revision: 1.4 $, $Date: 2000/04/26 09:39:25 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclTabcylSurface3D {
    /*
     * ̃KChȐ
     */
    private final JgclBsplineCurve3D basisCurve1;

    /*
     * ̃KChȐ
     */
    private final JgclBsplineCurve3D basisCurve2;

    /**
     * 2{BsplineȐ^āAIuWFNg\z
     *
     * @param basisCurve1	̃KChȐ
     * @param basisCurve2	̃KChȐ
     */
    JgclTabcylSurface3D(JgclBsplineCurve3D basisCurve1,
			JgclBsplineCurve3D basisCurve2) {
	this.basisCurve1 = basisCurve1;
	this.basisCurve2 = basisCurve2;
    }

    JgclBsplineSurface3D getSurface() {
	JgclBsplineCurve3D[] crvs = new JgclBsplineCurve3D[2];
	crvs[0] = basisCurve1;
	crvs[1] = basisCurve2;

	JgclParameterSection[] sec = new JgclParameterSection[2];
	for (int i = 0; i < 2; i++) {
	    sec[i] = crvs[i].parameterDomain().section();
	}

	double sleng = crvs[0].coordinates(sec[0].start()).distance(crvs[1].coordinates(sec[1].start()));
	double eleng = crvs[0].coordinates(sec[0].end()).distance(crvs[1].coordinates(sec[1].end()));
	double leng = (sleng + eleng) / 2.0;

	JgclParameterSection uSec = new JgclParameterSection(0.0, leng);

	crvs = JgclBsplineCurve3D.identicalKnotSequences(crvs, uSec);
	boolean hasRational = false;
	for (int i = 0; i < crvs.length; i++)
	    if (crvs[i].isRational())
		hasRational = true;
	if (hasRational)
	    for (int i = 0; i < crvs.length; i++)
		crvs[i] = crvs[i].toBsplineCurve();

	int uNControlPoints = 2;
	int vNControlPoints = crvs[0].nControlPoints();
	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNControlPoints][vNControlPoints];
	for (int i = 0; i < uNControlPoints; i++)
	    for (int j = 0; j < vNControlPoints; j++)
		controlPoints[i][j] = crvs[i].controlPointAt(j);

	double[][] weights = null;
	if (hasRational) {
	    weights = new double[uNControlPoints][vNControlPoints];
	    for (int i = 0; i < uNControlPoints; i++)
		for (int j = 0; j < vNControlPoints; j++)
		    weights[i][j] = crvs[i].weightAt(j);
	}

	int uDegree = 1;
	double[] uKnots = new double[2];
	uKnots[0] = uSec.start();
	uKnots[1] = uSec.end();
	int[] uKnotMulti = new int[2];
	uKnotMulti[0] = uKnotMulti[1] = 2;
	JgclBsplineKnot uKnotData = new JgclBsplineKnot(uDegree, JgclKnotType.UNSPECIFIED, false,
							uKnotMulti, uKnots, uNControlPoints);

	return new JgclBsplineSurface3D(uKnotData, crvs[0].knotData().beautify(), controlPoints, weights);
    }
}
