/*
 * R : ]ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceOfRevolution3D.java,v 1.43 2000/08/11 06:19:03 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ]ʂ\NXB
 * <p>
 * ]ʂƂ́A
 * RȐ钼̎ŉ]OՂȖʂƂ݂Ȃ̂łB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ]ׂRȐ sweptCurve
 * 
 * ]̒Szu (ǏWn, {@link JgclAxis1Placement3D JgclAxis1Placement3D}) axisPosition
 * ێB
 * AsweptCurve  {@link JgclSweptSurface3D X[p[NX} ŕێB
 * </p>
 * <p>
 * ]ʂ U ̃p[^`͗LŎIłA
 * ̃vC}ȗLԂ [0, (2 * )] łB
 * V ̃p[^`́AsweptCurve ̃p[^`ɈvB
 * </p>
 * <p>
 * (u, v) p[^Ƃ] P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = c + m(u) * cos(v) + ((m(u), d) * d * (1 - cos(v)) + (d X m(u)) * sin(v)
 * </pre>
 * 
 * <pre>
 *	c = axisPosition.location()
 *	d = axisPosition.z()
 *	m(u) = sweptCurve(u) - c
 *	(a, b) : a, b ̓
 *	(a X b) : a, b ̊O
 * </pre>
 * \B
 * </p>
 *
 * @version $Revision: 1.43 $, $Date: 2000/08/11 06:19:03 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSurfaceOfRevolution3D extends JgclSweptSurface3D {
    /**
     * ]̒SB
     * @serial
     */
    private JgclAxis1Placement3D axisPosition;

    /**
     * ]̒SǏWnWnւ̕ϊZqB
     * @serial
     */
    private JgclCartesianTransformationOperator3D transformationOperator;

    /**
     * ]ȐƉ]̒S^ăIuWFNg\zB
     * <p>
     * sweptCurve 邢 axisPosition  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param sweptCurve	]Ȑ
     * @param axisPosition	]̒S
     * @see	JgclInvalidArgumentValue
     */
    public JgclSurfaceOfRevolution3D(JgclParametricCurve3D sweptCurve,
				     JgclAxis1Placement3D axisPosition)
    {
	super(sweptCurve);
	setAxisPosition(axisPosition);
	setTransformationOperator();
    }

    /**
     * ]̒StB[hɐݒ肷B
     * <p>
     * axisPosition  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param axisPosition	]̒S
     * @see	JgclInvalidArgumentValue
     */
    private void setAxisPosition(JgclAxis1Placement3D axisPosition)
    {
	if (axisPosition == null) {
	    throw new JgclInvalidArgumentValue();
	}
	this.axisPosition = axisPosition;
    }

    /**
     * ]̒SǏWnWnւ̕ϊZqݒ肷B
     */
    private void setTransformationOperator() {
	JgclParameterDomain pd = this.vParameterDomain();

	double sp = 0.0;
	double ep = 1000.0;
	if (pd.isFinite() == true) {
	    sp = pd.section().start();
	    ep = pd.section().end();
	}
	double ip = (ep - sp) / 1000.0;

	double dTol2 = this.getToleranceForDistance2();
	double cosATol = Math.cos(this.getToleranceForAngle());

	JgclPoint3D location = this.axisPosition().location();
	JgclVector3D axis = this.axisPosition().z();	// unitized
	JgclVector3D refDir = null;

	for (int i = 0; i <= 1000; i++) {
	    refDir = this.sweptCurve().coordinates(sp + (i * ip)).subtract(location);
	    if (refDir.norm() > dTol2) {
		refDir = refDir.unitized();
		if (Math.abs(axis.dotProduct(refDir)) < cosATol) {
		    transformationOperator =
			new JgclCartesianTransformationOperator3D
			(new JgclAxis2Placement3D(location, axis, refDir), 1.0);
		    return;
		}
	    }
	}

	throw new JgclFatal("Maybe the surface is degenate.");
    }

    /**
     * ̋Ȗʂ̉]̒SzuԂB
     * 
     * @return	]̒Szu
     */
    public JgclAxis1Placement3D axisPosition() {
	return axisPosition;
    }

    /**
     * ̋Ȗʂ̉]̒S\ԂB
     * 
     * @return	]̒S\
     */
    public JgclLine3D axisLine() {
	return axisPosition().toLine();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam, double vParam)
    {
	JgclPoint3D cpnt;

	cpnt = sweptCurve().coordinates(vParam);

	JgclPoint3D lpnt;
	double u_cos = Math.cos(uParam);
	double u_sin = Math.sin(uParam);

	lpnt = transformationOperator.reverseTransform(cpnt);
	return transformationOperator.transform(XYRotation(lpnt, u_cos, u_sin));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam)
    {
	JgclPoint3D cpnt;
	JgclVector3D ctng;

	cpnt = sweptCurve().coordinates(vParam);
	ctng = sweptCurve().tangentVector(vParam);

	JgclVector3D[] tng = new JgclVector3D[2];
	JgclPoint3D lpnt;
	JgclVector3D lUtng, lVtng;
	double u_cos = Math.cos(uParam);
	double u_sin = Math.sin(uParam);

	lpnt = transformationOperator.reverseTransform(cpnt);
	lUtng = new JgclLiteralVector3D(-lpnt.y(), lpnt.x(), 0.0);
	lVtng = transformationOperator.reverseTransform(ctng);
	tng[0] = transformationOperator.transform(XYRotation(lUtng, u_cos, u_sin));
	tng[1] = transformationOperator.transform(XYRotation(lVtng, u_cos, u_sin));
	return tng;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam)
    {
	JgclCurveDerivative3D crv_drv;

	crv_drv = sweptCurve().evaluation(vParam);

	JgclPoint3D L;
	JgclVector3D Lu, Lv, Luu, Lvv, Luv;
	JgclPoint3D d0;
	JgclVector3D du, dv, duu, duv, dvv;
	double u_cos = Math.cos(uParam);
	double u_sin = Math.sin(uParam);

	L = transformationOperator.reverseTransform(crv_drv.d0D());
	Lv = transformationOperator.reverseTransform(crv_drv.d1D());
	Lvv = transformationOperator.reverseTransform(crv_drv.d2D());
	Lu = new JgclLiteralVector3D(-L.y(), L.x(), 0.0);
	Luu = new JgclLiteralVector3D(-L.x(), -L.y(), 0.0);
	Luv = new JgclLiteralVector3D(-Lv.y(), Lv.x(), 0.0);
	d0 = transformationOperator.transform(XYRotation(L, u_cos, u_sin));
	du = transformationOperator.transform(XYRotation(Lu, u_cos, u_sin));
	dv = transformationOperator.transform(XYRotation(Lv, u_cos, u_sin));
	duu = transformationOperator.transform(XYRotation(Luu, u_cos, u_sin));
	dvv = transformationOperator.transform(XYRotation(Lvv, u_cos, u_sin));
	duv = transformationOperator.transform(XYRotation(Luv, u_cos, u_sin));
	return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    /**
     * ^ꂽ_炱̋Ȗʂ̉]ׂȐւ̓e_̈ suitable Ƃ
     * JgclIndefiniteSolution ̗O𔭐B
     *
     * @param point	e̓_
     * @exception	JgclIndefiniteSolution	sł (݂̉)
     * @see	#projectFrom(JgclPoint3D)
     */
    private void indefiniteFoot(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	JgclPointOnCurve3D p;

	try {
	    p = sweptCurve().projectFrom(point)[0];
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

 	throw new JgclIndefiniteSolution(p);
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * point A̋Ȗʂ̉]̒Sւ̋
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * sƂ JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	sł (݂̉)
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	/*
	 * If projected point is on the Revolution's axis 
	 * then throws JgclIndefiniteSolution.
	 */
	if (point.isOn(axisLine())) {
	    indefiniteFoot(point);
	}

	JgclCartesianTransformationOperator3D cto = getCartesianTransformationOperator();

	// make angle1.
	JgclPoint3D local_point = cto.toLocal(point);
	local_point = JgclPoint3D.of(local_point.x(), local_point.y(), 0.0);
	JgclVector3D local_vector = local_point.toVector3D().unitized();
	double angle1 = Math.acos(local_vector.x());
	if (local_point.y() < 0.0) {
	    angle1 = 2 * Math.PI - angle1;
	}

	// rotate swept curve1.
	JgclParametricCurve3D curve = sweptCurve();
	JgclParametricCurve3D rotated_curve1 =
	    curve.rotateZ(cto, Math.cos(angle1), Math.sin(angle1));

	// make projected point on rotated swept curve1.
	JgclPointOnCurve3D[][] proj_on_curve = new JgclPointOnCurve3D[2][]; 
	proj_on_curve[0] = rotated_curve1.projectFrom(point);

	// make angle2.
	double angle2 = angle1 + Math.PI;
	if (angle2 > 2 * Math.PI) {
	    angle2 -= 2 * Math.PI;
	}

	// rotate swept curve2.
	JgclParametricCurve3D rotated_curve2 =
	    curve.rotateZ(cto, Math.cos(angle2), Math.sin(angle2));

	// make projected points on rotated swept curve2.
	proj_on_curve[1] = rotated_curve2.projectFrom(point);

	// convert JgclPointOnCurve3D to JgclPointOnSurface3D.
	JgclPointOnSurface3D[] proj = new
	    JgclPointOnSurface3D[proj_on_curve[0].length +
				proj_on_curve[1].length]; 

	int i = 0;
	double uParam, vParam;

	uParam = angle1;
	for (int j = 0 ; j < proj_on_curve[0].length ; i++, j++){
	    vParam = proj_on_curve[0][j].parameter();
	    proj[i] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
	}

	uParam = angle2;
	for (int k = 0 ; k < proj_on_curve[1].length ; i++, k++){
	    vParam = proj_on_curve[1][k].parameter();
	    proj[i] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
	}

	return proj;
    }

    /**
     * ]̍ő唼aB
     */
    private transient double maxRadius = 0.0;

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    public JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol)
    {
	JgclPointOnSurface3D[][] mesh;
	JgclPolyline3D pol;
	int u_npnts, v_npnts;
	JgclLine3D lin;
	JgclPoint3D pnt;
 	JgclPointOnCurve3D foot;
	double dist;
	JgclPointOnCurve3D poc;
	double uParam, vParam, uDelta;
	int i, j;

	/*
	 * XC[vȐ^ꂽe덷Ń|CߎB
	 */
	pol = sweptCurve().toPolyline(vPint, tol);
	v_npnts = pol.nPoints();

	/*
	 * ]̒Sł|C̐ߓ_߁A
	 * ]̍ő唼a𓾂B
	 */
	lin = new JgclLine3D(axisPosition.location(), axisPosition.z());
	maxRadius = 0.0;
	for (i = 0; i < v_npnts; i++) {
	    pnt = pol.pointAt(i);
	    try {
		foot = lin.project1From(pnt);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	    dist = foot.distance2(pnt);
	    if (dist > maxRadius) {
		maxRadius = dist;
	    }
	}
	maxRadius = Math.sqrt(maxRadius);

	if (maxRadius <= JgclConditionOfOperation.getCondition().getToleranceForDistance()) {
	    u_npnts = 2;
	} else {
	    /*
	     * ő唼a𔼌aƂ~߁A
	     * ̉~|CߎA̓_̐𓾂B
	     */
	    try {
		JgclCircle3D cir;

		cir = new JgclCircle3D(axisPosition.location(), axisPosition.z(), maxRadius);
		u_npnts = cir.toPolyline(uPint, tol).nPoints();
		if (u_npnts < 2) u_npnts = 2;
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	/*
	 * U u_npnts AV̓|Cߎ̃p[^pĊiq_\B
	 * (~ʂ̃|Cߎ̓p[^ƂȂ͂ł)
	 */
	mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];

	uDelta = uPint.increase() / (u_npnts - 1);
	uParam = uPint.start();
	for (i = 0; i < u_npnts; i++) {
	    for (j = 0; j < v_npnts; j++) {
		poc = (JgclPointOnCurve3D)pol.pointAt(j);
		vParam = poc.parameter();
		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
	    }
	    if (i == (u_npnts - 2))
		uParam = uPint.end();
	    else
		uParam += uDelta;
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclCircle2D uUnitCircle2D = new JgclCircle2D(JgclAxis2Placement2D.origin, 1.0);
	JgclBsplineCurve2D uUnitBsplineCurve2D = uUnitCircle2D.toBsplineCurve(uPint);

	JgclBsplineCurve3D vBsplineCurve = this.sweptCurve().toBsplineCurve(vPint);

	int uNPoints = uUnitBsplineCurve2D.nControlPoints();
	int vNPoints = vBsplineCurve.nControlPoints();

	JgclPoint3D[] vLocalControlPoints = new JgclPoint3D[vNPoints];
	for (int vi = 0; vi < vNPoints; vi++)
	    vLocalControlPoints[vi] =
		transformationOperator.toLocal(vBsplineCurve.controlPointAt(vi));

	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
	double[][] weights = new double[uNPoints][vNPoints];

	for (int ui = 0; ui < uNPoints; ui++) {
	    JgclPoint2D uPoint = uUnitBsplineCurve2D.controlPointAt(ui);
	    for (int vi = 0; vi < vNPoints; vi++) {
		controlPoints[ui][vi] = 
		    transformationOperator.toEnclosed
		    (this.XYRotation(vLocalControlPoints[vi], uPoint.x(), uPoint.y()));
		weights[ui][vi] = uUnitBsplineCurve2D.weightAt(ui) * vBsplineCurve.weightAt(vi);
	    }
	}

	return new JgclBsplineSurface3D(uUnitBsplineCurve2D.knotData(),
					vBsplineCurve.knotData(),
					controlPoints, weights);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset(); 
    }
    
    /**
     * ̋Ȗʂ̉]̒SǏ Z ƂAǏWnWnւ
     * ϊZqԂB
     *
     * @return	]̒SǏ Z ƂAǏWnWnւ̕ϊZq
     */
    private JgclCartesianTransformationOperator3D getCartesianTransformationOperator() {

	/*
	 *     Make vector xv which is parpendicular with the axisPosition
	 * and its direction of the plane that include the sweptCurve and
	 * the axisPosition.
	 */
	JgclLine3D line = axisLine();
	JgclPoint3D x = sweptCurve().getPointNotOnLine(line);
	JgclVector3D xv = x.subtract(line.project1From(x));

	// make CartesianTransformationOperator3D by Revolution's axis and xv.
	JgclAxis2Placement3D local_position
	    = new JgclAxis2Placement3D(axisPosition().location(), axisPosition().z(), xv);
	return local_position.toCartesianTransformationOperator();
    }

    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	JgclCartesianTransformationOperator3D cto = getCartesianTransformationOperator();
	return sweptCurve().rotateZ(cto, Math.cos(uParam), Math.sin(uParam));
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam)
	throws JgclReducedToPoint
    {
	JgclPoint3D pnt = sweptCurve().coordinates(vParam);
	JgclPoint3D prj = axisLine().project1From(pnt).literal();
	double radius = pnt.distance(prj);

	if (radius <= getToleranceForDistance()) {
	    throw new JgclReducedToPoint(prj);
	}
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(prj, axisPosition().z(), pnt.subtract(prj));
	return new JgclCircle3D(a2p, radius);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * LŎIȃp[^`ԂB
     * ̒`̃vC}ȗLԂ [0, (2 * )] łB
     * </p>
     * 
     * @return	U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2 * Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ]Ȑ̃p[^`ԂB
     * </p>
     * 
     * @return	V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	return sweptCurve().parameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#SURFACE_OF_REVOLUTION_3D JgclParametricSurface3D.SURFACE_OF_REVOLUTION_3D}
     */
    int type() {
	return SURFACE_OF_REVOLUTION_3D;
    }

    /**
     * ^ꂽ_AWn Z ̎ŎẘpxƂ]B
     *
     * @param pnt	]_
     * @param cosValue	cos() ̒l
     * @param sinValue	sin() ̒l
     * @return	]̓_
     */
    private JgclPoint3D XYRotation(JgclPoint3D pnt,
				   double cosValue, double sinValue) {
	double x, y, z;

	x = cosValue * pnt.x() - sinValue * pnt.y();
	y = sinValue * pnt.x() + cosValue * pnt.y();
	z = pnt.z();
	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ^ꂽxNgAWn Z ̎ŎẘpxƂ]B
     *
     * @param vec	]xNg
     * @param cosValue	cos() ̒l
     * @param sinValue	sin() ̒l
     * @return	]̃xNg
     */
    private JgclVector3D XYRotation(JgclVector3D vec,
				    double cosValue, double sinValue) {
	double x, y, z;

	x = cosValue * vec.x() - sinValue * vec.y();
	y = sinValue * vec.x() + cosValue * vec.y();
	z = vec.z();
	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	JgclMesh3D mesh = this.toMesh(uParameterSection,
				      vParameterSection,
				      new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	double vScale = 0.0;
	for (int v = 1; v < mesh.vNPoints(); v++)
	    vScale += mesh.pointAt(0, v).distance(mesh.pointAt(0, (v - 1)));
	vScale /= vParameterSection.increase();

	scalingFactor[0] = maxRadius;
	scalingFactor[1] = vScale;

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricCurve3D tSweptCurve =
	    this.sweptCurve().transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	JgclAxis1Placement3D tAxisPosition =
	    this.axisPosition.transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	return new JgclSurfaceOfRevolution3D(tSweptCurve, tAxisPosition);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tsweptCurve");
        sweptCurve().output(writer, indent + 2);
        writer.println(indent_tab + "\taxisPosition");
        axisPosition.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
