/*
 * R : Ȗʏ̋Ȑ (ʏ) \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceCurve3D.java,v 1.35 2000/08/11 06:19:02 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : Ȗʏ̋Ȑ (ʏ) \NXB
 * <p>
 * ̃NX̃CX^X͈ȉ̑ێB
 * <ul>
 * <li> ȏ̂R\ curve3d
 * <li> ȐĂȖ basisSurface1
 * <li> ȏ basisSurface1 ̃p[^Ԃł̂Q\ curve2d1
 * <li> IvVi : ȐĂ̋Ȗ basisSurface2
 * <li> IvVi : ȏ basisSurface2 ̃p[^Ԃł̂Q\ curve2d2
 * <li>	curve3d, curve2d1, curve2d2 ̂D悷邩 masterRepresentation
 *	({@link JgclPreferredSurfaceCurveRepresentation JgclPreferredSurfaceCurveRepresentation})
 * </ul>
 * </p>
 * <p>
 * masterRepresentation ̒l͈ȉ̂ꂩłȂ΂ȂȂB
 * <ul>
 * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_3D
 * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1
 * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2
 * </ul>
 * </p>
 * <p>
 * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂ
 * curve3d  null ł\ȂB
 * </p>
 * <p>
 * basisSurface1  null łĂ͂ȂȂB
 * </p>
 * <p>
 * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1 łȂ
 * curve2d1  null ł\ȂB
 * </p>
 * <p>
 * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2 łȂ
 * basisSurface2  null ł\ȂB
 * </p>
 * <p>
 * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2 łȂ
 * curve2d2  null ł\ȂB
 * </p>
 *
 * @version $Revision: 1.35 $, $Date: 2000/08/11 06:19:02 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSurfaceCurve3D extends JgclParametricCurve3D {

    /**
     * ȏ̂R\B
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂ
     * curve3d  null ł\ȂB
     * </p>
     * @serial
     */
    private JgclParametricCurve3D curve3d;

    /**
     * ȐĂȖʁB
     * <p>
     * basisSurface1  null łĂ͂ȂȂB
     * </p>
     * @serial
     */
    private JgclParametricSurface3D basisSurface1;

    /**
     * ȏ basisSurface1 ̃p[^Ԃł̂Q\B
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1 łȂ
     * curve2d1  null ł\ȂB
     * </p>
     * @serial
     */
    private JgclParametricCurve2D curve2d1;

    /**
     * ȐĂ̋ȖʁB
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2 łȂ
     * basisSurface2  null ł\ȂB
     * </p>
     * @serial
     */
    private JgclParametricSurface3D basisSurface2;

    /**
     * ȏ basisSurface2 ̃p[^Ԃł̂Q\B
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2 łȂ
     * curve2d2  null ł\ȂB
     * </p>
     * @serial
     */
    private JgclParametricCurve2D curve2d2;

    /**
     * curve3d, curve2d1, curve2d2 ̂D悷邩B
     * <p>
     * masterRepresentation ̒l͈ȉ̂ꂩłȂ΂ȂȂB
     * <ul>
     * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_3D
     * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1
     * <li>	JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2
     * </ul>
     * </p>
     * @serial
     * @see JgclPreferredSurfaceCurveRepresentation
     */
    private int masterRepresentation;

    /**
     * ʏ̂R\ƈ̋Ȗʂɑ΂Q\^ăIuWFNg\zB
     * <p>
     * \zCX^X̊etB[hɑl͈ȉ̒ʂB
     * <pre>
     * 		this.curve3d = curve3d;
     * 		this.basisSurface1 = basisSurface;
     * 		this.curve2d1 = curve2d;
     * 		this.basisSurface2 = null;
     * 		this.curve2d2 = null;
     * 		this.masterRepresentation = masterRepresentation;
     * </pre>
     * </p>
     * <p>
     * curve3d, curve2d ̗҂̒l null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * <p>
     * basisSurface  null łĂ͂ȂB
     * basisSurface  null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_3D łƂɂ
     * curve3d  null łĂ͂ȂB
     * ̏Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1 łƂɂ
     * curve2d  null łĂ͂ȂB
     * ̏Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒lL̂łȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param curve3d	R\
     * @param basisSurface	ȐĂȖ
     * @param curve2d	basisSurface ̃p[^Ԃł̂Q\
     * @param masterRepresentation	curve3d  curve2d ̂ǂD悷邩萔
     * @see	JgclPreferredSurfaceCurveRepresentation
     * @see	JgclNullArgument
     * @see	JgclInvalidArgumentValue
     */
    public JgclSurfaceCurve3D(JgclParametricCurve3D curve3d,
			      JgclParametricSurface3D basisSurface,
			      JgclParametricCurve2D curve2d,
			      int masterRepresentation)
    {
	super();
	if (curve3d == null && curve2d == null)
	    throw new JgclNullArgument();

	if (basisSurface == null)
	    throw new JgclNullArgument();

	switch (masterRepresentation) {
	case JgclPreferredSurfaceCurveRepresentation.CURVE_3D:
	    if (curve3d == null)
		throw new JgclInvalidArgumentValue();
	    break;
	case JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1:
	    if (curve2d == null)
		throw new JgclInvalidArgumentValue();
	    break;
	default:
	    throw new JgclInvalidArgumentValue();
	}
	this.curve3d = curve3d;
	this.basisSurface1 = basisSurface;
	this.curve2d1 = curve2d;
	this.basisSurface2 = null;
	this.curve2d2 = null;
	this.masterRepresentation = masterRepresentation;
    }

    /**
     * ʏ̂R\Ɠ̋Ȗʂɑ΂Q\^ăIuWFNg\zB
     * <p>
     * \zCX^X̊etB[hɑl͈ȉ̒ʂB
     * <pre>
     * 		this.curve3d = curve3d;
     * 		this.basisSurface1 = basisSurface1;
     * 		this.curve2d1 = curve2d1;
     * 		this.basisSurface2 = basisSurface2;
     * 		this.curve2d2 = curve2d2;
     * 		this.masterRepresentation = masterRepresentation;
     * </pre>
     * </p>
     * <p>
     * curve3d, curve2d, curve3d ̎O҂̒l null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * <p>
     * basisSurface1, basisSurface2 ̂ꂩ null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_3D łƂɂ
     * curve3d  null łĂ͂ȂB
     * ̏Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1 łƂɂ
     * curve2d1  null łĂ͂ȂB
     * ̏Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒l JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2 łƂɂ
     * curve2d2  null łĂ͂ȂB
     * ̏Ȃꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation ̒lL̂łȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param curve3d	R\
     * @param basisSurface1	ȐĂȖ
     * @param curve2d1	basisSurface1 ̃p[^Ԃł̂Q\
     * @param basisSurface2	ȐĂ̋Ȗ
     * @param curve2d2	basisSurface2 ̃p[^Ԃł̂Q\
     * @param masterRepresentation	ǂ̋Ȑ\D悷邩萔
     * @see	JgclPreferredSurfaceCurveRepresentation
     * @see	JgclNullArgument
     * @see	JgclInvalidArgumentValue
     */
    protected JgclSurfaceCurve3D(JgclParametricCurve3D curve3d,
				 JgclParametricSurface3D basisSurface1,
				 JgclParametricCurve2D curve2d1,
				 JgclParametricSurface3D basisSurface2,
				 JgclParametricCurve2D curve2d2,
				 int masterRepresentation)
    {
	super();
	if (curve3d == null && curve2d1 == null && curve2d2 == null)
	    throw new JgclNullArgument();

	if (basisSurface1 == null || basisSurface2 == null)
	    throw new JgclNullArgument();

	switch (masterRepresentation) {
	case JgclPreferredSurfaceCurveRepresentation.CURVE_3D:
	    if (curve3d == null)
		throw new JgclInvalidArgumentValue();
	    break;
	case JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1:
	    if (curve2d1 == null)
		throw new JgclInvalidArgumentValue();
	    break;
	case JgclPreferredSurfaceCurveRepresentation.CURVE_2D_2:
	    if (curve2d2 == null)
		throw new JgclInvalidArgumentValue();
	    break;
	default:
	    throw new JgclInvalidArgumentValue();
	}
	this.curve3d = curve3d;
	this.basisSurface1 = basisSurface1;
	this.curve2d1 = curve2d1;
	this.basisSurface2 = basisSurface2;
	this.curve2d2 = curve2d2;
	this.masterRepresentation = masterRepresentation;
    }

    /**
     * ʏ̂R\ƈ̋Ȗʂ^ăIuWFNg\zB
     * <p>
     * \zCX^X̊etB[hɑl͈ȉ̒ʂB
     * <pre>
     * 		this.curve3d = curve3d;
     * 		this.basisSurface1 = basisSurface;
     * 		this.curve2d1 = null;
     * 		this.basisSurface2 = null;
     * 		this.curve2d2 = null;
     * 		this.masterRepresentation = JgclPreferredSurfaceCurveRepresentation.CURVE_3D;
     * </pre>
     * </p>
     * <p>
     * curve3d, basisSurface ̂ꂩ null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * 
     * @param curve3d	R\
     * @param basisSurface	ȐĂȖ
     * @see	JgclPreferredSurfaceCurveRepresentation
     * @see	JgclNullArgument
     */
    public JgclSurfaceCurve3D(JgclParametricCurve3D curve3d,
			      JgclParametricSurface3D basisSurface) {
	super();
	if (curve3d == null || basisSurface == null)
	    throw new JgclNullArgument();
	this.curve3d = curve3d;
	this.basisSurface1 = basisSurface;
	this.curve2d1 = null;
	this.basisSurface2 = null;
	this.curve2d2 = null;
	this.masterRepresentation = JgclPreferredSurfaceCurveRepresentation.CURVE_3D;
    }

    /**
     * ʏ̈̋Ȗʂɑ΂Q\^ăIuWFNg\zB
     * <p>
     * \zCX^X̊etB[hɑl͈ȉ̒ʂB
     * <pre>
     * 		this.curve3d = null;
     * 		this.basisSurface1 = basisSurface;
     * 		this.curve2d1 = curve2d;
     * 		this.basisSurface2 = null;
     * 		this.curve2d2 = null;
     *		this.masterRepresentation = JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1;
     * </pre>
     * </p>
     * <p>
     * curve2d, basisSurface ̂ꂩ null ̏ꍇɂ
     * JgclNullArgument ̗O𔭐B
     * </p>
     * 
     * @param basisSurface	ȐĂȖ
     * @param curve2d	basisSurface ̃p[^Ԃł̂Q\
     * @see	JgclPreferredSurfaceCurveRepresentation
     * @see	JgclNullArgument
     */
    public JgclSurfaceCurve3D(JgclParametricSurface3D basisSurface,
			      JgclParametricCurve2D curve2d) {
	super();
	if (curve2d == null || basisSurface == null)
	    throw new JgclNullArgument();
	this.curve3d = null;
	this.basisSurface1 = basisSurface;
	this.curve2d1 = curve2d;
	this.basisSurface2 = null;
	this.curve2d2 = null;
	this.masterRepresentation = JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1;
    }
						
    /**
     * ̖ʏ̂R\ (curve3d) ԂB
     * <p>
     * null Ԃ邱ƂB
     * </p>
     * 
     * @return	R\ (curve3d)
     */
    public JgclParametricCurve3D curve3d() {
	return this.curve3d;
    }

    /**
     * ̖ʏĂȖ (basisSurface1) ԂB
     * 
     * @return	ȐĂȖ (basisSurface1)
     */
    public JgclParametricSurface3D basisSurface1() {
	return this.basisSurface1;
    }

    /**
     * ̖ʏ basisSurface1 ̃p[^Ԃł̂Q\ (curve2d1) ԂB
     * <p>
     * null Ԃ邱ƂB
     * </p>
     * 
     * @return	basisSurface1 ̃p[^Ԃł̂Q\ (curve2d1)
     */
    public JgclParametricCurve2D curve2d1() {
	return this.curve2d1;
    }

    /**
     * ̖ʏĂ̋Ȗ (basisSurface2) ԂB
     * <p>
     * null Ԃ邱ƂB
     * </p>
     * 
     * @return	ȐĂ̋Ȗ (basisSurface2)
     */
    public JgclParametricSurface3D basisSurface2() {
	return this.basisSurface2;
    }

    /**
     * ̖ʏ basisSurface2 ̃p[^Ԃł̂Q\ (curve2d2) ԂB
     * <p>
     * null Ԃ邱ƂB
     * </p>
     * 
     * @return	basisSurface2 ̃p[^Ԃł̂Q\ (curve2d2)
     */
    public JgclParametricCurve2D curve2d2() {
	return this.curve2d2;
    }

    /**
     * ̖ʏĂȖ (basisSurface1) ԂB
     * 
     * @return	ȐĂȖ (basisSurface1)
     */
    public JgclParametricSurface3D basisSurface() {
	return basisSurface1();
    }

    /**
     * ̖ʏ basisSurface1 ̃p[^Ԃł̂Q\ (curve2d1) ԂB
     * <p>
     * null Ԃ邱ƂB
     * </p>
     * 
     * @return	basisSurface1 ̃p[^Ԃł̂Q\ (curve2d1)
     */
    public JgclParametricCurve2D curve2d() {
	return curve2d1();
    }

    /**
     * ̖ʏɂāA̋Ȑ\D悷邩ԂB
     * 
     * @return	̋Ȑ\D悷邩
     * @see	JgclPreferredSurfaceCurveRepresentation
     */
    public int masterRepresentation() {
	return this.masterRepresentation;
    }

    /**
     * ̋Ȑ́A^ꂽp[^Ԃɂԏł̒ (̂) ԂB
     * 
     * @param pint	߂p[^
     * @return		w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().length(pint);

	JgclRealFunctionWithOneVariable realFunction
	    = new JgclRealFunctionWithOneVariable() {
	    public double evaluate(double parameter) {
		return tangentVector(parameter).length();
	    }
	};
        double dTol = getToleranceForDistance() / 2.0;

	return JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().coordinates(param);

	JgclParametricCurve2D curve2d;
	JgclParametricSurface3D basisSurface;
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1) {
	    basisSurface = basisSurface1();
	    curve2d = curve2d1();
	} else {
	    basisSurface = basisSurface2();
	    curve2d = curve2d2();
	}

	JgclPoint2D paramS = curve2d.coordinates(param);
	return basisSurface.coordinates(paramS.x(), paramS.y());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().tangentVector(param);

	JgclParametricCurve2D curve2d;
	JgclParametricSurface3D basisSurface;
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1) {
	    basisSurface = basisSurface1();
	    curve2d = curve2d1();
	} else {
	    basisSurface = basisSurface2();
	    curve2d = curve2d2();
	}
	JgclVector2D tngC = curve2d.tangentVector(param);
	JgclPoint2D paramS = curve2d.coordinates(param);
	JgclVector3D[] tngS = basisSurface.tangentVector(paramS.x(), paramS.y());
	return tngS[0].multiply(tngC.x()).add(tngS[1].multiply(tngC.y()));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclNotSupported
     */
    public JgclCurveCurvature3D curvature(double param) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().curvature(param);

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclNotSupported
     */
    public JgclCurveDerivative3D evaluation(double param) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().evaluation(param);

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     * @see	JgclNotSupported
     */
    public double torsion(double param) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().torsion(param);

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return		ٓ_̔z
     * @exception	JgclIndefiniteSolution	ȐŜkނĂ
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] singular()
	throws JgclIndefiniteSolution
    {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D) {
	    JgclPointOnCurve3D[] sol;
	    try {
		sol = curve3d().singular();
	    } catch (JgclIndefiniteSolution e) {
		JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
		sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), doCheckDebug);
		throw new JgclIndefiniteSolution(sol1);
	    }
	    for (int i = 0; i < sol.length; i++) {
		sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), doCheckDebug);
	    }
	    return sol;
	}

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł (̋Ȑ͒ł)
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] inflexion()
	throws JgclIndefiniteSolution
    {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D) {
	    JgclPointOnCurve3D[] sol;
	    try {
		sol = curve3d().inflexion();
	    } catch (JgclIndefiniteSolution e) {
		JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
		sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), doCheckDebug);
		throw new JgclIndefiniteSolution(sol1);
	    }
	    for (int i = 0; i < sol.length; i++) {
		sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), doCheckDebug);
	    }
	    return sol;
	}

	throw new JgclNotSupported();
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param point	e̓_
     * @return	e_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D) {
	    JgclPointOnCurve3D[] sol;
	    try {
		sol = curve3d().projectFrom(point);
	    } catch (JgclIndefiniteSolution e) {
		JgclPointOnCurve3D sol1 = (JgclPointOnCurve3D)e.suitable();
		sol1 = new JgclPointOnCurve3D(this, sol1.parameter(), doCheckDebug);
		throw new JgclIndefiniteSolution(sol1);
	    }
	    for (int i = 0; i < sol.length; i++) {
		sol[i] = new JgclPointOnCurve3D(this, sol[i].parameter(), doCheckDebug);
	    }
	    return sol;
	}

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclNotSupported
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D) {
	    JgclPolyline3D pol = curve3d().toPolyline(pint, tol);
	    int nPnts = pol.nPoints();
	    JgclPoint3D[] pnts = new JgclPoint3D[nPnts];
	    JgclPointOnCurve3D poc;
	    for (int i = 0; i < nPnts; i++) {
		poc = (JgclPointOnCurve3D)pol.pointAt(i);
		pnts[i] = new JgclPointOnCurve3D(this, poc.parameter(), doCheckDebug);
	    }
	    return new JgclPolyline3D(pnts, pol.closed());
	}

	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclNotSupported
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().toBsplineCurve(pint);

	throw new JgclNotSupported();
    }

    /**
     * ̖ʏƂ̋Ȑ^Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ܂͋Ȗ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    private JgclIntersectionPoint3D[] doIntersection(JgclGeometry mate,
						     boolean doExchange)
	throws JgclIndefiniteSolution
    {
	if (!mate.is3D() || !mate.isParametric() || mate.isPoint())
	    throw new JgclFatal();

	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D) {
	    JgclIntersectionPoint3D[] sol;
	    try {
		if (mate.isCurve())
		    sol = curve3d().intersect((JgclParametricCurve3D)mate);
		else
		    sol = curve3d().intersect((JgclParametricSurface3D)mate);
	    } catch (JgclIndefiniteSolution e) {
		JgclIntersectionPoint3D sol1 = (JgclIntersectionPoint3D)e.suitable();
		sol1 = (JgclIntersectionPoint3D)sol1.changeCurve1(this);
		if (doExchange)
		    sol1 = sol1.exchange();
		throw new JgclIndefiniteSolution(sol1);
	    }
	    for (int i = 0; i < sol.length; i++) {
		sol[i] = (JgclIntersectionPoint3D)sol[i].changeCurve1(this);
		if (doExchange)
		    sol[i] = sol[i].exchange();
	    }

	    return sol;
	}

	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ܂̂Ƃ
     * masterRepresentation  JgclPreferredSurfaceCurveRepresentation.CURVE_3D łȂꍇɂ
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, false);
    }

    /**
     * ̋Ȗ(͓IȖ)Ƃ̌_𓾂(internal use)
     * 
     * @param mate	̋Ȗ
     * @param doExchange _pointOnCurve1,2邩ǂ
     * @return		_̔z
     * @see		JgclIntersectionPoint3D
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					       boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋Ȗ(BezierȖ)Ƃ̌_𓾂(internal use)
     * 
     * @param mate	̋Ȗ
     * @param doExchange _pointOnCurve1,2邩ǂ
     * @return		_̔z
     * @see		JgclIntersectionPoint3D
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					       boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋Ȗ(BsplineȖ)Ƃ̌_𓾂(internal use)
     * 
     * @param mate	̋Ȗ
     * @param doExchange _pointOnCurve1,2邩ǂ
     * @return		_̔z
     * @see		JgclIntersectionPoint3D
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					       boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return doIntersection(mate, doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     * <p>
     * ܂̂ƂÃ\bh͏
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     * @see	JgclNotSupported
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().getParameterDomain();

	JgclParametricCurve2D curve2d;
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1)
	    curve2d = curve2d1();
	else
	    curve2d = curve2d2();

	return curve2d.getParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     *
     * @return	􉽓IɕĂ trueAłȂ false
     */
    boolean getClosedFlag() {
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
	    return curve3d().getClosedFlag();

	JgclParametricCurve2D curve2d;
	JgclParametricSurface3D basisSurface;
	if (masterRepresentation() == JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1) {
	    basisSurface = basisSurface1();
	    curve2d = curve2d1();
	} else {
	    basisSurface = basisSurface2();
	    curve2d = curve2d2();
	}
	if (curve2d.isPeriodic())
	    return true;
	if (curve2d.isInfinite())
	    return false;

	JgclParameterSection section = curve2d.parameterDomain().section();
	if (coordinates(section.start()).identical(coordinates(section.end())))
	    return true;

	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#SURFACE_CURVE_3D JgclParametricCurve3D.SURFACE_CURVE_3D}
     */
    int type() {
	return SURFACE_CURVE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     * <p>
     * ܂̂ƂÃ\bh͏
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     * @see	JgclNotSupported
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     * <p>
     * ܂̂ƂÃ\bh͏
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricCurve3D tCurve3d = this.curve3d;
	JgclParametricSurface3D tBasisSurface1 = this.basisSurface1;
	JgclParametricSurface3D tBasisSurface2 = this.basisSurface2;

	if (tCurve3d != null)
	    tCurve3d = tCurve3d.transformBy(reverseTransform,
					    transformationOperator,
					    transformedGeometries);
	if (tBasisSurface1 != null)
	    tBasisSurface1 = tBasisSurface1.transformBy(reverseTransform,
							transformationOperator,
							transformedGeometries);
	if (tBasisSurface2 != null)
	    tBasisSurface2 = tBasisSurface2.transformBy(reverseTransform,
							transformationOperator,
							transformedGeometries);

	return new JgclSurfaceCurve3D(tCurve3d,
				      tBasisSurface1, this.curve2d1,
				      tBasisSurface2, this.curve2d2,
				      this.masterRepresentation);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
	if (curve3d != null) {
	    writer.println(indent_tab + "\tcurve3d");
	    curve3d.output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tbasisSurface1");
        basisSurface1.output(writer, indent + 2);
	if (curve2d1 != null) {
	    writer.println(indent_tab + "\tcurve2d1");
	    curve2d1.output(writer, indent + 2);
	}
	if (basisSurface2 != null) {
	    writer.println(indent_tab + "\tbasisSurface2");
	    basisSurface2.output(writer, indent + 2);
	    if (curve2d2 != null) {
		writer.println(indent_tab + "\tcurve2d2");
		curve2d2.output(writer, indent + 2);
	    }
	}
        writer.println(indent_tab + "\tmasterRepresentation\t"
                       + JgclPreferredSurfaceCurveRepresentation.toString(masterRepresentation));
        writer.println(indent_tab + "End");
    }
}

