/*
 * 3D|C̎Ȋ߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSelfIntsPol3D.java,v 1.3 2000/04/26 09:39:23 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D|C̎Ȋ߂NX
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:39:23 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclSelfIntsPol3D {
    private JgclPolyline3D polyline;
    private JgclVector3D[] polylineUvecs;
    private double[] polylineLengs;
    private JgclEnclosingBox3D polylineEncls;

    private JgclSelfIntsPol3D(JgclPolyline3D polyline) {
	this(polyline, null, null, null);
    }

    private JgclSelfIntsPol3D(JgclPolyline3D polyline,
			      JgclVector3D[] polylineUvecs,
			      double[] polylineLengs,
			      JgclEnclosingBox3D polylineEncls) {
	super();

	this.polyline = polyline;
	this.polylineUvecs = polylineUvecs;
	this.polylineLengs = polylineLengs;
	this.polylineEncls = polylineEncls;
    }

    private class SegmentInfo {
	private JgclBoundedLine3D bln;	/* a segment */
	private JgclVector3D udir;	/* unitized vector */
	private double leng;		/* length of segment */
	private double tol;		/* tolerance */
	private JgclEnclosingBox3D box;	/* enclosing box */

	private SegmentInfo(JgclPoint3D spnt,
			    JgclPoint3D epnt,
			    JgclVector3D udir,
			    double leng) {
	    super();
	    double d_tol = spnt.getToleranceForDistance();

	    bln = new JgclBoundedLine3D(spnt, epnt);
	    if (udir == null) {
		this.udir = bln.unitizedDirection();
		this.leng = bln.length();
	    } else {
		this.udir = udir;
		this.leng = leng;
	    }
	    if (this.leng < d_tol) {
		this.tol = -1.0;
	    } else {
		this.tol = d_tol / this.leng;
	    }
	    box = bln.enclosingBox();
	}

	private SegmentInfo(JgclPoint3D spnt,
			    JgclPoint3D epnt) {
	    this(spnt, epnt, null, 0.0);
	}
    }

    private JgclCurveCurveInterferenceList getInterference() {
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(polyline, polyline);

	int nSegments = polyline.nSegments();	/* # of segments */
	if (nSegments < 3) {
	    return interferenceList;
	}

	SegmentInfo[] segmentInfo;		/* array of segments */

	JgclCurveCurveInterference3D intf;

	int i, j;			/* loop counter */

	segmentInfo = new SegmentInfo[nSegments];
	for (i = 0; i < nSegments; i++) {
	    if (polylineUvecs == null)
		segmentInfo[i] = new SegmentInfo(polyline.pointAt(i), polyline.pointAt(i+1));
	    else
		segmentInfo[i] = new SegmentInfo(polyline.pointAt(i), polyline.pointAt(i+1),
					 polylineUvecs[i], polylineLengs[i]);
	}

	for (i = 0; i < nSegments; i++) {
	    if (segmentInfo[i].tol < 0.0)
		continue;

	    for (j = i + 1; j < nSegments; j++) {
		if (segmentInfo[j].tol < 0.0)
		    continue;

		if (!segmentInfo[i].box.hasIntersection(segmentInfo[j].box))
		    continue;

		intf = segmentInfo[i].bln.interfere1(segmentInfo[j].bln,
						     segmentInfo[i].udir, segmentInfo[j].udir,
						     segmentInfo[i].leng, segmentInfo[j].leng);
		if (intf == null)
		    continue;

		if (intf.isIntersectionPoint()) {
		    /*
		     * intersect
		     */
		    if (((i + 1) == j) ||
			((polyline.isPeriodic() == true) && (i == 0) && (j == (nSegments - 1))))
			continue;

		    JgclIntersectionPoint3D ints = intf.toIntersectionPoint();
		    interferenceList.addAsIntersection
			(ints.coordinates(),
			 ints.pointOnCurve1().parameter() + i,
			 ints.pointOnCurve2().parameter() + j,
			 segmentInfo[i].tol, segmentInfo[j].tol);
		} else {
		    /*
		     * overlap
		     */
		    JgclOverlapCurve3D ovlp = intf.toOverlapCurve();
		    interferenceList.addAsOverlap
			(ovlp.start1() + i,
			 ovlp.start2() + j,
			 ovlp.increase1(),
			 ovlp.increase2(),
			 segmentInfo[i].tol, segmentInfo[j].tol,
			 segmentInfo[i].tol, segmentInfo[j].tol);
		}
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * |C̎Ȍ𓾂
     *
     * @param polyline	|C
     * @return		_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclPolyline3D polyline)
    {
	JgclSelfIntsPol3D doObj = new JgclSelfIntsPol3D(polyline);
	return doObj.getInterference().toJgclIntersectionPoint3DArray(false);
    }

    /**
     * |C̎Ȋ𓾂
     *
     * @param polyline	|C
     * @return		̔z
     * @see		JgclCurveCurveInterference3D
     */
    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D polyline)
    {
	JgclSelfIntsPol3D doObj = new JgclSelfIntsPol3D(polyline);
	return doObj.getInterference().toJgclCurveCurveInterference3DArray(false);
    }

    /**
     * |C̎Ȋ𓾂()
     *
     * @param polyline	|C
     * @param polylineUvecs	eZOg̐KxNg
     * @param polylineLengs	eZOg̒
     * @param polylineEncls	|C̑ݔ͈͂`
     * @return		̔z
     * @see		JgclCurveCurveInterference3D
     * @see		JgclPolyline3D
     * @see		JgclVector3D
     * @see		JgclEnclosingBox3D
     */
    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D polyline,
						       JgclVector3D[] polylineUvecs,
						       double[] polylineLengs,
						       JgclEnclosingBox3D polylineEncls)
    {
	JgclSelfIntsPol3D doObj =
	    new JgclSelfIntsPol3D(polyline, polylineUvecs, polylineLengs, polylineEncls);
	return doObj.getInterference().toJgclCurveCurveInterference3DArray(false);
    }
}
