/*
 * 2D|C̎Ȋ߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSelfIntsPol2D.java,v 1.3 2000/04/26 09:39:23 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2D|C̎Ȋ߂NX
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:39:23 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclSelfIntsPol2D {
    private JgclPolyline2D polyline;
    private JgclVector2D[] polylineUvecs;
    private double[] polylineLengs;
    private JgclEnclosingBox2D polylineEncls;

    private JgclSelfIntsPol2D(JgclPolyline2D polyline) {
	this(polyline, null, null, null);
    }

    private JgclSelfIntsPol2D(JgclPolyline2D polyline,
			      JgclVector2D[] polylineUvecs,
			      double[] polylineLengs,
			      JgclEnclosingBox2D polylineEncls) {
	super();

	this.polyline = polyline;
	this.polylineUvecs = polylineUvecs;
	this.polylineLengs = polylineLengs;
	this.polylineEncls = polylineEncls;
    }

    private class SegmentInfo {
	private JgclBoundedLine2D bln;	/* a segment */
	private JgclVector2D udir;	/* unitized vector */
	private double leng;		/* length of segment */
	private double tol;		/* tolerance */
	private JgclEnclosingBox2D box;	/* enclosing box */

	private SegmentInfo(JgclPoint2D spnt,
			    JgclPoint2D epnt,
			    JgclVector2D udir,
			    double leng) {
	    super();
	    double d_tol = spnt.getToleranceForDistance();

	    bln = new JgclBoundedLine2D(spnt, epnt);
	    if (udir == null) {
		this.udir = bln.unitizedDirection();
		this.leng = bln.length();
	    } else {
		this.udir = udir;
		this.leng = leng;
	    }
	    if (this.leng < d_tol) {
		this.tol = -1.0;
	    } else {
		this.tol = d_tol / this.leng;
	    }
	    box = bln.enclosingBox();
	}

	private SegmentInfo(JgclPoint2D spnt,
			    JgclPoint2D epnt) {
	    this(spnt, epnt, null, 0.0);
	}
    }

    private JgclCurveCurveInterferenceList getInterference() {
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(polyline, polyline);

	int nSegments = polyline.nSegments();	/* # of segments */
	if (nSegments < 3) {
	    return interferenceList;
	}

	SegmentInfo[] segmentInfo;		/* array of segments */

	JgclCurveCurveInterference2D intf;

	int i, j;			/* loop counter */

	segmentInfo = new SegmentInfo[nSegments];
	for (i = 0; i < nSegments; i++) {
	    if (polylineUvecs == null)
		segmentInfo[i] = new SegmentInfo(polyline.pointAt(i), polyline.pointAt(i+1));
	    else
		segmentInfo[i] = new SegmentInfo(polyline.pointAt(i), polyline.pointAt(i+1),
					 polylineUvecs[i], polylineLengs[i]);
	}

	for (i = 0; i < nSegments; i++) {
	    if (segmentInfo[i].tol < 0.0)
		continue;

	    for (j = i + 1; j < nSegments; j++) {
		if (segmentInfo[j].tol < 0.0)
		    continue;

		if (!segmentInfo[i].box.hasIntersection(segmentInfo[j].box))
		    continue;

		intf = segmentInfo[i].bln.interfere1(segmentInfo[j].bln,
						     segmentInfo[i].udir, segmentInfo[j].udir,
						     segmentInfo[i].leng, segmentInfo[j].leng);
		if (intf == null)
		    continue;

		if (intf.isIntersectionPoint()) {
		    /*
		     * intersect
		     */
		    if (((i + 1) == j) ||
			((polyline.isPeriodic() == true) && (i == 0) && (j == (nSegments - 1))))
			continue;

		    JgclIntersectionPoint2D ints = intf.toIntersectionPoint();
		    interferenceList.addAsIntersection
			(ints.coordinates(),
			 ints.pointOnCurve1().parameter() + i,
			 ints.pointOnCurve2().parameter() + j,
			 segmentInfo[i].tol, segmentInfo[j].tol);
		} else {
		    /*
		     * overlap
		     */
		    JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
		    interferenceList.addAsOverlap
			(ovlp.start1() + i,
			 ovlp.start2() + j,
			 ovlp.increase1(),
			 ovlp.increase2(),
			 segmentInfo[i].tol, segmentInfo[j].tol,
			 segmentInfo[i].tol, segmentInfo[j].tol);
		}
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * |C̎Ȍ𓾂
     *
     * @param polyline	|C
     * @return		_̔z
     * @see		JgclIntersectionPoint2D
     */
    static JgclIntersectionPoint2D[] intersection(JgclPolyline2D polyline)
    {
	JgclSelfIntsPol2D doObj = new JgclSelfIntsPol2D(polyline);
	return doObj.getInterference().toJgclIntersectionPoint2DArray(false);
    }

    /**
     * |C̎Ȋ𓾂
     *
     * @param polyline	|C
     * @return		̔z
     * @see		JgclCurveCurveInterference2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D polyline)
    {
	JgclSelfIntsPol2D doObj = new JgclSelfIntsPol2D(polyline);
	return doObj.getInterference().toJgclCurveCurveInterference2DArray(false);
    }

    /**
     * |C̎Ȋ𓾂()
     *
     * @param polyline	|C
     * @param polylineUvecs	eZOg̐KxNg
     * @param polylineLengs	eZOg̒
     * @param polylineEncls	|C̑ݔ͈͂`
     * @return		̔z
     * @see		JgclCurveCurveInterference2D
     * @see		JgclPolyline2D
     * @see		JgclVector2D
     * @see		JgclEnclosingBox2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D polyline,
						       JgclVector2D[] polylineUvecs,
						       double[] polylineLengs,
						       JgclEnclosingBox2D polylineEncls)
    {
	JgclSelfIntsPol2D doObj =
	    new JgclSelfIntsPol2D(polyline, polylineUvecs, polylineLengs, polylineEncls);
	return doObj.getInterference().toJgclCurveCurveInterference2DArray(false);
    }
}
