/*
 * R : L () xWGȖʂїLxWGȖʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPureBezierSurface3D.java,v 1.65 2000/08/11 06:19:01 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : L () xWGȖʂїLxWGȖʂ\NXB
 * <p>
 * ̃NXɓLȑ\tB[h͓ɂȂB
 * _ȂǂێtB[hɂẮA
 * {@link JgclFreeformSurfaceWithControlPoints3D X[p[NX̉} QƁB
 * </p>
 * <p>
 * xWGȖʂ̃p[^` U/V ƂɗLŔIłA
 * ̗LԂ [0, 1] łB
 * </p>
 * <p>
 * (u, v) p[^ƂxWGȖ P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	m = U ̐_̐ - 1
 *	n = V ̐_̐ - 1
 *	bi,j = controlPoints[i][j]
 *	wi,j = weights[i][j]
 * </pre>
 * ƂāALxWGȖʂ
 * <pre>
 *	P(u, v) = ((bi,j * Bm,i(u)) ̑a) * Bn,j(v) ̑a	(i = 0, ..., m, j = 0, ..., n)
 * </pre>
 * LxWGȖʂ
 * <pre>
 *		  ((wi,j * bi,j * Bm,i(u)) ̑a) * Bn,j(v) ̑a
 *	P(u, v) = ------------------------------------------------- 	(i = 0, ..., m, j = 0, ..., n)
 *		  ((wi,j * Bm,i(u)) ̑a) * Bn,j(v) ̑a
 * </pre>
 *  Bm,i(u), Bn,j(v) ̓o[X^C֐łB
 * </p>
 *
 * @version $Revision: 1.65 $, $Date: 2000/08/11 06:19:01 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPureBezierSurface3D extends JgclFreeformSurfaceWithControlPoints3D {
    /**
     * _^đȖʂƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][])
     * super}(controlPoints)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔z
     */
    public JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints) {
	super(controlPoints);
    }

    /**
     * _Ədݗ^ėLȖʂƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][])
     * super}(controlPoints, weights)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔z
     * @param weights		d݂̔z
     */
    public JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints, double[][] weights) {
	super(controlPoints, weights);
    }

    /**
     * _Ədݗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][], boolean)
     * super}(controlPoints, weights, doCheck)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔zB
     * @param weights		d݂̔z
     * @param doCheck		̃`FbN邩ǂ
     */
    JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints,
			    double[][] weights,
			    boolean doCheck) {
	super(controlPoints, weights, doCheck);
    }

    /**
     * _ (Əd) Ozŗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(double[][][])
     * super}(cpArray)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param cpArray	_ (яd) ̔z
     */
    JgclPureBezierSurface3D(double[][][] cpArray) {
	super(cpArray);
    }

    /**
     * _ (Əd) Ozŗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(double[][][], boolean)
     * super}(cpArray, doCheck)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param cpArray	_ (яd) ̔z
     * @param doCheck		̃`FbN邩ǂ
     */
    JgclPureBezierSurface3D(double[][][] cpArray,
			    boolean doCheck) {
	super(cpArray, doCheck);
    }

    /**
     * ̋Ȗʂ U ̎ԂB
     * 
     * @return	U ̎
     */
    public int uDegree() {
	return uNControlPoints() - 1;
    }

    /**
     * ̋Ȗʂ V ̎ԂB
     * 
     * @return	V ̎
     */
    public int vDegree() {
	return vNControlPoints() - 1;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp, vUicp;
	double[][] bzc;
	double[] d0D;
	boolean isPoly = isPolynomial();

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	vUicp = cntlPnts[0].length;
	bzc = new double[uUicp][];

	/*
	 * evaluate for V-direction
	 */
	for (int i = 0; i < uUicp; i++) {
	    bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
	}

	/*
	 * evaluate for U-direction
	 */
	d0D = JgclPureBezierCurveEvaluation.coordinates(bzc, uParam);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint3D(d0D);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp, vUicp;
	double[][] pp, dd, tt;
	double[][] ld1D = new double[2][];
	JgclVector3D[] d1D = new JgclVector3D[2];
	boolean isPoly = isPolynomial();

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	vUicp = cntlPnts[0].length;
	pp = new double[uUicp][4];
	tt = new double[uUicp][4];

	/*
	 * evaluate for V-direction
	 */
	for (int i = 0; i < uUicp; i++) {
	    JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam,
						     pp[i], tt[i], null, null);
	}

	/*
	 * evaluate for U-direction
	 */
	ld1D[0] = new double[4];
	if (isPoly) {
	    JgclPureBezierCurveEvaluation.evaluation(pp, uParam, null, ld1D[0], null, null);
	    ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
	} else {
	    double[] ld0D = new double[4];
	    JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0D, ld1D[0], null, null);
	    ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
	    convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
	}
	for (int i = 0; i < 2; i++) {
	    d1D[i] = new JgclLiteralVector3D(ld1D[i]);
	}
	return d1D;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp, vUicp;
	double[][] pp, tt, dd;
	double[] ld0, ldu, ldv, lduu, lduv, ldvv;
	JgclPoint3D d0;
	JgclVector3D du, dv, duu, duv, dvv;
	boolean isPoly = isPolynomial();

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	vUicp = cntlPnts[0].length;
	pp = new double[uUicp][4];
	tt = new double[uUicp][4];
	dd = new double[uUicp][4];

	/*
	 * evaluate for V-direction
	 */
	for (int i = 0; i < uUicp; i++) {
	    JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam,
						     pp[i], tt[i], dd[i], null);
	}

	/*
	 * evaluate for U-direction
	 */
	ldv = new double[4];
	lduv = new double[4];
	JgclPureBezierCurveEvaluation.evaluation(tt, uParam, ldv, lduv, null, null);
	ldvv = JgclPureBezierCurveEvaluation.coordinates(dd, uParam);
	ld0 = new double[4];
	ldu = new double[4];
	lduu = new double[4];
	JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0, ldu, lduu, null);

	if (!isPoly) {
	    convRational2Deriv(ld0, ldu, ldv, lduu, lduv, ldvv);
	}

	d0 = new JgclCartesianPoint3D(ld0);
	du = new JgclLiteralVector3D(ldu);
	dv = new JgclLiteralVector3D(ldv);
	duu = new JgclLiteralVector3D(lduu);
	duv = new JgclLiteralVector3D(lduv);
	dvv = new JgclLiteralVector3D(ldvv);
	return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
    {
	return JgclProjPntBzs3D.projection(point, this);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     * @see	#truncate(JgclParameterSection, JgclParameterSection)
     * @see	#toMesh(JgclToleranceForDistance)
     */
    public JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol)
    {
	JgclPureBezierSurface3D t_bzs;
	JgclMesh3D Mesh;
	JgclPoint3D[][] mesh;
	int u_npnts, v_npnts;
	double uSp, uIp, vSp, vIp;
	double uParam, vParam;
	int i, j;

	t_bzs = truncate(uPint, vPint);
	Mesh = t_bzs.toMesh(tol);

	uSp = uPint.start();
	uIp = uPint.increase();
	vSp = vPint.start();
	vIp = vPint.increase();

	u_npnts = Mesh.uNPoints();
	v_npnts = Mesh.vNPoints();
	mesh = Mesh.points();

	for (i = 0; i < u_npnts; i++) {
	    for (j = 0; j < v_npnts; j++) {
		uParam = uSp + uIp * ((JgclPointOnSurface3D)mesh[i][j]).uParameter();
		vParam = vSp + vIp * ((JgclPointOnSurface3D)mesh[i][j]).vParameter();
		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
	    }
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
	JgclFreeformSurfaceWithControlPoints3D.SegInfo seg_info; /* a SegInfo */

	JgclFreeformSurfaceWithControlPoints3D.GpList u_gp_list; /* list of MeshParam for U dir. */
	JgclFreeformSurfaceWithControlPoints3D.GpList v_gp_list; /* list of MeshParam for V dir. */

	double[] kp = new double[2];		/* parameter interval */

	/*
	 * divide Bezier into planes and determine mesh.
	 */
	u_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();
	v_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();

	seg_info = new JgclFreeformSurfaceWithControlPoints3D.SegInfo
	    (new MeshParam(0, 0, 1), new MeshParam(0, 1, 1),
	     new MeshParam(0, 0, 1), new MeshParam(0, 1, 1));

	getSrfMesh(seg_info, tol, u_gp_list, v_gp_list);

	/*
	 * make parameters and mesh points
	 */
	kp[0] = 0.0;
	kp[1] = 1.0;
	return makeParamAndMesh(u_gp_list, v_gp_list, kp, kp);
    }

    /**
     * ̋Ȗʂ^ꂽxɂĕʂƌȂȂꍇɁA
     * U/V Ƀp[^_œ񕪊B
     * <p>
     * ʂƂēz S ̗vf̐ 4 łB
     * evf́A̋Ȗʂ𕪊Ȗʂ̂ꂼ\B
     * <p>
     * ^ꂽ tol ɂāAȖʂ𕪊KvȂꍇɂ
     * S[i] (i = 0, ..., 3) ɂׂ͂ null B
     * </p>
     * <p>
     * Ȗʂ U/V Ƃɓ񕪊ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U AV ɂȖ
     *		S[1] : U 㑤AV ɂȖ
     *		S[2] : U AV 㑤ɂȖ
     *		S[3] : U 㑤AV 㑤ɂȖ
     * </pre>
     * </p>
     * <p>
     * Ȗʂ U ɂ̂ݓ񕪊 (V ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U ɂȖ
     *		S[1] : U 㑤ɂȖ
     *		S[2] : null
     *		S[3] : null
     * </pre>
     * </p>
     * <p>
     * Ȗʂ V ɂ̂ݓ񕪊 (U ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : V ɂȖ
     *		S[1] : null
     *		S[2] : V 㑤ɂȖ
     *		S[3] : null
     * </pre>
     * </p>
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ꂽȖʂ̔z
     */
    JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance tol) {
	boolean u_coln;
	boolean v_coln;

	JgclPureBezierSurface3D[] bzss;
	JgclPureBezierSurface3D vb_bzs;
	JgclPureBezierSurface3D vu_bzs;
	JgclPureBezierSurface3D lb_bzs;
	JgclPureBezierSurface3D rb_bzs;
	JgclPureBezierSurface3D lu_bzs;
	JgclPureBezierSurface3D ru_bzs;

	double told = tol.value();

	u_coln = uIsColinear(controlPoints, told);
	v_coln = vIsColinear(controlPoints, told);

	try {
	    if (u_coln && v_coln) {
		lb_bzs = null;
		rb_bzs = null;
		lu_bzs = null;
		ru_bzs = null;

	    } else if ((!u_coln) && (!v_coln)) {
		bzss = vDivide(0.5);
		vb_bzs = bzss[0];
		vu_bzs = bzss[1];
	    
		bzss = vb_bzs.uDivide(0.5);
		lb_bzs = bzss[0];
		rb_bzs = bzss[1];

		bzss = vu_bzs.uDivide(0.5);
		lu_bzs = bzss[0];
		ru_bzs = bzss[1];

	    } else if (u_coln) {
		bzss = vDivide(0.5);
		lb_bzs = bzss[0];
		lu_bzs = bzss[1];

		rb_bzs = null;
		ru_bzs = null;

	    } else {	// if (v_coln)
		bzss = uDivide(0.5);
		lb_bzs = bzss[0];
		rb_bzs = bzss[1];

		lu_bzs = null;
		ru_bzs = null;
	    }
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}

	bzss = new JgclPureBezierSurface3D[4];

	bzss[0] = lb_bzs;
	bzss[1] = rb_bzs;
	bzss[2] = lu_bzs;
	bzss[3] = ru_bzs;

	return bzss;
    }

    /**
     * ̋Ȗʂʌ`Ƃ݂Ȃ邩ǂԂB
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ʂƂ݂ȂȂ trueAłȂ false
     * @see	#makeRefPln()
     */
    boolean isPlaner(JgclToleranceForDistance tol) {
	int u_uicp = uNControlPoints();
	int v_uicp = vNControlPoints();
	JgclPlane3D pln;

	JgclVector3D evec;
	double tolerance = tol.value();
	int i, j;

	if ((pln = makeRefPln()) == null) {
	    return true;
	} else {
	    for (i = 0; i < u_uicp; i++) {
		for (j = 0; j < v_uicp; j++) {
		    evec = controlPointAt(i, j).subtract(pln.position().location());
		    if (Math.abs(evec.dotProduct(pln.position().z())) > tolerance)
			return false;
		}
	    }
	}

	return true;
    }

    /**
     * ̋Ȗʂʌ`Ƃ݂Ȃ邩ǂ𔻒肷ۂ
     * ƂȂ镽ʂ쐬B
     *
     * @return	̋Ȗʂʌ`Ƃ݂Ȃ邩ǂ𔻒肷ۂ̊ƂȂ镽
     * @see	#isPlaner(JgclToleranceForDistance)
     */
    private JgclPlane3D makeRefPln() {
	double tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
	double tol2 = tol * tol;
	double atol = JgclConditionOfOperation.getCondition().getToleranceForAngle();

	JgclPoint3D org;
	JgclVector3D normal;

	getDirInfo uInfo;
	getDirInfo vInfo;

	int u_uicp = uNControlPoints();
	int v_uicp = vNControlPoints();

	boolean found;
	double[] cos_val = new double[4];
	int i;

	cos_val[0] = Math.cos(Math.PI * (1.0 / 3.0));	/* 60 degree */
	cos_val[1] = Math.cos(Math.PI * (1.0 / 4.0));	/* 45 degree */
	cos_val[2] = Math.cos(Math.PI * (1.0 / 6.0));	/* 30 degree */
	cos_val[3] = Math.cos(atol);			/* tolerance */

	org = controlPointAt(0, 0);

	/*
	 * first search
	 */
	found = false;
	uInfo = new getDirInfo();
	vInfo = new getDirInfo();
    first_loop:
	for (i = 0; i < 3; i++) {
	    uInfo.firstCall = true;
	    while (getUDir(org, uInfo, u_uicp, v_uicp, tol2)) {
		vInfo.firstCall = true;
		while (getVDir(org, vInfo, u_uicp, v_uicp, tol2)) {
		    if (Math.abs(uInfo.dir.dotProduct(vInfo.dir)) < cos_val[i]) {
			found = true;
			break first_loop;
		    }
		}
	    }
	}

	/*
	 * second search
	 */
	if (!found) {
	    double leng;
	    JgclVector3D evec;
	    boolean isU;
	    int j, k;

	second_loop:
	    for (i = 0; i < 4; i++) {
		isU = true;
		for (j = 0; j < u_uicp; j++) {
		    for (k = 0; k < v_uicp; k++) {
			if (j == 0 && k == 0) continue;

			evec = controlPointAt(j, k).subtract(org);
			if ((leng = evec.norm()) < tol2)
			    continue;

			leng = Math.sqrt(leng);
			evec = evec.divide(leng);

			if (isU) {
			    isU = false;
			    uInfo.dir = evec;
			    continue;
			}
			vInfo.dir = evec;

			if (Math.abs(uInfo.dir.dotProduct(vInfo.dir)) < cos_val[i]) {
			    found = true;
			    break second_loop;
			}
		    }
		}
	    }
	}

	if (!found) {
	    return null;
	}

	normal = uInfo.dir.crossProduct(vInfo.dir);
	try {
	    return new JgclPlane3D(org, normal);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ U ̐_̐Lт𓾂B
     *
     * @param org	߂ۂ̊ƂȂ_
     * @param info	ĂяoƂƂ肷
     * @param u_uicp	U ̐_̐
     * @param v_uicp	V ̐_̐
     * @param tol2	̋e덷̎l
     * @return	 trueAłȂ false
     * @see	#makeRefPln()
     * @see	#getVDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)
     */
    boolean getUDir(JgclPoint3D org, getDirInfo info, int u_uicp, int v_uicp, double tol2) {
	JgclPoint3D cpnt;
	double leng;

	if (info.firstCall) {
	    info.firstCall = false;
	    info.v = 0;
	    info.u = u_uicp - 1;
	} else {
	    info.u--;
	}

	for (;info.v < v_uicp; info.v++) {
	    for (; info.u > info.v; info.u--) {
		cpnt = controlPointAt(info.u, info.v);
		info.dir = cpnt.subtract(org);
		if ((leng = info.dir.norm()) > tol2) {
		    leng = Math.sqrt(leng);
		    info.dir = info.dir.divide(leng);
		    return true;
		}
	    }

	    info.u = u_uicp - 1;
	}

	return false;
    }

    /**
     * ̋Ȗʂ V ̐_̐Lт𓾂B
     *
     * @param org	߂ۂ̊ƂȂ_
     * @param info	ĂяoƂƂ肷
     * @param u_uicp	U ̐_̐
     * @param v_uicp	V ̐_̐
     * @param tol2	̋e덷̎l
     * @return	 trueAłȂ false
     * @see	#makeRefPln()
     * @see	#getUDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)
     */
    boolean getVDir(JgclPoint3D org, getDirInfo info, int u_uicp, int v_uicp, double tol2) {
	JgclPoint3D cpnt;
	double leng;

	if (info.firstCall) {
	    info.firstCall = false;
	    info.u = 0;
	    info.v = v_uicp - 1;
	} else {
	    info.v--;
	}

	for (;info.u < u_uicp; info.u++) {
	    for (; info.v > info.u; info.v--) {
		cpnt = controlPointAt(info.u, info.v);
		info.dir = cpnt.subtract(org);
		if ((leng = info.dir.norm()) > tol2) {
		    leng = Math.sqrt(leng);
		    info.dir = info.dir.divide(leng);
		    return true;
		}
	    }

	    info.v = v_uicp - 1;
	}

	return false;
    }

    /**
     * {@link #getUDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)
     * getUDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)}
     * 
     * {@link #getVDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)
     * getVDir(JgclPoint3D, JgclPureBezierSurface3D.getDirInfo, int, int, double)}
     * ɂāAĂяoƂƂ肷i[邽߂̓NXB
     *
     * @see	#makeRefPln()
     */
    private class getDirInfo {
	/**
	 * ŏ̌Ăяoł邩ۂtOB
	 */
	private boolean firstCall;

	/**
	 * ׂ_ U ̃CfbNXB
	 */
	private int u;

	/**
	 * ׂ_ V ̃CfbNXB
	 */
	private int v;

	/**
	 * _̐LтB
	 */
	private JgclVector3D dir;

	/**
	 * ^ɃIuWFNg\zB
	 */
	private getDirInfo() {
	    super();
	}
    }

    /**
     * ̋Ȗʂ̎w̋E\xWGȐԂB
     * 
     * @param nth	Ȅ (u,v):(0,0)-(1,0)-(1,1)-(0,1)-(0,0)
     * @return		EȐ
     * @see	JgclIntsBzsBzs3D.BezierInfo
     * @see	JgclIntsQrdBzs3D.BezierInfo
     */
    JgclPureBezierCurve3D getBoundaryCurve(int nth) {

	int u_uicp = uNControlPoints();
	int v_uicp = vNControlPoints();
	int uicp = ((nth % 2) == 0) ? u_uicp : v_uicp;
	JgclPoint3D[] pnts = new JgclPoint3D[uicp];
	double[] ws;
	int i;

	if (isRational())
	    ws = new double[uicp];
	else
	    ws = null;
	switch (nth) {
	case 0:
	    for (i = 0; i < u_uicp; i++) {
		pnts[i] = controlPointAt(i, 0);
		if (isRational())
		    ws[i] = weightAt(i, 0);
	    }
	    break;
	case 1:
	    for (i = 0; i < v_uicp; i++) {
		pnts[i] = controlPointAt(u_uicp-1, i);
		if (isRational())
		    ws[i] = weightAt(u_uicp-1, i);
	    }
	    break;
	case 2:
	    for (i = 0; i < u_uicp; i++) {
		pnts[i] = controlPointAt(u_uicp-1-i, v_uicp-1);
		if (isRational())
		    ws[i] = weightAt(u_uicp-1-i, v_uicp-1);
	    }
	    break;
	case 3:
	    for (i = 0; i < v_uicp; i++) {
		pnts[i] = controlPointAt(0, v_uicp-1-i);
		if (isRational())
		    ws[i] = weightAt(0, v_uicp-1-i);
	    }
	    break;
	}

	JgclPureBezierCurve3D result;
	if (isRational()) {
	    result = new JgclPureBezierCurve3D(pnts, ws);
	    //return new JgclPureBezierCurve3D(pnts, ws);
	}
	else {
	    result = new JgclPureBezierCurve3D(pnts);
	    //return new JgclPureBezierCurve3D(pnts);
	}

	return result;
    }

    /**
     *  (`̃p[^`) LȖʑŜɍČ
     * L Bspline ȖʂԂB
     * 
     * @return		̗LȖʑŜČL Bspline Ȗ
     */
    public JgclBsplineSurface3D toBsplineSurface()
    {
	double[][] www =
	    (this.isRational()) ? this.weights : this.makeUniformWeights();

	return new JgclBsplineSurface3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					this.controlPoints, www);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclParameterOutOfRange
     * @see	#truncate(JgclParameterSection, JgclParameterSection)
     * @see	#toBsplineSurface()
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	return this.truncate(uPint, vPint).toBsplineSurface();
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCncBzs3D#intersection(JgclLine3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsCncBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	return JgclIntsCncBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCncBzs3D#intersection(JgclConic3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsCncBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
	return JgclIntsCncBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsBzcBzs3D#intersection(JgclPureBezierCurve3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsBzcBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return JgclIntsBzcBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsBscBzs3D#intersection(JgclBsplineCurve3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsBscBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return JgclIntsBscBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsBzsBzs3D#intersection(JgclPureBezierSurface3D, JgclPureBezierSurface3D)
     * JgclIntsBzsBzs3D.intersection}(this, mate)
     * 邢
     * JgclIntsBzsBzs3D.intersection(mate, this)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	if (doExchange) {
	    return JgclIntsBzsBzs3D.intersection(mate, this);
	}
	return JgclIntsBzsBzs3D.intersection(this, mate);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclPureBezierSurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
        offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset();
    }
    
    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	uParam = checkUParameter(uParam);
	boolean isPoly = isPolynomial();
	double[][][] cntlPnts = toDoubleArray(isPoly);
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	double[][] tBzc = new double[uUicp][];
	double[][] bzc = new double[vUicp][];

	for (int i = 0; i < vUicp; i++) {
	    for (int j = 0; j < uUicp; j++)
		tBzc[j] = cntlPnts[j][i];
	    bzc[i] = JgclPureBezierCurveEvaluation.coordinates(tBzc, uParam);
	}
	return new JgclPureBezierCurve3D(bzc);
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
	vParam = checkVParameter(vParam);
	boolean isPoly = isPolynomial();
	double[][][] cntlPnts = toDoubleArray(isPoly);
	int uUicp = uNControlPoints();
	double[][] bzc = new double[uUicp][];

	for (int i = 0; i < uUicp; i++) {
	    bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
	}
	return new JgclPureBezierCurve3D(bzc);
    }

    /**
     * ̒ԃf[^̗̈lB
     *
     * @return	̒ԃf[^̗̈
     * @see	#uDivide(double)
     * @see	#vDivide(double)
     */
    double[][][][] allocateIntermediateDoubleArrayForDividing() {
	boolean isPoly = isPolynomial();
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	double [][][][] bzss_array = new double [2][][][];
	for (int i = 0; i < 2; i++)
	    bzss_array[i] = allocateDoubleArray(isPoly, uUicp, vUicp);
	return bzss_array;
    }

    /**
     * ̋ȖʂA^ꂽ U ̃p[^lœ񕪊B
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ U ̋ȖʁA
     * Ԗڂ̗vfɂ U 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @return	񕪊ꂽxWGȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#vDivide(double)
     */
    public JgclPureBezierSurface3D[] uDivide(double uParam)
    {
	return uDivide(uParam, allocateIntermediateDoubleArrayForDividing());
    }

    /**
     * ̋ȖʂA^ꂽ U ̃p[^lœ񕪊B
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ U ̋ȖʁA
     * Ԗڂ̗vfɂ U 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param bzssArray	̒ԃf[^̗̈
     * @return	񕪊ꂽxWGȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#uDivide(double)
     * @see	#allocateIntermediateDoubleArrayForDividing()
     */
    JgclPureBezierSurface3D[] uDivide(double uParam,
				      double[][][][] bzssArray)
    {
	double[][][] cntlPnts;
	double [][] bzc;
	double [][][] bzcsArray;
	JgclPureBezierSurface3D[] bzss;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	boolean isPoly = isPolynomial();
	int i, j, k;

	uParam = checkUParameter(uParam);
	cntlPnts = toDoubleArray(isPoly);
	bzc = new double[uUicp][];
	bzcsArray = new double[2][uUicp][];

	for (i = 0; i < vUicp; i++) {
	    for (j = 0; j < uUicp; j++) {
		bzc[j] = cntlPnts[j][i];
		bzcsArray[0][j] = bzssArray[0][j][i];
		bzcsArray[1][j] = bzssArray[1][j][i];
	    }
	    try {
		JgclPureBezierCurveEvaluation.divide(bzc, uParam, bzcsArray);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	bzss = new JgclPureBezierSurface3D[2];
	for (i = 0; i < 2; i++) {
	    try {
		bzss[i] = new JgclPureBezierSurface3D(bzssArray[i], false);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bzss;
    }

    /**
     * ̋ȖʂA^ꂽ V ̃p[^lœ񕪊B
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ V ̋ȖʁA
     * Ԗڂ̗vfɂ V 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param vParam	V ̃p[^l
     * @return	񕪊ꂽxWGȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#uDivide(double)
     */
    public JgclPureBezierSurface3D[] vDivide(double vParam)
    {
	return vDivide(vParam, allocateIntermediateDoubleArrayForDividing());
    }

    /**
     * ̋ȖʂA^ꂽ V ̃p[^lœ񕪊B
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ V ̋ȖʁA
     * Ԗڂ̗vfɂ V 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param vParam	V ̃p[^l
     * @param bzssArray	̒ԃf[^̗̈
     * @return	񕪊ꂽxWGȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#vDivide(double)
     * @see	#allocateIntermediateDoubleArrayForDividing()
     */
    JgclPureBezierSurface3D[] vDivide(double vParam,
				      double[][][][] bzssArray)
    {
	double[][][] cntlPnts;
	double [][][] bzcsArray;
	JgclPureBezierSurface3D[] bzss;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	boolean isPoly = isPolynomial();
	int i, j;

	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	bzcsArray = new double[2][][];

	for (i = 0; i < uUicp; i++) {
	    bzcsArray[0] = bzssArray[0][i];
	    bzcsArray[1] = bzssArray[1][i];
	    try {
		JgclPureBezierCurveEvaluation.divide(cntlPnts[i], vParam, bzcsArray);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	bzss = new JgclPureBezierSurface3D[2];
	for (i = 0; i < 2; i++) {
	    try {
		bzss[i] = new JgclPureBezierSurface3D(bzssArray[i], false);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bzss;
    }

    /**
     * ̃xWGȖʂA^ꂽ`ԂŐؒfB
     * <p>
     * uSection ̑l̏ꍇɂ́AU ̐is]xWGȖʂԂB
     * lɁA
     * vSection ̑l̏ꍇɂ́AV ̐is]xWGȖʂԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uSection	ؒfĎc\ U ̃p[^
     * @param vSection	ؒfĎc\ V ̃p[^
     * @return	ؒfĎc\xWGȖ
     * @see	JgclParameterOutOfRange
     */
    public JgclPureBezierSurface3D truncate(JgclParameterSection uSection,
					    JgclParameterSection vSection)
    {
	JgclPureBezierSurface3D t_bzs;

	t_bzs = truncate(uSection, true);
	t_bzs = t_bzs.truncate(vSection, false);
	return t_bzs;
    }

    /**
     * ̃xWGȖʂA^ꂽԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́Ais]xWGȖʂԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ؒfĎc\p[^
     * @param isU	U ۂ
     * @return	ؒfĎc\xWGȖ
     * @see	JgclParameterOutOfRange
     * @see	#truncate(JgclParameterSection, JgclParameterSection)
     * @see	#reverse(boolean, boolean)
     */
    private JgclPureBezierSurface3D truncate(JgclParameterSection section,
					     boolean isU)
    {
	double start_par, end_par;
	JgclPureBezierSurface3D t_bzs;

	if (isU) {
	    start_par = checkUParameter(section.lower());
	    end_par = checkUParameter(section.upper());
	    t_bzs = uDivide(start_par)[1];
	} else {
	    start_par = checkVParameter(section.lower());
	    end_par = checkVParameter(section.upper());
	    t_bzs = vDivide(start_par)[1];
	}

	end_par = (end_par - start_par) / (1.0 - start_par);

	if (isU)
	    t_bzs = t_bzs.uDivide(end_par)[0];
	else
	    t_bzs = t_bzs.vDivide(end_par)[0];

	if (section.increase() < 0.0)
	    if (isU)
		t_bzs = t_bzs.reverse(true, false);
	    else
		t_bzs = t_bzs.reverse(false, true);

	return t_bzs;
    }

    /**
     * ̃xWGȖʂAw̕ɔ]xWGȖʂԂB
     *
     * @param isU	U ɔ]ǂ
     * @param isV	V ɔ]ǂ
     * @return		]xWGȖ
     */
    private JgclPureBezierSurface3D reverse(boolean isU, boolean isV) {
	boolean isRat = isRational();
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	JgclPoint3D[][] rCp = new JgclPoint3D[uUicp][vUicp];
	double[][] rWt = null;
	int i, j, k, l;

	if ((!isU) && (!isV)) {
	    return this;
	}

	if (isRat)
	    rWt = new double[uUicp][vUicp];

	if (isU)
	    j = uUicp - 1;
	else
	    j = 0;
	for (i = 0; i < uUicp; i++) {
	    if (isV)
		l = vUicp - 1;
	    else
		l = 0;
	    for (k = 0; k < vUicp; k++) {
		rCp[i][k] = controlPointAt(j, l);
		if (isRat)
		    rWt[i][k] = weightAt(j, l);
		if (isV)
		    l--;
		else
		    l++;
	    }
	    if (isU)
		j--;
	    else
		j++;
	}
	try {
	    JgclPureBezierSurface3D result;

	    if (isRat) {
		result = new JgclPureBezierSurface3D(rCp, rWt);
		//return new JgclPureBezierSurface3D(rCp, rWt);
	    } else {
		result = new JgclPureBezierSurface3D(rCp);
		//return new JgclPureBezierSurface3D(rCp);
	    }

	    return result;

	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * 
     * @return	U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0.0, 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * 
     * @return	V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0.0, 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /*
     * ^ꂽp[^lA̋Ȗʂ U ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ U ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	U ̃p[^l
     * @return	KvɉĂ̋Ȗʂ U ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkUParameter(double param)
    {
	checkUValidity(param);
	return uParameterDomain().force(param);
    }

    /*
     * ^ꂽp[^lA̋Ȗʂ V ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ V ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	V ̃p[^l
     * @return	KvɉĂ̋Ȗʂ V ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricSurface#checkVValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkVParameter(double param)
    {
	checkVValidity(param);
	return vParameterDomain().force(param);
    }

    /**
     * ̋ȖʂA`̂܂܂ɂāAU ̎グȖʂԂB
     *
     * @return	`ŁAU ̎オȖ
     */
    public JgclPureBezierSurface3D uElevateOneDegree() {
	boolean isPoly = isPolynomial();
	int uNCP = this.uNControlPoints();
	int vNCP = this.vNControlPoints();

	double[][][] newCP =
	    JgclFreeformSurfaceWithControlPoints3D.
	    allocateDoubleArray(isPoly, (uNCP + 1), vNCP);

	this.setCoordinatesToDoubleArray(isPoly, uNCP, vNCP, newCP);

	double[][] curve = new double[uNCP + 1][];

	for (int vi = 0; vi < vNCP; vi++) {
	    for (int ui = 0; ui < (uNCP + 1); ui++)
		curve[ui] = newCP[ui][vi];
	    JgclPureBezierCurveEvaluation.elevateOneDegree(uNCP, curve);
	}

	return new JgclPureBezierSurface3D(newCP);
    }

    /**
     * ̋ȖʂA`̂܂܂ɂāAV ̎グȖʂԂB
     *
     * @return	`ŁAV ̎オȖ
     */
    public JgclPureBezierSurface3D vElevateOneDegree() {
	boolean isPoly = isPolynomial();
	int uNCP = this.uNControlPoints();
	int vNCP = this.vNControlPoints();

	double[][][] newCP =
	    JgclFreeformSurfaceWithControlPoints3D.
	    allocateDoubleArray(isPoly, uNCP, (vNCP + 1));

	this.setCoordinatesToDoubleArray(isPoly, uNCP, vNCP, newCP);

	for (int ui = 0; ui < uNCP; ui++)
	    JgclPureBezierCurveEvaluation.elevateOneDegree(vNCP, newCP[ui]);

	return new JgclPureBezierSurface3D(newCP);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#PURE_BEZIER_SURFACE_3D JgclParametricSurface3D.PURE_BEZIER_SURFACE_3D}
     */
    int type() {
	return PURE_BEZIER_SURFACE_3D;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	// 芸A̎
	JgclMesh3D mesh = this.toMesh(uParameterSection,
				      vParameterSection,
				      new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	scalingFactor[0] = getMaxLengthOfUControlPolygons(false);
	scalingFactor[1] = getMaxLengthOfVControlPolygons(false);

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[][] tControlPoints = new JgclPoint3D[this.uNControlPoints()][];
	for (int i = 0; i < this.uNControlPoints(); i++)
	    tControlPoints[i] = JgclPoint3D.transform(this.controlPoints[i],
						      reverseTransform,
						      transformationOperator,
						      transformedGeometries);
	if (this.isPolynomial() == true)
	    return new JgclPureBezierSurface3D(tControlPoints);
	else
	    return new JgclPureBezierSurface3D(tControlPoints, this.weights);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tuNControlPoints\t" + uNControlPoints());
        writer.println(indent_tab + "\tvNControlPoints\t" + vNControlPoints());
        writer.println(indent_tab + "\tcontrolPoints");
	for (int i = 0; i < controlPoints.length; i++) {
            for (int j = 0; j < controlPoints[i].length; j++) {
                controlPoints[i][j].output(writer, indent + 2);
            }
        }

        // output weights
	if (weights() != null) {
	    writer.println(indent_tab + "\tweights ");
	    for (int j = 0; j < weights().length; j++) {
		writer.print(indent_tab + "\t\t");
		for (int k =0; k < weights()[j].length; k++){
		    writer.print(" " + weightAt(j,k));
		}
		writer.println();
	    }
	}

        writer.println(indent_tab + "End");
    }
}
