/*
 * R̓_\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPoint3D.java,v 1.39 2000/08/15 08:47:39 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

/**
 * R̓_\ۃNXB
 *
 * @version $Revision: 1.39 $, $Date: 2000/08/15 08:47:39 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclVector3D
 */

public abstract class JgclPoint3D extends JgclPoint {
    /**
     * Ř_ (0, 0, 0)B
     */
    public static final JgclPoint3D origin;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	origin = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
    }

    /**
     * IuWFNg\zB
     *
     * @see JgclConditionOfOperation
     */
    protected JgclPoint3D(){
	super();
    }

    /**
     * ԂB
     * <p>
     *  3 ԂB
     * </p>
     *
     * @return	RȂ̂ŁA 3
     */
    public int dimension() {
        return 3;
    }

    /**
     * RۂԂ
     *
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		RȂ̂ŁA <code>true</code>
     */
    public boolean is3D() {
        return true;
    }

    /**
     * _ X WlԂۃ\bhB
     *
     * @return	_ X Wl
     */
    public abstract double x();

    /**
     * _ Y WlԂۃ\bhB
     *
     * @return	_ Y Wl
     */
    public abstract double y();

    /**
     * _ Z WlԂۃ\bhB
     *
     * @return	_ Z Wl
     */
    public abstract double z();

    /**
     * ̓_ɗ^ꂽxNg𑫂_ԂB
     *
     * @param vector	_ɑxNg
     * @return	^ꂽxNg𑫂_ (this + vector)
     */
    public JgclPoint3D add(JgclVector3D vector)	{
        return new JgclCartesianPoint3D(x() + vector.x(), 
					y() + vector.y(),
					z() + vector.z());
    }

    /**
     * ̓_^ꂽxNg_ԂB
     *
     * @param vector	_xNg
     * @return	^ꂽxNg_ (this - vector)
     */
    public JgclPoint3D subtract(JgclVector3D vector) {
        return new JgclCartesianPoint3D(x() - vector.x(), 
					y() - vector.y(),
					z() - vector.z());
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̍ԂB
     *
     * @param mate	鑊̓_
     * @return	_̍ (this - mate)
     */
    public JgclVector3D subtract(JgclPoint3D mate) {
        return new JgclLiteralVector3D(x() - mate.x(),
				       y() - mate.y(),
				       z() - mate.z());
    }

    /**
     * ̓_ɗ^ꂽXP[悶_ԂB
     *
     * @param scale	XP[
     * @return	(this * scale)
     */
    public JgclPoint3D multiply(double scale) {
        return new JgclCartesianPoint3D(x() * scale,
					y() * scale,
					z() * scale);
    }

    /**
     * ̓_^ꂽXP[Ŋ_ԂB
     *
     * @param scale	XP[
     * @return	(this / scale)
     */
    public JgclPoint3D divide(double scale) {
        return new JgclCartesianPoint3D(x() / scale,
					y() / scale,
					z() / scale);
    }

    /**
     * ̓_Ɨ^ꂽ_Ő^ԂʂԂB
     *
     * @param mate	`Ԃ̑ƂȂ_
     * @param weightForThis	gɑ΂d (ɑ΂d݂ 1 - weightForThis)
     * @return	`Ԃʂ̓_ (weightForThis * this + (1 - weightForThis) * mate)
     */
    public JgclPoint3D linearInterpolate(JgclPoint3D mate,
					 double weightForThis) {
	double weightForMate = 1.0 - weightForThis;
        return new JgclCartesianPoint3D(
            this.x() * weightForThis + mate.x() * weightForMate,
            this.y() * weightForThis + mate.y() * weightForMate,
            this.z() * weightForThis + mate.z() * weightForMate);
    }

    /**
     * ̓_Ɨ^ꂽ_̒_ԂB
     *
     * @param mate	_߂鑊ƂȂ_
     * @return	_ (0.5 * this + 0.5 * mate)
     */
    public JgclPoint3D midPoint(JgclPoint3D mate) {
        return linearInterpolate(mate, 0.5);
    }

    /**
     * Q_̓ꐫ𔻒肷B
     *
     * @param mate	̑ΏۂƂȂ_
     * @return	this  mate űe덷vȓ
     *		̓_łƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     */ 
    public boolean identical(JgclPoint3D mate) {
	return distance2(mate) < getToleranceForDistance2();
    }

    /**
     * ̓_R̃xNg (JgclVector3D) ɕϊB
     *
     * @return	_̃xNgƂ݂ȂxNg
     */
    public JgclVector3D toVector3D() {
        return new JgclLiteralVector3D(x(), y(), z());
    }

    /**
     * _̔zxNg (JgclVector3D) ̔zɕϊB
     *
     * @return	_̃xNgƂ݂ȂxNg̔z
     */
    public static JgclVector3D[] toVector3D(JgclPoint3D[] pnts) {
	JgclVector3D[] vecs = new JgclVector3D[pnts.length];
	for (int i = 0; i < pnts.length; i++)
	    vecs[i] = pnts[i].toVector3D();
	return vecs;
    }

    /**
     * ̓_^ꂽȐւ̓e_߂B
     *
     * @param mate	eΏۂ̋Ȑ
     * @return	w肳ꂽȐւ̓e_ (݂ȂƂ͒0̔zԂ)
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] project(JgclParametricCurve3D mate) 
	throws JgclIndefiniteSolution
    {
	return mate.projectFrom(this);
    }

    /**
     * ̓_^ꂽȐ̏ɏĂ邩ǂԂB
     *
     * @param mate	Ώۂ̋Ȑ
     * @return	Ȑ̏ɏĂ trueAłȂ false
     */
    public boolean isOn(JgclParametricCurve3D mate) {
	JgclPointOnCurve3D prjp = mate.nearestProjectFrom(this);

	if (prjp != null && identical(prjp))
	    return true;

	if (false) {	// Kv??
	    if (mate.isFinite() && mate.isNonPeriodic()) {	// LŔI
		// mate must be a bounded curve
		JgclBoundedCurve3D bnd = (JgclBoundedCurve3D)mate;

		if (identical(bnd.startPoint()))
		    return true;
		if (identical(bnd.endPoint()))
		    return true;
	    }
	}

	return false;
    }

    /**
     * ̓_^ꂽȖʂ̏ɏĂ邩ǂԂB
     *
     * @param mate	Ώۂ̋Ȗ
     * @return	Ȗʂ̏ɏĂ trueAłȂ false
     */
    public boolean isOn(JgclParametricSurface3D mate) {
	JgclPointOnSurface3D prjp = mate.nearestProjectFrom(this);

	if (prjp != null && identical(prjp))
	    return true;

	return false;
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̊Ԃ̋ԂB
     *
     * @param mate	߂_
     * @return	this - mate Ԃ̋
     */
    public double distance(JgclPoint3D mate) {
	return Math.sqrt(distance2(mate));
    }

    /**
     * ̓_Ɨ^ꂽ_Ƃ̊Ԃ̋̎ԂB
     *
     * @param mate	̎߂_
     * @return	this - mate Ԃ̋̎
     */
    public double distance2(JgclPoint3D mate) {
        double dx, dy, dz;

        dx = x() - mate.x();
        dy = y() - mate.y();
        dz = z() - mate.z();
	return(dx * dx + dy * dy + dz * dz);
    }

    /**
     * ^ꂽ_̒ŁA̓_ł_ԂB
     *
     * @param pnts	_
     * @return	ł_
     */
    public JgclPoint3D longestPoint(JgclPoint3D[] pnts) {
        return longestPoint(pnts, 0, pnts.length - 1);
    }

    /**
     * ^ꂽ_̎w͈̔͂̒ŁA̓_ł_ԂB
     *  
     * @param pnts	_
     * @param start	Jn_̃CfbNX (0 ~ pnts.length - 1)
     * @param end	I_̃CfbNX (0 ~ pnts.length - 1, start <= end)
     * @return	ł_
     */
    public JgclPoint3D longestPoint(JgclPoint3D[] pnts,
                                    int start, int end) {

        double max_dist, dist;
        int index;

        if ((start < 0) || (end >= pnts.length)) {
            throw new JgclInvalidArgumentValue();
        }

        max_dist = distance2(pnts[start]);
        index = 0;

        for (int i = start + 1; i <= end; i++) {
            if ((dist = distance2(pnts[i])) > max_dist) {
                max_dist = dist;
                index = i;
            }
        }

        return pnts[index];
    }

    /**
     * _Q̕xNgԂB
     * <p>
     * (start == end) ̏ꍇɂ́A[xNgԂB
     * </p>
     *
     * @param points	_Q
     * @param start	Jn_̃CfbNX (0 ~ points.length - 1)
     * @param end	I_̃CfbNX (0 ~ points.length - 1, start <= end)
     * @return	̒PʕxNg
     */
    static JgclVector3D collinear(JgclPoint3D[] points,
                                  int start, int end) {
        if ((start < 0) || (points.length <= end)) {
            throw new JgclInvalidArgumentValue();
        }

        if (end - start <= 1) {
            return JgclVector3D.zeroVector;
        }

        JgclConditionOfOperation condition =
            JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double dTol2 = dTol * dTol;

        JgclPoint3D basisPoint = points[start];
        JgclPoint3D longestPoint =
            basisPoint.longestPoint(points, start + 1, end);
        JgclVector3D uax = longestPoint.subtract(basisPoint);

        if (uax.norm() < dTol2) {
            return JgclVector3D.zeroVector;
        }
        uax = uax.unitized();

        JgclVector3D evec;
        double ecrs;

        for (int i = start + 1; i <= end; i++) {
            evec = points[i].subtract(points[start]);
            ecrs = evec.crossProduct(uax).norm();
            if (ecrs > dTol2) {
                return null;
            }
        }
        return uax;
    }

    /**
     * ̓_A^ꂽǏWn Z ɑ΂āA^ꂽpx]_ԂB
     * <p>
     * ĂяóA(rCos * rCos + rSin * rSin) ̒l 1 ł邱Ƃ
     * ۏ؂Ȃ΂ȂȂB
     * </p>
     *
     * @param trns	ǏWn\WϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̓_
     * @see	JgclVector3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     * @see	JgclAxis2Placement3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     */
    JgclPoint3D rotateZ(JgclCartesianTransformationOperator3D trns,
			double rCos, double rSin) {
	JgclPoint3D lpnt, rpnt;
	double x, y, z;

	lpnt = trns.toLocal(this);
	x = (rCos * lpnt.x()) - (rSin * lpnt.y());
	y = (rSin * lpnt.x()) + (rCos * lpnt.y());
	z = lpnt.z();
	rpnt = new JgclCartesianPoint3D(x, y, z);
	return trns.toEnclosed(rpnt);
    }

    /**
     * ̓_ (x, y, z)  XY ʂɎˉe 2D B
     *
     * @return	2D _ (x, y)
     */
    JgclPoint2D to2D() {
	return new JgclCartesianPoint2D(x(), y());
    }

    /**
     * ̓_ǏWn XY ʂɎˉe 2D B
     *
     * @return	2D _ (̓_̍Wl͋ǏWnł XY l)
     */
    JgclPoint2D to2D(JgclCartesianTransformationOperator3D transform) {
	return transform.toLocal(this).to2D();
    }

    /**
     * ̓_ JgclCartesianPoint3D ̃IuWFNgɕϊB
     *
     * @return	ϊ_
     */
    JgclCartesianPoint3D literal() {
	return new JgclCartesianPoint3D(x(), y(), z());
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclPoint3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclPoint3D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclPoint3D transformed = (JgclPoint3D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclPoint3D
    transformBy(JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclPoint3D
    reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * _A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł͑ΏۂƂȂL[A
     * ̕ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint3D[]
    transform(JgclPoint3D[] points,
	      boolean reverseTransform,
	      JgclCartesianTransformationOperator3D transformationOperator,
	      java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[] tPoints = new JgclPoint3D[points.length];
	for (int i = 0; i < points.length; i++)
	    tPoints[i] = points[i].transformBy(reverseTransform,
					       transformationOperator,
					       transformedGeometries);
	return tPoints;
    }

    /**
     * _A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł͑ΏۂƂȂ_L[A
     * ̕ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint3D[]
    transform(JgclPoint3D[] points,
	      JgclCartesianTransformationOperator3D transformationOperator,
	      java.util.Hashtable transformedGeometries)
    {
	return transform(points, false, transformationOperator, transformedGeometries);
    }

    /**
     * _A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * ΏۂƂȂ_ transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     *  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł͑ΏۂƂȂ_L[A
     * ̕ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * ΏۂƂȂ邪 transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     * ɑΏۂƂȂ_ transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param points	_
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     */
    public static JgclPoint3D[]
    reverseTransform(JgclPoint3D[] points,
		     JgclCartesianTransformationOperator3D transformationOperator,
		     java.util.Hashtable transformedGeometries)

    {
	return transform(points, true, transformationOperator, transformedGeometries);
    }

    /**
     * JgclCartesianPoint3D ̃CX^X𐶐B
     *
     * @param x	X 
     * @param y	Y 
     * @param z	Z 
     * @return	JgclCartesianPoint3D ̃CX^X
     */
    public static JgclCartesianPoint3D of(double x,
					  double y,
					  double z) {
	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * JgclCartesianPoint3D ̃CX^X𐶐B
     *
     * @param components	X, Y̔z (vf 3)
     * @return	JgclCartesianPoint3D ̃CX^X
     */
    public static JgclCartesianPoint3D of(double[] components) {
	return new JgclCartesianPoint3D(components);
    }
}

