/*
 * R̃pgbNȋȖʂ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParametricSurface3D.java,v 1.45 2000/08/11 06:18:55 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;

/**
 * R̃pgbNȋȖʂ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX́A̎lŕ\p[^̑g (u, v) ̒lɂāA
 * ʒu肳R̋Ȗ P(u, v) Sʂ\B
 * </p>
 *
 * @version $Revision: 1.45 $, $Date: 2000/08/11 06:18:55 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclParametricSurface3D extends JgclParametricSurface {
    /**
     * Ȗʂ Plane ł邱Ƃ萔
     */
    static final int PLANE_3D = 1;

    /**
     * Ȗʂ Cylindrical Surface ł邱Ƃ萔
     */
    static final int CYLINDRICAL_SURFACE_3D = 10;

    /**
     * Ȗʂ Conical Surface ł邱Ƃ萔
     */
    static final int CONICAL_SURFACE_3D = 11;

    /**
     * Ȗʂ Spherical Surface ł邱Ƃ萔
     */
    static final int SPHERICAL_SURFACE_3D = 12;

    /**
     * Ȗʂ Surface Of Linear Extrusion ł邱Ƃ萔
     */
    static final int SURFACE_OF_LINEAR_EXTRUSION_3D = 20;

    /**
     * Ȗʂ Surface Of Revolution ł邱Ƃ萔
     */
    static final int SURFACE_OF_REVOLUTION_3D = 21;

    /**
     * Ȗʂ Bspline Surface ł邱Ƃ萔
     */
    static final int BSPLINE_SURFACE_3D = 30;

    /**
     * Ȗʂ Pure Bezier Surface ł邱Ƃ萔
     */
    static final int PURE_BEZIER_SURFACE_3D = 31;

    /**
     * Ȗʂ Rectangular Trimmed Surface ł邱Ƃ萔
     */
    static final int RECTANGULAR_TRIMMED_SURFACE_3D = 32;

    /**
     * Ȗʂ Curve Bounded Surface ł邱Ƃ萔
     */
    static final int CURVE_BOUNDED_SURFACE_3D = 33;

    /**
     * Ȗʂ Mesh ł邱Ƃ萔
     */
    static final int MESH_3D = 40;

    /**
     * IuWFNg\zB
     */
    protected JgclParametricSurface3D() {
	super();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂۃ\bhB
     * 
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		Wl
     */
    public abstract JgclPoint3D coordinates(double uParam, double vParam);

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂۃ\bhB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     *
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		ڃxNg̔z
     */
    public abstract JgclVector3D[] tangentVector(double uParam, double vParam);

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̖@xNgԂB
     * <p>
     * ̃\bhԂ@xNǵAKꂽPʃxNgłB 
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Kꂽ@xNg
     */
    public JgclVector3D normalVector(double uParam, double vParam)
    {
	JgclVector3D[] tang;

	tang = tangentVector(uParam, vParam);
	return tang[0].crossProduct(tang[1]).unitized();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̎ȗԂB
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		ȗ
     */
    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
	JgclSurfaceDerivative3D deriv;

	deriv = evaluation(uParam, vParam);
	return deriv.principalCurvature();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐Ԃۃ\bhB
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     */
    public abstract JgclSurfaceDerivative3D
	evaluation(double uParam, double vParam);

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂钊ۃ\bhB
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution;

    /**
     * ^ꂽ_ P 炱̋Ȗʂւ̓e_̓ŁAP ɍł߂_ԂB
     * <p>
     * e_݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param pnt	e̓_
     * @return		e̓_ɍł߂e_
     * @see	#projectFrom(JgclPoint3D)
     * @see	#nearestProjectWithDistanceFrom(JgclPoint3D, double)
     */
    public JgclPointOnSurface3D nearestProjectFrom(JgclPoint3D pnt) {
	JgclPointOnSurface3D[] proj;
	try {
	    proj = projectFrom(pnt);
	}
	catch (JgclIndefiniteSolution e) {
	    proj = new JgclPointOnSurface3D[1];
	    proj[0] = (JgclPointOnSurface3D)e.suitable();
	}

	if (proj.length == 0)
	    return null;

	double dist = proj[0].distance2(pnt);
	int idx = 0;

	// find nearest point
	for (int i = 1; i < proj.length; i++) {
	    double dist2 = proj[i].distance2(pnt);

	    if (dist2 < dist) {
		dist = dist2;
		idx = i;
	    }
	}

	return proj[idx];
    }

    /**
     * ^ꂽ_ P 炱̋Ȗʂւ̓e_̓ŁAP ̋w̒lɍł߂_ԂB
     * <p>
     * e_݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param pnt	e̓_
     * @param distance	
     * @return		w肵ɍł߂e_
     * @see	#projectFrom(JgclPoint3D)
     * @see	#nearestProjectFrom(JgclPoint3D)
     */
    public JgclPointOnSurface3D nearestProjectWithDistanceFrom(JgclPoint3D pnt, double distance) {
	JgclPointOnSurface3D[] proj;
	try {
	    proj = projectFrom(pnt);
	}
	catch (JgclIndefiniteSolution e) {
	    proj = new JgclPointOnSurface3D[1];
	    proj[0] = (JgclPointOnSurface3D)e.suitable();
	}

	if (proj.length == 0)
	    return null;

	double diff = Math.abs(distance - proj[0].distance(pnt));
	int idx = 0;

	// find nearest point
	for (int i = 1; i < proj.length; i++) {
	    double diff2 = Math.abs(distance - proj[i].distance(pnt));

	    if (diff2 < diff) {
		diff = diff2;
		idx = i;
	    }
	}

	return proj[idx];
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂۃ\bhB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public abstract JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol);

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂۃ\bhB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     */
    public abstract JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint);

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂钊ۃ\bhB
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclIntersectionPoint3D[]
	intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint3D[]
	intersect(JgclLine3D mate, boolean doExchange)
  	throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint3D[]
	intersect(JgclConic3D mate, boolean doExchange)
  	throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȑ (|C) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint3D[]
	intersect(JgclPureBezierCurve3D mate, boolean doExchange)
  	throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint3D[]
	intersect(JgclBsplineCurve3D mate, boolean doExchange)
  	throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȑ (gȐ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (Ȑ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (ȐZOg) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋ȖʂƂ̌߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȗ () Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclPlane3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȗ () Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclSphericalSurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȗ (~) Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclCylindricalSurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȗ (~) Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	sł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclConicalSurface3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclPureBezierSurface3D mate, boolean doExchange);

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) Ƃ̌߂钊ۃ\bh (internal use) B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange  basisSurface1/2 邩ǂ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    abstract JgclSurfaceSurfaceInterference3D[]
	intersect(JgclBsplineSurface3D mate, boolean doExchange);

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂钊ۃ\bhB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public abstract JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uSect,
			       JgclParameterSection vSect,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol);

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂƁA
     * ̋Ȗʂ̎w (p[^I) `ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param uSect1	̋Ȗʂ U ̃p[^
     * @param vSect1	̋Ȗʂ V ̃p[^
     * @param side1	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param mate	̋Ȗ
     * @param uSect2	̋Ȗʂ U ̃p[^
     * @param vSect2	̋Ȗʂ V ̃p[^
     * @param side2	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    public JgclFilletObject3D[]
	fillet(JgclParameterSection uSect1, JgclParameterSection vSect1, int side1,
	       JgclParametricSurface3D mate,
	       JgclParameterSection uSect2, JgclParameterSection vSect2, int side2,
	       double radius)
	throws JgclIndefiniteSolution
    {
	return JgclFiltSrfSrf3D.fillet(this, uSect1, vSect1, side1,
				       mate, uSect2, vSect2, side2, radius);
    }

    /**
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂۃ\bhB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public abstract JgclParametricCurve3D uIsoParametricCurve(double uParam)
	 throws JgclReducedToPoint;

    /**
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂۃ\bhB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public abstract JgclParametricCurve3D vIsoParametricCurve(double vParam)
	throws JgclReducedToPoint;

    /**
     * ̋Ȗʂ̎ԂB
     * <p>
     *  3 ԂB
     * </p>
     *
     * @return RȂ̂ŁA 3
     */
    public int dimension() {
	return 3;
    }

    /**
     * ̋ȖʂRۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		RȂ̂ŁA true
     */
    public boolean is3D() {
	return true;
    }

    /**
     * ̋Ȗʂ̗vfʂԂۃ\bhB
     *
     * @return	vf
     * @see	#PLANE_3D
     * @see	#CYLINDRICAL_SURFACE_3D
     * @see	#CONICAL_SURFACE_3D
     * @see	#SPHERICAL_SURFACE_3D
     * @see	#SURFACE_OF_LINEAR_EXTRUSION_3D
     * @see	#SURFACE_OF_REVOLUTION_3D
     * @see	#BSPLINE_SURFACE_3D
     * @see	#PURE_BEZIER_SURFACE_3D
     * @see	#RECTANGULAR_TRIMMED_SURFACE_3D
     * @see	#CURVE_BOUNDED_SURFACE_3D
     * @see	#MESH_3D
     */
    abstract int type();

    /**
     * ^ꂽʏ_́A̋Ȗʂł̃p[^l߂B
     * <p>
     * ^ꂽ_̋ȖʏɏĂ̂ƂāA
     * ̓_ɑΉp[^l (u, v) ߂B
     * </p>
     * <p>
     * ̃\bh͈̓ȉ̒ʂB
     * <ul>
     * <li> nearestProjectFrom(pnt) gāA
     *		^ꂽ_ P ɍł߂e_ Q 𓾂
     * <li> e_݂Ȃ΁A
     *		^ꂽ_͂̋ȖʂɏĂȂ̂ƂO𓊂
     * <li> P  Q ݐݒ肳Ă鉉Zœ̓_Ƃ݂ȂȂ΁A
     *		^ꂽ_͂̋ȖʂɏĂȂ̂ƂO𓊂
     * <li> Q ̃p[^l (u, v) Ԃ
     * </ul>
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vf U ̃p[^lA
     * Ԗڂ̗vf V ̃p[^l܂ށB
     * </p>
     *
     * @param pnt	Ȗʏ̓_
     * @return		Ήp[^l̔z (u, v)
     * @exception JgclInvalidArgumentValue	^ꂽ_̋ȖʂɏĂȂ
     * @see	#nearestProjectFrom(JgclPoint3D)
     * @see	JgclConditionOfOperation
     */
    public double[] pointToParameter(JgclPoint3D pnt) {
	JgclPointOnSurface3D proj = nearestProjectFrom(pnt);
	if (proj == null)
	    throw new JgclInvalidArgumentValue();

	if (pnt.identical(proj))
	    return proj.parameters();
	else
	    throw new JgclInvalidArgumentValue();
    }

    /**
     * ̋ȖʂƑ̋Ȗ (͋Ȗ) ̌_̍WlA_IuWFNgɕϊB
     * <p>
     * ̃\bh̓ł́A
     * this  mate ̂ꂼɂ pointToParameter(JgclPoint3D) ĂяoA
     * ^ꂽ_̃p[^l𓾂ĂB
     * ȂApointToParameter(JgclPoint3D) 
     * JgclInvalidArgumentValue ̗O𔭐邱Ƃ邪A
     * ̃\bh̓ł͂ catch ĂȂB
     * </p>
     *
     * @param point	_\Wl
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange _̊i[邩ǂ
     * @return		_IuWFNg
     * @exception JgclInvalidArgumentValue	^ꂽ_ǂ炩̋ȖʂɏĂȂ
     * @see	#pointToParameter(JgclPoint3D)
     */
    JgclIntersectionPoint3D pointToIntersectionPoint(JgclPoint3D point,
						     JgclElementarySurface3D mate,
						     boolean doExchange) {
	double[] thisParams = this.pointToParameter(point);
	double[] mateParams = mate.pointToParameter(point);
	if (!doExchange)
	    return new JgclIntersectionPoint3D(point,
					       this, thisParams[0], thisParams[1],
					       mate, mateParams[0], mateParams[1],
					       doCheckDebug);
	else
	    return new JgclIntersectionPoint3D(point,
					       mate, mateParams[0], mateParams[1],
					       this, thisParams[0], thisParams[1],
					       doCheckDebug);
    }

    /**
     * ̋ȖʂI () Ȗʂł΁A
     * ^ꂽp[^ԏ̓_␳B
     * <p>
     * ̋Ȗʂ U/V ɎIłȂ΁A
     * ̃\bh͉ȂB
     * </p>
     * <p>
     * pnts ɗ^ꂽQ̓_A
     * ̎IȋȖʂ̃p[^ԏ̃|CƌȂA
     * ̃|CȖʂ̎̌qڂ̓_܂łƂɁA
     * ^ꂽ|Ĉ̂\ȐA
     * |C̎̌qڂׂŐLтĂƍl
     * |C̒ZȂꍇɁA
     * ̎̌qڂׂ悤Ƀ|C̊e_̒lύXB
     * </p>
     * <p>
     * pnts ̊evf͂̃\bh̓ŕύX邩ȂB
     * </p>
     *
     * @param pnts	Q̓_̔z
     */
    void confirmConnectionOfPointsOnSurface(JgclPoint2D[] pnts) {
	int uip = pnts.length;
	double width;
	double val_i, val_j;
	double gap0, gapm, gapp;
	int i, j;

	if (isUFinite() && isUPeriodic()) {
	    width = uParameterDomain().section().absIncrease();
	    for (i = 0, j = 1; j < uip; i++, j++) {
		val_i = pnts[i].x();
		val_j = pnts[j].x();
		gap0 = Math.abs(val_j         - val_i);
		gapm = Math.abs(val_j - width - val_i);
		gapp = Math.abs(val_j + width - val_i);
		if (gapm < gapp) {
		    if (gapm < gap0)
			pnts[j] = new JgclCartesianPoint2D(pnts[j].x() - width, pnts[j].y());
		} else {
		    if (gapp < gap0)
			pnts[j] = new JgclCartesianPoint2D(pnts[j].x() + width, pnts[j].y());
		}
	    }
	}

	if (isVFinite() && isVPeriodic()) {
	    width = vParameterDomain().section().absIncrease();
	    for (i = 0, j = 1; j < uip; i++, j++) {
		val_i = pnts[i].y();
		val_j = pnts[j].y();
		gap0 = Math.abs(val_j         - val_i);
		gapm = Math.abs(val_j - width - val_i);
		gapp = Math.abs(val_j + width - val_i);
		if (gapm < gapp) {
		    if (gapm < gap0)
			pnts[j] = new JgclCartesianPoint2D(pnts[j].x(), pnts[j].y() - width);
		} else {
		    if (gapp < gap0)
			pnts[j] = new JgclCartesianPoint2D(pnts[j].x(), pnts[j].y() + width);
		}
	    }
	}
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * _QԂۃ\bhB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public abstract Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
						 JgclParameterSection vParameterSection,
						 double tolerance,
						 double[] scalingFactor);

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclParametricSurface3D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclParametricSurface3D transformed = (JgclParametricSurface3D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclParametricSurface3D
    transformBy(JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return transformBy(false, transformationOperator, transformedGeometries);
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclParametricSurface3D
    reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return transformBy(true, transformationOperator, transformedGeometries);
    }
}

