/*
 * R : ȐԂ̃p[^ϊ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParameterConversion3D.java,v 1.6 2000/04/26 09:39:14 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : ȐԂ̃p[^ϊ\ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * Ȑ P ɑ΂p[^l s A
 * P(s) = Q(t) 𖞂悤
 * ʂ̋Ȑ Q ɑ΂p[^l t ɕϊ鏈sȂ\bhB
 * </p>
 *
 * @version $Revision: 1.6 $, $Date: 2000/04/26 09:39:14 $
 * @author Information-technology Promotion Agency, Japan
 */
abstract class JgclParameterConversion3D {
    /**
     * P ɑ΂p[^l Q ɑ΂p[^lɕϊ钊ۃ\bhB
     * 
     * @param param	P ɑ΂p[^l
     * @return	Q ɑ΂p[^l
     */
    abstract double convParameter(double param);

    /**
     * P ɑ΂p[^lϊΏۂł Q Ԃۃ\bhB
     * 
     * @param param	P ɑ΂p[^l
     * @return	Ȑ Q
     */
    abstract JgclParametricCurve3D convCurve(double param);

    /**
     * P ɑ΂p[^Ԃ Q ɑ΂p[^ԂɕϊB
     * 
     * @param sec	P ɑ΂p[^
     * @return	Q ɑ΂p[^
     * @see	#convParameter(double)
     * @see	#convCurve(double)
     */
    JgclParameterSection convParameter(JgclParameterSection sec) {
	JgclParametricCurve3D scurve = convCurve(sec.start());
	JgclParametricCurve3D ecurve = convCurve(sec.end());

	if (scurve != ecurve)
	    return null;

	double sparam = convParameter(sec.start());
	double eparam = convParameter(sec.end());
	return new JgclParameterSection(sparam, eparam - sparam);
    }

    /**
     * P ɑ΂p[^lɑΉ Q ̐_ Q(t) ԂB
     * 
     * @param param	P ɑ΂p[^l
     * @return	Ή Q ̐_ Q(t)
     * @see	#convParameter(double)
     * @see	#convCurve(double)
     */
    JgclPointOnCurve3D convToPoint(double param) {
	double tparam = convParameter(param);
	JgclParametricCurve3D curve = convCurve(param);

	return new JgclPointOnCurve3D(curve, tparam, JgclGeometry.doCheckDebug);
    }

    /**
     * P ɑ΂p[^ԂɑΉ Q ̃gȐԂB
     * 
     * @param sec	P ɑ΂p[^
     * @return	Ή Q ̃gȐ
     * @see	#convParameter(double)
     * @see	#convCurve(double)
     */
    JgclTrimmedCurve3D convToTrimmedCurve(JgclParameterSection sec) {
	JgclParametricCurve3D scurve = convCurve(sec.start());
	JgclParametricCurve3D ecurve = convCurve(sec.end());

	if (scurve != ecurve)
	    return null;

	double sparam = convParameter(sec.start());
	double eparam = convParameter(sec.end());
	return new JgclTrimmedCurve3D(ecurve,
	    new JgclParameterSection(sparam, eparam - sparam));
    }
}
