/*
 * R : 􉽗vf () I[o[bvĂԂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclOverlapCurve3D.java,v 1.16 2000/04/26 09:39:11 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : 􉽗vf () I[o[bvĂԂ\NXB
 * <p>
 * ̃NX̃CX^X́A
 * 􉽗vf̃I[o[bv
 * ̊􉽗vfɂp[^͈͂\`vf geom1
 * 
 * ̊􉽗vfɂp[^͈͂\`vf geom2
 * ێB
 * </p>
 * <p>
 * ȂA
 * geom1  geom2 ۂɃI[o[bv邩ǂ́A
 * ̃NX̓ł͊֒mȂB
 * </p>
 *
 * @version $Revision: 1.16 $, $Date: 2000/04/26 09:39:11 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclOverlapCurve3D extends JgclNonParametricCurve3D implements JgclCurveCurveInterference3D {
    /**
     * I[o[bvԂ̌`vf1 ł̈ʒu\`vf
     * <p>
     * `vf1 ȐȂ΃gȐAȖʂȂΖʏ
     * </p>
     * @serial
     */
    private JgclGeometry geom1;

    /**
     * I[o[bvԂ̌`vf2 ł̈ʒu\`vf
     * <p>
     * `vf2 ȐȂ΃gȐAȖʂȂΖʏ
     * </p>
     * @serial
     */
    private JgclGeometry geom2;

    /**
     * 􉽗vfI[o[bvԂ̎w肹ɃIuWFNg\zB
     */
    private JgclOverlapCurve3D() {
	geom1 = null;
	geom2 = null;
    }

    /**
     * ̃gȐ^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param trc1	̋Ȑ (Ȑ1) I[o[bvԂŃg~OȐ
     * @param trc2	̋Ȑ (Ȑ2) I[o[bvԂŃg~OȐ
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclOverlapCurve3D(JgclTrimmedCurve3D trc1,
		       JgclTrimmedCurve3D trc2,
		       boolean doCheck) {
	super();
	this.geom1 = trc1;
	this.geom2 = trc2;
    }

    /**
     * ̋ȐƁAI[o[bvԂ̂ꂼ̋Ȑł̃p[^͈͂^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve1	̋Ȑ (Ȑ1)
     * @param section1	I[o[bvԂ̋Ȑ1 ł̃p[^
     * @param curve2	̋Ȑ (Ȑ2)
     * @param section2	I[o[bvԂ̋Ȑ2 ł̃p[^
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclOverlapCurve3D(JgclParametricCurve3D curve1,
		       JgclParameterSection section1,
		       JgclParametricCurve3D curve2,
		       JgclParameterSection section2,
		       boolean doCheck) {
	super();
	this.geom1 = new JgclTrimmedCurve3D(curve1, section1);
	this.geom2 = new JgclTrimmedCurve3D(curve2, section2);
    }

    /**
     * ̋ȐƁAI[o[bvԂ̂ꂼ̋Ȑł̃p[^͈͂^ăIuWFNg\zB
     * <p>
     * doCheck ̒l͎QƂȂB
     * </p>
     *
     * @param curve1	̋Ȑ (Ȑ1)
     * @param start1	I[o[bvԂ̋Ȑ1 ł̃p[^Ԃ̊Jnl
     * @param inc1	I[o[bvԂ̋Ȑ1 ł̃p[^Ԃ̑l
     * @param curve2	̋Ȑ (Ȑ2)
     * @param start2	I[o[bvԂ̋Ȑ2 ł̃p[^Ԃ̊Jnl
     * @param inc2	I[o[bvԂ̋Ȑ2 ł̃p[^Ԃ̑l
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclOverlapCurve3D(JgclParametricCurve3D curve1,
		       double start1, double inc1,
		       JgclParametricCurve3D curve2,
		       double start2, double inc2,
		       boolean doCheck) {
	super();
	this.geom1 = new JgclTrimmedCurve3D(curve1, new JgclParameterSection(start1, inc1));
	this.geom2 = new JgclTrimmedCurve3D(curve2, new JgclParameterSection(start2, inc2));
    }

    /**
     * ̃I[o[bv̈̊􉽗vf (􉽗vf1) Ȑ (Ȑ1) łƂāA
     * ̋ȐԂB
     * <p>
     * `vf1 ȐłȂꍇ null ԂB
     * </p>
     *
     * @return	`vf1 (Ȑ1)
     */
    public JgclParametricCurve3D curve1() {
	if (!geom1.isCurve())
	    return null;
	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	return trc1.basisCurve();
    }

    /**
     * ̃I[o[bv̈̊􉽗vf (􉽗vf1) Ȑ (Ȑ1) łƂāA
     * ̋Ȑ1 ł̃p[^Ԃ̊JnlԂB
     * <p>
     * `vf1 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ1 ł̃p[^Ԃ̊Jnl
     * @see	JgclFatal
     */
    public double start1() {
	if (!geom1.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	return trc1.tParam1();
    }

    /**
     * ̃I[o[bv̈̊􉽗vf (􉽗vf1) Ȑ (Ȑ1) łƂāA
     * ̋Ȑ1 ł̃p[^Ԃ̏IlԂB
     * <p>
     * `vf1 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ1 ł̃p[^Ԃ̏Il
     * @see	JgclFatal
     */
    public double end1() {
	if (!geom1.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	return trc1.tParam2();
    }

    /**
     * ̃I[o[bv̈̊􉽗vf (􉽗vf1) Ȑ (Ȑ1) łƂāA
     * ̋Ȑ1 ł̃p[^Ԃ̑lԂB
     * <p>
     * `vf1 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ1 ł̃p[^Ԃ̑l
     * @see	JgclFatal
     */
    public double increase1() {
	if (!geom1.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	return end1() - start1();
    }

    /**
     * ̃I[o[bv̑̊􉽗vf (􉽗vf2) Ȑ (Ȑ2) łƂāA
     * ̋ȐԂB
     * <p>
     * `vf2 ȐłȂꍇ null ԂB
     * </p>
     *
     * @return	`vf2 (Ȑ2)
     */
    public JgclParametricCurve3D curve2() {
	if (!geom2.isCurve())
	    return null;
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	return trc2.basisCurve();
    }

    /**
     * ̃I[o[bv̑̊􉽗vf (􉽗vf2) Ȑ (Ȑ2) łƂāA
     * ̋Ȑ2 ł̃p[^Ԃ̊JnlԂB
     * <p>
     * `vf2 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ2 ł̃p[^Ԃ̊Jnl
     * @see	JgclFatal
     */
    public double start2() {
	if (!geom2.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	return trc2.tParam1();
    }

    /**
     * ̃I[o[bv̑̊􉽗vf (􉽗vf2) Ȑ (Ȑ2) łƂāA
     * ̋Ȑ2 ł̃p[^Ԃ̏IlԂB
     * <p>
     * `vf2 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ2 ł̃p[^Ԃ̏Il
     * @see	JgclFatal
     */
    public double end2() {
	if (!geom2.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	return trc2.tParam2();
    }

    /**
     * ̃I[o[bv̑̊􉽗vf (􉽗vf2) Ȑ (Ȑ2) łƂāA
     * ̋Ȑ2 ł̃p[^Ԃ̑lԂB
     * <p>
     * `vf2 ȐłȂꍇ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	Ȑ2 ł̃p[^Ԃ̑l
     * @see	JgclFatal
     */
    public double increase2() {
	if (!geom2.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	return end2() - start2();
    }

    /**
     * ̊_ł邩ۂԂB
     *
     * @return	_ł͂ȂI[o[bvȂ̂ŁA false
     */
    public boolean isIntersectionPoint() {
	return false;
    }

    /**
     * ̊I[o[bvł邩ۂԂB
     *
     * @return	I[o[bvȂ̂ŁA true
     */
    public boolean isOverlapCurve() {
	return true;
    }

    /**
     * ̊_ɕϊB
     * <p>
     * I[o[bv_ɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclIntersectionPoint3D toIntersectionPoint() {
	return null;
    }

    /**
     * ̊I[o[bvɕϊB
     * <p>
     * gԂB
     * </p>
     *
     * @return	g
     */
    public JgclOverlapCurve3D toOverlapCurve() {
	return this;
    }

    /**
     * ̃I[o[bv geom1  geom2 I[o[bvԂB
     *
     * @return	geom1  geom2 I[o[bv
     */
    public JgclOverlapCurve3D exchange() {
	JgclOverlapCurve3D ex = new JgclOverlapCurve3D();
	ex.geom1 = this.geom2;
	ex.geom2 = this.geom1;
	return ex;
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     *
     * @param sec	Ȑ1 ̃p[^
     * @param conv	Ȑ1 ̃p[^lϊIuWFNg
     * @return	Ȑ1 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference3D trim1(JgclParameterSection sec,
					      JgclParameterConversion3D conv) {
	// sec  trc1 ̕Ȑ̃p[^łB
	// (JgclIntersectionPoint3D ƓӖɂ邽)
	// senseAgreement == (tParam1 < tParam2)

	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	int lowerValidity, upperValidity;
	double lower1, upper1;
	double lower, upper;
	if (trc1.senseAgreement()) {
	    lower1 = sec.lower();
	    upper1 = sec.upper();
	}
	else {
	    lower1 = sec.upper();
	    upper1 = sec.lower();
	}

	lower = trc1.toOwnParameter(lower1);
	upper = trc1.toOwnParameter(upper1);
	lowerValidity = trc1.parameterValidity(lower);
	upperValidity = trc1.parameterValidity(upper);

	// gȐ parameterDomain  [0..v]
	//  v = abs(tParam2 - tParam1)
	if (lowerValidity == JgclParameterValidity.OUTSIDE &&
	    lower > 0)
	    return null;	// sec is above upper

	if (upperValidity == JgclParameterValidity.OUTSIDE &&
	    upper <= 0)
	    return null;	// sec is below lower

	if (lowerValidity == JgclParameterValidity.TOLERATED_UPPER_LIMIT) {
	    // touch at upper, so make JgclIntersectionPoint
	    // gȐ parameter ԍő̓_
	    // == Ȑ tParam2 ̓_
	    JgclPointOnCurve3D poc2 =
		new JgclPointOnCurve3D(trc2.basisCurve(), trc2.tParam2(), doCheckDebug);
	    return new JgclIntersectionPoint3D(conv.convToPoint(lower1),
					       poc2,
					       JgclGeometry.doCheckDebug);
	}

	if (upperValidity == JgclParameterValidity.TOLERATED_LOWER_LIMIT) {
	    // touch at lower, so make JgclIntersectionPoint
	    JgclPointOnCurve3D poc1 =
		new JgclPointOnCurve3D(trc2.basisCurve(), trc2.tParam1(), doCheckDebug);
	    return new JgclIntersectionPoint3D(conv.convToPoint(upper1),
					       poc1,
					       JgclGeometry.doCheckDebug);
	}

	double lparam1 = 0;
	double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
	double lparam2 = 0;
	double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());

	if (upperValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint3D upoint1 =
		new JgclPointOnCurve3D(trc1.basisCurve(), upper1, doCheckDebug);
	    uparam2 = trc2.pointToParameter(upoint1);
	    uparam1 = upper;
	}
	if (lowerValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint3D lpoint1 =
		new JgclPointOnCurve3D(trc1.basisCurve(), lower1, doCheckDebug);
	    lparam2 = trc2.pointToParameter(lpoint1);
	    lparam1 = lower;
	}

	JgclParameterSection pint1 = 
	    trc1.toBasisParameter(new JgclParameterSection(lparam1,
							   uparam1 - lparam1));
	JgclParameterSection pint2 = 
	    trc2.toBasisParameter(new JgclParameterSection(lparam2,
							   uparam2 - lparam2));

	if (upperValidity != JgclParameterValidity.PROPERLY_INSIDE &&
	    lowerValidity != JgclParameterValidity.PROPERLY_INSIDE) {
	    // both lower and upper are outside, so no trim required
	    return new JgclOverlapCurve3D(conv.convToTrimmedCurve(pint1),
					  trc2,
					  false);
	}
	else {
	    JgclTrimmedCurve3D trc =
		new JgclTrimmedCurve3D(trc2.basisCurve(), pint2);
	    return new JgclOverlapCurve3D(conv.convToTrimmedCurve(pint1),
					  trc,
					  false);
	}
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ł̈ʒuA
     * ^ꂽϊɂĕϊ̂ɒuԂB
     *
     * @param sec	Ȑ2 ̃p[^
     * @param conv	Ȑ2 ̃p[^lϊIuWFNg
     * @return	Ȑ2 ̈ʒu^ꂽϊɂĕϊ̂ɒu
     */
    public JgclCurveCurveInterference3D trim2(JgclParameterSection sec,
					      JgclParameterConversion3D conv) {
	// sec  trc2 ̕Ȑ̃p[^łB
	// (JgclIntersectionPoint3D ƓӖɂ邽)
	// senseAgreement == (tParam1 < tParam2)

	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)geom1;
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)geom2;
	int lowerValidity, upperValidity;
	double lower2, upper2;
	double lower, upper;
	if (trc2.senseAgreement()) {
	    lower2 = sec.lower();
	    upper2 = sec.upper();
	}
	else {
	    lower2 = sec.upper();
	    upper2 = sec.lower();
	}

	lower = trc2.toOwnParameter(lower2);
	upper = trc2.toOwnParameter(upper2);
	lowerValidity = trc2.parameterValidity(lower);
	upperValidity = trc2.parameterValidity(upper);

	// gȐ parameterDomain  [0..v]
	//  v = abs(tParam2 - tParam1)
	if (lowerValidity == JgclParameterValidity.OUTSIDE &&
	    lower > 0)
	    return null;	// sec is above upper

	if (upperValidity == JgclParameterValidity.OUTSIDE &&
	    upper <= 0)
	    return null;	// sec is below lower

	if (lowerValidity == JgclParameterValidity.TOLERATED_UPPER_LIMIT) {
	    // touch at upper, so make JgclIntersectionPoint
	    // gȐ parameter ԍő̓_
	    // == Ȑ tParam2 ̓_
	    JgclPointOnCurve3D poc2 =
		new JgclPointOnCurve3D(trc1.basisCurve(), trc1.tParam2(), doCheckDebug);
	    return new JgclIntersectionPoint3D(poc2,
					       conv.convToPoint(lower2),
					       JgclGeometry.doCheckDebug);
	}

	if (upperValidity == JgclParameterValidity.TOLERATED_LOWER_LIMIT) {
	    // touch at lower, so make JgclIntersectionPoint
	    JgclPointOnCurve3D poc1 =
		new JgclPointOnCurve3D(trc1.basisCurve(), trc1.tParam1(), doCheckDebug);
	    return new JgclIntersectionPoint3D(poc1,
					       conv.convToPoint(upper2),
					       JgclGeometry.doCheckDebug);
	}

	double lparam1 = 0;
	double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
	double lparam2 = 0;
	double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());

	if (upperValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint3D upoint2 =
		new JgclPointOnCurve3D(trc2.basisCurve(), upper2, doCheckDebug);
	    uparam2 = upper;
	    uparam1 = trc1.pointToParameter(upoint2);
	}
	if (lowerValidity == JgclParameterValidity.PROPERLY_INSIDE) {
	    JgclPoint3D lpoint2 =
		new JgclPointOnCurve3D(trc2.basisCurve(), lower2, doCheckDebug);
	    lparam2 = lower;
	    lparam1 = trc1.pointToParameter(lpoint2);
	}

	JgclParameterSection pint1 = 
	    trc1.toBasisParameter(new JgclParameterSection(lparam1,
							   uparam1 - lparam1));
	JgclParameterSection pint2 = 
	    trc2.toBasisParameter(new JgclParameterSection(lparam2,
							   uparam2 - lparam2));

	if (upperValidity != JgclParameterValidity.PROPERLY_INSIDE &&
	    lowerValidity != JgclParameterValidity.PROPERLY_INSIDE) {
	    // both lower and upper are outside, so no trim required
	    return new JgclOverlapCurve3D(trc1,
					  conv.convToTrimmedCurve(pint2),
					  false);
	}
	else {
	    JgclTrimmedCurve3D trc =
		new JgclTrimmedCurve3D(trc1.basisCurve(), pint1);
	    return new JgclOverlapCurve3D(trc,
					  conv.convToTrimmedCurve(pint2),
					  false);
	}
    }

    /**
     * ̊̈̋Ȑ (Ȑ1) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ1 ɐݒ肷Ȑ
     * @return	Ȑ1u
     */
    public JgclCurveCurveInterference3D changeCurve1(JgclParametricCurve3D newCurve) {
	if (!this.geom1.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
	JgclTrimmedCurve3D newTrc1 =
	    new JgclTrimmedCurve3D(newCurve,
				   trc1.tPnt1(), trc1.tPnt2(),
				   trc1.tParam1(), trc1.tParam2(),
				   trc1.masterRepresentation1(),
				   trc1.masterRepresentation2(),
				   trc1.senseAgreement());
	return new JgclOverlapCurve3D(newTrc1, (JgclTrimmedCurve3D)this.geom2, false);
    }

    /**
     * ̊̑̋Ȑ (Ȑ2) ^ꂽȐɒuԂB
     * <p>
     * p[^lȂǂ͂̂܂܁B
     * </p>
     *
     * @param newCurve	Ȑ2 ɐݒ肷Ȑ
     * @return	Ȑ2 u
     */
    public JgclCurveCurveInterference3D changeCurve2(JgclParametricCurve3D newCurve) {
	if (!this.geom2.isCurve())
	    throw new JgclFatal();
	JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
	JgclTrimmedCurve3D newTrc2 =
	    new JgclTrimmedCurve3D(newCurve,
				   trc2.tPnt1(), trc2.tPnt2(),
				   trc2.tParam1(), trc2.tParam2(),
				   trc2.masterRepresentation1(),
				   trc2.masterRepresentation2(),
				   trc2.senseAgreement());
	return new JgclOverlapCurve3D((JgclTrimmedCurve3D)this.geom1, newTrc2, false);
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	geom1, geom2 ƂɎR`łȂ trueAȂ false
     */
    public boolean isFreeform() {
	return (this.geom1.isFreeform() && this.geom2.isFreeform());
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\ttrc1");
        geom1.output(writer, indent + 2);
        writer.println(indent_tab + "\ttrc2");
        geom2.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
