/*
 * ÕItZbgvZNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclOfst3D.java,v 1.9 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ÕItZbgvZNX
 *
 * @version $Revision: 1.9 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclOfst3D {
    
    /**
     * ItZbg镽
     */
    private JgclParametricSurface3D surface;
    
    /**
     * u\萔
     */
    private final static int u_dir = 0;
    
    /**
     * v\萔
     */
    private final static int v_dir = 1;
    
    /**
     * ItZbg͈
     */
    private JgclParameterSection upint;
    private JgclParameterSection vpint;
    
    /**
     * ItZbg̕
     */
    private int side;
    
    /**
     * ItZbg̒
     */
    private double magni;

    /**
     * 덷
     */
    private JgclToleranceForDistance tolerance;
    
    /**
     * bVz(TvO)
     */
    private JgclMesh3D mesh;
    
    /**
     * RXgN^
     *
     * @param  surface           ItZbg镽
     * @param  upint             ItZbg(u)
     * @param  vpint             ItZbg(v)
     * @param  magni             ItZbg̋
     * @param  side              ItZbg̕
     * @param  tolerance         덷
     */
    JgclOfst3D(JgclParametricSurface3D surface,
	       JgclParameterSection upint,
	       JgclParameterSection vpint,
	       double magni,
	       int side,
	       JgclToleranceForDistance tolerance){
	surface.checkUValidity(upint);
	surface.checkVValidity(vpint);
        this.surface = surface;
        this.upint = upint;
        this.vpint = vpint;
        this.magni = magni;
        this.side = side;
        this.tolerance = tolerance;
    }

    /**
     * Ȗʂ̃ItZbg߂
     *
     * @return           ItZbgȖ
     */
    private JgclBsplineSurface3D offset_bss(){

        // TvO(bVɕϊ)
        set_sampling_points();
        
        // ItZbg_߂
        JgclPoint3D[][] offset_mesh = set_offset_points();
	
	// p[^߂
	double[] uparams = make_own_parameter(offset_mesh,u_dir);
	double[] vparams = make_own_parameter(offset_mesh,v_dir);
        
	// ԋߎ
	JgclBsplineSurface3D obss = approx_bss(offset_mesh,uparams,vparams);
	
        return obss;
    }

    /**
     * bV߂(TvO)
     *
     * @return      bVIuWFNg
     */
    private void set_sampling_points(){
        
        // TvOɂ͕ϐtolerance̔̒lp
        JgclToleranceForDistance tol = 
	    new JgclToleranceForDistance(0.5*tolerance.value());
        
        mesh = surface.toMesh(upint,vpint,tol);
    }    
    
    /**
     * bVItZbg_߂(ٓ_Ȃ)
     *
     * @return      ItZbgꂽbV
     */
    private JgclPoint3D[][] set_offset_points(){
        int i,j;
        JgclPoint3D[][] offset_mesh = 
	    new JgclPoint3D[mesh.uNPoints()][mesh.vNPoints()];
        
        // ItZbg_߂
        for(i=0;i<mesh.uNPoints();i++)
	    for(j=0;j<mesh.vNPoints();j++){
		offset_mesh[i][j] = 
		    make_offset_point(i,j);
	    }
        return offset_mesh;
    }      
    
    /**
     * ItZbg_BXvCǖʂŋߎ
     *
     * @param   offset_points ItZbg_
     * @param   uparams       ũp[^
     * @param   vparams       ṽp[^
     * @return                ItZbgȖ
     */
    private JgclBsplineSurface3D approx_bss(JgclPoint3D[][] offset_points,
					    double[] uparams,
					    double[] vparams){

	JgclBsplineSurface3D bss = 
	    new JgclBsplineSurface3D(offset_points,
				     uparams,
				     vparams,
				     mesh.uClosed(),
				     mesh.vClosed(),
				     tolerance);
	return bss;
    }

    /**
     * ItZbg_vZ
     *
     * @param  i     ũCfbNX
     * @param  j     ṽCfbNX
     * @return       ItZbg_
     */
    private JgclPoint3D make_offset_point(int i,int j){
        
        // ܂AItZbgxNg߂
        JgclPointOnSurface3D base_point = 
	    (JgclPointOnSurface3D)mesh.pointAt(i,j);
        double[] params = base_point.parameters();
	
        JgclVector3D offset_vector = 
	    surface.normalVector(params[0],params[1]);
	
        offset_vector = offset_vector.unitized();
        offset_vector = offset_vector.multiply(magni);

        // ItZbg_߂
        JgclPoint3D point = surface.coordinates(params[0],params[1]);
	JgclPoint3D offset_point;
        if(side == JgclWhichSide.FRONT)
	    offset_point = point.add(offset_vector);
	else if(side == JgclWhichSide.BACK){
	    offset_vector = offset_vector.reverse();
	    offset_point = point.add(offset_vector);
	} else 
	    throw new JgclInvalidArgumentValue();
	
        return offset_point;
    }

    /**
     * ItZbg_̃p[^߂
     *
     * @param  points  ItZbgz
     * @param  dir     ItZbg̕
     * @return         p[^z
     */
    private double[] make_own_parameter(JgclPoint3D[][] points,int dir){
        int longest_line;           // Ԓ̃CfbNX
        double[] length;            // ̔z
        JgclPoint3D[] one_line;     // _(C)
        int num_of_line;            // C̐
        int i,j;
        double inc;
        boolean is_closed;
	
        longest_line = get_longest_line(points,dir);
	
        // ϐɒlZbg
        if(dir == u_dir){
            num_of_line = mesh.uNPoints();
            inc = upint.increase();
            is_closed = mesh.uClosed();
            one_line = new JgclPoint3D[num_of_line];
	    for(i=0;i<num_of_line;i++)
		one_line[i] = points[i][longest_line];
        } else {
            num_of_line = mesh.vNPoints();
            inc = vpint.increase();
            is_closed = mesh.vClosed();
            one_line = new JgclPoint3D[num_of_line];
            for(i=0;i<num_of_line;i++)
		one_line[i] = points[longest_line][i];
        }
	
        // ߂
        double[] array_of_length = new double[num_of_line];
        array_of_length[0] = 0.0;
        JgclPoint3D source_point = one_line[0];
        for(i=1;i<num_of_line;i++){
            array_of_length[i] = 
		array_of_length[i-1] + one_line[i].distance(source_point);
            source_point = one_line[i];
        }
        
        // Pʒ̃p[^̑𓾂
        double increase_per_length = inc/array_of_length[num_of_line-1];
        
        double[] own_params = new double[num_of_line];
        own_params[0] = 0.0;
        
        for(i=1;i<num_of_line;i++)
	    own_params[i] = array_of_length[i] * increase_per_length;
	
        return own_params;
    }
    
    /**
     * bVňԒ߂
     *
     * @param   points ItZbg_
     * @param   dir    
     * @return         Ԓ̃CfbNX
     */
    private int get_longest_line(JgclPoint3D[][] points,int dir){
        double length,max_length;
        int longest_line;
        int i,j;
	
        max_length = 0.0;
        longest_line = -1;
	
        if(dir == u_dir){
            for(j=0;j<mesh.vNPoints();j++){
                length = 0.0;
                for(i=1;i<mesh.uNPoints();i++)
		    length += points[i][j].distance(points[i-1][j]);
                if(mesh.uClosed() == true)
		    length += points[0][j].distance(points[i-1][j]);
                if(length > max_length){
                    max_length = length;
                    longest_line = j;
                }
            }
        } else {
            for(i=0;i<mesh.uNPoints();i++){
                length = 0.0;
                for(j=1;j<mesh.vNPoints();j++)
		    length += points[i][j].distance(points[i][j-1]);
                if(mesh.vClosed() == true)
		    length += points[i][0].distance(points[i][j-1]);
                if(length > max_length){
                    max_length = length;
                    longest_line = i;
                }
            }
        }
        
        return longest_line;
    }

    /**
     * ItZbgԂ
     *
     * @return     ItZbgȖ
     */
    JgclBsplineSurface3D offset(){
        if(magni == 0.0)
	    return surface.toBsplineSurface(upint,vpint);
        else 
	    return offset_bss();
    }
}
