/*
 * R : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclLine3D.java,v 1.67 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : \NXB
 * <p>
 * ́Â_ pnt ƕxNg dir Œ`B
 * </p>
 * <p>
 * t p[^Ƃ钼 P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = pnt + t * dir
 * </pre>
 * </p>
 * <p>
 * uȐvłB
 * </p>
 * <p>
 * ͖̒Ȓ\B
 * LȒ\ꍇɂ
 * {@link JgclBoundedLine3D JgclBoundedLine3D}
 * 
 * {@link JgclTrimmedCurve3D JgclTrimmedCurve3D}
 * płB
 * </p>
 *
 * @version $Revision: 1.67 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclLine3D extends JgclParametricCurve3D {
    /**
     * ̂_B
     * <p>
     * p[^l 0 ɑΉ_B
     * </p>
     * @serial
     */
    private final JgclPoint3D pnt;

    /**
     * xNgB
     * <p>
     * p[^l 1 ɑΉ_ pnt + dir ɂȂB
     * </p>
     * @serial
     */
    private final JgclVector3D dir;

    /**
     * tB[hɐݒ肷l̂܂ܗ^ăIuWFNg\zB
     * <p>
     * pnt p[^l 0 ̓_ƂA
     * dir xNgƂ钼𐶐B
     * </p>
     * <p>
     * dir ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt	̂_ (p[^l 0 ɑΉ)
     * @param dir	xNg
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclLine3D(JgclPoint3D pnt, JgclVector3D dir) {
	super();

	if (dir.norm() < getToleranceForDistance2())
	    throw new JgclInvalidArgumentValue();
	this.pnt = pnt;
	this.dir = dir;
    }

    /**
     * ʉ߂_^ăIuWFNg\zB
     * <p>
     * pnt1 p[^l 0 ̓_ƂA
     * pnt2 p[^l 1 ̓_Ƃ
     * 𐶐B
     * </p>
     * <p>
     * pnt  dir ́Aȉ̂悤ɐݒ肳B
     * <pre>
     *		pnt = pnt1
     *		dir = pnt2 - pnt1
     * </pre>
     * </p>
     * <p>
     * pnt1  pnt2 A
     * ݐݒ肳Ă鉉Z̋̋e덷̉ŁA
     * ̓_ƌȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt1	̂_ (p[^l 0 ɑΉ)
     * @param pnt2	̂_ (p[^l 1 ɑΉ)
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint3D#identical(JgclPoint3D)
     */
    public JgclLine3D(JgclPoint3D pnt1, JgclPoint3D pnt2) {
	super();

	if (pnt1.identical(pnt2))
	    throw new JgclInvalidArgumentValue();
	this.pnt = pnt1;
	this.dir = pnt2.subtract(pnt1);
    }

    /**
     * ̒`Ă̂_ (p[^l 0 ɑΉ_) ԂB
     * 
     * @return		̂_ (p[^l 0 ɑΉ_)
     */
    public JgclPoint3D pnt() {
	return this.pnt;
    }

    /**
     * ̒`ĂxNgԂB
     * <p>
     * ̃xNǵA̒̐ڃxNgɓB
     * </p>
     * 
     * @return		xNg
     */
    public JgclVector3D dir() {
	return this.dir;
    }

    /**
     * ̋Ȑ́A^ꂽp[^Ԃɂԏł̒ (̂) ԂB
     * 
     * @param pint	߂p[^
     * @return		w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        return dir.length() * Math.abs(pint.increase());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	return pnt.add(dir.multiply(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ̐ڃxNǵA dir ɓB
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	return dir;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ̋ȗ́A 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	return new JgclCurveDerivative3D(coordinates(param),
					 dir, 
					 JgclVector3D.zeroVector,
					 JgclVector3D.zeroVector);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ̃ĆA 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     */
    public double torsion(double param) {
	return 0.0;
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ɂ͓ٓ_݂͑Ȃ̂ŁAɗvf 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ɂ͕ϋȓ_݂͑Ȃ̂ŁAɗvf 0 ̔zԂB
     * </p>
     * 
     * @return		ϋȓ_̔z
     */
    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * 钼ւ̔Cӂ̓_̓e_͕̐K 1 ɂȂB
     * </p>
     * <p>
     * ̃\bh́A
     * {@link JgclParametricCurve3D JgclParametricCurve3D} NX
     * ۃ\bhƂĐ錾Ă̂ł邪A
     * ̃NXɂ͓e_߂郁\bhƂāA
     * {@link #project1From(JgclPoint3D) project1From(JgclPoint3D)}
     * B
     * project1From(JgclPoint3D) ́A
     * ue_̔zvł͂ȂA
     * ue_v̂܂ܕԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see #project1From(JgclPoint3D)
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) 
    {
	JgclPointOnCurve3D[] proj = new JgclPointOnCurve3D[1];
	proj[0] = project1From(point);
	return proj;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂA
     * ʂƂĕԂ|ĆA
     * ̒̎w肳ꂽԂ́uߎvł͂ȂAȁuČvłB
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see		JgclPointOnCurve3D
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {
	JgclPoint3D[] points = new JgclPoint3D[2];

	points[0] = new JgclPointOnCurve3D(this, pint.start(), doCheckDebug);
	points[1] = new JgclPointOnCurve3D(this, pint.end(), doCheckDebug);

	if (points[0].identical(points[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline3D(points);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * ʂƂĕԂL Bspline Ȑ
     * PŐ_ 2A[d̃jtH[ȃmbgB
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclPoint3D[] controlPoints = {this.coordinates(pint.start()),
				       this.coordinates(pint.end())};
	double[] weights = {1.0, 1.0};

	return new JgclBsplineCurve3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
				      controlPoints, weights);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ŁA񒼐I[o[bvĂꍇɂ́A
     * słƂ JgclIndefiniteSolution 𔭐B
     * 񒼐I[o[bvĂƔf
     * {@link #intersect1Line(JgclLine3D) intersect1Line(JgclLine3D)}
     * ƓlłB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ŁA񒼐̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
  	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̒Ƒ̒Ƃ () _߂B
     * <p>
     * 񒼐słꍇɂ null ԂB
     * 񒼐̕xNĝȂpx (̓ - ) 
     * ݐݒ肳Ă鉉Źupx̋e덷ȓvł΁A
     * 񒼐͕sł̂ƔfB
     * </p>
     * <p>
     * A񒼐słꍇɁA
     * ꂩ pnt 瑊ւ̋
     * ݐݒ肳Ă鉉Źűe덷ȓvł΁A
     * 񒼐̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̒
     * @return		_
     * @exception	JgclIndefiniteSolution 񒼐̓I[o[bvĂAsł
     * @see	JgclConditionOfOperation
     * @see	JgclVector3D#parallelDirection(JgclVector3D)
     */
    public JgclIntersectionPoint3D intersect1Line(JgclLine3D mate)
	throws JgclIndefiniteSolution
    {
	JgclVector3D p = mate.pnt().subtract(pnt());
	JgclVector3D pa = p.crossProduct(dir());
	JgclVector3D pb = p.crossProduct(mate.dir());
	double dTol = getToleranceForDistance();

	if (dir().parallelDirection(mate.dir())) {
	    if (pa.length() / dir().length() < dTol ||
		pb.length() / mate.dir().length() < dTol) {
		// same line
		JgclPointOnCurve3D pnt1 = new JgclPointOnCurve3D(this, 0, doCheckDebug);
		JgclPointOnCurve3D pnt2 = mate.project1From(pnt1);
		JgclIntersectionPoint3D ip = 
		    new JgclIntersectionPoint3D(pnt1, pnt2, doCheckDebug);
		throw new JgclIndefiniteSolution(ip);
	    }
	    else
		return null;	// parallel
	}

	JgclVector3D o = dir().crossProduct(mate.dir());

	if (!o.parallelDirection(pa) || !o.parallelDirection(pb))
	    return null;	// twisted

	double paramT = pb.length() / o.length();
	if (pb.dotProduct(o) < 0.0)
	    paramT = -paramT;
	double paramM = pa.length() / o.length();
	if (pa.dotProduct(o) < 0.0)
	    paramM = -paramM;
	return new JgclIntersectionPoint3D(this, paramT,
					   mate, paramM, doCheckDebug);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * słƂ JgclIndefiniteSolution 𔭐
     * {@link #intersect1Line(JgclLine3D) intersect1Line(JgclLine3D)}
     * ƓlłB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link #intersect1Line(JgclLine3D) intersect1Line(JgclLine3D)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D ints;
	if ((ints = intersect1Line(mate)) == null) {
	    return new JgclIntersectionPoint3D[0];
	}
	if (doExchange)
	    ints = ints.exchange();
	JgclIntersectionPoint3D[] sol = new JgclIntersectionPoint3D[1];
	sol[0] = ints;
	return sol;
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~Ȑ̃NX́u~Ȑ vs. v̌_Z\bh
     * {@link JgclConic3D#intersect(JgclLine3D, boolean)
     * JgclConic3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~ ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~Ȑ̃NX́u~Ȑ vs. v̌_Z\bh
     * {@link JgclConic3D#intersect(JgclLine3D, boolean)
     * JgclConic3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~Ȑ̃NX́u~Ȑ vs. v̌_Z\bh
     * {@link JgclConic3D#intersect(JgclLine3D, boolean)
     * JgclConic3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~Ȑ̃NX́u~Ȑ vs. v̌_Z\bh
     * {@link JgclConic3D#intersect(JgclLine3D, boolean)
     * JgclConic3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. v̌_Z\bh
     * {@link JgclPolyline3D#intersect(JgclLine3D, boolean)
     * JgclPolyline3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * xWGȐ̃NX́uxWGȐ vs. v̌_Z\bh
     * {@link JgclPureBezierCurve3D#intersect(JgclLine3D, boolean)
     * JgclPureBezierCurve3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * aXvCȐ̃NX́uaXvCȐ vs. v̌_Z\bh
     * {@link JgclBsplineCurve3D#intersect(JgclLine3D, boolean)
     * JgclBsplineCurve3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclLine3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclLine3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. v̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclLine3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate)
      	throws JgclIndefiniteSolution {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ͋ȖʃNX́u͋Ȗ vs. v̌_Z\bh
     * {@link JgclElementarySurface3D#intersect(JgclLine3D, boolean)
     * JgclElementarySurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) 
  	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	this  mate ɏĂAsł
     */
    public JgclIntersectionPoint3D[] intersect(JgclPlane3D mate)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D intersectionPoint = mate.intersect1(this);
	JgclIntersectionPoint3D[] ints = { intersectionPoint.exchange() };
	return ints;
    }

    /**
     * ̋ȐƑ̋Ȗ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * {@link JgclPlane3D#intersect1(JgclLine3D) JgclPlane3D.intersect1(JgclLine3D)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	this  mate ɏĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclPlane3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D intersectionPoint = mate.intersect1(this);
	if (!doExchange) {
	    intersectionPoint = intersectionPoint.exchange();
	}
	JgclIntersectionPoint3D[] ints = { intersectionPoint };
	return ints;
    }

    /**
     * ̋ȐƑ̋Ȗ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ʂ̃NX́u vs. v̌_Z\bh
     * {@link JgclSphericalSurface3D#intersect(JgclLine3D, boolean)
     * JgclSphericalSurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~ʂ̃NX́u~ vs. v̌_Z\bh
     * {@link JgclCylindricalSurface3D#intersect(JgclLine3D, boolean)
     * JgclCylindricalSurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	this  mate ɏĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) 
  	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~ʂ̃NX́u~ vs. v̌_Z\bh
     * {@link JgclConicalSurface3D#intersect(JgclLine3D, boolean)
     * JgclConicalSurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	this  mate ɏĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclConicalSurface3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * xWGȖʂ̃NX́uxWGȖ vs. v̌_Z\bh
     * {@link JgclPureBezierSurface3D#intersect(JgclLine3D, boolean)
     * JgclPureBezierSurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange)
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * aXvCȖʂ̃NX́uaXvCȖ vs. v̌_Z\bh
     * {@link JgclBsplineSurface3D#intersect(JgclLine3D, boolean)
     * JgclBsplineSurface3D.intersect(JgclLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange)
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ^ꂽ_炱̒ւ (݂) e_߂B
     * <p>
     * ͈ȉ̒ʂB
     * <br>
     * (point - this.pnt)  (this.dir ̒PʃxNg) ̓ς̒l
     * ̒ɑ΂铊e_̃p[^lƂA
     * ̃p[^l JgclPointOnCurve3D ̃CX^XԂB
     * </p>
     *
     * @param point     e̓_
     * @return          e_
     * @see	#projectFrom(JgclPoint3D) 
     */
    public JgclPointOnCurve3D project1From(JgclPoint3D point)
    {
        /*
         * ALGORITHM
         *
         *                            point
         *                              x
         *                             /|
         *                            / |
         *                           /  |
         *                          /   |
         *                   theta /    |
         *                        /\    |   Line.pnt + ( param * Line.dir )
         *                 ------x------x-------->     (param: real)
         *                  Line.pnt    prj
         *
         *     evpp = vector of ( Line.pnt --> point )
         *     euvec = unit direction vector of Line
         *
         *     prj = Line.pnt + ( |evpp|*cos( theta ) * euvec )
         *         = Line.pnt + ( (evpp, euvec) * euvec )
         *         = Line.pnt + ( (dir / sqrt(|Line.dir|), euvec) ) *
         *                        ( Line.dir / sqrt(|Line.dir| )
         *         = Line.pnt + ( (dir, euvec) / |Line.dir| ) * Line.dir
         *                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ parameter
         */

        // ̎n_瓊e̓_܂ł̃xNg߂
        JgclVector3D evpp = point.subtract(pnt);

        // xNg̓ς瓊e_̃p[^߂
        double edot = dir.dotProduct(evpp);
        double param = edot / dir.norm();

        // e_߂
        return new JgclPointOnCurve3D(this, param, doCheckDebug);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclLine3D(pnt().add(moveVec), dir());
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * ŔIȃp[^`ԂB
     * </p>
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȃ̂ŁA false ԂB
     * </p>
     *
     * @return	͕邱Ƃ͂Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#LINE_3D JgclParametricCurve3D.LINE_3D}
     */
    int type() {
	return LINE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclPoint3D rpnt = pnt().rotateZ(trns, rCos, rSin);
	JgclVector3D rdir = dir().rotateZ(trns, rCos, rSin);
	return new JgclLine3D(rpnt, rdir);
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	double start = 0.0, increase = 1.0;
	int itry = 0, limit = 100;
	JgclPoint3D point;
	JgclVector3D vector;

	/*
	 * Get a point which is not on the line, then verify that
	 * the distance between a point and the line is greater
	 * than the tolerance.
	 */
	do {
	    if (itry > limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = this.coordinates(start + (increase * itry));
	    vector = point.subtract(line.project1From(point));
	    itry ++;
	} while(point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̒A^ꂽǏWn XY ʂɓeē񎟌ԂB
     *
     * @param transform	ǏWn瓾ꂽWϊZq
     * @return	񎟌
     */
    JgclLine2D toLocal2D(JgclCartesianTransformationOperator3D transform) {
	return new JgclLine2D(pnt().to2D(transform),
			      dir().to2D(transform));
    }

    /**
     * ̒ƁA^ꂽ̋ʖ@߂B
     * <p>
     * ʂƂēz̗vf 2 łB
     * ŏ̗vfɂ̒̓_A
     * Ԗڂ̗vfɗ^ꂽ̓_B
     * </p>
     * <p>
     * 񒼐̕xNĝȂpx (̓ - ) 
     * ݐݒ肳Ă鉉Z̊px̋e덷菬΁A
     * 񒼐͕sł̂ƔfA
     * JgclIndefiniteSolution ̗OԂB
     * </p>
     *
     * @param   mate    
     * @return	ʖ@̒[_
     * @exception       JgclIndefiniteSolution      sł (񒼐sł)
     */
    JgclPointOnCurve3D[] commonNormal(JgclLine3D mate) throws JgclIndefiniteSolution {
	JgclVector3D thisUnitVec = this.dir().unitized();
	JgclVector3D mateUnitVec = mate.dir().unitized();
	double aTol = getToleranceForAngle();

	if (Math.abs(thisUnitVec.dotProduct(mateUnitVec)) > Math.cos(aTol)) {
	    throw new JgclIndefiniteSolution(this);
	}
	JgclVector3D crossVec = thisUnitVec.crossProduct(mateUnitVec);
	JgclAxis2Placement3D position;

	JgclVector3D aNormVec = thisUnitVec.crossProduct(crossVec);
	position = new JgclAxis2Placement3D(this.pnt(),
					    aNormVec, aNormVec.verticalVector());
	JgclPlane3D planeA = new JgclPlane3D(position);
	JgclIntersectionPoint3D[] planeAlineB;
	try {
	    planeAlineB = planeA.intersect(mate);
	}
	catch (JgclIndefiniteSolution e) {
	    throw e;
	}

	JgclVector3D bNormVec = mateUnitVec.crossProduct(crossVec);
	position = new JgclAxis2Placement3D(mate.pnt(),
					    bNormVec, bNormVec.verticalVector());
	JgclPlane3D planeB = new JgclPlane3D(position);
	JgclIntersectionPoint3D[] planeBlineA;	
	try {
	    planeBlineA = planeB.intersect(this);
	}
	catch (JgclIndefiniteSolution e) {
	    throw e;
	}

	JgclPointOnCurve3D[] point = new JgclPointOnCurve3D[2];
	point[0] = planeAlineB[0].pointOnCurve2();
	point[1] = planeBlineA[0].pointOnCurve2();

	return point;
    }

    /**
     * ̒ƁA^ꂽ̂Ȃpx߂B
     *
     * @param   mate    
     * @return		񒼐̂Ȃpx
     */
    double angleWith(JgclLine3D mate) {
	JgclVector3D thisVec = this.dir().unitized();
	JgclVector3D mateVec = mate.dir().unitized();
	double cosAB = thisVec.dotProduct(mateVec);

	if (cosAB > 1.0)
	    cosAB = 1.0;
	if (cosAB < -1.0)
	    cosAB = -1.0;

	return Math.acos(cosAB);
    }

    /**
     * ^ꂽ_炱̒ւ̋߂B
     *
     * @param   mate	_
     * @return	_炱̒ւ̋
     */
    double distanceFrom(JgclPoint3D point) {
	JgclVector3D subVec = point.toVector3D().subtract(this.pnt().toVector3D());
	JgclVector3D unitVec = this.dir().unitized();
	JgclVector3D crossVec = unitVec.crossProduct(subVec);

	return Math.sqrt(crossVec.norm());
    }

    /**
     * ̒ƁA^ꂽƂ̋߂B
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * 񒼐̕xNĝȂpx (̓ - ) 
     * px̋e덷菬A
     * ̒̂_^ꂽւ̋
     * ̋e덷菬ꍇɂ́A
     * ̋Ԃ̂ł͂ȂA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     *
     * @param   mate    
     * @return	񒼐Ԃ̋
     * @exception	JgclIndefiniteSolution	񒼐̋̋e덷菬
     * @see	#distanceFrom(JgclPoint3D)
     */
    double distanceFrom(JgclLine3D mate) throws JgclIndefiniteSolution {
	JgclVector3D thisVec = this.dir().unitized();
	JgclVector3D mateVec = mate.dir().unitized();
	JgclVector3D crossVec = thisVec.crossProduct(mateVec);

	double aTol = getToleranceForAngle();
	double aTol2 = aTol * aTol;
	double dTol = getToleranceForDistance();
	double dist;

	if (crossVec.norm() < aTol2) {
	    // Parallel
	    dist = mate.distanceFrom(this.pnt());
	    if (Math.abs(dist) < dTol)
		// overlap
		throw new JgclIndefiniteSolution(this);
	    return dist;
	}

	JgclVector3D normVec = this.dir().crossProduct(mate.dir());
	JgclVector3D axis = normVec.crossProduct(this.dir());
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(this.pnt(), axis, this.dir());
	JgclPlane3D plane = new JgclPlane3D(position);
	JgclIntersectionPoint3D[] point = mate.intersect(plane);
	if (point.length != 1) throw new JgclFatal();

	return this.distanceFrom(point[0]);
    }

    /**
     * ꂽxWGȖʂƂ̊𒲂ׂ
     *
     * @param bi xWGȖʏ
     * @return   邩ǂ
     */
    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
	double dTol = getToleranceForDistance();
	if (!(bi.box.min().y() < dTol))
	    return false;
	if (!(bi.box.min().z() < dTol))
	    return false;
	if (!(bi.box.max().y() > -dTol))
	    return false;
	if (!(bi.box.max().z() > -dTol))
	    return false;

	return true;
    }

    /**
     * nlFunc
     */
    JgclPoint3D nlFunc(double parameter) {
	double ework = Math.sqrt(this.dir().norm());
	JgclLine3D line =
	    new JgclLine3D(JgclPoint3D.origin,
			   new JgclLiteralVector3D(ework, 0, 0));

	double x = line.dir().x() * parameter;
	double y = 0.0;
	double z = 0.0;

	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * dnlFunc
     */
    JgclVector3D dnlFunc(double parameter) {
	double ework = Math.sqrt(this.dir().norm());

	return new JgclLiteralVector3D(ework, 0, 0);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tPnt = this.pnt().transformBy(reverseTransform,
						  transformationOperator, transformedGeometries);
	JgclVector3D tDir = this.dir().transformBy(reverseTransform,
						   transformationOperator, transformedGeometries);
	return new JgclLine3D(tPnt, tDir);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpnt");
        pnt.output(writer, indent + 2);
        writer.println(indent_tab + "\tdir");
        dir.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
