/*
 * Ȗ(͓I/xWG/BXvC)BXvCȖʂ̌߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsSrfBss3D.java,v 1.11 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * (͓I/xWG/BXvC)ȖʂBXvCȖʂ̌߂NX
 *
 * @version $Revision: 1.11 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsSrfBss3D
{
    private static final boolean DEBUG = false;

    /**
     * Ǐp[^lŕ\2D|Cl̂̂֕ϊ
     *
     * @param	validSegments	Ȗʂ̗̂LȃZOg̏
     * @param	index	ΏۂƂLȃZOg̓Y
     * @param	local	Ǐp[^l
     * @retrun	lŕ\2D|C
     */
    private static JgclPolyline2D l2Gc(JgclBsplineKnot.ValidSegmentInfo uValidSegments,
				       int uIndex,
				       JgclBsplineKnot.ValidSegmentInfo vValidSegments,
				       int vIndex,
				       JgclPolyline2D pol2d)
    {
	int npnts = pol2d.nPoints();
	JgclPoint2D[] pnts = new JgclPoint2D[npnts];
	for (int i = 0; i < npnts; i++)
	    pnts[i] = new JgclCartesianPoint2D(uValidSegments.l2Gp(uIndex, pol2d.pointAt(i).x()),
					       vValidSegments.l2Gp(vIndex, pol2d.pointAt(i).y()));
	return new JgclPolyline2D(pnts, pol2d.closed());
    }

    /**
     * ͓IȖʂBXvCȖʂ̌߂
     *
     * @param	elmA	2Ȗ A
     * @param	bssB	BXvCȖ B
     * @return		ȐƋȖʂ̌_̔z
     * @see		JgclSurfaceSurfaceInterferenceList
     */
    private static JgclSurfaceSurfaceInterferenceList
    getInterference(JgclElementarySurface3D elmA,
		    JgclBsplineSurface3D bssB)
    {
	int i, j;

	// ̃Xg
	JgclSurfaceSurfaceInterferenceList interferenceList
	    = new JgclSurfaceSurfaceInterferenceList(elmA, bssB);

	if (elmA.type() == JgclParametricSurface3D.PLANE_3D) {
	    JgclPlane3D plnA = (JgclPlane3D)elmA;
	    int uUicp = bssB.uNControlPoints();
	    int vUicp = bssB.vNControlPoints();
	    int pside;

	    if ((pside = plnA.pointIsWhichSide(bssB.controlPointAt(0, 0))) != JgclWhichSide.ON) {
		boolean sameSide = true;
	      sideCheck:
		for (i = 0; i < uUicp; i++)
		    for (j = 0; j < vUicp; j++) {
			if (i == 0 && j == 0)
			    continue;
			if (plnA.pointIsWhichSide(bssB.controlPointAt(i, j)) != pside) {
			    sameSide = false;
			    break sideCheck;
			}
		    }

		if (sameSide)
		    return interferenceList;
	    }
	}

	// Ȗ B U/V̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();

	JgclSurfaceSurfaceInterference3D[] ints;
	JgclIntersectionPoint3D intp;
	JgclIntersectionCurve3D intc;

	// Ȗ B ŮeZOgɑ΂
	for (int iBu = 0; iBu < bzssB.length; iBu++) {
	    // Ȗ B V̊eZOgɑ΂
	    for (int iBv = 0; iBv < bzssB[iBu].length; iBv++) {
		if (DEBUG) {
		    bzssB[iBu][iBv].output(System.out);
		}
		// xWGȖʃxł̊𓾂
		try {
		    ints = elmA.intersect(bzssB[iBu][iBv]);
		} catch (JgclIndefiniteSolution e) {
		    throw new JgclFatal();
		}

		for (i = 0; i < ints.length; i++) {
		    // _Xgɒǉ
		    if (ints[i].isIntersectionPoint()) {
			intp = ints[i].toIntersectionPoint();
			interferenceList.addAsIntersectionPoint
			    (intp.coordinates(),
			     intp.pointOnSurface1().uParameter(),
			     intp.pointOnSurface1().vParameter(),
			     vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()),
			     vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
		    }

		    // Xgɒǉ
		    else {	// if (ints[i].isIntersectionCurve())
			intc = ints[i].toIntersectionCurve();
			interferenceList.addAsIntersectionCurve
			    ((JgclPolyline3D)intc.curve3d(),
			     (JgclPolyline2D)intc.curve2d(),
			     l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
		    }
		}
	    }
	}

	// fĂȂ
	interferenceList.connectIntersectionCurves();

	return interferenceList;
    }

    /**
     * xWGȖʂBXvCȖʂ̌߂
     *
     * @param	bzsA	xWGȖ A
     * @param	bssB	BXvCȖ B
     * @return		ȐƋȖʂ̌_̔z
     * @see		JgclSurfaceSurfaceInterferenceList
     */
    private static JgclSurfaceSurfaceInterferenceList
    getInterference(JgclPureBezierSurface3D bzsA,
		    JgclBsplineSurface3D bssB)
    {
	int i, j;

	// ̃Xg
	JgclSurfaceSurfaceInterferenceList interferenceList
	    = new JgclSurfaceSurfaceInterferenceList(bzsA, bssB);

	// Ȗ B U/V̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();

	JgclSurfaceSurfaceInterference3D[] ints;
	JgclIntersectionPoint3D intp;
	JgclIntersectionCurve3D intc;

	// Ȗ B ŮeZOgɑ΂
	for (int iBu = 0; iBu < bzssB.length; iBu++) {
	    // Ȗ B V̊eZOgɑ΂
	    for (int iBv = 0; iBv < bzssB[iBu].length; iBv++) {
		if (DEBUG) {
		    bzssB[iBu][iBv].output(System.out);
		}
		// xWGȖʃxł̊𓾂
		ints = bzsA.intersect(bzssB[iBu][iBv]);

		for (i = 0; i < ints.length; i++) {
		    // _Xgɒǉ
		    if (ints[i].isIntersectionPoint()) {
			intp = ints[i].toIntersectionPoint();
			interferenceList.addAsIntersectionPoint
			    (intp.coordinates(),
			     intp.pointOnSurface1().uParameter(),
			     intp.pointOnSurface1().vParameter(),
			     vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()),
			     vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
		    }

		    // Xgɒǉ
		    else {	// if (ints[i].isIntersectionCurve())
			intc = ints[i].toIntersectionCurve();
			interferenceList.addAsIntersectionCurve
			    ((JgclPolyline3D)intc.curve3d(),
			     (JgclPolyline2D)intc.curve2d(),
			     l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
		    }
		}
	    }
	}

	// fĂȂ
	interferenceList.connectIntersectionCurves();

	return interferenceList;
    }

    /**
     * BXvCȖʓm̌߂
     *
     * @param	bssA	BXvCȖ A
     * @param	bssB	BXvCȖ B
     * @return		ȐƋȖʂ̌_̔z
     * @see		JgclSurfaceSurfaceInterferenceList
     */
    private static JgclSurfaceSurfaceInterferenceList
    getInterference(JgclBsplineSurface3D bssA,
		    JgclBsplineSurface3D bssB)
    {
	int i, j;

	// ̃Xg
	JgclSurfaceSurfaceInterferenceList interferenceList
	    = new JgclSurfaceSurfaceInterferenceList(bssA, bssB);

	// Ȗ A U/V̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsAu = bssA.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vldsAv = bssA.vValidSegments();
	// Ȑ A \xWGȐ
	JgclPureBezierSurface3D[][] bzssA = bssA.toPureBezierSurfaceArray();

	// Ȗ B U/V̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();

	JgclSurfaceSurfaceInterference3D[] ints;
	JgclIntersectionPoint3D intp;
	JgclIntersectionCurve3D intc;

	// Ȗ A ŮeZOgɑ΂
	for (int iAu = 0; iAu < bzssA.length; iAu++) {
	    // Ȗ A V̊eZOgɑ΂
	    for (int iAv = 0; iAv < bzssA[iAu].length; iAv++) {
		// Ȗ B ŮeZOgɑ΂
		for (int iBu = 0; iBu < bzssB.length; iBu++) {
		    // Ȗ B V̊eZOgɑ΂
		    for (int iBv = 0; iBv < bzssB[iBu].length; iBv++) {
			if (DEBUG) {
			    bzssA[iAu][iAv].output(System.out);
			    bzssB[iBu][iBv].output(System.out);
			}
			// xWGȖʃxł̊𓾂
			ints = bzssA[iAu][iAv].intersect(bzssB[iBu][iBv]);

			for (i = 0; i < ints.length; i++) {
			    // _Xgɒǉ
			    if (ints[i].isIntersectionPoint()) {
				intp = ints[i].toIntersectionPoint();
				interferenceList.addAsIntersectionPoint
				    (intp.coordinates(),
				     vldsAu.l2Gp(iAu, intp.pointOnSurface1().uParameter()),
				     vldsAv.l2Gp(iAv, intp.pointOnSurface1().vParameter()),
				     vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()),
				     vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
			    }

			    // Xgɒǉ
			    else {	// if (ints[i].isIntersectionCurve())
				intc = ints[i].toIntersectionCurve();
				interferenceList.addAsIntersectionCurve
				    ((JgclPolyline3D)intc.curve3d(),
				     l2Gc(vldsAu, iAu, vldsAv, iAv, (JgclPolyline2D)intc.curve2d()),
				     l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
			    }
			}
		    }
		}
	    }
	}

	// fĂȂ
	interferenceList.connectIntersectionCurves();

	return interferenceList;
    }

    /**
     * ͓IȖʂBXvCȖʂ̌߂
     *
     * @param	elmA	2Ȗ A
     * @param	bssB	BXvCȖ B
     * @return		2Ȗʂ̊(_ƌ)̔z
     * @see		JgclSurfaceSurfaceInterference3D
     */
    static JgclSurfaceSurfaceInterference3D[] intersection(JgclElementarySurface3D elmA,
							   JgclBsplineSurface3D bssB,
							   boolean doExchange) {
	return getInterference(elmA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    /**
     * xWGȖʂBXvCȖʂ̌߂
     *
     * @param	bzsA	xWGȖ A
     * @param	bssB	BXvCȖ B
     * @return		2Ȗʂ̊(_ƌ)̔z
     * @see		JgclSurfaceSurfaceInterference3D
     */
    static JgclSurfaceSurfaceInterference3D[] intersection(JgclPureBezierSurface3D bzsA,
							   JgclBsplineSurface3D bssB,
							   boolean doExchange) {
	return getInterference(bzsA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    /**
     * BXvCȖʓm̌߂
     *
     * @param	bssA	BXvCȖ A
     * @param	bssB	BXvCȖ B
     * @return		2Ȗʂ̊(_ƌ)̔z
     * @see		JgclSurfaceSurfaceInterference3D
     */
    static JgclSurfaceSurfaceInterference3D[] intersection(JgclBsplineSurface3D bssA,
							   JgclBsplineSurface3D bssB,
							   boolean doExchange) {
	return getInterference(bssA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }
}

// end of file
