/*
 * 3D xWGȐBXvCȐ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBzcBsc3D.java,v 1.8 2000/04/26 09:38:59 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D xWGȐBXvCȐ̌_߂NX
 *
 * @version $Revision: 1.8 $, $Date: 2000/04/26 09:38:59 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsBzcBsc3D
{
    /**
     * xWGȐBXvCȐ̊𓾂
     *
     * @param	bscA	xWGȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̃Xg
     * @see		JgclCurveCurveInterferenceList
     */
    private static JgclCurveCurveInterferenceList
    getInterference(JgclPureBezierCurve3D bzcA,
		    JgclBsplineCurve3D bscB)
    {
	// Ȑ B ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierCurve3D[] bzcsB = bscB.toPureBezierCurveArray();

	// ̃Xg
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(bzcA, bscB);

	// Ȑ B ̊eZOgɑ΂
	for (int iB = 0; iB < bzcsB.length; iB++)
	{
	    /*** Debug
	    bzcA.output(System.out);
	    bzcsB[iB].output(System.out);
	    ***/

	    // xWGȐxł̊𓾂
	    JgclCurveCurveInterference3D[] localInterferences
		= JgclIntsBzcBzc3D.interference(bzcA, bzcsB[iB], false);

	    // _Xgɒǉ
	    Vector intsList
		= JgclCurveCurveInterferenceList.extractIntersections
		(localInterferences);
	    for (Enumeration e = intsList.elements(); e.hasMoreElements();)
	    {
		JgclIntersectionPoint3D ints
		    = (JgclIntersectionPoint3D)e.nextElement();
		interferenceList.addAsIntersection
		    (ints.coordinates(),
		     ints.pointOnCurve1().parameter(),
		     vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
	    }

	    // dXgɒǉ
	    Vector ovlpList
		= JgclCurveCurveInterferenceList.extractOverlaps
		(localInterferences);
	    for (Enumeration e = ovlpList.elements(); e.hasMoreElements();)
	    {
		JgclOverlapCurve3D ovlp
		    = (JgclOverlapCurve3D)e.nextElement();
		interferenceList.addAsOverlap
		    (ovlp.start1(),
		     vldsB.l2Gp(iB, ovlp.start2()),
		     ovlp.increase1(),
		     vldsB.l2Gw(iB, ovlp.increase2()));
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * xWGȐBXvCȐ̊𓾂
     *
     * @param	bzcA	xWGȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̔z
     * @see		JgclCurveCurveInterference3D
     */
    static JgclCurveCurveInterference3D[] interference(JgclPureBezierCurve3D bzcA,
						       JgclBsplineCurve3D bscB,
						       boolean doExchange) {
	return getInterference(bzcA, bscB).toJgclCurveCurveInterference3DArray(doExchange);
    }

    /**
     * xWGȐBXvCȐ̌_𓾂
     *
     * @param	bzcA	xWGȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̌_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclPureBezierCurve3D bzcA,
						  JgclBsplineCurve3D bscB,
						  boolean doExchange) {
	return getInterference(bzcA, bscB).toJgclIntersectionPoint3DArray(doExchange);
    }
}

// end of file
