/*
 * 3D BXvCȐm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBscBsc3D.java,v 1.8 2000/04/26 09:38:59 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D BXvCȐm̌_߂NX
 *
 * @version $Revision: 1.8 $, $Date: 2000/04/26 09:38:59 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsBscBsc3D
{
    /**
     * 2 BXvCȐ̊𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̃Xg
     * @see		JgclCurveCurveInterferenceList
     */
    private static JgclCurveCurveInterferenceList
    getInterference(JgclBsplineCurve3D bscA,
		    JgclBsplineCurve3D bscB)
    {
	// Ȑ A ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
	// Ȑ A \xWGȐ
	JgclPureBezierCurve3D[] bzcsA = bscA.toPureBezierCurveArray();

	// Ȑ B ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierCurve3D[] bzcsB = bscB.toPureBezierCurveArray();

	// ̃Xg
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(bscA, bscB);

	// Ȑ A ̊eZOgɑ΂
	for (int iA = 0; iA < bzcsA.length; iA++)
	{
	    // Ȑ B ̊eZOgɑ΂
	    for (int iB = 0; iB < bzcsB.length; iB++)
	    {
		/*** Debug
		bzcsA[iA].output(System.out);
		bzcsB[iB].output(System.out);
		***/

		// xWGȐxł̊𓾂
		JgclCurveCurveInterference3D[] localInterferences
		    = JgclIntsBzcBzc3D.interference(bzcsA[iA], bzcsB[iB], false);

		// _Xgɒǉ
		Vector intsList
		    = JgclCurveCurveInterferenceList.extractIntersections
			(localInterferences);
		for (Enumeration e = intsList.elements(); e.hasMoreElements();)
		{
		    JgclIntersectionPoint3D ints
			= (JgclIntersectionPoint3D)e.nextElement();
		    interferenceList.addAsIntersection
			(ints.coordinates(),
			 vldsA.l2Gp(iA, ints.pointOnCurve1().parameter()),
			 vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
		}

		// dXgɒǉ
		Vector ovlpList
		    = JgclCurveCurveInterferenceList.extractOverlaps
			(localInterferences);
		for (Enumeration e = ovlpList.elements(); e.hasMoreElements();)
		{
		    JgclOverlapCurve3D ovlp
			= (JgclOverlapCurve3D)e.nextElement();
		    interferenceList.addAsOverlap
			(vldsA.l2Gp(iA, ovlp.start1()),
			 vldsB.l2Gp(iB, ovlp.start2()),
			 vldsA.l2Gw(iA, ovlp.increase1()),
			 vldsB.l2Gw(iB, ovlp.increase2()));
		}
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * 2 BXvCȐ̊𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̔z
     * @see		JgclCurveCurveInterference3D
     */
    static JgclCurveCurveInterference3D[] interference(JgclBsplineCurve3D bscA,
						       JgclBsplineCurve3D bscB,
						       boolean doExchange) {
	return getInterference(bscA, bscB).toJgclCurveCurveInterference3DArray(doExchange);
    }

    /**
     * 2 BXvCȐ̌_𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̌_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclBsplineCurve3D bscA,
						  JgclBsplineCurve3D bscB,
						  boolean doExchange) {
	return getInterference(bscA, bscB).toJgclIntersectionPoint3DArray(doExchange);
    }
}

// end of file
