/*
 * 2D BXvCȐm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBscBsc2D.java,v 1.11 2000/08/11 06:18:50 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2D BXvCȐm̌_߂NX
 *
 * @version $Revision: 1.11 $, $Date: 2000/08/11 06:18:50 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsBscBsc2D
{
    /**
     * 2 BXvCȐ̊𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̃Xg
     * @see		JgclCurveCurveInterferenceList
     */
    private static JgclCurveCurveInterferenceList
    getInterference(JgclBsplineCurve2D bscA,
		    JgclBsplineCurve2D bscB)
    {
	// Ȑ A ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
	// Ȑ A \xWGȐ
	JgclPureBezierCurve2D[] bzcsA = bscA.toPureBezierCurveArray();

	// Ȑ B ̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierCurve2D[] bzcsB = bscB.toPureBezierCurveArray();

	// ̃Xg
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(bscA, bscB);

	// Ȑ A ̊eZOgɑ΂
	for (int iA = 0; iA < bzcsA.length; iA++)
	{
	    // Ȑ B ̊eZOgɑ΂
	    for (int iB = 0; iB < bzcsB.length; iB++)
	    {
		/*** Debug
		bzcsA[iA].output(System.out);
		bzcsB[iB].output(System.out);
		***/

		// xWGȐxł̊𓾂
		JgclCurveCurveInterference2D[] localInterferences
		    = JgclIntsBzcBzc2D.interference(bzcsA[iA], bzcsB[iB], false);

		// _Xgɒǉ
		Vector intsList
		    = JgclCurveCurveInterferenceList.extractIntersections
			(localInterferences);
		for (Enumeration e = intsList.elements(); e.hasMoreElements();)
		{
		    JgclIntersectionPoint2D ints
			= (JgclIntersectionPoint2D)e.nextElement();
		    interferenceList.addAsIntersection
			(ints.coordinates(),
			 vldsA.l2Gp(iA, ints.pointOnCurve1().parameter()),
			 vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
		}

		// dXgɒǉ
		Vector ovlpList
		    = JgclCurveCurveInterferenceList.extractOverlaps
			(localInterferences);
		for (Enumeration e = ovlpList.elements(); e.hasMoreElements();)
		{
		    JgclOverlapCurve2D ovlp
			= (JgclOverlapCurve2D)e.nextElement();
		    interferenceList.addAsOverlap
			(vldsA.l2Gp(iA, ovlp.start1()),
			 vldsB.l2Gp(iB, ovlp.start2()),
			 vldsA.l2Gw(iA, ovlp.increase1()),
			 vldsB.l2Gw(iB, ovlp.increase2()));
		}
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList;
    }

    /**
     * 2 BXvCȐ̊𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̊̔z
     * @see		JgclCurveCurveInterference2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclBsplineCurve2D bscA,
						       JgclBsplineCurve2D bscB,
						       boolean doExchange) {
	return getInterference(bscA, bscB).toJgclCurveCurveInterference2DArray(doExchange);
    }

    /**
     * 2 BXvCȐ̌_𓾂
     *
     * @param	bscA	BXvCȐ A
     * @param	bscB	BXvCȐ B
     * @return		2 Ȑ̌_̔z
     * @see		JgclIntersectionPoint2D
     */
    static JgclIntersectionPoint2D[] intersection(JgclBsplineCurve2D bscA,
						  JgclBsplineCurve2D bscB,
						  boolean doExchange) {
	return getInterference(bscA, bscB).toJgclIntersectionPoint2DArray(doExchange);
    }

    /**
     * fobOpCvOB
     */
    public static void main(String[] argv) {
	int[] knotMulti1 = {  1,   1,   1,   1,   1,   1,   1,   1,   1};
	double[] knots1  = {0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 2.0, 2.0};
	JgclPoint2D[] controlPoints1 = new JgclPoint2D[5];
	controlPoints1[0] = new JgclCartesianPoint2D( 0.0,   0.0);
	controlPoints1[1] = new JgclCartesianPoint2D(10.0,  10.0);
	controlPoints1[2] = new JgclCartesianPoint2D(20.0, -10.0);
	controlPoints1[3] = new JgclCartesianPoint2D(30.0,   0.0);
	controlPoints1[4] = new JgclCartesianPoint2D(40.0,   0.0);

	JgclBsplineCurve2D bsc1
	    = new JgclBsplineCurve2D(3, knotMulti1, knots1, controlPoints1);

	int[] knotMulti2 = {  1,   1,   1,   1,   1,   1,   1,   1,   1};
	double[] knots2  = {0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 2.0, 2.0};
	JgclPoint2D[] controlPoints2 = new JgclPoint2D[5];
	controlPoints2[0] = new JgclCartesianPoint2D( 50.0,   0.0);
	controlPoints2[1] = new JgclCartesianPoint2D( 30.0,   1.0);
	controlPoints2[2] = new JgclCartesianPoint2D( 10.0,   0.0);
	controlPoints2[3] = new JgclCartesianPoint2D(-10.0,   5.0);
	controlPoints2[4] = new JgclCartesianPoint2D(-30.0,  10.0);

	JgclBsplineCurve2D bsc2
	    = new JgclBsplineCurve2D(3, knotMulti2, knots2, controlPoints2);

	JgclIntersectionPoint2D[] result = intersection(bsc1, bsc2, false);

	for (int i = 0; i < result.length; i++)
	    result[i].output(System.out);
    }
}

// end of file
