/*
 * R : ȖʊԂ̌\NXB
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntersectionCurve3D.java,v 1.21 2000/04/26 09:38:58 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ȖʊԂ̌\NXB
 * <p>
 * ̃NXɓLȑ\tB[h͓ɂȂB
 * \߂ɕKvȋȐ̏ȂǂێtB[hɂẮA
 * {@link JgclSurfaceCurve3D X[p[NX̉} QƁB
 * ȂAIuWFNǵA
 * X[p[NX JgclSurfaceCurve3D Œ`ĂCX^XtB[h
 * basisSurface2, curve2d2 pB
 * </p>
 *
 * @version $Revision: 1.21 $, $Date: 2000/04/26 09:38:58 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclIntersectionCurve3D extends JgclSurfaceCurve3D
    implements JgclSurfaceSurfaceInterference3D
{
    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclSurfaceCurve3D#JgclSurfaceCurve3D(JgclParametricCurve3D, JgclParametricSurface3D, JgclParametricCurve2D, JgclParametricSurface3D, JgclParametricCurve2D, int)
     * super}(curve3d, basisSurface1, curve2d1, basisSurface2, curve2d2, masterRepresentation)
     * ĂяoĂB
     * </p>
     * <p>
     * basisSurface1  basisSurface2 Ȗʂłꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param curve3d	̎O\
     * @param basisSurface1	߂̋Ȗ
     * @param curve2d1	 basisSurface1 ɂ񎟌\
     * @param basisSurface2	߂̋Ȗ
     * @param curve2d2	 basisSurface2 ɂ񎟌\
     * @param masterRepresentation	ǂ̋Ȑ\D悷邩萔 (JgclPreferredSurfaceCurveRepresentation)
     * @see	JgclPreferredSurfaceCurveRepresentation
     * @see	JgclInvalidArgumentValue
     */
    public JgclIntersectionCurve3D(JgclParametricCurve3D curve3d,
				   JgclParametricSurface3D basisSurface1,
				   JgclParametricCurve2D curve2d1,
				   JgclParametricSurface3D basisSurface2,
				   JgclParametricCurve2D curve2d2,
				   int masterRepresentation) {
	super(curve3d, basisSurface1, curve2d1, basisSurface2, curve2d2, masterRepresentation);
	if (basisSurface1 == basisSurface2)
	    throw new JgclInvalidArgumentValue();
    }

    /**
     * ̊_ł邩ۂԂB
     *
     * @return	_ł͂ȂȂ̂ŁA false
     * @see	#isIntersectionCurve()

     */
    public boolean isIntersectionPoint() {
	return false;
    }

    /**
     * ̊ł邩ۂԂB
     *
     * @return	Ȃ̂ŁA true
     * @see	#isIntersectionPoint()
     */
    public boolean isIntersectionCurve() {
	return true;
    }

    /**
     * ̊_ɕϊB
     * <p>
     * _ɕϊ邱Ƃ͂łȂ̂ null ԂB
     * </p>
     *
     * @return	 null
     */
    public JgclIntersectionPoint3D toIntersectionPoint() {
	return null;
    }

    /**
     * ̊ɕϊB
     * <p>
     * gԂB
     * </p>
     *
     * @return	g
     */
    public JgclIntersectionCurve3D toIntersectionCurve() {
	return this;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#INTERSECTION_CURVE_3D JgclParametricCurve3D.INTERSECTION_CURVE_3D}
     */
    int type() {
	return INTERSECTION_CURVE_3D;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
	if (curve3d() != null) {
	    writer.println(indent_tab + "\tcurve3d");
	    curve3d().output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tbasisSurface1");
        basisSurface1().output(writer, indent + 2);
	if (curve2d1() != null) {
	    writer.println(indent_tab + "\tcurve2d1");
	    curve2d1().output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tbasisSurface2");
        basisSurface2().output(writer, indent + 2);
	if (curve2d2() != null) {
	    writer.println(indent_tab + "\tcurve2d2");
	    curve2d2().output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tmasterRepresentation\t"
                       + JgclPreferredSurfaceCurveRepresentation.toString(masterRepresentation()));
        writer.println(indent_tab + "End");
    }
}
