/*
 * Interpolation ̂߂̃NX(2D)
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclInterpolation2D.java,v 1.9 2000/04/26 09:38:58 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Interpolation ̂߂̃NX(2D)
 *
 * @version $Revision: 1.9 $, $Date: 2000/04/26 09:38:58 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclInterpolation2D {
    /**
     * ԂɕKvȏ
     * @see JgclInterpolation
     */
    private JgclInterpolation info;

    /**
     * Ԃ_
     * @see	JgclPoint2D
     */
    private JgclPoint2D[] points;

    /**
     * [̌X
     * @see	JgclVector2D
     */
    private JgclVector2D[] endvecs;

    /**
     * _ƃp[^^ăIuWFNg\z
     *
     * @param points   _
     * @param params   p[^
     * @see	JgclPoint2D
     */
    JgclInterpolation2D(JgclPoint2D[] points, double[] params) {
	this.info = new JgclInterpolation(params, false);
	this.points = points;
	this.endvecs = besselPoints(points, params);
    }

    /**
     * _Ap[^A[̌X^ăIuWFNg\z
     *
     * @param points   _
     * @param params   p[^
     * @param endvecs  [̌X
     * @see	JgclPoint2D
     * @see	JgclVector2D
     */
    JgclInterpolation2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs) {
	this.info = new JgclInterpolation(params, false);
	this.points = points;
	this.endvecs = endvecs;
    }

    /**
     * _Ap[^A[̌XAĂ邩ǂ̃tO^ăIuWFNg\z
     *
     * @param points   _
     * @param params   p[^
     * @param endvecs  [̌X(Ă͖)
     * @param isClosed Ă邩ǂ̃tO
     * @see	JgclPoint2D
     * @see	JgclVector2D
     */
    JgclInterpolation2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs, boolean isClosed) {
	this.info = new JgclInterpolation(params, isClosed);
	this.points = points;
	if (!info.isClosed) {
	    if (endvecs != null)
		this.endvecs = endvecs;
	    else
		this.endvecs = besselPoints(points, params);
	}
    }

    /**
     * xbZ_([̌X)߂
     *
     * @param points	_
     * @param params	p[^
     * @return [̌X
     * @see	JgclPoint2D
     * @see	JgclVector2D
     */
    static JgclVector2D[] besselPoints(JgclPoint2D[] points, double[] params) {
	int uip = points.length;
	JgclVector2D[] endvecs = new JgclVector2D[2];
	double delta = params[1] - params[0];
	if (uip == 2) {
	    endvecs[0] = points[1].subtract(points[0]);
	    endvecs[0] = endvecs[0].divide(delta);
	    endvecs[1] = endvecs[0];
	    return endvecs;
	}

	// start
	double t = delta / (params[2] - params[0]);
	double t1 = 1.0 - t;
	double b0 = t1 * t1;
	double b1 = 2.0 * t * t1;
	double b2 = t * t;

	JgclPoint2D mPoint = points[1].subtract(points[0].multiply(b0)).toPoint2D().subtract(points[2].multiply(b2)).toPoint2D().divide(b1);
	endvecs[0] = mPoint.subtract(points[0]).multiply(t * 2.0 / delta);

	// end
	int index = uip - 3;
	t = (params[index+1] - params[index]) / (params[index+2] - params[index]);
	t1 = 1.0 -t;
	b0 = t1 * t1;
	b1 = 2.0 * t * t1;
	b2 = t * t;

	mPoint = points[index+1].subtract(points[index].multiply(b0)).toPoint2D().subtract(points[index+2].multiply(b2)).toPoint2D().divide(b1);
	delta = params[index+2] - params[index+1];
	endvecs[1] = points[index+2].subtract(mPoint).multiply(t1 * 2.0 / delta);
	return endvecs;
    }

    /**
     * _߂
     *
     * @param  cp   _
     * @return      _
     * @see	JgclPoint2D
     */
    private JgclPoint2D[] solveLS(JgclPoint2D[] cp) {
	JgclPoint2D[] newCp = new JgclPoint2D[info.uip];
	for (int i = 0; i < info.uip; i++)
	    newCp[i] = cp[i];

	for (int i = 1; i < info.uip; i++) {
	    newCp[i] =
		newCp[i].subtract(newCp[i - 1].multiply(info.matrix.getElementAt(i, 0))).toPoint2D();
	}
	for (int i = info.uip - 2; i >= 0; i--) {
	    newCp[i] =
  		newCp[i].subtract(newCp[i + 1].multiply(info.matrix.getElementAt(i, 2))).toPoint2D();
	}
	for (int i = 0; i < info.uip; i++)
  	    newCp[i] = newCp[i].divide(info.matrix.getElementAt(i, 1));

	return newCp;
    }

    /**
     * _߂(Ȑ̏ꍇ)
     *
     * @param  cp        _
     * @return           _
     * @see	JgclPoint2D
     */
    private JgclPoint2D[] solveLSClosed(JgclPoint2D[] cp) {
	double[] wX = new double[info.uip];
	double[] wY = new double[info.uip];
	JgclPoint2D[] newCp = new JgclPoint2D[info.uip];

	for (int i = 0; i < info.uip; i++) {
	    wX[i] = cp[i].x();
	}
	wX = info.matrix.solveSimultaneousLinearEquations(wX);

	for (int i = 0; i < info.uip; i++) {
	    wY[i] = cp[i].y();
	}
	wY = info.matrix.solveSimultaneousLinearEquations(wY);

	int i;
	for (i = 1; i < info.uip; i++) {
	    newCp[i] = new JgclCartesianPoint2D(wX[i-1], wY[i-1]);
	}
	newCp[0] = new JgclCartesianPoint2D(wX[i-1], wY[i-1]);

	return newCp;
    }

    /**
     * _߂(JȐ̏ꍇ)
     *
     * @return         _
     * @see	JgclPoint2D
     */
    private JgclPoint2D[] solveLinearSystem() {
	JgclPoint2D[] cp = new JgclPoint2D[info.uip];

	cp[0] = points[0].add(endvecs[0].multiply(info.pInt(0) / 3));
	int i;
	for (i = 1; i < info.uip - 1; i++) {
	    double ework = info.pInt(i-1) + info.pInt(i);
	    cp[i] = points[i].multiply(ework);
	}
	cp[i] = points[i].subtract(endvecs[1].multiply(info.pInt(info.uip - 2) / 3));
	cp = solveLS(cp);

	JgclPoint2D[] newCp = new JgclPoint2D[info.uip + 2];

	newCp[0] = points[0];
	for (i = 0; i < info.uip; i++)
	    newCp[i+1] = cp[i];
	newCp[info.uip + 1] = points[info.uip - 1];

	return newCp;
    }

    /**
     * _߂(Ȑ̏ꍇ)
     *
     * @return           _
     * @see	JgclPoint2D
     */
    private JgclPoint2D[] solveLinearSystemClosed() {
	JgclPoint2D[] cp = new JgclPoint2D[info.uip];

	for (int i = 0; i < info.uip; i++) {
	    double ework = info.pInt(i-1) + info.pInt(i);
	    cp[i] = points[i].multiply(ework);
	}
	cp = solveLSClosed(cp);

	return cp;
    }

    /**
     * ԂȐ̃mbg߂
     *
     * @return       mbg
     * @see	JgclBsplineKnot
     */
    JgclBsplineKnot knotData() {
	return info.knotData();
    }

    /**
     * ԂȐ̐_߂
     *
     * @return       _
     * @see	JgclPoint2D
     */
    JgclPoint2D[] controlPoints() {
	if (!info.isClosed) {
	    return solveLinearSystem();
	}
	else {
	    return solveLinearSystemClosed();
	}
    }

    /**
     * ԂȐ̏d݂߂
     *
     * @return	d(`Ȃ̂null)
     */
    double[] weights() {
	return null;
    }

    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	JgclCartesianPoint2D p0 = new JgclCartesianPoint2D(0.0, 0.0);
	JgclCartesianPoint2D p1 = new JgclCartesianPoint2D(1.0, 1.0);
	JgclCartesianPoint2D p2 = new JgclCartesianPoint2D(2.0, 0.0);
	JgclCartesianPoint2D p3 = new JgclCartesianPoint2D(1.0, -1.0);
	JgclLiteralVector2D v = new JgclLiteralVector2D(0.0, -1.0);

	JgclInterpolation2D open, closed;

	// open case
	JgclCartesianPoint2D[] points = {p0, p1, p2};
	double[] params = {0.0, 0.5, 1.0};
	JgclLiteralVector2D[] vectors = { v, v };

	System.out.println("\n\n<for open case.>\n");
	open = new JgclInterpolation2D(points, params, vectors);
	JgclPoint2D[] cp = open.controlPoints();
  	System.out.println("\n\n[interpolated points]\n");
	for (int i = 0; i < cp.length; i++) {
	    System.out.println("cp[" + i + "] = ("
			       + cp[i].x()
			       + ", "
			       + cp[i].y() + ")");
	}


	// closed case
	JgclCartesianPoint2D[] pointsClosed = {p0, p1, p2, p3};
	double[] paramsClosed = {0.0, 0.25, 0.5, 0.75, 1.0};

  	System.out.println("\n\n<for closed case.>\n");

 	closed = new JgclInterpolation2D(pointsClosed, paramsClosed, null, true);
 	JgclPoint2D[] cpClosed = closed.controlPoints();
  	System.out.println("\n[interpolated points]\n");
 	for (int i = 0; i < cpClosed.length; i++) {
 	    System.out.println("cp[" + i + "] = ("
 			       + cpClosed[i].x()
 			       + ", "
 			       + cpClosed[i].y() + ")");
 	}
    }
}

// end of file
