/*
 * PFe萔Œ`ꂽxNg\
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHomogeneousVector1D.java,v 1.19 2000/04/26 09:38:57 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * PFe萔Œ`ꂽxNg\NXB
 *
 * @version $Revision: 1.19 $, $Date: 2000/04/26 09:38:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclLiteralVector1D
 */
public class JgclHomogeneousVector1D extends JgclVector1D {

    /**
     * WX B
     * @serial
     */
    private final double wx;

    /**
     * W B
     * @serial
     */
    private final double w;

    /**
     * wx/w Œ`IuWFNg\zB
     * 
     * @param wx	WX 
     * @param w		W 
     */
    public JgclHomogeneousVector1D(double wx, double w) {
	super();

	this.wx = wx;
	this.w = w;
    }

    /**
     * wx/w Œ`IuWFNg\zB
     * 
     * @param wx	WX 
     * @param w		W 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclHomogeneousVector1D(double wx, double w,
			    boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);

	this.wx = wx;
	this.w = w;
    }

    /**
     * X ԂB
     * 
     * @return		X 
     */
    public double x() {
	return wx/w;
    }

    /**
     * WX ԂB
     * 
     * @return		WX 
     */
    public double wx() {
	return wx;
    }

    /**
     * W ԂB
     * 
     * @return		W 
     */
    public double w() {
	return w;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName() + " "
                       + wx() + " "
                       + w()  + " End");
    }
}

