/*
 * R : _RȐ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFreeformCurveWithControlPoints3D.java,v 1.19 2000/08/11 06:18:49 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : _RȐ\ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * _ (JgclPoint3D) ̔z controlPoints
 * 
 * d (double) ̔z weights
 * B
 * </p>
 * <p>
 * weights  null ̏ꍇɂ͔LȐ (Ȑ) \B
 * </p>
 * <p>
 * weights ɔz񂪐ݒ肳Ăꍇɂ͗LȐ\B
 * weights[i]  controlPoints[i] ɑΉB
 * ȂA܂̂Ƃ weights[i] ̒l͐łȂ΂ȂȂB
 * </p>
 *
 * @version $Revision: 1.19 $, $Date: 2000/08/11 06:18:49 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclFreeformCurveWithControlPoints3D extends JgclBoundedCurve3D {
    /**
     * _̔zB
     * @serial
     */
    protected JgclPoint3D[] controlPoints;

    /**
     * d݂̔zB
     * <p>
     * Ȑł null ƂB
     * </p>
     * @serial
     */
    protected double[] weights;

    /**
     * _Əd݂\񎟌zB
     * <p>
     * KvɉăLbVB
     * </p>
     * <p>
     * controlPointsArray[i] ̒ 3 ̏ꍇA
     * controlPointsArray[i][0]  i Ԗڂ̐_ X A
     * controlPointsArray[i][1]  i Ԗڂ̐_ Y 
     * controlPointsArray[i][2]  i Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * controlPointsArray[i] ̒ 4 ̏ꍇA
     * controlPointsArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * controlPointsArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * controlPointsArray[i][2]  (i Ԗڂ̐_ Z  * i Ԗڂ̏d)A
     * controlPointsArray[i][3]  i Ԗڂ̏d
     * \B
     * </p>
     * @serial
     */
    private double[][] controlPointsArray = null;

    /**
     * ^ɃIuWFNg\zB
     * <p>
     * etB[hɂ͒lݒ肵ȂB
     * </p>
     */
    protected JgclFreeformCurveWithControlPoints3D() {
	super();
    }

    /**
     * _^đȐƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	_̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints) {
	super();
	int npnts = setControlPoints(controlPoints);
	weights = null;
    }

    /**
     * _Ədݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * <li>	weights  null ł
     * <li>	weights ̒ controlPoints ̒ƈقȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param controlPoints	_̔z
     * @param weights		d݂̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints, double[] weights) {
	super();
	int npnts = setControlPoints(controlPoints);
	setWeights(npnts, weights);
    }

    /**
     * _ (Əd) 񎟌zŗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * cpArray ̒𐧌_̐ƂB
     * ܂AcpArray[0] ̒ 3 łΑȐA4 łΗLȐƂB
     * </p>
     * <p>
     * cpArray[i] ̒ 3 ̏ꍇA
     * cpArray[i][0]  i Ԗڂ̐_ X A
     * cpArray[i][1]  i Ԗڂ̐_ Y A
     * cpArray[i][2]  i Ԗڂ̐_ Z 
     * ̂ƂB
     * </p>
     * <p>
     * cpArray[i] ̒ 4 ̏ꍇA
     * cpArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * cpArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * cpArray[i][2]  (i Ԗڂ̐_ Z  * i Ԗڂ̏d)A
     * cpArray[i][3]  i Ԗڂ̏d
     * ̂ƂB
     * </p>
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	_̐ 2 菬
     * <li>	d݂̒lłȂ
     * <li>	d݂̒l w ɂāA
     *		(w / (dݗ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param cpArray	_ (яd) ̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints3D(double[][] cpArray) {
	super();

	int npnts = cpArray.length;
	JgclPoint3D[] cp = new JgclPoint3D[npnts];
	boolean isPoly = (cpArray[0].length == 3);

	if (!isPoly) {	// L
	    double[] tmp = new double[4];
	    double[] wt = new double[npnts];
	    for (int i = 0; i < npnts; i++) {
		for (int j = 0; j < 4; j++)
		    tmp[j] = cpArray[i][j];
		convRational0Deriv(tmp);
		cp[i] = new JgclCartesianPoint3D(tmp[0], tmp[1], tmp[2]);
		wt[i] = tmp[3];
	    }
	    setWeights(npnts, wt);
	} else {
	    for (int i = 0; i < npnts; i++) {
		cp[i] = new JgclCartesianPoint3D(cpArray[i][0], cpArray[i][1], cpArray[i][2]);
	    }
	    weights = null;
	}
	npnts = setControlPoints(cp);
    }

    /**
     * _Ədݗ^
     * Ȑ邢͗LȐƂăIuWFNg\zB
     * <p>
     * doCheck  false ̏ꍇA
     * ^ꂽ controlPoints  weights ̒l
     * ΉtB[hɂ̂܂ܐݒ肷B
     *  weights  null ł΁AȐ͔L () `ɂȂB
     * ȂAcontrolPoints  null ^ƁA\łȂʂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇA
     * weights lĂ
     * {@link #JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])
     * JgclFreeformCurveWithControlPoints3D(JgclPoint3D[], double[])}A
     * weights  null ł
     * {@link #JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])
     * JgclFreeformCurveWithControlPoints3D(JgclPoint3D[])}
     * Ɠl̏sȂB
     * </p>
     *
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     * @param doCheck	̃`FbNsȂǂ
     */
    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints,
						   double[] weights,
						   boolean doCheck) {
	super();
	if (doCheck) {
	    int npnts = setControlPoints(controlPoints);
	    if (weights == null)
		weights = null;
	    else
		setWeights(npnts, weights);
	} else {
	    this.controlPoints = controlPoints;
	    this.weights = weights;
	}
    }

    /**
     * ̋Ȑ̐_ԂB
     * 
     * @return		_̔z
     */
    public JgclPoint3D[] controlPoints() {
	JgclPoint3D[] copied = new JgclPoint3D[controlPoints.length];

	for (int i = 0; i < controlPoints.length; i++)
	    copied[i] = controlPoints[i];
	return copied;
    }

    /**
     * ̋Ȑ i Ԗڂ̐_ԂB
     * 
     * @param i	CfbNX
     * @return	_
     */
    public JgclPoint3D controlPointAt(int i) {
	return controlPoints[i];
    }

    /**
     * ̋Ȑ̏dݗԂB
     * <p>
     * ȐȐ̏ꍇ null ԂB
     * </p>
     * 
     * @return	d݂̔z
     */
    public double[] weights() {
	if (weights == null)
	    return null;
	return (double[])weights.clone();
    }

    /**
     * ̋Ȑ i Ԗڂ̐_̏d݂ԂB
     * <p>
     * ȐȐ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𓊂B
     * </p>
     * 
     * @param i	CfbNX
     * @return	d
     * @see	JgclInvalidArgumentValue
     */
    public double weightAt(int i) {
	if (weights == null)
	    throw new JgclInvalidArgumentValue();
	return weights[i];
    }

    /**
     * ̋Ȑ̐_̐ԂB
     * 
     * @return	_̐
     */
    public int nControlPoints() {
	return controlPoints.length;
    }

    /**
     * ̋ȐL`ۂԂB
     *
     * @return	L`Ȃ trueAłȂ false
     */
    public boolean isRational() {
	return weights != null;
    }

    /**
     * ̋Ȑ`ۂԂB
     *
     * @return	`Ȃ trueAłȂ false
     */
    public boolean isPolynomial() {
	return weights == null;
    }

    /**
     * ̋Ȑ̎ԏł̂悻̒ԂB
     * <p>
     * _񂾃|S (䑽p`) ̒ԂB
     * </p>
     *
     * @return	Ȑ̂悻̒
     */
    double approximateLength() {
	int i, j;
	double aprx_leng;

	aprx_leng = 0.0;
	for (i = 0, j = 1; j < nControlPoints(); i++, j++)
	    aprx_leng += controlPointAt(i).distance(controlPointAt(j));

	return aprx_leng;
    }

    /**
     * ̋Ȑ̎ԏł̂悻̑ݔ͈͂̂ԂB
     * <p>
     * _܂ޒ̂ԂB
     * </p>
     *
     * @return	Ȑ̂悻̑ݔ͈͂
     */
    JgclEnclosingBox3D approximateEnclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double min_crd_z;
	double max_crd_x;
	double max_crd_y;
	double max_crd_z;
	int n = nControlPoints();
	JgclPoint3D point;
	double x, y, z;

	point = controlPointAt(0);
	max_crd_x = min_crd_x = point.x();
	max_crd_y = min_crd_y = point.y();
	max_crd_z = min_crd_z = point.z();

	for (int i = 1; i < n; i++) {
	    point = controlPointAt(i);
	    x = point.x();
	    y = point.y();
	    z = point.z();
	    /**/ if (x < min_crd_x) min_crd_x = x;
	    else if (x > max_crd_x) max_crd_x = x;
	    /**/ if (y < min_crd_y) min_crd_y = y;
	    else if (y > max_crd_y) max_crd_y = y;
	    /**/ if (z < min_crd_z) min_crd_z = z;
	    else if (z > max_crd_z) max_crd_z = z;
	}
	return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z,
				      max_crd_x, max_crd_y, max_crd_z);
    }

    /**
     * ̃CX^X̃tB[hɐ_ݒ肷B
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	ݒ肷鐧_
     * @return	_̐
     * @see	JgclInvalidArgumentValue
     */
    private int setControlPoints(JgclPoint3D[] controlPoints) {
	int npnts;

	if (controlPoints == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if ((npnts = controlPoints.length) < 2) {
	    throw new JgclInvalidArgumentValue();
	}
	this.controlPoints = new JgclPoint3D[npnts];
	for (int i = 0; i < npnts; i++) {
	    if (controlPoints[i] == null) {
		throw new JgclInvalidArgumentValue();
	    }
	    this.controlPoints[i] = controlPoints[i];
	}
	return npnts;
    }

    /**
     * ̃CX^X̃tB[hɏdݗݒ肷B
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	weights  null ł
     * <li>	weights ̒ npnts ƈvĂȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param npnts	_̐
     * @param weights	ݒ肷dݗ
     * @see	JgclUtil#isDividable(double, double)
     * @see	JgclMachineEpsilon#DOUBLE
     * @see	JgclInvalidArgumentValue
     */
    private void setWeights(int npnts, double[] weights) {
	if (weights == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if (weights.length != npnts) {
	    throw new JgclInvalidArgumentValue();
	}

	double max_weight = 0.0;
	for (int i = 0; i < npnts; i++)
	    if (weights[i] > max_weight)
		max_weight = weights[i];
	if (max_weight <= 0.0)
	    throw new JgclInvalidArgumentValue();

	this.weights = new double[npnts];
	for (int i = 0; i < npnts; i++) {
	    if (weights[i] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i])) {
		throw new JgclInvalidArgumentValue();
	    }
	    this.weights[i] = weights[i];
	}
    }

    /**
     * ^ꂽ̐_̐i[u̓񎟌zv̗̈lB
     *
     * @param isPoly	`ۂ
     * @param size	z̑ꎟ̗vf (_̐)
     * @return		_̐i[z
     */
    static protected double[][] allocateDoubleArray(boolean isPoly,
						    int size) {
	return new double[size][(isPoly) ? 3 : 4];
    }

    /**
     * ̋Ȑ̐_ (яd) ̐A^ꂽ񎟌z̗vfɑB
     * <p>
     * isPoly  true ̏ꍇA
     * doubleArray[i][0]  i Ԗڂ̐_ X A
     * doubleArray[i][1]  i Ԗڂ̐_ Y 
     * doubleArray[i][2]  i Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * doubleArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * doubleArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * doubleArray[i][2]  (i Ԗڂ̐_ Z  * i Ԗڂ̏d)A
     * doubleArray[i][3]  i Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @param uicp	z̑ꎟ̗vf (zɒl鐧_̐)
     * @param doubleArray	_̐i[񎟌z
     */
    protected void setCoordinatesToDoubleArray(boolean isPoly,
					       int uicp,
					       double[][] doubleArray) {
	if (isPoly) {
	    for (int i = 0; i < uicp; i++) {
		doubleArray[i][0] = controlPoints[i].x();
		doubleArray[i][1] = controlPoints[i].y();
		doubleArray[i][2] = controlPoints[i].z();
	    }
	} else {
	    for (int i = 0; i < uicp; i++) {
		doubleArray[i][0] = controlPoints[i].x() * weights[i];
		doubleArray[i][1] = controlPoints[i].y() * weights[i];
		doubleArray[i][2] = controlPoints[i].z() * weights[i];
		doubleArray[i][3] = weights[i];
	    }
	}
    }

    /**
     * ̋Ȑ̐_ (яd) ̐܂ށu̓񎟌zvԂB
     * <p>
     * isPoly  true ̏ꍇA
     * ̃\bhԂ񎟌z C ̗vf
     * C[i][0]  i Ԗڂ̐_ X A
     * C[i][1]  i Ԗڂ̐_ Y 
     * C[i][2]  i Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * ̃\bhԂ񎟌z C ̗vf
     * C[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * C[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * C[i][2]  (i Ԗڂ̐_ Z  * i Ԗڂ̏d)A
     * C[i][3]  i Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @return	_ (яd) ̐܂ޔz
     */
    protected double[][] toDoubleArray(boolean isPoly) {
	if (controlPointsArray != null)
	    return controlPointsArray;

	int uicp = nControlPoints();

	controlPointsArray =
	    JgclFreeformCurveWithControlPoints3D.allocateDoubleArray(isPoly, uicp);

	setCoordinatesToDoubleArray(isPoly, uicp, controlPointsArray);

	return controlPointsArray;
    }

    /**
     * Wŗ^ꂽ (Ȑ) _ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽ (Ȑ) _ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     */
    protected void convRational0Deriv(double[] d0D) {
	for (int i = 0; i < 3; i++) {
	    d0D[i] /= d0D[3];
	}
    }

    /**
     * Wŗ^ꂽȐ̓_ƈꎟ֐ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽȐ̓_ƈꎟ֐ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     * @param d1D	ꎟ֐
     */
    protected void convRational1Deriv(double[] d0D, double[] d1D) {
	convRational0Deriv(d0D);
	for (int i = 0; i < 3; i++) {
	    d1D[i] = (d1D[i] - (d1D[3] * d0D[i])) / d0D[3];
	}
    }

    /**
     * Wŗ^ꂽȐ̓_/ꎟ֐/񎟓֐ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽȐ̓_/ꎟ֐/񎟓֐ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     * @param d1D	ꎟ֐
     * @param d2D	񎟓֐
     */
    protected void convRational2Deriv(double[] d0D, double[] d1D, double[] d2D) {
	convRational1Deriv(d0D, d1D);
	for (int i = 0; i < 3; i++) {
	    d2D[i] = (d2D[i] - ((2.0 * d1D[3] * d1D[i]) + (d2D[3] * d0D[i]))) / d0D[3];
	}
    }

    /**
     * Wŗ^ꂽȐ̓_/ꎟ֐/񎟓֐/O֐ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽȐ̓_/ꎟ֐/񎟓֐/O֐ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     * @param d1D	ꎟ֐
     * @param d2D	񎟓֐
     * @param d3D	O֐
     */
    protected void convRational3Deriv(double[] d0D, double[] d1D, double[] d2D, double[] d3D) {
	convRational2Deriv(d0D, d1D, d2D);
	for (int i = 0; i < 3; i++) {
	    d3D[i] = (d3D[i] - (3.0 * ((d1D[3] * d2D[i]) + (d2D[3] * d1D[i])) + (d3D[3] * d0D[i]))) / d0D[3];
	}
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋Ȑ̐_̐ɓψȏdݗԂB
     * <p>
     * ʂƂēz̊evf̒l 1 łB
     * </p>
     *
     * @return	d݂̔z
     */
    public double[] makeUniformWeights() {
	double[] uniformWeights = new double[this.nControlPoints()];
	for (int i = 0; i < uniformWeights.length; i++)
	    uniformWeights[i] = 1.0;
	return uniformWeights;
    }
}
